/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.ui.toolbar.actions;

import com.android.tools.idea.layoutinspector.model.InspectorModel;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import icons.StudioIcons;
import java.io.IOException;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u0012\u0014\u0010\u0007\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/layoutinspector/ui/toolbar/actions/ToggleOverlayAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "inspectorModel", "Lcom/android/tools/idea/layoutinspector/model/InspectorModel;", "getImage", "Lkotlin/Function0;", "", "setImage", "Lkotlin/Function1;", "", "<init>", "(Lcom/android/tools/idea/layoutinspector/model/InspectorModel;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "loadOverlay", "loadImageFile", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.android.layout-inspector"})
final class ToggleOverlayAction
extends AnAction {
    @NotNull
    private final InspectorModel inspectorModel;
    @NotNull
    private final Function0<byte[]> getImage;
    @NotNull
    private final Function1<byte[], Unit> setImage;

    public ToggleOverlayAction(@NotNull InspectorModel inspectorModel, @NotNull Function0<byte[]> getImage, @NotNull Function1<? super byte[], Unit> setImage) {
        Intrinsics.checkNotNullParameter((Object)inspectorModel, (String)"inspectorModel");
        Intrinsics.checkNotNullParameter(getImage, (String)"getImage");
        Intrinsics.checkNotNullParameter(setImage, (String)"setImage");
        super(StudioIcons.LayoutInspector.Toolbar.LOAD_OVERLAY);
        this.inspectorModel = inspectorModel;
        this.getImage = getImage;
        this.setImage = setImage;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        if (this.getImage.invoke() != null) {
            e.getPresentation().setIcon(StudioIcons.LayoutInspector.Toolbar.CLEAR_OVERLAY);
            e.getPresentation().setText("Clear Overlay");
        } else {
            e.getPresentation().setIcon(StudioIcons.LayoutInspector.Toolbar.LOAD_OVERLAY);
            e.getPresentation().setText("Load Overlay");
        }
        e.getPresentation().setEnabled(!this.inspectorModel.isEmpty());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.getImage.invoke() != null) {
            this.setImage.invoke(null);
        } else {
            this.loadOverlay(e);
        }
    }

    private final void loadOverlay(AnActionEvent e) {
        boolean bl;
        String[] stringArray = new String[]{"svg", "png", "jpg"};
        FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFileDescriptor().withTitle("Choose Overlay").withExtensionFilter("Image files", stringArray);
        FileChooserDialog fileChooserDialog = FileChooserFactory.getInstance().createFileChooser(descriptor2, null, null);
        Intrinsics.checkNotNullExpressionValue((Object)fileChooserDialog, (String)"createFileChooser(...)");
        FileChooserDialog fileChooserDialog2 = fileChooserDialog;
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        Object object = e.getProject();
        if (object == null || (object = object.getBasePath()) == null) {
            object = "/";
        }
        VirtualFile toSelect = localFileSystem.refreshAndFindFileByPath((String)object);
        Object object2 = new VirtualFile[1];
        Intrinsics.checkNotNull((Object)toSelect);
        VirtualFile[] virtualFileArray = fileChooserDialog2.choose(null, object2);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"choose(...)");
        VirtualFile[] files2 = virtualFileArray;
        if (files2.length == 0) {
            return;
        }
        boolean bl2 = bl = files2.length == 1;
        if (_Assertions.ENABLED && !bl) {
            object2 = "Assertion failed";
            throw new AssertionError(object2);
        }
        VirtualFile virtualFile = files2[0];
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"get(...)");
        this.setImage.invoke((Object)this.loadImageFile(virtualFile));
    }

    private final byte[] loadImageFile(VirtualFile file) {
        byte[] byArray;
        try {
            ImageIO.read(file.getInputStream());
            byArray = file.getInputStream().readAllBytes();
        }
        catch (IOException e) {
            Messages.showErrorDialog((String)("Failed to read image from \"" + file.getName() + "\" Error: " + e.getMessage()), (String)"Error");
            return null;
        }
        return byArray;
    }
}

