/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J)\u0010\u0012\u001a\u00020\u000f2\u000e\u0010\u0013\u001a\n \u0007*\u0004\u0018\u00010\u00140\u00142\u000e\u0010\u0015\u001a\n \u0007*\u0004\u0018\u00010\u00160\u0016H\u0096\u0001J!\u0010\u0017\u001a\n \u0007*\u0004\u0018\u00010\u00180\u00182\u000e\u0010\u0013\u001a\n \u0007*\u0004\u0018\u00010\u00110\u0011H\u0096\u0001J!\u0010\u0019\u001a\n \u0007*\u0004\u0018\u00010\u00180\u00182\u000e\u0010\u0013\u001a\n \u0007*\u0004\u0018\u00010\u00110\u0011H\u0096\u0001J\u0019\u0010\u001a\u001a\u00020\u000f2\u000e\u0010\u0013\u001a\n \u0007*\u0004\u0018\u00010\u00160\u0016H\u0096\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0007*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/layoutinspector/ui/CenteredViewportLayout;", "Ljava/awt/LayoutManager;", "viewport", "Ljavax/swing/JViewport;", "<init>", "(Ljavax/swing/JViewport;)V", "delegate", "kotlin.jvm.PlatformType", "forceCenterOnNextLayout", "", "getForceCenterOnNextLayout", "()Z", "setForceCenterOnNextLayout", "(Z)V", "layoutContainer", "", "parent", "Ljava/awt/Container;", "addLayoutComponent", "p0", "", "p1", "Ljava/awt/Component;", "minimumLayoutSize", "Ljava/awt/Dimension;", "preferredLayoutSize", "removeLayoutComponent", "intellij.android.layout-inspector"})
final class CenteredViewportLayout
implements LayoutManager {
    private final /* synthetic */ LayoutManager $$delegate_0;
    @NotNull
    private final JViewport viewport;
    private final LayoutManager delegate;
    private boolean forceCenterOnNextLayout;

    public CenteredViewportLayout(@NotNull JViewport viewport) {
        Intrinsics.checkNotNullParameter((Object)viewport, (String)"viewport");
        this.$$delegate_0 = viewport.getLayout();
        this.viewport = viewport;
        this.delegate = this.viewport.getLayout();
    }

    public final boolean getForceCenterOnNextLayout() {
        return this.forceCenterOnNextLayout;
    }

    public final void setForceCenterOnNextLayout(boolean bl) {
        this.forceCenterOnNextLayout = bl;
    }

    @Override
    public void layoutContainer(@Nullable Container parent) {
        Pair pair;
        Component component = this.viewport.getView();
        if (component == null) {
            return;
        }
        Component view = component;
        Dimension viewSize = view.getSize();
        Dimension viewportSize = this.viewport.getExtentSize();
        if (this.forceCenterOnNextLayout) {
            pair = TuplesKt.to((Object)0.5, (Object)0.5);
        } else {
            Point p = SwingUtilities.convertPoint(this.viewport, viewportSize.width / 2, viewportSize.height / 2, view);
            pair = TuplesKt.to((Object)((double)p.x / (double)RangesKt.coerceAtLeast((int)viewSize.width, (int)1)), (Object)((double)p.y / (double)RangesKt.coerceAtLeast((int)viewSize.height, (int)1)));
        }
        Pair pair2 = pair;
        double rx = ((Number)pair2.component1()).doubleValue();
        double ry = ((Number)pair2.component2()).doubleValue();
        this.delegate.layoutContainer(parent);
        this.forceCenterOnNextLayout = false;
        Component newView = this.viewport.getView();
        int wDiff = viewportSize.width - newView.getWidth();
        int hDiff = viewportSize.height - newView.getHeight();
        int xPadding = wDiff > 0 ? wDiff / 2 : 0;
        int yPadding = hDiff > 0 ? hDiff / 2 : 0;
        double xScroll = wDiff < 0 ? (double)newView.getWidth() * rx - (double)(viewportSize.width / 2) : 0.0;
        double yScroll = hDiff < 0 ? (double)newView.getHeight() * ry - (double)(viewportSize.height / 2) : 0.0;
        newView.setLocation(xPadding, yPadding);
        this.viewport.setViewPosition(new Point(RangesKt.coerceAtLeast((int)((int)xScroll), (int)0), RangesKt.coerceAtLeast((int)((int)yScroll), (int)0)));
    }

    @Override
    public void addLayoutComponent(String p0, Component p1) {
        this.$$delegate_0.addLayoutComponent(p0, p1);
    }

    @Override
    public void removeLayoutComponent(Component p0) {
        this.$$delegate_0.removeLayoutComponent(p0);
    }

    @Override
    public Dimension preferredLayoutSize(Container p0) {
        return this.$$delegate_0.preferredLayoutSize(p0);
    }

    @Override
    public Dimension minimumLayoutSize(Container p0) {
        return this.$$delegate_0.minimumLayoutSize(p0);
    }
}

