/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.stateinspection;

import com.android.tools.idea.layoutinspector.LayoutInspectorBundle;
import com.android.tools.idea.layoutinspector.stateinspection.StateInspectionFoldingDetector;
import com.android.tools.idea.layoutinspector.stateinspection.StateInspectionFoldingDetectorKt;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u0015H\u0002J\b\u0010\u001b\u001a\u00020\u0013H\u0002J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0015H\u0002J\u0010\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/layoutinspector/stateinspection/StateInspectionFoldingDetector;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lkotlinx/coroutines/CoroutineScope;)V", "document", "Lcom/intellij/openapi/editor/Document;", "Lorg/jetbrains/annotations/NotNull;", "foldingModel", "Lcom/intellij/openapi/editor/ex/FoldingModelEx;", "lines", "", "", "detectFolding", "Lkotlinx/coroutines/Job;", "foldLines", "", "foldDetailedValue", "", "start", "foldStartOfReadException", "foldEndOfException", "line", "lineNumber", "fetchLines", "startOffset", "endOffset", "intellij.android.layout-inspector"})
@SourceDebugExtension(value={"SMAP\nStateInspectionFoldingDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StateInspectionFoldingDetector.kt\ncom/android/tools/idea/layoutinspector/stateinspection/StateInspectionFoldingDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,315:1\n1761#2,3:316\n*S KotlinDebug\n*F\n+ 1 StateInspectionFoldingDetector.kt\ncom/android/tools/idea/layoutinspector/stateinspection/StateInspectionFoldingDetector\n*L\n222#1:316,3\n*E\n"})
public final class StateInspectionFoldingDetector {
    @NotNull
    private final Editor editor;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final Document document;
    @Nullable
    private final FoldingModelEx foldingModel;
    @NotNull
    private List<String> lines;

    public StateInspectionFoldingDetector(@NotNull Editor editor, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.editor = editor;
        this.scope = scope;
        Document document = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        this.document = document;
        FoldingModel foldingModel = this.editor.getFoldingModel();
        this.foldingModel = foldingModel instanceof FoldingModelEx ? (FoldingModelEx)foldingModel : null;
        this.lines = kotlin.collections.CollectionsKt.emptyList();
    }

    @Nullable
    public final Job detectFolding() {
        FoldingModelEx foldingModelEx = this.foldingModel;
        if (foldingModelEx == null) {
            return null;
        }
        FoldingModelEx model = foldingModelEx;
        return BuildersKt.launch$default((CoroutineScope)this.scope, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(model, this, null){
            int label;
            final /* synthetic */ FoldingModelEx $model;
            final /* synthetic */ StateInspectionFoldingDetector this$0;
            {
                this.$model = $model;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = CoroutinesKt.writeAction(() -> detectFolding.1.invokeSuspend$lambda$0(this.$model, this.this$0), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(FoldingModelEx $model, StateInspectionFoldingDetector this$0) {
                $model.runBatchFoldingOperation(() -> detectFolding.1.invokeSuspend$lambda$0$0(this$0, $model));
                return Unit.INSTANCE;
            }

            private static final void invokeSuspend$lambda$0$0(StateInspectionFoldingDetector this$0, FoldingModelEx $model) {
                StateInspectionFoldingDetector.access$fetchLines(this$0);
                $model.clearFoldRegions();
                StateInspectionFoldingDetector.access$foldLines(this$0);
            }
        }), (int)2, null);
    }

    private final void foldLines() {
        int lineIndex = 0;
        while (lineIndex < this.lines.size()) {
            String line = this.line(lineIndex);
            if (StringsKt.startsWith$default((String)line, (String)"value: ", (boolean)false, (int)2, null)) {
                lineIndex = this.foldDetailedValue(lineIndex);
                continue;
            }
            if (StringsKt.startsWith$default((String)line, (String)"at androidx.compose.runtime.CompositionImpl.recordReadOf", (boolean)false, (int)2, null)) {
                lineIndex = this.foldStartOfReadException(lineIndex);
                continue;
            }
            if (StringsKt.startsWith$default((String)line, (String)"at androidx.compose.runtime.RecomposeScopeImpl.compose", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)line, (String)"at androidx.compose.runtime.internal.ComposableLambdaImpl.invoke", (boolean)false, (int)2, null)) {
                lineIndex = this.foldEndOfException(lineIndex);
                continue;
            }
            ++lineIndex;
        }
    }

    private final int foldDetailedValue(int start2) {
        int next;
        block1: {
            next = CollectionsKt.indexOfFirst(this.lines, (int)start2, StateInspectionFoldingDetector::foldDetailedValue$lambda$0);
            if (next <= start2) break block1;
            String placeholderText = LayoutInspectorBundle.INSTANCE.message("layout.inspector.value.folding.hint", new String[0]);
            FoldRegion foldRegion = this.editor.getFoldingModel().addFoldRegion(this.startOffset(start2), this.endOffset(next), placeholderText);
            if (foldRegion != null) {
                FoldRegion it = foldRegion;
                boolean bl = false;
                it.setExpanded(false);
            }
        }
        return next;
    }

    private final int foldStartOfReadException(int start2) {
        int next;
        block8: {
            next = start2 + 1;
            String nextLine = null;
            nextLine = this.line(next);
            while (((CharSequence)nextLine).length() > 0 && !StringsKt.startsWith$default((String)nextLine, (String)"at androidx.compose.runtime.snapshots.SnapshotKt.readable", (boolean)false, (int)2, null)) {
                nextLine = this.line(++next);
            }
            if (!StringsKt.startsWith$default((String)nextLine, (String)"at androidx.compose.runtime.snapshots.SnapshotKt.readable", (boolean)false, (int)2, null)) {
                return start2;
            }
            while (true) {
                boolean bl;
                block7: {
                    Iterable $this$any$iv = StateInspectionFoldingDetectorKt.access$getRECORD_READ_EXCEPTION_PREFIXES$p();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            if (!StringsKt.startsWith$default((String)nextLine, (String)it, (boolean)false, (int)2, null)) continue;
                            bl = true;
                            break block7;
                        }
                        bl = false;
                    }
                }
                if (!bl) break;
                nextLine = this.line(++next);
            }
            if (--next <= start2) break block8;
            String[] stringArray = new String[]{String.valueOf(next - start2 + 1)};
            String placeholderText = LayoutInspectorBundle.INSTANCE.message("layout.inspector.stacktrace.folding.hint", stringArray);
            FoldRegion foldRegion = this.editor.getFoldingModel().addFoldRegion(this.startOffset(start2), this.endOffset(next), placeholderText);
            if (foldRegion != null) {
                FoldRegion it = foldRegion;
                boolean bl = false;
                it.setExpanded(false);
            }
        }
        return next;
    }

    private final int foldEndOfException(int start2) {
        int next;
        block2: {
            next = CollectionsKt.indexOfFirst(this.lines, (int)start2, StateInspectionFoldingDetector::foldEndOfException$lambda$0);
            if (next < 0) {
                return start2;
            }
            if (--next <= start2) break block2;
            String[] stringArray = new String[]{String.valueOf(next - start2 + 1)};
            String placeholderText = LayoutInspectorBundle.INSTANCE.message("layout.inspector.stacktrace.folding.hint", stringArray);
            FoldRegion foldRegion = this.editor.getFoldingModel().addFoldRegion(this.startOffset(start2), this.endOffset(next), placeholderText);
            if (foldRegion != null) {
                FoldRegion it = foldRegion;
                boolean bl = false;
                it.setExpanded(false);
            }
        }
        return next;
    }

    private final String line(int lineNumber) {
        return this.lines.size() > lineNumber ? ((Object)StringsKt.trimStart((CharSequence)this.lines.get(lineNumber))).toString() : "";
    }

    private final void fetchLines() {
        String string = this.document.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String text2 = string;
        this.lines = StringsKt.lines((CharSequence)text2);
    }

    private final int startOffset(int line) {
        return this.document.getLineStartOffset(line);
    }

    private final int endOffset(int line) {
        return this.document.getLineEndOffset(line);
    }

    private static final boolean foldDetailedValue$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((CharSequence)it).length() == 0;
    }

    private static final boolean foldEndOfException$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((CharSequence)it).length() == 0;
    }

    public static final /* synthetic */ void access$fetchLines(StateInspectionFoldingDetector $this) {
        $this.fetchLines();
    }

    public static final /* synthetic */ void access$foldLines(StateInspectionFoldingDetector $this) {
        $this.foldLines();
    }
}

