/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.runningdevices.ui.rendering;

import com.android.tools.idea.layoutinspector.runningdevices.ui.rendering.AbstractStudioRendererPanel;
import com.android.tools.idea.layoutinspector.runningdevices.ui.rendering.EmbeddedRendererModel;
import com.android.tools.idea.layoutinspector.runningdevices.ui.rendering.ForwardingMouseListener;
import com.android.tools.idea.layoutinspector.runningdevices.ui.rendering.StudioRendererPanelKt;
import com.intellij.openapi.Disposable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001BY\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\t\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\t\u00a2\u0006\u0004\b\u0011\u0010\u0012J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0014J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001b\u001a\u00020\u0019H\u0014J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\nH\u0002R\u0016\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/layoutinspector/runningdevices/ui/rendering/StudioRendererPanel;", "Lcom/android/tools/idea/layoutinspector/runningdevices/ui/rendering/AbstractStudioRendererPanel;", "disposable", "Lcom/intellij/openapi/Disposable;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "renderModel", "Lcom/android/tools/idea/layoutinspector/runningdevices/ui/rendering/EmbeddedRendererModel;", "displayRectangleProvider", "Lkotlin/Function0;", "Ljava/awt/Rectangle;", "screenScaleProvider", "", "orientationQuadrantProvider", "", "deviceDisplayDimensionProvider", "Ljava/awt/Dimension;", "<init>", "(Lcom/intellij/openapi/Disposable;Lkotlinx/coroutines/CoroutineScope;Lcom/android/tools/idea/layoutinspector/runningdevices/ui/rendering/EmbeddedRendererModel;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "interceptClicks", "", "getInterceptClicks", "()Z", "currentDrawingArea", "getRenderTransform", "Ljava/awt/geom/AffineTransform;", "getOverlayBounds", "transform", "calculateTransform", "displayRectangle", "intellij.android.layout-inspector"})
public final class StudioRendererPanel
extends AbstractStudioRendererPanel {
    @NotNull
    private final Function0<Rectangle> displayRectangleProvider;
    @NotNull
    private final Function0<Double> screenScaleProvider;
    @NotNull
    private final Function0<Integer> orientationQuadrantProvider;
    @NotNull
    private final Function0<Dimension> deviceDisplayDimensionProvider;
    @Nullable
    private Rectangle currentDrawingArea;

    public StudioRendererPanel(@NotNull Disposable disposable, @NotNull CoroutineScope scope, @NotNull EmbeddedRendererModel renderModel, @NotNull Function0<? extends Rectangle> displayRectangleProvider, @NotNull Function0<Double> screenScaleProvider, @NotNull Function0<Integer> orientationQuadrantProvider, @NotNull Function0<? extends Dimension> deviceDisplayDimensionProvider) {
        ForwardingMouseListener forwardingMouseListener;
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)renderModel, (String)"renderModel");
        Intrinsics.checkNotNullParameter(displayRectangleProvider, (String)"displayRectangleProvider");
        Intrinsics.checkNotNullParameter(screenScaleProvider, (String)"screenScaleProvider");
        Intrinsics.checkNotNullParameter(orientationQuadrantProvider, (String)"orientationQuadrantProvider");
        Intrinsics.checkNotNullParameter(deviceDisplayDimensionProvider, (String)"deviceDisplayDimensionProvider");
        super(disposable, scope, renderModel);
        this.displayRectangleProvider = displayRectangleProvider;
        this.screenScaleProvider = screenScaleProvider;
        this.orientationQuadrantProvider = orientationQuadrantProvider;
        this.deviceDisplayDimensionProvider = deviceDisplayDimensionProvider;
        ForwardingMouseListener it = forwardingMouseListener = new ForwardingMouseListener((Function0<? extends Component>)((Function0)() -> StudioRendererPanel._init_$lambda$0(this)), (Function0<Boolean>)((Function0)() -> StudioRendererPanel._init_$lambda$1(this)));
        boolean bl = false;
        this.addMouseListener(it);
        this.addMouseMotionListener(it);
        this.addMouseWheelListener(it);
    }

    @Override
    public boolean getInterceptClicks() {
        return (Boolean)this.getRenderModel().getInterceptClicks().getValue();
    }

    @Override
    @Nullable
    protected AffineTransform getRenderTransform() {
        Rectangle scaledDisplayRectangle;
        Rectangle rectangle = (Rectangle)this.displayRectangleProvider.invoke();
        if (rectangle == null) {
            return null;
        }
        Rectangle displayRectangle = rectangle;
        double physicalToLogicalScale = 1.0 / ((Number)this.screenScaleProvider.invoke()).doubleValue();
        this.currentDrawingArea = scaledDisplayRectangle = StudioRendererPanelKt.access$scale(displayRectangle, physicalToLogicalScale);
        return this.calculateTransform(scaledDisplayRectangle);
    }

    @Override
    @Nullable
    protected Rectangle getOverlayBounds(@NotNull AffineTransform transform2) {
        Intrinsics.checkNotNullParameter((Object)transform2, (String)"transform");
        Rectangle rectangle = this.currentDrawingArea;
        if (rectangle == null) {
            return null;
        }
        Rectangle drawingArea = rectangle;
        return transform2.createInverse().createTransformedShape(drawingArea).getBounds();
    }

    private final AffineTransform calculateTransform(Rectangle displayRectangle) {
        AffineTransform affineTransform;
        AffineTransform transform2;
        AffineTransform affineTransform2;
        Dimension deviceDisplayDimension = (Dimension)this.deviceDisplayDimensionProvider.invoke();
        Rectangle layoutInspectorDisplayRectangle = new Rectangle(0, 0, deviceDisplayDimension.width, deviceDisplayDimension.height);
        double scale = StudioRendererPanelKt.access$calculateScaleDifference(displayRectangle, layoutInspectorDisplayRectangle);
        int orientationQuadrant = ((Number)this.orientationQuadrantProvider.invoke()).intValue();
        this.getRenderModel().getRenderSettings().setScalePercent((int)(scale * (double)100));
        AffineTransform $this$calculateTransform_u24lambda_u240 = affineTransform2 = (transform2 = new AffineTransform());
        boolean bl = false;
        $this$calculateTransform_u24lambda_u240.scale(scale, scale);
        $this$calculateTransform_u24lambda_u240.quadrantRotate(orientationQuadrant);
        Shape deviceRectTrans = transform2.createTransformedShape(layoutInspectorDisplayRectangle);
        int xDelta = Math.abs(displayRectangle.x - deviceRectTrans.getBounds().x);
        int yDelta = Math.abs(displayRectangle.y - deviceRectTrans.getBounds().y);
        AffineTransform $this$calculateTransform_u24lambda_u241 = affineTransform = transform2;
        boolean bl2 = false;
        $this$calculateTransform_u24lambda_u241.quadrantRotate(-orientationQuadrant);
        $this$calculateTransform_u24lambda_u241.translate((double)xDelta / scale, (double)yDelta / scale);
        $this$calculateTransform_u24lambda_u241.quadrantRotate(orientationQuadrant);
        return transform2;
    }

    private static final Component _init_$lambda$0(StudioRendererPanel this$0) {
        Container container = this$0.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)container, (String)"getParent(...)");
        return container;
    }

    private static final boolean _init_$lambda$1(StudioRendererPanel this$0) {
        return !this$0.getInterceptClicks();
    }
}

