/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.runningdevices.ui.rendering;

import com.android.sdklib.deviceprovisioner.DeviceType;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.layoutinspector.LayoutInspector;
import com.android.tools.idea.layoutinspector.metrics.statistics.SessionStatistics;
import com.android.tools.idea.layoutinspector.resource.data.Display;
import com.android.tools.idea.layoutinspector.runningdevices.NavigationUtilsKt;
import com.android.tools.idea.layoutinspector.runningdevices.ui.rendering.EmbeddedRendererModel;
import com.android.tools.idea.layoutinspector.runningdevices.ui.rendering.OnDeviceRendererModel;
import com.android.tools.idea.layoutinspector.runningdevices.ui.rendering.OnDeviceRendererPanel;
import com.android.tools.idea.layoutinspector.runningdevices.ui.rendering.RenderingComponents;
import com.android.tools.idea.layoutinspector.runningdevices.ui.rendering.StudioRendererPanel;
import com.android.tools.idea.streaming.core.AbstractDisplayView;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u001a:\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00012\u0006\u0010\u0007\u001a\u00020\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u001a4\u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\nH\u0007\u001a\n\u0010\u0012\u001a\u00020\u0013*\u00020\b\u001a\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0002\u00a8\u0006\u0017"}, d2={"createRenderingComponents", "", "Lcom/android/tools/idea/layoutinspector/runningdevices/ui/rendering/RenderingComponents;", "disposable", "Lcom/intellij/openapi/Disposable;", "displayList", "Lcom/android/tools/idea/streaming/core/AbstractDisplayView;", "layoutInspector", "Lcom/android/tools/idea/layoutinspector/LayoutInspector;", "statsProvider", "Lkotlin/Function0;", "Lcom/android/tools/idea/layoutinspector/metrics/statistics/SessionStatistics;", "calculateRotationCorrection", "", "displayProvider", "Lcom/android/tools/idea/layoutinspector/resource/data/Display;", "displayOrientationQuadrant", "displayOrientationQuadrantCorrection", "navigateToSelectedViewFromRendererDoubleClick", "", "combine", "parentDisposable1", "parentDisposable2", "intellij.android.layout-inspector"})
@SourceDebugExtension(value={"SMAP\nRenderingComponents.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenderingComponents.kt\ncom/android/tools/idea/layoutinspector/runningdevices/ui/rendering/RenderingComponentsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,249:1\n1761#2,3:250\n1563#2:254\n1634#2,3:255\n1563#2:258\n1634#2,3:259\n1#3:253\n*S KotlinDebug\n*F\n+ 1 RenderingComponents.kt\ncom/android/tools/idea/layoutinspector/runningdevices/ui/rendering/RenderingComponentsKt\n*L\n63#1:250,3\n102#1:254\n102#1:255,3\n122#1:258\n122#1:259,3\n*E\n"})
public final class RenderingComponentsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<RenderingComponents> createRenderingComponents(@NotNull Disposable disposable, @NotNull List<? extends AbstractDisplayView> displayList, @NotNull LayoutInspector layoutInspector, @NotNull Function0<? extends SessionStatistics> statsProvider) {
        List list2;
        Object it;
        boolean bl;
        block9: {
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            Intrinsics.checkNotNullParameter(displayList, (String)"displayList");
            Intrinsics.checkNotNullParameter((Object)layoutInspector, (String)"layoutInspector");
            Intrinsics.checkNotNullParameter(statsProvider, (String)"statsProvider");
            Iterable $this$any$iv = displayList;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (AbstractDisplayView)element$iv;
                    boolean bl2 = false;
                    if (!(((AbstractDisplayView)it).getDeviceType() == DeviceType.XR_HEADSET)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        boolean isXrDevice = bl;
        boolean useOnDeviceRendering = isXrDevice || (Boolean)StudioFlags.DYNAMIC_LAYOUT_INSPECTOR_ON_DEVICE_RENDERING.get() != false;
        ((SessionStatistics)statsProvider.invoke()).setOnDeviceRendering(useOnDeviceRendering);
        if (useOnDeviceRendering) {
            void $this$mapTo$iv$iv;
            AbstractDisplayView mainDisplayView;
            Object v1;
            block10: {
                Object element$iv;
                element$iv = displayList;
                it = element$iv.iterator();
                while (it.hasNext()) {
                    Object bl2 = it.next();
                    AbstractDisplayView it2 = (AbstractDisplayView)bl2;
                    boolean bl3 = false;
                    if (!(it2.getDisplayId() == 0)) continue;
                    v1 = bl2;
                    break block10;
                }
                v1 = null;
            }
            if ((mainDisplayView = (AbstractDisplayView)v1) == null) {
                boolean $i$a$-checkNotNull-RenderingComponentsKt$createRenderingComponents$32 = false;
                String $i$a$-checkNotNull-RenderingComponentsKt$createRenderingComponents$32 = "Main display is missing";
                throw new IllegalStateException($i$a$-checkNotNull-RenderingComponentsKt$createRenderingComponents$32.toString());
            }
            Disposable combinedDisposable = RenderingComponentsKt.combine(disposable, mainDisplayView);
            renderModel = new EmbeddedRendererModel(combinedDisposable, null, layoutInspector.getInspectorModel(), layoutInspector.getTreeSettings(), layoutInspector.getRenderSettings(), (Function0<Unit>)((Function0)() -> RenderingComponentsKt.createRenderingComponents$lambda$4(layoutInspector)));
            OnDeviceRendererModel onDeviceRendererModel = new OnDeviceRendererModel(combinedDisposable, layoutInspector.getCoroutineScope(), (EmbeddedRendererModel)renderModel);
            Iterable $this$map$iv = displayList;
            boolean $i$f$map = false;
            Iterable bl3 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void displayView;
                AbstractDisplayView abstractDisplayView = (AbstractDisplayView)item$iv$iv;
                Collection collection2 = destination$iv$iv2;
                boolean bl4 = false;
                OnDeviceRendererPanel renderer2 = new OnDeviceRendererPanel(combinedDisposable, layoutInspector.getCoroutineScope(), onDeviceRendererModel, arg_0 -> RenderingComponentsKt.createRenderingComponents$lambda$5$0((AbstractDisplayView)displayView, arg_0), null, 16, null);
                collection2.add(new RenderingComponents(combinedDisposable, layoutInspector, renderer2, (EmbeddedRendererModel)renderModel, (AbstractDisplayView)displayView));
            }
            list2 = (List)destination$iv$iv2;
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = displayList;
            boolean $i$f$map = false;
            renderModel = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void displayView;
                AbstractDisplayView destination$iv$iv2 = (AbstractDisplayView)item$iv$iv;
                Collection collection3 = destination$iv$iv;
                boolean bl5 = false;
                Disposable combinedDisposable = RenderingComponentsKt.combine(disposable, (Disposable)displayView);
                EmbeddedRendererModel renderModel = new EmbeddedRendererModel(combinedDisposable, displayView.getDisplayId(), layoutInspector.getInspectorModel(), layoutInspector.getTreeSettings(), layoutInspector.getRenderSettings(), (Function0<Unit>)((Function0)() -> RenderingComponentsKt.createRenderingComponents$lambda$6$0(layoutInspector)));
                CoroutineScope coroutineScope = layoutInspector.getCoroutineScope();
                StudioRendererPanel renderer3 = new StudioRendererPanel(combinedDisposable, coroutineScope, renderModel, (Function0<? extends Rectangle>)((Function0)() -> RenderingComponentsKt.createRenderingComponents$lambda$6$1((AbstractDisplayView)displayView)), (Function0<Double>)((Function0)() -> RenderingComponentsKt.createRenderingComponents$lambda$6$2((AbstractDisplayView)displayView)), (Function0<Integer>)((Function0)() -> RenderingComponentsKt.createRenderingComponents$lambda$6$3(layoutInspector, (AbstractDisplayView)displayView)), (Function0<? extends Dimension>)((Function0)() -> RenderingComponentsKt.createRenderingComponents$lambda$6$4(renderModel, (AbstractDisplayView)displayView)));
                collection3.add(new RenderingComponents(combinedDisposable, layoutInspector, renderer3, renderModel, (AbstractDisplayView)displayView));
            }
            list2 = (List)destination$iv$iv;
        }
        return list2;
    }

    public static /* synthetic */ List createRenderingComponents$default(Disposable disposable, List list2, LayoutInspector layoutInspector, Function0 function0, int n, Object object) {
        if ((n & 8) != 0) {
            function0 = () -> RenderingComponentsKt.createRenderingComponents$lambda$0(layoutInspector);
        }
        return RenderingComponentsKt.createRenderingComponents(disposable, list2, layoutInspector, (Function0<? extends SessionStatistics>)function0);
    }

    @VisibleForTesting
    public static final int calculateRotationCorrection(@NotNull Function0<Display> displayProvider, @NotNull Function0<Integer> displayOrientationQuadrant, @NotNull Function0<Integer> displayOrientationQuadrantCorrection) {
        int n;
        int n2;
        Integer n3;
        Intrinsics.checkNotNullParameter(displayProvider, (String)"displayProvider");
        Intrinsics.checkNotNullParameter(displayOrientationQuadrant, (String)"displayOrientationQuadrant");
        Intrinsics.checkNotNullParameter(displayOrientationQuadrantCorrection, (String)"displayOrientationQuadrantCorrection");
        int orientationCorrectionFromRunningDevices = ((Number)displayOrientationQuadrantCorrection.invoke()).intValue();
        if (orientationCorrectionFromRunningDevices != 0) {
            return -orientationCorrectionFromRunningDevices;
        }
        int displayRectangleOrientationQuadrant = ((Number)displayOrientationQuadrant.invoke()).intValue();
        Display display = (Display)displayProvider.invoke();
        Integer n4 = n3 = display != null ? Integer.valueOf(display.getOrientation()) : null;
        if (n4 != null && n4 == 0) {
            n2 = 0;
        } else {
            Integer n5 = n3;
            n = 90;
            if (n5 != null && n5 == n) {
                n2 = 1;
            } else {
                Integer n6 = n3;
                n = 180;
                if (n6 != null && n6 == n) {
                    n2 = 2;
                } else {
                    Integer n7 = n3;
                    n = 270;
                    n2 = n7 != null && n7 == n ? 3 : 0;
                }
            }
        }
        int layoutInspectorDisplayOrientationQuadrant = n2;
        int n8 = layoutInspectorDisplayOrientationQuadrant - displayRectangleOrientationQuadrant;
        n = 4;
        int n9 = n8 % n;
        return n9 + (n & ((n9 ^ n) & (n9 | -n9)) >> 31);
    }

    public static final void navigateToSelectedViewFromRendererDoubleClick(@NotNull LayoutInspector $this$navigateToSelectedViewFromRendererDoubleClick) {
        Intrinsics.checkNotNullParameter((Object)$this$navigateToSelectedViewFromRendererDoubleClick, (String)"<this>");
        NavigationUtilsKt.navigateToSelectedViewFromRendererDoubleClick($this$navigateToSelectedViewFromRendererDoubleClick.getCoroutineScope(), $this$navigateToSelectedViewFromRendererDoubleClick.getInspectorModel(), $this$navigateToSelectedViewFromRendererDoubleClick.getCurrentClient(), $this$navigateToSelectedViewFromRendererDoubleClick.getNotificationModel());
    }

    private static final Disposable combine(Disposable parentDisposable1, Disposable parentDisposable2) {
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable newDisposable = disposable;
        Disposer.register((Disposable)parentDisposable1, () -> RenderingComponentsKt.combine$lambda$0(newDisposable));
        Disposer.register((Disposable)parentDisposable2, () -> RenderingComponentsKt.combine$lambda$1(newDisposable));
        return newDisposable;
    }

    private static final SessionStatistics createRenderingComponents$lambda$0(LayoutInspector $layoutInspector) {
        return $layoutInspector.getCurrentClient().getStats();
    }

    private static final Unit createRenderingComponents$lambda$4(LayoutInspector $layoutInspector) {
        RenderingComponentsKt.navigateToSelectedViewFromRendererDoubleClick($layoutInspector);
        return Unit.INSTANCE;
    }

    private static final Unit createRenderingComponents$lambda$5$0(AbstractDisplayView $displayView, boolean enable) {
        $displayView.setRightClicksAreSentToDevice(enable);
        return Unit.INSTANCE;
    }

    private static final Unit createRenderingComponents$lambda$6$0(LayoutInspector $layoutInspector) {
        RenderingComponentsKt.navigateToSelectedViewFromRendererDoubleClick($layoutInspector);
        return Unit.INSTANCE;
    }

    private static final Rectangle createRenderingComponents$lambda$6$1(AbstractDisplayView $displayView) {
        return $displayView.getDisplayRectangle();
    }

    private static final double createRenderingComponents$lambda$6$2(AbstractDisplayView $displayView) {
        return $displayView.getScreenScalingFactor();
    }

    private static final int createRenderingComponents$lambda$6$3(LayoutInspector $layoutInspector, AbstractDisplayView $displayView) {
        return RenderingComponentsKt.calculateRotationCorrection((Function0<Display>)((Function0)() -> RenderingComponentsKt.createRenderingComponents$lambda$6$3$0($layoutInspector, $displayView)), (Function0<Integer>)((Function0)() -> RenderingComponentsKt.createRenderingComponents$lambda$6$3$1($displayView)), (Function0<Integer>)((Function0)() -> RenderingComponentsKt.createRenderingComponents$lambda$6$3$2($displayView)));
    }

    private static final Display createRenderingComponents$lambda$6$3$0(LayoutInspector $layoutInspector, AbstractDisplayView $displayView) {
        Object v0;
        block1: {
            Iterable iterable = $layoutInspector.getInspectorModel().getResourceLookup().getDisplays();
            for (Object t : iterable) {
                Display it = (Display)t;
                boolean bl = false;
                if (!(it.getId() == $displayView.getDisplayId())) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private static final int createRenderingComponents$lambda$6$3$1(AbstractDisplayView $displayView) {
        return $displayView.getDisplayOrientationQuadrants();
    }

    private static final int createRenderingComponents$lambda$6$3$2(AbstractDisplayView $displayView) {
        return $displayView.getDisplayOrientationCorrectionQuadrants();
    }

    private static final Dimension createRenderingComponents$lambda$6$4(EmbeddedRendererModel $renderModel, AbstractDisplayView $displayView) {
        return $renderModel.getInspectorModel().getDisplayDimension($displayView.getDisplayId());
    }

    private static final void combine$lambda$0(Disposable $newDisposable) {
        Disposer.dispose((Disposable)$newDisposable);
    }

    private static final void combine$lambda$1(Disposable $newDisposable) {
        Disposer.dispose((Disposable)$newDisposable);
    }
}

