/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.runningdevices.actions;

import com.android.tools.idea.layoutinspector.LayoutInspectorBundle;
import com.android.tools.idea.layoutinspector.runningdevices.LayoutInspectorManager;
import com.android.tools.idea.layoutinspector.runningdevices.LayoutInspectorManagerGlobalState;
import com.android.tools.idea.layoutinspector.runningdevices.actions.ToggleLayoutInspectorActionKt;
import com.android.tools.idea.layoutinspector.settings.LayoutInspectorSettings;
import com.android.tools.idea.streaming.core.AbstractDisplayView;
import com.android.tools.idea.streaming.core.DeviceId;
import com.android.tools.idea.streaming.core.StreamingConstants;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.TooltipDescriptionProvider;
import com.intellij.openapi.actionSystem.ex.TooltipLinkProvider;
import com.intellij.openapi.project.Project;
import icons.StudioIcons;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u001d\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016R\u001c\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/layoutinspector/runningdevices/actions/ToggleLayoutInspectorAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/actionSystem/ex/TooltipDescriptionProvider;", "Lcom/intellij/openapi/actionSystem/ex/TooltipLinkProvider;", "showNotificationDiscovery", "Lkotlin/Function1;", "Lcom/intellij/openapi/project/Project;", "", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "state", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "update", "enforceOnlyOneLayoutInspectorPerDeviceAcrossProjects", "getTooltipLink", "Lcom/intellij/openapi/actionSystem/ex/TooltipLinkProvider$TooltipLink;", "owner", "Ljavax/swing/JComponent;", "intellij.android.layout-inspector"})
@SourceDebugExtension(value={"SMAP\nToggleLayoutInspectorAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToggleLayoutInspectorAction.kt\ncom/android/tools/idea/layoutinspector/runningdevices/actions/ToggleLayoutInspectorAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,174:1\n1#2:175\n*E\n"})
public final class ToggleLayoutInspectorAction
extends ToggleAction
implements TooltipDescriptionProvider,
TooltipLinkProvider {
    @TestOnly
    @NotNull
    private final Function1<Project, Unit> showNotificationDiscovery;

    public ToggleLayoutInspectorAction(@NotNull Function1<? super Project, Unit> showNotificationDiscovery) {
        Intrinsics.checkNotNullParameter(showNotificationDiscovery, (String)"showNotificationDiscovery");
        super("Toggle Layout Inspector", "Toggles Layout Inspection on and off for this device.", StudioIcons.Shell.ToolWindows.CAPTURES);
        this.showNotificationDiscovery = showNotificationDiscovery;
    }

    public /* synthetic */ ToggleLayoutInspectorAction(Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function1 = ToggleLayoutInspectorAction::_init_$lambda$0;
        }
        this((Function1<? super Project, Unit>)function1);
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!LayoutInspectorSettings.Companion.getInstance().getEmbeddedLayoutInspectorEnabled()) {
            return false;
        }
        Project project = e.getProject();
        if (project == null) {
            return false;
        }
        Project project2 = project;
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DeviceId deviceId = (DeviceId)StreamingConstants.DEVICE_ID_KEY.getData(dataContext);
        if (deviceId == null) {
            return false;
        }
        DeviceId deviceId2 = deviceId;
        return LayoutInspectorManager.Companion.getInstance(project2).isEnabled(deviceId2);
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state2) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!LayoutInspectorSettings.Companion.getInstance().getEmbeddedLayoutInspectorEnabled()) {
            return;
        }
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DeviceId deviceId = (DeviceId)StreamingConstants.DEVICE_ID_KEY.getData(dataContext);
        if (deviceId == null) {
            return;
        }
        DeviceId deviceId2 = deviceId;
        LayoutInspectorManager.Companion.getInstance(project2).enableLayoutInspector(deviceId2, state2);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DeviceId deviceId = (DeviceId)StreamingConstants.DEVICE_ID_KEY.getData(dataContext);
        if (deviceId == null) {
            this.showNotificationDiscovery.invoke((Object)project2);
        } else {
            super.actionPerformed(e);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DeviceId deviceId = (DeviceId)StreamingConstants.DEVICE_ID_KEY.getData(dataContext);
        if (deviceId == null) {
            return;
        }
        DeviceId deviceId2 = deviceId;
        boolean isEnabled = LayoutInspectorSettings.Companion.getInstance().getEmbeddedLayoutInspectorEnabled();
        e.getPresentation().setVisible(isEnabled && LayoutInspectorManager.Companion.getInstance(project2).isSupported(deviceId2));
        DataContext dataContext2 = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        AbstractDisplayView displayView = (AbstractDisplayView)StreamingConstants.DISPLAY_VIEW_KEY.getData(dataContext2);
        Object object3 = this;
        try {
            ToggleLayoutInspectorAction $this$update_u24lambda_u240 = object3;
            boolean bl = false;
            AbstractDisplayView abstractDisplayView = displayView;
            object2 = Result.constructor-impl((Object)(abstractDisplayView != null ? Integer.valueOf(abstractDisplayView.getApiLevel()) : null));
        }
        catch (Throwable bl) {
            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object3 = object2;
        Integer apiLevel = (Integer)(Result.isFailure-impl((Object)object3) ? null : object3);
        object2 = this;
        try {
            ToggleLayoutInspectorAction $this$update_u24lambda_u241 = (ToggleLayoutInspectorAction)((Object)object2);
            boolean bl = false;
            AbstractDisplayView abstractDisplayView = displayView;
            object = Result.constructor-impl((Object)(abstractDisplayView != null ? abstractDisplayView.getDeviceSerialNumber() : null));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        String serialNumber = (String)(Result.isFailure-impl((Object)object2) ? null : object2);
        if (apiLevel == null || serialNumber == null) {
            e.getPresentation().setEnabled(false);
        } else if (apiLevel < 29) {
            e.getPresentation().setEnabled(false);
            e.getPresentation().setDescription(LayoutInspectorBundle.INSTANCE.message("api.29.limit", new String[0]));
        } else {
            e.getPresentation().setEnabled(true);
            e.getPresentation().setDescription("");
        }
        if (e.getPresentation().isVisible() && e.getPresentation().isEnabled()) {
            this.enforceOnlyOneLayoutInspectorPerDeviceAcrossProjects(e);
        }
    }

    private final void enforceOnlyOneLayoutInspectorPerDeviceAcrossProjects(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DeviceId deviceId = (DeviceId)StreamingConstants.DEVICE_ID_KEY.getData(dataContext);
        if (deviceId == null) {
            return;
        }
        DeviceId deviceId2 = deviceId;
        boolean isLayoutInspectorEnabledForTab = LayoutInspectorManager.Companion.getInstance(project2).isEnabled(deviceId2);
        if (!isLayoutInspectorEnabledForTab && LayoutInspectorManagerGlobalState.INSTANCE.getTabsWithLayoutInspector().contains(deviceId2)) {
            e.getPresentation().setEnabled(false);
            e.getPresentation().setDescription(LayoutInspectorBundle.INSTANCE.message("layout.inspector.active.in.another.project", new String[0]));
        }
    }

    @NotNull
    public TooltipLinkProvider.TooltipLink getTooltipLink(@Nullable JComponent owner) {
        return new TooltipLinkProvider.TooltipLink(LayoutInspectorBundle.INSTANCE.message("learn.more", new String[0]), ToggleLayoutInspectorAction::getTooltipLink$lambda$0);
    }

    private static final Unit _init_$lambda$0(Project it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ToggleLayoutInspectorActionKt.access$showLayoutInspectorDiscoveryPopUp(it);
        return Unit.INSTANCE;
    }

    private static final void getTooltipLink$lambda$0() {
        BrowserUtil.browse((String)"https://d.android.com/r/studio-ui/layout-inspector");
    }

    public ToggleLayoutInspectorAction() {
        this(null, 1, null);
    }
}

