/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.runningdevices;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.appinspection.inspector.api.process.DeviceDescriptor;
import com.android.tools.idea.layoutinspector.LayoutInspector;
import com.android.tools.idea.layoutinspector.pipeline.foregroundprocessdetection.DeviceModel;
import com.android.tools.idea.layoutinspector.pipeline.foregroundprocessdetection.ForegroundProcessDetection;
import com.android.tools.idea.layoutinspector.runningdevices.LayoutInspectorManager;
import com.android.tools.idea.layoutinspector.runningdevices.LayoutInspectorManagerGlobalState;
import com.android.tools.idea.layoutinspector.runningdevices.LayoutInspectorManagerKt;
import com.android.tools.idea.layoutinspector.runningdevices.RunningDevicesStateObserver;
import com.android.tools.idea.layoutinspector.runningdevices.ui.SelectedTabState;
import com.android.tools.idea.layoutinspector.runningdevices.ui.TabComponents;
import com.android.tools.idea.streaming.core.DeviceId;
import com.android.tools.idea.streaming.core.DisplayOwner;
import com.android.tools.idea.streaming.core.StreamingConstants;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.content.Content;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UiThread
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\bH\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\bH\u0016J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\bH\u0016J\b\u0010\u001a\u001a\u00020\u0015H\u0016J\b\u0010\u001b\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\n\u0010\u000bR\"\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u0006\u001a\u0004\u0018\u00010\f@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/layoutinspector/runningdevices/LayoutInspectorManagerImpl;", "Lcom/android/tools/idea/layoutinspector/runningdevices/LayoutInspectorManager;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "value", "", "Lcom/android/tools/idea/streaming/core/DeviceId;", "tabsWithLayoutInspector", "setTabsWithLayoutInspector", "(Ljava/util/Set;)V", "Lcom/android/tools/idea/layoutinspector/runningdevices/ui/SelectedTabState;", "selectedTab", "setSelectedTab", "(Lcom/android/tools/idea/layoutinspector/runningdevices/ui/SelectedTabState;)V", "existingRunningDevicesTabs", "", "createTabState", "deviceId", "enableLayoutInspector", "", "enable", "", "isEnabled", "isSupported", "dispose", "disable", "intellij.android.layout-inspector"})
@SourceDebugExtension(value={"SMAP\nLayoutInspectorManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LayoutInspectorManager.kt\ncom/android/tools/idea/layoutinspector/runningdevices/LayoutInspectorManagerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,316:1\n1#2:317\n*E\n"})
final class LayoutInspectorManagerImpl
implements LayoutInspectorManager {
    @NotNull
    private final Project project;
    @NotNull
    private Set<? extends DeviceId> tabsWithLayoutInspector;
    @Nullable
    private SelectedTabState selectedTab;
    @NotNull
    private List<? extends DeviceId> existingRunningDevicesTabs;

    public LayoutInspectorManagerImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.tabsWithLayoutInspector = SetsKt.emptySet();
        this.existingRunningDevicesTabs = CollectionsKt.emptyList();
        RunningDevicesStateObserver.Companion.getInstance(this.project).addListener(new RunningDevicesStateObserver.Listener(){

            /*
             * WARNING - void declaration
             */
            @Override
            public void onVisibleTabsChanged(List<? extends DeviceId> visibleTabs) {
                List visibleTabsWithLayoutInspector;
                block5: {
                    Object object;
                    LayoutInspectorManagerImpl layoutInspectorManagerImpl;
                    block7: {
                        block6: {
                            void it;
                            void $this$filterTo$iv$iv;
                            void $this$filter$iv;
                            Intrinsics.checkNotNullParameter(visibleTabs, (String)"visibleTabs");
                            Iterable iterable = visibleTabs;
                            LayoutInspectorManagerImpl layoutInspectorManagerImpl2 = this;
                            boolean $i$f$filter = false;
                            void var6_5 = $this$filter$iv;
                            Object destination$iv$iv = new ArrayList();
                            boolean $i$f$filterTo = false;
                            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                                DeviceId it2 = (DeviceId)element$iv$iv;
                                boolean bl = false;
                                if (!layoutInspectorManagerImpl2.tabsWithLayoutInspector.contains(it2)) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            visibleTabsWithLayoutInspector = (List)destination$iv$iv;
                            if (visibleTabsWithLayoutInspector.size() <= 1) break block5;
                            layoutInspectorManagerImpl = this;
                            object = selectedTab;
                            if (object == null || (object = ((SelectedTabState)object).getDeviceId()) == null) break block6;
                            destination$iv$iv = object;
                            LayoutInspectorManagerImpl layoutInspectorManagerImpl3 = layoutInspectorManagerImpl;
                            boolean bl = false;
                            Set set2 = SetsKt.setOf((Object)it);
                            layoutInspectorManagerImpl = layoutInspectorManagerImpl3;
                            object = set2;
                            if (set2 != null) break block7;
                        }
                        object = SetsKt.emptySet();
                    }
                    layoutInspectorManagerImpl.setTabsWithLayoutInspector((Set)object);
                    return;
                }
                DeviceId newSelectedTab = (DeviceId)CollectionsKt.firstOrNull((List)visibleTabsWithLayoutInspector);
                SelectedTabState selectedTabState = selectedTab;
                if (Intrinsics.areEqual((Object)newSelectedTab, (Object)(selectedTabState != null ? selectedTabState.getDeviceId() : null))) {
                    return;
                }
                this.setSelectedTab(newSelectedTab != null ? this.createTabState(newSelectedTab) : null);
            }

            @Override
            public void onExistingTabsChanged(List<? extends DeviceId> existingTabs) {
                Intrinsics.checkNotNullParameter(existingTabs, (String)"existingTabs");
                existingRunningDevicesTabs = existingTabs;
            }
        });
    }

    private final void setTabsWithLayoutInspector(Set<? extends DeviceId> value2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (Intrinsics.areEqual(value2, this.tabsWithLayoutInspector)) {
            return;
        }
        Set tabsAdded = SetsKt.minus(value2, (Iterable)this.tabsWithLayoutInspector);
        Set tabsRemoved = SetsKt.minus(this.tabsWithLayoutInspector, (Iterable)value2);
        SelectedTabState selectedTabState = this.selectedTab;
        if (CollectionsKt.contains((Iterable)tabsRemoved, (Object)(selectedTabState != null ? selectedTabState.getDeviceId() : null))) {
            this.setSelectedTab(null);
        }
        this.tabsWithLayoutInspector = value2;
        LayoutInspectorManagerGlobalState.INSTANCE.getTabsWithLayoutInspector().addAll(tabsAdded);
        LayoutInspectorManagerGlobalState.INSTANCE.getTabsWithLayoutInspector().removeAll(tabsRemoved);
    }

    private final void setSelectedTab(SelectedTabState value2) {
        DeviceDescriptor selectedDevice;
        Object object;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (Intrinsics.areEqual((Object)this.selectedTab, (Object)value2)) {
            return;
        }
        SelectedTabState previousTab = this.selectedTab;
        if (previousTab != null) {
            Disposer.dispose((Disposable)previousTab.getTabComponents());
            previousTab.getLayoutInspector().stopInspector();
            DeviceModel deviceModel = previousTab.getLayoutInspector().getDeviceModel();
            if (deviceModel != null) {
                deviceModel.setForcedDeviceSerialNumber(null);
            }
            ForegroundProcessDetection foregroundProcessDetection = previousTab.getLayoutInspector().getForegroundProcessDetection();
            if (foregroundProcessDetection != null) {
                foregroundProcessDetection.stop();
            }
        }
        this.selectedTab = value2;
        if (value2 == null) {
            return;
        }
        DeviceModel deviceModel = value2.getLayoutInspector().getDeviceModel();
        if (deviceModel != null) {
            deviceModel.setForcedDeviceSerialNumber(value2.getDeviceId().getSerialNumber());
        }
        ForegroundProcessDetection foregroundProcessDetection = value2.getLayoutInspector().getForegroundProcessDetection();
        if (foregroundProcessDetection != null) {
            foregroundProcessDetection.start(value2.getDeviceId().getSerialNumber());
        }
        if ((object = value2.getLayoutInspector().getDeviceModel()) != null && (object = ((DeviceModel)object).getDevices()) != null) {
            Object v5;
            block12: {
                Iterable iterable = (Iterable)object;
                for (Object t : iterable) {
                    DeviceDescriptor it = (DeviceDescriptor)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getSerial(), (Object)value2.getDeviceId().getSerialNumber())) continue;
                    v5 = t;
                    break block12;
                }
                v5 = null;
            }
            v6 = v5;
        } else {
            v6 = selectedDevice = null;
        }
        if (selectedDevice != null) {
            ForegroundProcessDetection foregroundProcessDetection2 = value2.getLayoutInspector().getForegroundProcessDetection();
            if (foregroundProcessDetection2 != null) {
                SelectedTabState selectedTabState = previousTab;
                foregroundProcessDetection2.startPollingDevice(selectedDevice, CollectionsKt.contains((Iterable)this.existingRunningDevicesTabs, (Object)(selectedTabState != null ? selectedTabState.getDeviceId() : null)));
            }
        }
        value2.enableLayoutInspector();
    }

    private final SelectedTabState createTabState(DeviceId deviceId) {
        Content selectedTabContent;
        ThreadingAssertions.assertEventDispatchThread();
        Content content2 = selectedTabContent = RunningDevicesStateObserver.Companion.getInstance(this.project).getTabContent(deviceId);
        JComponent jComponent = content2 != null ? content2.getComponent() : null;
        if (jComponent == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        JComponent streamingDevicePanel = jComponent;
        DataContext dataContext = DataManager.getInstance().customizeDataContext(DataContext.EMPTY_CONTEXT, (Object)streamingDevicePanel);
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"customizeDataContext(...)");
        DataContext selectedTabDataProvider = dataContext;
        BorderLayoutPanel streamingContentPanel = (BorderLayoutPanel)StreamingConstants.STREAMING_CONTENT_PANEL_KEY.getData(selectedTabDataProvider);
        if (streamingContentPanel == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        Disposable disposable = (Disposable)selectedTabContent;
        JComponent jComponent2 = (JComponent)streamingContentPanel;
        Container container = streamingContentPanel.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)container, (String)"getParent(...)");
        Intrinsics.checkNotNull((Object)streamingDevicePanel, (String)"null cannot be cast to non-null type com.android.tools.idea.streaming.core.DisplayOwner");
        TabComponents tabComponents = new TabComponents(disposable, jComponent2, container, (DisplayOwner)((Object)streamingDevicePanel));
        LayoutInspector layoutInspector = LayoutInspectorManagerKt.access$getLayoutInspector(this.project);
        return new SelectedTabState(tabComponents, this.project, deviceId, tabComponents, layoutInspector, null, 32, null);
    }

    @Override
    public void enableLayoutInspector(@NotNull DeviceId deviceId, boolean enable) {
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (enable) {
            ToolWindowEx toolWindow;
            ToolWindow toolWindow2 = ToolWindowManager.Companion.getInstance(this.project).getToolWindow("Running Devices");
            ToolWindowEx toolWindowEx = toolWindow = toolWindow2 instanceof ToolWindowEx ? (ToolWindowEx)toolWindow2 : null;
            if (toolWindowEx != null) {
                Comparable comparable;
                ToolWindowEx it = toolWindowEx;
                boolean bl = false;
                List list2 = toolWindow.getContentManager().getContentsRecursively();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getContentsRecursively(...)");
                Iterator iterator2 = ((Iterable)list2).iterator();
                if (!iterator2.hasNext()) {
                    comparable = null;
                } else {
                    Content it2 = (Content)iterator2.next();
                    boolean bl2 = false;
                    Comparable comparable2 = Integer.valueOf(it2.getComponent().getWidth());
                    while (iterator2.hasNext()) {
                        Content it3 = (Content)iterator2.next();
                        $i$a$-maxOfOrNull-LayoutInspectorManagerImpl$enableLayoutInspector$1$currentWidth$1 = false;
                        Comparable comparable3 = Integer.valueOf(it3.getComponent().getWidth());
                        if (comparable2.compareTo(comparable3) >= 0) continue;
                        comparable2 = comparable3;
                    }
                    comparable = comparable2;
                }
                Integer currentWidth = (Integer)comparable;
                int desiredWidth = JBUIScale.scale((int)800);
                if (currentWidth != null && currentWidth < desiredWidth) {
                    toolWindow.stretchWidth(desiredWidth - currentWidth);
                }
            }
            SelectedTabState selectedTabState = this.selectedTab;
            if (selectedTabState != null) {
                SelectedTabState it = selectedTabState;
                boolean bl = false;
                this.setTabsWithLayoutInspector(SetsKt.minus(this.tabsWithLayoutInspector, (Object)it.getDeviceId()));
            }
            if (this.tabsWithLayoutInspector.contains(deviceId)) {
                return;
            }
            this.setTabsWithLayoutInspector(SetsKt.plus(this.tabsWithLayoutInspector, (Object)deviceId));
            this.setSelectedTab(this.createTabState(deviceId));
        } else {
            if (!this.tabsWithLayoutInspector.contains(deviceId)) {
                return;
            }
            this.setTabsWithLayoutInspector(SetsKt.minus(this.tabsWithLayoutInspector, (Object)deviceId));
            SelectedTabState selectedTabState = this.selectedTab;
            if (Intrinsics.areEqual((Object)(selectedTabState != null ? selectedTabState.getDeviceId() : null), (Object)deviceId)) {
                this.setSelectedTab(null);
            }
        }
    }

    @Override
    public boolean isEnabled(@NotNull DeviceId deviceId) {
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        ApplicationManager.getApplication().assertIsDispatchThread();
        SelectedTabState selectedTabState = this.selectedTab;
        return Intrinsics.areEqual((Object)(selectedTabState != null ? selectedTabState.getDeviceId() : null), (Object)deviceId);
    }

    @Override
    public boolean isSupported(@NotNull DeviceId deviceId) {
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        return RunningDevicesStateObserver.Companion.getInstance(this.project).hasDevice(deviceId);
    }

    public void dispose() {
        this.setSelectedTab(null);
        this.setTabsWithLayoutInspector(SetsKt.emptySet());
    }

    @Override
    public void disable() {
        this.setSelectedTab(null);
        this.setTabsWithLayoutInspector(SetsKt.emptySet());
    }
}

