/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.resource;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.ResourcesUtil;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.util.PathString;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.dom.attrs.AttributeDefinition;
import com.android.tools.dom.attrs.AttributeDefinitions;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.layoutinspector.model.ComposeViewNode;
import com.android.tools.idea.layoutinspector.model.ViewNode;
import com.android.tools.idea.layoutinspector.properties.InspectorPropertyItem;
import com.android.tools.idea.layoutinspector.properties.PropertyType;
import com.android.tools.idea.layoutinspector.resource.ResourceLookupResolverKt;
import com.android.tools.idea.layoutinspector.resource.SourceLocation;
import com.android.tools.idea.layoutinspector.resource.StyleItemResourceValueWithStyleReference;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.ResourceNamespaceContext;
import com.android.tools.idea.res.StateList;
import com.android.tools.idea.res.StateListState;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.android.tools.idea.util.FileExtensions;
import com.android.tools.res.LocalResourceRepository;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.text.StringKt;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.android.dom.AttributeProcessingUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.FrameworkResourceManager;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00ec\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001qB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ \u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%J6\u0010&\u001a\u00020'2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010+\u001a\u00020,J\u0010\u0010-\u001a\u0004\u0018\u00010*2\u0006\u0010\"\u001a\u00020#J\u001c\u0010.\u001a\u0004\u0018\u00010/2\b\u00100\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\"\u001a\u00020#H\u0007J\u0018\u00101\u001a\u0002022\u0006\u0010\"\u001a\u00020#2\u0006\u00103\u001a\u00020\u001fH\u0007J$\u00104\u001a\u0004\u0018\u0001052\u0006\u00106\u001a\u0002072\b\u00108\u001a\u0004\u0018\u00010\u001f2\u0006\u00103\u001a\u00020\u001fH\u0002J\u0012\u00109\u001a\u0004\u0018\u00010:2\u0006\u00106\u001a\u000207H\u0002J6\u0010;\u001a\u00020'2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010<\u001a\u00020%2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010+\u001a\u00020,H\u0002J\u001e\u0010=\u001a\u00020'2\u0006\u0010<\u001a\u00020%2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)H\u0002J\u0010\u0010>\u001a\u00020*2\u0006\u0010<\u001a\u00020%H\u0002J\b\u0010?\u001a\u00020*H\u0002J.\u0010@\u001a\u00020'2\u0006\u0010 \u001a\u00020!2\u0006\u0010A\u001a\u00020%2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010+\u001a\u00020,H\u0002J\"\u0010B\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010<\u001a\u00020%H\u0002J\"\u0010C\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010A\u001a\u00020%H\u0002J\"\u0010D\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010E\u001a\u00020FH\u0002J\u001a\u0010G\u001a\u0004\u0018\u00010\u001f2\u0006\u0010E\u001a\u00020F2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010H\u001a\u00020%2\u0006\u0010 \u001a\u00020!H\u0002J\u0012\u0010I\u001a\u0004\u0018\u00010F2\u0006\u00100\u001a\u00020FH\u0002J\u001a\u0010J\u001a\u0004\u0018\u00010F2\u0006\u0010K\u001a\u00020L2\u0006\u00100\u001a\u00020FH\u0002J\u0010\u0010M\u001a\u00020\u00142\u0006\u0010N\u001a\u00020OH\u0002J\u0014\u0010P\u001a\u0004\u0018\u00010Q2\b\u0010R\u001a\u0004\u0018\u00010%H\u0002J\u0012\u0010S\u001a\u0004\u0018\u00010F2\u0006\u0010T\u001a\u00020UH\u0002J\u0012\u0010V\u001a\u0004\u0018\u00010F2\u0006\u0010W\u001a\u00020%H\u0002J\u001a\u0010X\u001a\u0004\u0018\u00010Q2\u0006\u0010Y\u001a\u00020\u00192\u0006\u0010H\u001a\u00020%H\u0002J&\u0010Z\u001a\u00020'2\u0006\u0010[\u001a\u00020F2\f\u0010\\\u001a\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010+\u001a\u00020,H\u0002J\u0012\u0010]\u001a\u0004\u0018\u00010O2\u0006\u00100\u001a\u00020FH\u0002J\u0012\u0010^\u001a\u0004\u0018\u00010O2\u0006\u00100\u001a\u00020FH\u0002J\u001a\u0010_\u001a\u0004\u0018\u00010O2\u0006\u0010A\u001a\u00020\u00192\u0006\u0010`\u001a\u00020aH\u0002J\u0012\u0010b\u001a\u0004\u0018\u00010O2\u0006\u00100\u001a\u00020FH\u0002J\u0012\u0010c\u001a\u0004\u0018\u00010L2\u0006\u00100\u001a\u00020FH\u0002J\u0012\u0010d\u001a\u0004\u0018\u00010e2\u0006\u00100\u001a\u00020FH\u0002J\u0012\u0010f\u001a\u0004\u0018\u00010*2\u0006\u0010g\u001a\u00020hH\u0002J\u0012\u0010i\u001a\u0004\u0018\u00010\u001f2\u0006\u0010g\u001a\u00020hH\u0002J\"\u0010j\u001a\u0004\u0018\u00010k2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010<\u001a\u00020%H\u0002J&\u0010l\u001a\u0004\u0018\u00010O2\u0006\u0010\"\u001a\u00020#2\b\u0010<\u001a\u0004\u0018\u00010%2\b\b\u0002\u0010m\u001a\u000202H\u0002J\u0010\u0010n\u001a\u00020:2\u0006\u0010o\u001a\u00020:H\u0002J\u0014\u0010p\u001a\u0004\u0018\u00010%2\b\u0010W\u001a\u0004\u0018\u00010%H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\f\u001a\u0015\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e0\r\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u00198FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006r"}, d2={"Lcom/android/tools/idea/layoutinspector/resource/ResourceLookupResolver;", "", "project", "Lcom/intellij/openapi/project/Project;", "appFacet", "Lorg/jetbrains/android/facet/AndroidFacet;", "folderConfiguration", "Lcom/android/ide/common/resources/configuration/FolderConfiguration;", "resolver", "Lcom/android/ide/common/resources/ResourceResolver;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/android/facet/AndroidFacet;Lcom/android/ide/common/resources/configuration/FolderConfiguration;Lcom/android/ide/common/resources/ResourceResolver;)V", "projectResources", "Lcom/android/tools/res/LocalResourceRepository;", "Lcom/intellij/openapi/vfs/VirtualFile;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "androidResourceNamespaceResolver", "Lcom/android/ide/common/rendering/api/ResourceNamespace$Resolver;", "androidNamespaceContext", "Lcom/android/tools/idea/res/ResourceNamespaceContext;", "localAttrDefs", "Lcom/android/tools/dom/attrs/AttributeDefinitions;", "systemAttrDefs", "defaultTheme", "Lcom/android/ide/common/rendering/api/StyleResourceValue;", "getDefaultTheme$annotations", "()V", "getDefaultTheme", "()Lcom/android/ide/common/rendering/api/StyleResourceValue;", "findAttributeValue", "", "property", "Lcom/android/tools/idea/layoutinspector/properties/InspectorPropertyItem;", "view", "Lcom/android/tools/idea/layoutinspector/model/ViewNode;", "source", "Lcom/android/ide/common/rendering/api/ResourceReference;", "findFileLocations", "", "sourceLocations", "", "Lcom/android/tools/idea/layoutinspector/resource/SourceLocation;", "max", "", "findFileLocation", "resolveAsIcon", "Ljavax/swing/Icon;", "value", "isDimension", "", "attributeName", "findAttributeDefinition", "Lcom/android/tools/dom/attrs/AttributeDefinition;", "psiClass", "Lcom/intellij/psi/PsiClass;", "styleableName", "findNamespaceFromPsiClass", "Lcom/android/ide/common/rendering/api/ResourceNamespace;", "findFileLocationsFromViewTag", "layout", "addApproximateLocation", "findApproximateLocation", "unknownLocation", "findFileLocationsFromStyle", "style", "findAttributeValueFromViewTag", "findAttributeValueFromStyle", "resolveValue", "resValue", "Lcom/android/ide/common/rendering/api/ResourceValue;", "toString", "attr", "dereference", "dereferenceStateList", "stateList", "Lcom/android/tools/idea/res/StateList;", "getNamespacesContext", "tag", "Lcom/intellij/psi/xml/XmlTag;", "dereferenceThemeReference", "Lcom/android/tools/idea/layoutinspector/resource/StyleItemResourceValueWithStyleReference;", "themeReference", "dereferenceRawAttributeValue", "xmlAttributeValue", "Lcom/intellij/psi/xml/XmlAttributeValue;", "dereferenceReference", "reference", "findItemInTheme", "theme", "addValueReference", "resourceValue", "result", "convertToXmlTag", "convertSimpleValueToXmlTag", "convertStyleItemValueToXmlTag", "item", "Lcom/android/ide/common/rendering/api/StyleItemResourceValue;", "convertStateListToXmlTag", "convertToStateList", "convertToResourceItem", "Lcom/android/ide/common/resources/ResourceItem;", "createFileLocation", "element", "Lcom/intellij/psi/PsiElement;", "findSourceLocationWithLineNumber", "findLayoutAttribute", "Lcom/intellij/psi/xml/XmlAttribute;", "findViewTagInFile", "isViewLayout", "mapNamespace", "namespace", "mapReference", "ViewLocator", "intellij.android.layout-inspector"})
@SourceDebugExtension(value={"SMAP\nResourceLookupResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceLookupResolver.kt\ncom/android/tools/idea/layoutinspector/resource/ResourceLookupResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,688:1\n1#2:689\n295#3,2:690\n*S KotlinDebug\n*F\n+ 1 ResourceLookupResolver.kt\ncom/android/tools/idea/layoutinspector/resource/ResourceLookupResolver\n*L\n265#1:690,2\n*E\n"})
public final class ResourceLookupResolver {
    @NotNull
    private final Project project;
    @NotNull
    private final AndroidFacet appFacet;
    @NotNull
    private final FolderConfiguration folderConfiguration;
    @NotNull
    private final ResourceResolver resolver;
    @NotNull
    private final LocalResourceRepository<VirtualFile> projectResources;
    @NotNull
    private final ResourceNamespace.Resolver androidResourceNamespaceResolver;
    @NotNull
    private final ResourceNamespaceContext androidNamespaceContext;
    @NotNull
    private final AttributeDefinitions localAttrDefs;
    @Nullable
    private final AttributeDefinitions systemAttrDefs;

    public ResourceLookupResolver(@NotNull Project project, @NotNull AndroidFacet appFacet, @NotNull FolderConfiguration folderConfiguration, @NotNull ResourceResolver resolver) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)appFacet, (String)"appFacet");
        Intrinsics.checkNotNullParameter((Object)folderConfiguration, (String)"folderConfiguration");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        this.project = project;
        this.appFacet = appFacet;
        this.folderConfiguration = folderConfiguration;
        this.resolver = resolver;
        LocalResourceRepository<VirtualFile> localResourceRepository = StudioResourceRepositoryManager.getProjectResources(this.appFacet);
        Intrinsics.checkNotNullExpressionValue(localResourceRepository, (String)"getProjectResources(...)");
        this.projectResources = localResourceRepository;
        this.androidResourceNamespaceResolver = ResourceLookupResolver::androidResourceNamespaceResolver$lambda$0;
        ResourceNamespace resourceNamespace = ResourceNamespace.ANDROID;
        Intrinsics.checkNotNullExpressionValue((Object)resourceNamespace, (String)"ANDROID");
        this.androidNamespaceContext = new ResourceNamespaceContext(resourceNamespace, this.androidResourceNamespaceResolver);
        ModuleResourceManagers moduleResourceManagers = ModuleResourceManagers.getInstance(this.appFacet);
        Intrinsics.checkNotNullExpressionValue((Object)moduleResourceManagers, (String)"getInstance(...)");
        ModuleResourceManagers resourceManagers = moduleResourceManagers;
        LocalResourceManager localResourceManager = resourceManagers.getLocalResourceManager();
        Intrinsics.checkNotNullExpressionValue((Object)localResourceManager, (String)"getLocalResourceManager(...)");
        LocalResourceManager localResourceManager2 = localResourceManager;
        FrameworkResourceManager frameworkResourceManager = resourceManagers.getFrameworkResourceManager();
        AttributeDefinitions attributeDefinitions = localResourceManager2.getAttributeDefinitions();
        Intrinsics.checkNotNullExpressionValue((Object)attributeDefinitions, (String)"getAttributeDefinitions(...)");
        this.localAttrDefs = attributeDefinitions;
        FrameworkResourceManager frameworkResourceManager2 = frameworkResourceManager;
        this.systemAttrDefs = frameworkResourceManager2 != null ? frameworkResourceManager2.getAttributeDefinitions() : null;
    }

    @Nullable
    public final StyleResourceValue getDefaultTheme() {
        return this.resolver.getDefaultTheme();
    }

    @VisibleForTesting
    public static /* synthetic */ void getDefaultTheme$annotations() {
    }

    @Nullable
    public final String findAttributeValue(@NotNull InspectorPropertyItem property2, @NotNull ViewNode view, @NotNull ResourceReference source2) {
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        ResourceType resourceType = source2.getResourceType();
        return switch (resourceType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[resourceType.ordinal()]) {
            case 1 -> this.findAttributeValueFromViewTag(property2, view, source2);
            case 2 -> this.findAttributeValueFromStyle(property2, view, source2);
            default -> null;
        };
    }

    public final void findFileLocations(@NotNull InspectorPropertyItem property2, @NotNull ViewNode view, @Nullable ResourceReference source2, @NotNull List<SourceLocation> sourceLocations, int max) {
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter(sourceLocations, (String)"sourceLocations");
        sourceLocations.clear();
        ResourceReference resourceReference = source2;
        Object object = resourceReference != null ? resourceReference.getResourceType() : null;
        switch (object == null ? -1 : WhenMappings.$EnumSwitchMapping$0[object.ordinal()]) {
            case 1: {
                this.findFileLocationsFromViewTag(property2, view, source2, sourceLocations, max);
                break;
            }
            case 2: {
                this.findFileLocationsFromStyle(property2, source2, sourceLocations, max);
            }
        }
    }

    @Nullable
    public final SourceLocation findFileLocation(@NotNull ViewNode view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        XmlTag xmlTag = ResourceLookupResolver.findViewTagInFile$default(this, view, view.getLayout(), false, 4, null);
        if (xmlTag == null) {
            return null;
        }
        XmlTag tag = xmlTag;
        return this.createFileLocation((PsiElement)tag);
    }

    @Slow
    @Nullable
    public final Icon resolveAsIcon(@Nullable String value2, @NotNull ViewNode view) {
        String string;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                string = value2;
                if (string == null) break block5;
                String it = string;
                boolean bl = false;
                ResourceUrl resourceUrl = ResourceUrl.parse((String)it);
                string = resourceUrl;
                if (resourceUrl != null) break block6;
            }
            return null;
        }
        String url = string;
        XmlTag xmlTag = ResourceLookupResolver.findViewTagInFile$default(this, view, view.getLayout(), false, 4, null);
        if (xmlTag == null) {
            return null;
        }
        XmlTag tag = xmlTag;
        ResourceNamespaceContext resourceNamespaceContext = this.getNamespacesContext(tag);
        ResourceNamespace namespace = resourceNamespaceContext.component1();
        ResourceNamespace.Resolver namespaceResolver = resourceNamespaceContext.component2();
        ResourceReference resourceReference = url.resolve(namespace, namespaceResolver);
        if (resourceReference == null) {
            return null;
        }
        ResourceReference reference = resourceReference;
        return IdeResourcesUtil.resolveAsIcon((RenderResources)this.resolver, this.resolver.getUnresolvedResource(reference), this.appFacet);
    }

    @Slow
    public final boolean isDimension(@NotNull ViewNode view, @NotNull String attributeName) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)attributeName, (String)"attributeName");
        if (view instanceof ComposeViewNode) {
            return false;
        }
        boolean isLayoutAttribute = StringsKt.startsWith$default((String)attributeName, (String)"layout_", (boolean)false, (int)2, null);
        String string = isLayoutAttribute ? (String)ViewNode.Companion.readAccess(arg_0 -> ResourceLookupResolver.isDimension$lambda$0(view, arg_0)) : view.getQualifiedName();
        if (string == null) {
            return false;
        }
        String qualifiedTagName = string;
        for (PsiClass psiClass = JavaPsiFacade.getInstance((Project)this.project).findClass(qualifiedTagName, GlobalSearchScope.allScope((Project)this.project)); psiClass != null; psiClass = psiClass.getSuperClass()) {
            AttributeDefinition attrValue;
            AttributeDefinition attributeDefinition;
            if (isLayoutAttribute) {
                attributeDefinition = this.findAttributeDefinition(psiClass, AttributeProcessingUtil.INSTANCE.getLayoutStyleablePrimary(psiClass), attributeName);
                if (attributeDefinition == null) {
                    attributeDefinition = this.findAttributeDefinition(psiClass, AttributeProcessingUtil.INSTANCE.getLayoutStyleableSecondary(psiClass), attributeName);
                }
            } else {
                attributeDefinition = this.findAttributeDefinition(psiClass, psiClass.getName(), attributeName);
            }
            if ((attrValue = attributeDefinition) == null) continue;
            return attrValue.getFormats().contains(AttributeFormat.DIMENSION);
        }
        return false;
    }

    private final AttributeDefinition findAttributeDefinition(PsiClass psiClass, String styleableName, String attributeName) {
        Object v4;
        block4: {
            String string = styleableName;
            if (string == null) {
                return null;
            }
            String styleable = string;
            ResourceNamespace resourceNamespace = this.findNamespaceFromPsiClass(psiClass);
            if (resourceNamespace == null) {
                return null;
            }
            ResourceNamespace namespace = resourceNamespace;
            ResourceReference reference = new ResourceReference(namespace, ResourceType.STYLEABLE, styleable);
            AttributeDefinitions attrDefs = Intrinsics.areEqual((Object)namespace.getXmlNamespaceUri(), (Object)"http://schemas.android.com/apk/res/android") ? this.systemAttrDefs : this.localAttrDefs;
            Object object = attrDefs;
            if (object == null || (object = object.getStyleableDefinition(reference)) == null) {
                return null;
            }
            Object styleableDefinition = object;
            List<AttributeDefinition> list2 = styleableDefinition.getAttributes();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getAttributes(...)");
            Iterable $this$firstOrNull$iv = list2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AttributeDefinition it = (AttributeDefinition)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)attributeName)) continue;
                v4 = element$iv;
                break block4;
            }
            v4 = null;
        }
        return v4;
    }

    private final ResourceNamespace findNamespaceFromPsiClass(PsiClass psiClass) {
        String string = psiClass.getQualifiedName();
        if (string == null) {
            return null;
        }
        String className = string;
        String namespaceUri = StringsKt.startsWith$default((String)className, (String)"android.", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)className, (String)"android.support.", (boolean)false, (int)2, null) ? "http://schemas.android.com/apk/res/android" : "http://schemas.android.com/apk/res-auto";
        return ResourceNamespace.fromNamespaceUri((String)namespaceUri);
    }

    private final void findFileLocationsFromViewTag(InspectorPropertyItem property2, ViewNode view, ResourceReference layout, List<SourceLocation> sourceLocations, int max) {
        XmlAttribute xmlAttribute = this.findLayoutAttribute(property2, view, layout);
        if (xmlAttribute == null || (xmlAttribute = xmlAttribute.getValueElement()) == null) {
            this.addApproximateLocation(layout, sourceLocations);
            return;
        }
        XmlAttribute xmlAttributeValue = xmlAttribute;
        SourceLocation sourceLocation = this.createFileLocation((PsiElement)xmlAttributeValue);
        if (sourceLocation == null) {
            this.addApproximateLocation(layout, sourceLocations);
            return;
        }
        SourceLocation location = sourceLocation;
        ResourceValue resValue = this.dereferenceRawAttributeValue((XmlAttributeValue)xmlAttributeValue);
        sourceLocations.add(location);
        if (resValue != null) {
            this.addValueReference(resValue, sourceLocations, max - 1);
        }
    }

    private final void addApproximateLocation(ResourceReference layout, List<SourceLocation> sourceLocations) {
        sourceLocations.add(this.findApproximateLocation(layout));
    }

    private final SourceLocation findApproximateLocation(ResourceReference layout) {
        ResourceReference resourceReference = this.mapReference(layout);
        if (resourceReference == null) {
            return this.unknownLocation();
        }
        ResourceReference reference = resourceReference;
        ResourceValue layoutValue = this.resolver.getUnresolvedResource(reference);
        VirtualFile virtualFile = IdeResourcesUtil.resolveLayout((RenderResources)this.resolver, layoutValue);
        if (virtualFile == null) {
            return this.unknownLocation();
        }
        VirtualFile file = virtualFile;
        PsiFile psiFile = AndroidPsiUtils.getPsiFileSafely((Project)this.project, (VirtualFile)file);
        XmlFile xmlFile = psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
        if (xmlFile == null) {
            return this.unknownLocation();
        }
        XmlFile xmlFile2 = xmlFile;
        XmlTag xmlTag = xmlFile2.getRootTag();
        PsiElement element = xmlTag != null ? (PsiElement)xmlTag : (PsiElement)xmlFile2;
        Navigatable navigatable2 = ResourceLookupResolverKt.findNavigatable(element);
        return new SourceLocation(file.getName() + ":?", navigatable2);
    }

    private final SourceLocation unknownLocation() {
        return new SourceLocation("unknown:?", null);
    }

    private final void findFileLocationsFromStyle(InspectorPropertyItem property2, ResourceReference style, List<SourceLocation> sourceLocations, int max) {
        block5: {
            ResourceReference resourceReference = this.mapReference(style);
            if (resourceReference == null) {
                return;
            }
            ResourceReference reference = resourceReference;
            ResourceReference attr = this.attr(property2);
            StyleResourceValue styleResourceValue = this.resolver.getStyle(reference);
            if (styleResourceValue == null) {
                return;
            }
            StyleResourceValue styleValue = styleResourceValue;
            StyleItemResourceValue styleItemResourceValue = styleValue.getItem(attr);
            if (styleItemResourceValue == null) {
                return;
            }
            StyleItemResourceValue value2 = styleItemResourceValue;
            XmlTag xmlTag = this.convertStyleItemValueToXmlTag(styleValue, value2);
            if (xmlTag == null) {
                return;
            }
            XmlTag tag = xmlTag;
            SourceLocation sourceLocation = this.createFileLocation((PsiElement)tag);
            if (sourceLocation == null) {
                return;
            }
            SourceLocation location = sourceLocation;
            sourceLocations.add(location);
            ResourceValue resourceValue = this.dereference((ResourceValue)value2);
            if (resourceValue == null) break block5;
            ResourceValue it = resourceValue;
            boolean bl = false;
            this.addValueReference(it, sourceLocations, max - 1);
        }
    }

    private final String findAttributeValueFromViewTag(InspectorPropertyItem property2, ViewNode view, ResourceReference layout) {
        XmlAttribute xmlAttribute = this.findLayoutAttribute(property2, view, layout);
        if (xmlAttribute == null || (xmlAttribute = xmlAttribute.getValueElement()) == null) {
            return null;
        }
        XmlAttribute xmlAttributeValue = xmlAttribute;
        ResourceValue resourceValue = this.dereferenceRawAttributeValue((XmlAttributeValue)xmlAttributeValue);
        if (resourceValue == null) {
            return xmlAttributeValue.getValue();
        }
        ResourceValue resValue = resourceValue;
        String string = this.resolveValue(property2, view, resValue);
        if (string == null) {
            String string2 = xmlAttributeValue.getValue();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
        }
        return string;
    }

    private final String findAttributeValueFromStyle(InspectorPropertyItem property2, ViewNode view, ResourceReference style) {
        ResourceReference resourceReference = this.mapReference(style);
        if (resourceReference == null) {
            return null;
        }
        ResourceReference reference = resourceReference;
        StyleResourceValue styleResourceValue = this.resolver.getStyle(reference);
        if (styleResourceValue == null) {
            return null;
        }
        StyleResourceValue styleValue = styleResourceValue;
        StyleItemResourceValue styleItemResourceValue = styleValue.getItem(this.attr(property2));
        if (styleItemResourceValue == null) {
            return null;
        }
        StyleItemResourceValue it = styleItemResourceValue;
        boolean bl = false;
        StyleItemResourceValueWithStyleReference styleItem = new StyleItemResourceValueWithStyleReference(styleValue, it);
        return this.resolveValue(property2, view, (ResourceValue)styleItem);
    }

    private final String resolveValue(InspectorPropertyItem property2, ViewNode view, ResourceValue resValue) {
        if (property2.getType() == PropertyType.COLOR) {
            Color color = IdeResourcesUtil.resolveColor((RenderResources)this.resolver, resValue, this.project);
            if (color != null) {
                Color it = color;
                boolean bl = false;
                return ResourcesUtil.colorToString((Color)it);
            }
        }
        return this.toString((ResourceValue)SequencesKt.last((Sequence)SequencesKt.take((Sequence)SequencesKt.generateSequence((Object)resValue, arg_0 -> ResourceLookupResolver.resolveValue$lambda$1(this, arg_0)), (int)50)), view);
    }

    private final String toString(ResourceValue resValue, ViewNode view) {
        String string = resValue.getValue();
        if (string == null) {
            return null;
        }
        String stringValue2 = string;
        if (ResourcesUtil.toFileResourcePathString((String)stringValue2) == null) {
            return stringValue2;
        }
        XmlTag xmlTag = ResourceLookupResolver.findViewTagInFile$default(this, view, view.getLayout(), false, 4, null);
        if (xmlTag == null) {
            return stringValue2;
        }
        XmlTag tag = xmlTag;
        ResourceNamespaceContext resourceNamespaceContext = this.getNamespacesContext(tag);
        ResourceNamespace namespace = resourceNamespaceContext.component1();
        ResourceNamespace.Resolver namespaceResolver = resourceNamespaceContext.component2();
        ResourceReference reference = resValue.asReference();
        ResourceUrl url = reference.getRelativeResourceUrl(namespace, namespaceResolver);
        return url.toString();
    }

    private final ResourceReference attr(InspectorPropertyItem property2) {
        ResourceNamespace resourceNamespace = ResourceNamespace.fromNamespaceUri((String)property2.getNamespace());
        if (resourceNamespace == null) {
            resourceNamespace = ResourceNamespace.ANDROID;
        }
        ResourceNamespace resourceNamespace2 = resourceNamespace;
        Intrinsics.checkNotNull((Object)resourceNamespace2);
        ResourceNamespace attrNamespace = this.mapNamespace(resourceNamespace2);
        ResourceReference resourceReference = ResourceReference.attr((ResourceNamespace)attrNamespace, (String)property2.getAttrName());
        Intrinsics.checkNotNullExpressionValue((Object)resourceReference, (String)"attr(...)");
        return resourceReference;
    }

    private final ResourceValue dereference(ResourceValue value2) {
        ResourceValue resourceValue;
        StateList stateList = this.convertToStateList(value2);
        StateList stateList2 = stateList;
        if (stateList2 != null) {
            resourceValue = this.dereferenceStateList(stateList2, value2);
        } else {
            String string = value2.getValue();
            resourceValue = (string != null ? StringsKt.startsWith$default((String)string, (String)"?", (boolean)false, (int)2, null) : false) ? (ResourceValue)this.dereferenceThemeReference(value2.getReference()) : this.resolver.dereference(value2);
        }
        return resourceValue;
    }

    private final ResourceValue dereferenceStateList(StateList stateList, ResourceValue value2) {
        ResourceValue resourceValue;
        StateListState stateListState = (StateListState)CollectionsKt.lastOrNull(stateList.getStates());
        if (stateListState == null) {
            return null;
        }
        StateListState state2 = stateListState;
        String string = state2.getValue();
        if (string == null) {
            return null;
        }
        String stringValue2 = string;
        ResourceUrl resourceUrl = ResourceUrl.parse((String)stringValue2);
        if (resourceUrl == null) {
            return null;
        }
        ResourceUrl url = resourceUrl;
        XmlTag xmlTag = this.convertStateListToXmlTag(value2);
        if (xmlTag == null) {
            return null;
        }
        XmlTag tag = xmlTag;
        ResourceNamespaceContext resourceNamespaceContext = this.getNamespacesContext(tag);
        ResourceNamespace namespace = resourceNamespaceContext.component1();
        ResourceNamespace.Resolver namespaceResolver = resourceNamespaceContext.component2();
        ResourceReference resourceReference = url.resolve(namespace, namespaceResolver);
        if (resourceReference != null) {
            ResourceReference it = resourceReference;
            boolean bl = false;
            resourceValue = this.dereferenceReference(it);
        } else {
            resourceValue = null;
        }
        return resourceValue;
    }

    private final ResourceNamespaceContext getNamespacesContext(XmlTag tag) {
        ResourceNamespaceContext resourceNamespaceContext;
        ResourceNamespace resourceNamespace = IdeResourcesUtil.getResourceNamespace((PsiElement)tag);
        if (resourceNamespace != null) {
            ResourceNamespace it = resourceNamespace;
            boolean bl = false;
            resourceNamespaceContext = new ResourceNamespaceContext(it, new ResourceNamespace.Resolver(tag){
                final /* synthetic */ XmlTag $tag;
                {
                    this.$tag = $tag;
                }

                public String uriToPrefix(String namespaceUri) {
                    Intrinsics.checkNotNullParameter((Object)namespaceUri, (String)"namespaceUri");
                    return this.$tag.getPrefixByNamespace(namespaceUri);
                }

                public String prefixToUri(String namespacePrefix) {
                    Intrinsics.checkNotNullParameter((Object)namespacePrefix, (String)"namespacePrefix");
                    return StringKt.nullize$default((String)this.$tag.getNamespaceByPrefix(namespacePrefix), (boolean)false, (int)1, null);
                }
            });
        } else {
            resourceNamespaceContext = this.androidNamespaceContext;
        }
        return resourceNamespaceContext;
    }

    private final StyleItemResourceValueWithStyleReference dereferenceThemeReference(ResourceReference themeReference) {
        ResourceReference resourceReference = themeReference;
        if (resourceReference == null) {
            return null;
        }
        ResourceReference attr = resourceReference;
        for (StyleResourceValue theme : this.resolver.getAllThemes()) {
            Intrinsics.checkNotNull((Object)theme);
            StyleItemResourceValueWithStyleReference value2 = this.findItemInTheme(theme, attr);
            if (value2 == null) continue;
            return value2;
        }
        return null;
    }

    private final ResourceValue dereferenceRawAttributeValue(XmlAttributeValue xmlAttributeValue) {
        ResourceValue resourceValue;
        ResourceUrl resourceUrl = ResourceUrl.parse((String)xmlAttributeValue.getValue());
        if (resourceUrl == null) {
            return null;
        }
        ResourceUrl url = resourceUrl;
        ResourceReference resourceReference = IdeResourcesUtil.resolve(url, (XmlElement)xmlAttributeValue);
        if (resourceReference != null) {
            ResourceReference it = resourceReference;
            boolean bl = false;
            resourceValue = this.dereferenceReference(it);
        } else {
            resourceValue = null;
        }
        return resourceValue;
    }

    private final ResourceValue dereferenceReference(ResourceReference reference) {
        if (reference.getResourceType() == ResourceType.ATTR) {
            return (ResourceValue)this.dereferenceThemeReference(reference);
        }
        return this.resolver.getUnresolvedResource(reference);
    }

    private final StyleItemResourceValueWithStyleReference findItemInTheme(StyleResourceValue theme, ResourceReference attr) {
        StyleResourceValue style = theme;
        for (int depth = 0; depth < 50; ++depth) {
            StyleItemResourceValue item = style.getItem(attr);
            if (item != null) {
                return new StyleItemResourceValueWithStyleReference(style, item);
            }
            if (this.resolver.getParent(style) != null) continue;
            return null;
        }
        return null;
    }

    private final void addValueReference(ResourceValue resourceValue, List<SourceLocation> result2, int max) {
        ResourceValue nextResourceValue = resourceValue;
        for (int count = 0; nextResourceValue != null && count < max; ++count) {
            SourceLocation location;
            XmlTag tag;
            if (this.convertToXmlTag(nextResourceValue) == null) {
                return;
            }
            if (this.createFileLocation((PsiElement)tag) == null) {
                return;
            }
            result2.add(location);
            nextResourceValue = this.dereference(nextResourceValue);
        }
    }

    private final XmlTag convertToXmlTag(ResourceValue value2) {
        StateList stateList = this.convertToStateList(value2);
        return stateList != null ? this.convertStateListToXmlTag(value2) : (value2 instanceof StyleItemResourceValueWithStyleReference ? this.convertStyleItemValueToXmlTag(((StyleItemResourceValueWithStyleReference)value2).getStyle(), (StyleItemResourceValue)value2) : this.convertSimpleValueToXmlTag(value2));
    }

    private final XmlTag convertSimpleValueToXmlTag(ResourceValue value2) {
        XmlFile xmlFile;
        ResourceItem resourceItem = this.convertToResourceItem(value2);
        if (resourceItem == null) {
            return null;
        }
        ResourceItem item = resourceItem;
        if (FolderTypeRelationship.getRelatedFolders((ResourceType)item.getType()).contains(ResourceFolderType.VALUES)) {
            return IdeResourcesUtil.getItemTag(this.project, item);
        }
        PsiFile psiFile = IdeResourcesUtil.getItemPsiFile(this.project, item);
        XmlFile xmlFile2 = xmlFile = psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
        return xmlFile2 != null ? xmlFile2.getRootTag() : null;
    }

    private final XmlTag convertStyleItemValueToXmlTag(StyleResourceValue style, StyleItemResourceValue item) {
        XmlTag xmlTag;
        block3: {
            XmlTag[] itemTags;
            ResourceItem resourceItem = this.convertToResourceItem((ResourceValue)style);
            if (resourceItem == null) {
                return null;
            }
            ResourceItem styleItem = resourceItem;
            XmlTag xmlTag2 = IdeResourcesUtil.getItemTag(this.project, styleItem);
            if (xmlTag2 == null) {
                return null;
            }
            XmlTag styleTag = xmlTag2;
            XmlTag[] xmlTagArray = styleTag.findSubTags("item");
            Intrinsics.checkNotNullExpressionValue((Object)xmlTagArray, (String)"findSubTags(...)");
            XmlTag[] xmlTagArray2 = itemTags = xmlTagArray;
            int n = xmlTagArray2.length;
            for (int i = 0; i < n; ++i) {
                XmlTag xmlTag3;
                XmlTag it = xmlTag3 = xmlTagArray2[i];
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getAttributeValue("name"), (Object)item.getAttrName())) continue;
                xmlTag = xmlTag3;
                break block3;
            }
            xmlTag = null;
        }
        return xmlTag;
    }

    private final XmlTag convertStateListToXmlTag(ResourceValue value2) {
        String string = value2.getValue();
        if (string == null) {
            return null;
        }
        String stringValue2 = string;
        PathString pathString = ResourcesUtil.toFileResourcePathString((String)stringValue2);
        if (pathString == null || (pathString = FileExtensions.toVirtualFile$default(pathString, false, 1, null)) == null) {
            return null;
        }
        PathString virtualFile = pathString;
        PsiFile psiFile = AndroidPsiUtils.getPsiFileSafely((Project)this.project, (VirtualFile)virtualFile);
        XmlFile xmlFile = psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
        if (xmlFile == null) {
            return null;
        }
        XmlFile xmlFile2 = xmlFile;
        XmlTag xmlTag = xmlFile2.getRootTag();
        if (xmlTag == null) {
            return null;
        }
        XmlTag rootTag = xmlTag;
        if (!Intrinsics.areEqual((Object)"selector", (Object)rootTag.getName())) {
            return null;
        }
        XmlTag[] xmlTagArray = rootTag.findSubTags("item");
        Intrinsics.checkNotNullExpressionValue((Object)xmlTagArray, (String)"findSubTags(...)");
        return (XmlTag)ArraysKt.lastOrNull((Object[])xmlTagArray);
    }

    private final StateList convertToStateList(ResourceValue value2) {
        String string = value2.getValue();
        if (string == null) {
            return null;
        }
        String stringValue2 = string;
        if (StringsKt.startsWith$default((String)stringValue2, (String)"@", (boolean)false, (int)2, null)) {
            return null;
        }
        return IdeResourcesUtil.resolveStateList((RenderResources)this.resolver, value2, this.project);
    }

    private final ResourceItem convertToResourceItem(ResourceValue value2) {
        if (value2 instanceof ResourceItem) {
            return (ResourceItem)value2;
        }
        List items = this.projectResources.getResources(value2.asReference());
        return (ResourceItem)this.folderConfiguration.findMatchingConfigurable((Collection)items);
    }

    private final SourceLocation createFileLocation(PsiElement element) {
        String string = this.findSourceLocationWithLineNumber(element);
        if (string == null) {
            return null;
        }
        String source2 = string;
        Navigatable navigatable2 = ResourceLookupResolverKt.findNavigatable(element);
        if (navigatable2 == null) {
            return null;
        }
        Navigatable navigatable3 = navigatable2;
        return new SourceLocation(source2, navigatable3);
    }

    private final String findSourceLocationWithLineNumber(PsiElement element) {
        Document doc;
        Document document;
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        PsiFile file = psiFile;
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            document = FileDocumentManager.getInstance().getDocument(it);
        } else {
            document = null;
        }
        Document document2 = doc = document;
        if (document2 == null) {
            return file.getName();
        }
        int line = document2.getLineNumber(element.getTextOffset()) + 1;
        return file.getName() + ":" + line;
    }

    private final XmlAttribute findLayoutAttribute(InspectorPropertyItem property2, ViewNode view, ResourceReference layout) {
        XmlTag tag = this.findViewTagInFile(view, layout, false);
        ResourceNamespace resourceNamespace = ResourceNamespace.fromNamespaceUri((String)property2.getNamespace());
        if (resourceNamespace == null) {
            resourceNamespace = ResourceNamespace.ANDROID;
        }
        ResourceNamespace resourceNamespace2 = resourceNamespace;
        Intrinsics.checkNotNull((Object)resourceNamespace2);
        ResourceNamespace attrNamespace = this.mapNamespace(resourceNamespace2);
        XmlTag xmlTag = tag;
        return xmlTag != null ? xmlTag.getAttribute(property2.getAttrName(), attrNamespace.getXmlNamespaceUri()) : null;
    }

    private final XmlTag findViewTagInFile(ViewNode view, ResourceReference layout, boolean isViewLayout) {
        XmlTag xmlTag;
        PsiFile idValue;
        VirtualFile virtualFile;
        XmlTag xmlTag2;
        if (isViewLayout && (xmlTag2 = view.getTag()) != null) {
            XmlTag it = xmlTag2;
            boolean bl = false;
            return it;
        }
        if (layout != null) {
            ResourceReference resourceReference = this.mapReference(layout);
            if (resourceReference == null) {
                return null;
            }
            ResourceReference reference = resourceReference;
            ResourceValue layoutValue = this.resolver.getUnresolvedResource(reference);
            virtualFile = IdeResourcesUtil.resolveLayout((RenderResources)this.resolver, layoutValue);
        } else if (isViewLayout) {
            ResourceReference resourceReference = view.getViewId();
            if (resourceReference == null) {
                return null;
            }
            ResourceReference id2 = resourceReference;
            ResourceValue resourceValue = this.resolver.getResolvedResource(id2);
            if (resourceValue == null) {
                return null;
            }
            idValue = resourceValue;
            ResourceItem resourceItem = this.convertToResourceItem((ResourceValue)idValue);
            if (resourceItem == null) {
                return null;
            }
            ResourceItem item = resourceItem;
            virtualFile = FileExtensions.toVirtualFile$default(item.getOriginalSource(), false, 1, null);
        } else {
            virtualFile = null;
        }
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        idValue = AndroidPsiUtils.getPsiFileSafely((Project)this.project, file);
        XmlFile xmlFile = idValue instanceof XmlFile ? (XmlFile)idValue : null;
        if (xmlFile == null) {
            return null;
        }
        XmlFile xmlFile2 = xmlFile;
        ViewLocator locator = new ViewLocator(view);
        XmlTag xmlTag3 = xmlFile2.getRootTag();
        if (xmlTag3 == null) {
            return null;
        }
        XmlTag rootTag = xmlTag3;
        if (rootTag.isEmpty()) {
            return rootTag;
        }
        XmlTag xmlTag4 = xmlFile2.getRootTag();
        if (xmlTag4 != null) {
            xmlTag4.accept((PsiElementVisitor)locator);
        }
        XmlTag xmlTag5 = locator.getFoundXmlTag();
        if (xmlTag5 != null) {
            XmlTag xmlTag6;
            XmlTag it = xmlTag6 = xmlTag5;
            boolean bl = false;
            if (isViewLayout) {
                view.setTag(it);
            }
            xmlTag = xmlTag6;
        } else {
            xmlTag = null;
        }
        return xmlTag;
    }

    static /* synthetic */ XmlTag findViewTagInFile$default(ResourceLookupResolver resourceLookupResolver, ViewNode viewNode, ResourceReference resourceReference, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return resourceLookupResolver.findViewTagInFile(viewNode, resourceReference, bl);
    }

    private final ResourceNamespace mapNamespace(ResourceNamespace namespace) {
        return ResourceLookupResolverKt.mapNamespace(this.appFacet, namespace);
    }

    private final ResourceReference mapReference(ResourceReference reference) {
        return ResourceLookupResolverKt.mapReference(this.appFacet, reference);
    }

    private static final String androidResourceNamespaceResolver$lambda$0(String namespacePrefix) {
        return Intrinsics.areEqual((Object)namespacePrefix, (Object)"android") ? "http://schemas.android.com/apk/res/android" : null;
    }

    private static final String isDimension$lambda$0(ViewNode $view, ViewNode.ReadAccess $this$readAccess) {
        Intrinsics.checkNotNullParameter((Object)$this$readAccess, (String)"$this$readAccess");
        ViewNode viewNode = $this$readAccess.getParent($view);
        return viewNode != null ? viewNode.getQualifiedName() : null;
    }

    private static final ResourceValue resolveValue$lambda$1(ResourceLookupResolver this$0, ResourceValue it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.dereference(it);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0007H\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/layoutinspector/resource/ResourceLookupResolver$ViewLocator;", "Lcom/intellij/psi/PsiRecursiveElementVisitor;", "view", "Lcom/android/tools/idea/layoutinspector/model/ViewNode;", "<init>", "(Lcom/android/tools/idea/layoutinspector/model/ViewNode;)V", "viewId", "Lcom/android/ide/common/rendering/api/ResourceReference;", "parentId", "found", "Lcom/intellij/psi/xml/XmlTag;", "foundParent", "foundXmlTag", "getFoundXmlTag", "()Lcom/intellij/psi/xml/XmlTag;", "visitElement", "", "element", "Lcom/intellij/psi/PsiElement;", "sameId", "", "tag", "id", "intellij.android.layout-inspector"})
    private static final class ViewLocator
    extends PsiRecursiveElementVisitor {
        @Nullable
        private final ResourceReference viewId;
        @Nullable
        private final ResourceReference parentId;
        @Nullable
        private XmlTag found;
        @Nullable
        private XmlTag foundParent;

        public ViewLocator(@NotNull ViewNode view) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            this.viewId = view.getViewId();
            this.parentId = (ResourceReference)ViewNode.Companion.readAccess(arg_0 -> ViewLocator.parentId$lambda$0(view, arg_0));
        }

        @Nullable
        public final XmlTag getFoundXmlTag() {
            XmlTag xmlTag = this.found;
            if (xmlTag != null) {
                XmlTag it = xmlTag;
                boolean bl = false;
                return it;
            }
            Object[] objectArray = this.foundParent;
            return this.foundParent != null && (objectArray = objectArray.getSubTags()) != null ? (XmlTag)ArraysKt.singleOrNull((Object[])objectArray) : null;
        }

        public void visitElement(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            if (element instanceof XmlTag) {
                if (this.viewId != null && this.sameId((XmlTag)element, this.viewId)) {
                    this.found = (XmlTag)element;
                }
                if (this.parentId != null && this.sameId((XmlTag)element, this.parentId)) {
                    this.foundParent = (XmlTag)element;
                }
            }
            super.visitElement(element);
        }

        private final boolean sameId(XmlTag tag, ResourceReference id2) {
            ResourceUrl url;
            String string = tag.getAttributeValue("id", "http://schemas.android.com/apk/res/android");
            if (string == null) {
                return false;
            }
            String attr = string;
            ResourceUrl resourceUrl = url = ResourceUrl.parse((String)attr);
            return (resourceUrl != null ? resourceUrl.type : null) == ResourceType.ID && Intrinsics.areEqual((Object)url.name, (Object)id2.getName());
        }

        private static final ResourceReference parentId$lambda$0(ViewNode $view, ViewNode.ReadAccess $this$readAccess) {
            Intrinsics.checkNotNullParameter((Object)$this$readAccess, (String)"$this$readAccess");
            ViewNode viewNode = $this$readAccess.getParent($view);
            return viewNode != null ? viewNode.getViewId() : null;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ResourceType.values().length];
            try {
                nArray[ResourceType.LAYOUT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResourceType.STYLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

