/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.resource;

import com.android.annotations.concurrency.Slow;
import com.android.tools.idea.layoutinspector.model.ComposeViewNode;
import com.android.tools.idea.layoutinspector.model.ComposeViewNodeKt;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.SearchScopeProvidingRunProfile;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J&\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00120\u0011H\u0005J.\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00120\u0011H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/layoutinspector/resource/ComposeResolver;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "findComposableNavigatable", "Lcom/intellij/pom/Navigatable;", "node", "Lcom/android/tools/idea/layoutinspector/model/ComposeViewNode;", "findKotlinFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "fileName", "", "packageNameMatcher", "Lkotlin/Function1;", "", "findKotlinFileInScope", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "intellij.android.layout-inspector"})
@SourceDebugExtension(value={"SMAP\nComposeResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeResolver.kt\ncom/android/tools/idea/layoutinspector/resource/ComposeResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,83:1\n1617#2,9:84\n1869#2:93\n1870#2:95\n1626#2:96\n808#2,11:97\n1#3:94\n*S KotlinDebug\n*F\n+ 1 ComposeResolver.kt\ncom/android/tools/idea/layoutinspector/resource/ComposeResolver\n*L\n71#1:84,9\n71#1:93\n71#1:95\n71#1:96\n78#1:97,11\n71#1:94\n*E\n"})
public class ComposeResolver {
    @NotNull
    private final Project project;

    public ComposeResolver(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Slow
    @Nullable
    public final Navigatable findComposableNavigatable(@NotNull ComposeViewNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        KtFile ktFile = this.findKotlinFile(node.getComposeFilename(), (Function1<? super String, Boolean>)((Function1)arg_0 -> ComposeResolver.findComposableNavigatable$lambda$0(node, arg_0)));
        if (ktFile == null) {
            return null;
        }
        KtFile ktFile2 = ktFile;
        VirtualFile virtualFile = ktFile2.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile vFile = virtualFile;
        return PsiNavigationSupport.getInstance().createNavigatable(this.project, vFile, node.getComposeOffset());
    }

    @Slow
    @Nullable
    protected final KtFile findKotlinFile(@NotNull String fileName, @NotNull Function1<? super String, Boolean> packageNameMatcher) {
        KtFile ktFile;
        GlobalSearchScope runScope;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter(packageNameMatcher, (String)"packageNameMatcher");
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = RunManager.Companion.getInstance(this.project).getSelectedConfiguration();
        RunConfiguration configuration2 = runnerAndConfigurationSettings != null ? runnerAndConfigurationSettings.getConfiguration() : null;
        SearchScopeProvidingRunProfile searchScopeProvidingRunProfile = configuration2 instanceof SearchScopeProvidingRunProfile ? (SearchScopeProvidingRunProfile)configuration2 : null;
        Object object = runScope = searchScopeProvidingRunProfile != null ? searchScopeProvidingRunProfile.getSearchScope() : null;
        if (runScope != null && (ktFile = this.findKotlinFileInScope(runScope, fileName, packageNameMatcher)) != null) {
            KtFile it = ktFile;
            boolean bl = false;
            return it;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
        return this.findKotlinFileInScope(globalSearchScope, fileName, packageNameMatcher);
    }

    /*
     * WARNING - void declaration
     */
    private final KtFile findKotlinFileInScope(GlobalSearchScope scope, String fileName, Function1<? super String, Boolean> packageNameMatcher) {
        Object v2;
        block3: {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$mapNotNullTo$iv$iv;
            Collection collection2 = FilenameIndex.getVirtualFilesByName((String)fileName, (GlobalSearchScope)scope);
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getVirtualFilesByName(...)");
            Collection files2 = collection2;
            PsiManager psiManager = PsiManager.getInstance((Project)this.project);
            Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
            PsiManager psiManager2 = psiManager;
            Iterable $this$mapNotNull$iv = files2;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                PsiFile it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                VirtualFile it = (VirtualFile)element$iv$iv;
                boolean bl2 = false;
                if ((!it.isValid() ? null : (it.isDirectory() ? null : psiManager2.findFile(it))) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List sourceFiles = (List)destination$iv$iv;
            Iterable $this$filterIsInstance$iv = sourceFiles;
            boolean $i$f$filterIsInstance = false;
            $this$mapNotNullTo$iv$iv = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof KtFile)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable iterable2 = (List)destination$iv$iv;
            for (Object e : iterable2) {
                KtFile it = (KtFile)e;
                boolean bl = false;
                if (!((Boolean)packageNameMatcher.invoke((Object)it.getPackageFqName().asString())).booleanValue()) continue;
                v2 = e;
                break block3;
            }
            v2 = null;
        }
        return v2;
    }

    private static final boolean findComposableNavigatable$lambda$0(ComposeViewNode $node, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ComposeViewNodeKt.packageNameHash(it) == $node.getComposePackageHash();
    }
}

