/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.model;

import com.android.tools.idea.layoutinspector.model.ComposeViewNode;
import com.android.tools.idea.layoutinspector.model.DrawViewNode;
import com.android.tools.idea.layoutinspector.model.DrawViewNodeKt;
import com.android.tools.idea.layoutinspector.model.InspectorModel;
import com.android.tools.idea.layoutinspector.model.RecompositionData;
import com.android.tools.idea.layoutinspector.model.ViewNode;
import com.android.tools.idea.layoutinspector.tree.TreeSettings;
import com.android.tools.idea.layoutinspector.ui.RenderSettings;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J8\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0017H\u0002J \u0010\u001d\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0017H\u0002J*\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001bH\u0002J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00010$2\u0006\u0010%\u001a\u00020&H\u0016R\u0014\u0010\n\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006'"}, d2={"Lcom/android/tools/idea/layoutinspector/model/DrawViewChild;", "Lcom/android/tools/idea/layoutinspector/model/DrawViewNode;", "owner", "Lcom/android/tools/idea/layoutinspector/model/ViewNode;", "<init>", "(Lcom/android/tools/idea/layoutinspector/model/ViewNode;)V", "canCollapse", "", "treeSettings", "Lcom/android/tools/idea/layoutinspector/tree/TreeSettings;", "drawWhenCollapsed", "getDrawWhenCollapsed", "()Z", "paint", "", "g2", "Ljava/awt/Graphics2D;", "model", "Lcom/android/tools/idea/layoutinspector/model/InspectorModel;", "paintBorder", "isSelected", "isHovered", "renderSettings", "Lcom/android/tools/idea/layoutinspector/ui/RenderSettings;", "highlightColor", "Ljava/awt/Color;", "highlightCount", "", "viewSettings", "heatmapColor", "computeLabelPosition", "Lkotlin/Triple;", "border", "Ljava/awt/Shape;", "textWidth", "children", "Lkotlin/sequences/Sequence;", "access", "Lcom/android/tools/idea/layoutinspector/model/ViewNode$ReadAccess;", "intellij.android.layout-inspector"})
@SourceDebugExtension(value={"SMAP\nDrawViewNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DrawViewNode.kt\ncom/android/tools/idea/layoutinspector/model/DrawViewChild\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,477:1\n1#2:478\n*E\n"})
public final class DrawViewChild
extends DrawViewNode {
    public DrawViewChild(@NotNull ViewNode owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        super(owner, null);
    }

    @Override
    public boolean canCollapse(@NotNull TreeSettings treeSettings) {
        Intrinsics.checkNotNullParameter((Object)treeSettings, (String)"treeSettings");
        return !this.getUnfilteredOwner().isInComponentTree(treeSettings);
    }

    @Override
    public boolean getDrawWhenCollapsed() {
        return false;
    }

    @Override
    public void paint(@NotNull Graphics2D g2, @NotNull InspectorModel model) {
        Intrinsics.checkNotNullParameter((Object)g2, (String)"g2");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
    }

    @Override
    public void paintBorder(@NotNull Graphics2D g2, boolean isSelected, boolean isHovered, @NotNull InspectorModel model, @NotNull RenderSettings renderSettings, @NotNull TreeSettings treeSettings) {
        boolean showHighlight;
        boolean showCount;
        Intrinsics.checkNotNullParameter((Object)g2, (String)"g2");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)renderSettings, (String)"renderSettings");
        Intrinsics.checkNotNullParameter((Object)treeSettings, (String)"treeSettings");
        Color hoverColor = new Color(renderSettings.getHoverColor(), true);
        Color selectionColor = new Color(renderSettings.getSelectionColor(), true);
        Color baseColor = new Color(renderSettings.getBaseColor(), true);
        Color outlineColor = new Color(renderSettings.getOutlineColor(), true);
        ViewNode owner = this.getUnfilteredOwner();
        if (isSelected || isHovered) {
            g2.setColor(outlineColor);
            g2.setStroke(DrawViewNodeKt.access$getEmphasizedLineOutlineStroke(renderSettings.getScaleFraction()));
            if (renderSettings.getDrawBorders()) {
                g2.draw(this.getBounds());
            }
            if (renderSettings.getDrawUntransformedBounds()) {
                g2.draw(owner.getLayoutBounds());
            }
        }
        float labelX = 0.0f;
        float countX = 0.0f;
        float labelY = 0.0f;
        float borderWidth = 0.0f;
        ComposeViewNode composeView = owner instanceof ComposeViewNode ? (ComposeViewNode)owner : null;
        Object object = composeView;
        int composeCount = object != null && (object = ((ComposeViewNode)object).getRecompositions()) != null ? ((RecompositionData)object).getCount() : 0;
        Object object2 = composeView;
        float highlightCount = object2 != null && (object2 = ((ComposeViewNode)object2).getRecompositions()) != null ? ((RecompositionData)object2).getHighlightCount() : 0.0f;
        boolean bl = showCount = isSelected && treeSettings.getShowRecompositions() && composeCount > 0;
        boolean bl2 = treeSettings.getShowRecompositions() && highlightCount > 0.0f && !(model.getMaxHighlight() == 0.0f) ? true : (showHighlight = false);
        if (isSelected && renderSettings.getDrawLabel()) {
            g2.setFont(g2.getFont().deriveFont(DrawViewNodeKt.getLabelFontSize(renderSettings.getScaleFraction())));
            FontMetrics fontMetrics = g2.getFontMetrics();
            float textWidth = fontMetrics.stringWidth(owner.getUnqualifiedName());
            float countWidth = showCount ? (float)fontMetrics.stringWidth(String.valueOf(composeCount)) : 0.0f;
            Shape border = renderSettings.getDrawBorders() || !renderSettings.getDrawUntransformedBounds() ? this.getBounds() : (Shape)owner.getLayoutBounds();
            float textHeight = fontMetrics.getMaxAscent();
            borderWidth = textHeight * 0.3f;
            Triple<Float, Float, Float> position = this.computeLabelPosition(border, textWidth);
            labelX = ((Number)position.getFirst()).floatValue();
            countX = ((Number)position.getSecond()).floatValue() - countWidth - 2.0f * borderWidth;
            labelY = ((Number)position.getThird()).floatValue();
            showCount = showCount && labelX + textWidth + 2.0f * borderWidth < countX - 2.0f * borderWidth;
            g2.draw(new Rectangle2D.Float(labelX, labelY - textHeight - 2.0f * borderWidth, textWidth + 2.0f * borderWidth, textHeight + 2.0f * borderWidth));
            if (showCount) {
                g2.draw(new Rectangle2D.Float(countX, labelY - textHeight - 2.0f * borderWidth, countWidth + 2.0f * borderWidth, textHeight + 2.0f * borderWidth));
            }
            g2.setColor(selectionColor);
            float emphasizedBorderThickness = DrawViewNodeKt.getEmphasizedBorderThickness(renderSettings.getScaleFraction());
            g2.fill(new Rectangle2D.Float(labelX - emphasizedBorderThickness / 2.0f, labelY - textHeight - 2.0f * borderWidth - emphasizedBorderThickness / 2.0f, textWidth + 2.0f * borderWidth + emphasizedBorderThickness, textHeight + 2.0f * borderWidth + emphasizedBorderThickness));
            if (showCount) {
                g2.fill(new Rectangle2D.Float(countX - emphasizedBorderThickness / 2.0f, labelY - textHeight - 2.0f * borderWidth - emphasizedBorderThickness / 2.0f, countWidth + 2.0f * borderWidth + emphasizedBorderThickness, textHeight + 2.0f * borderWidth + emphasizedBorderThickness));
            }
        }
        if (isSelected) {
            g2.setColor(selectionColor);
            g2.setStroke(DrawViewNodeKt.access$getSelectedLineStroke(renderSettings.getScaleFraction()));
        } else if (isHovered) {
            g2.setColor(hoverColor);
            g2.setStroke(DrawViewNodeKt.access$getEmphasizedLineStroke(renderSettings.getScaleFraction()));
        } else if (showHighlight) {
            g2.setColor(this.highlightColor(model, highlightCount, renderSettings));
            g2.setStroke(DrawViewNodeKt.access$getNormalLineStroke(renderSettings.getScaleFraction()));
        } else {
            g2.setColor(baseColor);
            g2.setStroke(DrawViewNodeKt.access$getNormalLineStroke(renderSettings.getScaleFraction()));
        }
        if (renderSettings.getDrawBorders() || isHovered || showHighlight || isSelected && !renderSettings.getDrawUntransformedBounds()) {
            g2.draw(this.getBounds());
        }
        if (renderSettings.getDrawUntransformedBounds()) {
            g2.draw(owner.getLayoutBounds());
        }
        if (isSelected && renderSettings.getDrawLabel()) {
            g2.setColor(Color.WHITE);
            g2.drawString(owner.getUnqualifiedName(), labelX + borderWidth, labelY - borderWidth - DrawViewNodeKt.getEmphasizedBorderThickness(renderSettings.getScaleFraction()) / 2.0f);
            if (showCount) {
                g2.drawString(String.valueOf(composeCount), countX + borderWidth, labelY - borderWidth - DrawViewNodeKt.getEmphasizedBorderThickness(renderSettings.getScaleFraction()) / 2.0f);
            }
        }
        if (showHighlight) {
            g2.setPaint(this.heatmapColor(model, highlightCount, renderSettings));
            g2.fill(this.getBounds());
        }
    }

    private final Color highlightColor(InspectorModel model, float highlightCount, RenderSettings viewSettings) {
        Color baseColor = new Color(viewSettings.getRecompositionColor());
        int alpha = RangesKt.coerceIn((int)((int)(highlightCount * 255.0f / model.getMaxHighlight())), (int)32, (int)255);
        return new Color(baseColor.getRed(), baseColor.getGreen(), baseColor.getBlue(), alpha);
    }

    private final Color heatmapColor(InspectorModel model, float highlightCount, RenderSettings viewSettings) {
        Color baseColor = new Color(viewSettings.getRecompositionColor());
        int alpha = RangesKt.coerceIn((int)((int)(highlightCount * 192.0f / model.getMaxHighlight())), (int)8, (int)192);
        return new Color(baseColor.getRed(), baseColor.getGreen(), baseColor.getBlue(), alpha);
    }

    private final Triple<Float, Float, Float> computeLabelPosition(Shape border, float textWidth) {
        float minY = (float)border.getBounds().getMinY();
        float minSlope = Float.MAX_VALUE;
        float[] nextPoint = new float[6];
        PathIterator pathIter = border.getPathIterator(null);
        pathIter.currentSegment(nextPoint);
        float prevX = 0.0f;
        float prevY = 0.0f;
        float leastSlopedSideWidth = 0.0f;
        float topLeftY = 0.0f;
        float xLeft = 0.0f;
        float xRight = 0.0f;
        while (true) {
            float slope;
            prevX = nextPoint[0];
            prevY = nextPoint[1];
            pathIter.next();
            if (pathIter.isDone()) break;
            pathIter.currentSegment(nextPoint);
            if (!(prevY == minY) && !(nextPoint[1] == minY) || (double)Math.abs(prevX - nextPoint[0]) < 0.001 || !(Math.abs(slope = (nextPoint[1] - prevY) / (nextPoint[0] - prevX)) < Math.abs(minSlope))) continue;
            xLeft = Math.min(nextPoint[0], prevX);
            xRight = Math.max(nextPoint[0], prevX);
            minSlope = slope;
            leastSlopedSideWidth = Math.abs(nextPoint[0] - prevX);
            topLeftY = nextPoint[0] < prevX ? nextPoint[1] : prevY;
        }
        float connectionWidth = Math.min(leastSlopedSideWidth, textWidth) / 2.0f;
        return new Triple((Object)Float.valueOf(xLeft), (Object)Float.valueOf(xRight), (Object)Float.valueOf(minSlope * connectionWidth + topLeftY));
    }

    @Override
    @NotNull
    public Sequence<DrawViewNode> children(@NotNull ViewNode.ReadAccess access) {
        Intrinsics.checkNotNullParameter((Object)access, (String)"access");
        ViewNode.ReadAccess $this$children_u24lambda_u240 = access;
        boolean bl = false;
        return CollectionsKt.asSequence((Iterable)$this$children_u24lambda_u240.getDrawChildren(this.getUnfilteredOwner()));
    }
}

