/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.devtools;

import com.android.tools.idea.layoutinspector.devtools.ChromeDevToolsKt;
import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\bJ\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\nH\u0007R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/layoutinspector/devtools/ChromeDevTools;", "", "<init>", "()V", "isChromeAvailable", "", "()Z", "navigateTo", "", "findChromeBrowser", "Lcom/intellij/ide/browsers/WebBrowser;", "isChrome", "browser", "intellij.android.layout-inspector"})
public final class ChromeDevTools {
    @NotNull
    public static final ChromeDevTools INSTANCE = new ChromeDevTools();

    private ChromeDevTools() {
    }

    public final boolean isChromeAvailable() {
        return this.findChromeBrowser() != null;
    }

    public final void navigateTo() {
        WebBrowser webBrowser = this.findChromeBrowser();
        if (webBrowser == null) {
            return;
        }
        WebBrowser browser = webBrowser;
        BrowserLauncher.Companion.getInstance().browse("chrome://inspect", browser);
    }

    private final WebBrowser findChromeBrowser() {
        WebBrowserManager manager = WebBrowserManager.getInstance();
        List list2 = manager.getBrowsers(ChromeDevTools::findChromeBrowser$lambda$0, true);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getBrowsers(...)");
        return (WebBrowser)CollectionsKt.firstOrNull((List)list2);
    }

    @VisibleForTesting
    public final boolean isChrome(@NotNull WebBrowser browser) {
        Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
        return browser.getFamily() == BrowserFamily.CHROME && Intrinsics.areEqual((Object)browser.getId(), (Object)ChromeDevToolsKt.access$getCHROME_ID$p());
    }

    private static final boolean findChromeBrowser$lambda$0(WebBrowser it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.isChrome(it);
    }
}

