/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lang.androidSql.room;

import com.android.tools.idea.lang.androidSql.NotRenamableElement;
import com.android.tools.idea.lang.androidSql.parser.AndroidSqlLexer;
import com.android.tools.idea.lang.androidSql.refactoring.AndroidSqlFindUsagesProvider;
import com.android.tools.idea.lang.androidSql.resolution.AndroidSqlColumn;
import com.android.tools.idea.lang.androidSql.resolution.AndroidSqlDefinition;
import com.android.tools.idea.lang.androidSql.room.PsiElementForFakeColumn;
import com.android.tools.idea.lang.androidSql.room.RoomAnnotations;
import com.android.tools.idea.lang.androidSql.room.RoomDependencyChecker;
import com.android.tools.idea.lang.androidSql.room.RoomSchema;
import com.android.tools.idea.lang.androidSql.room.RoomSchemaManager;
import com.android.tools.idea.lang.androidSql.room.RoomTable;
import com.android.tools.idea.lang.androidSql.room.RoomUtilsKt;
import com.intellij.lang.cacheBuilder.WordOccurrence;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020\u000fH\u0016J\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0012H\u0002J$\u0010\u0013\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u0015\u0012\u0004\u0012\u00020\n\u0018\u00010\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/lang/androidSql/room/RoomReferenceSearchExecutor;", "Lcom/intellij/openapi/application/QueryExecutorBase;", "Lcom/intellij/psi/PsiReference;", "Lcom/intellij/psi/search/searches/ReferencesSearch$SearchParameters;", "<init>", "()V", "getSchema", "Lcom/android/tools/idea/lang/androidSql/room/RoomSchema;", "kotlin.jvm.PlatformType", "element", "Lcom/intellij/psi/PsiElement;", "processQuery", "", "queryParameters", "consumer", "Lcom/intellij/util/Processor;", "definesSqlTable", "", "Lcom/intellij/psi/PsiClass;", "chooseWordsAndElement", "Lkotlin/Pair;", "", "", "definition", "Lcom/android/tools/idea/lang/androidSql/resolution/AndroidSqlDefinition;", "getNameDefinition", "schema", "intellij.android.lang"})
@SourceDebugExtension(value={"SMAP\nRoomReferenceSearchExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoomReferenceSearchExecutor.kt\ncom/android/tools/idea/lang/androidSql/room/RoomReferenceSearchExecutor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,166:1\n1563#2:167\n1634#2,2:168\n1636#2:171\n295#2,2:172\n1#3:170\n*S KotlinDebug\n*F\n+ 1 RoomReferenceSearchExecutor.kt\ncom/android/tools/idea/lang/androidSql/room/RoomReferenceSearchExecutor\n*L\n121#1:167\n121#1:168,2\n121#1:171\n157#1:172,2\n*E\n"})
public final class RoomReferenceSearchExecutor
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    private final RoomSchema getSchema(PsiElement element) {
        return (RoomSchema)ReadAction.compute(() -> RoomReferenceSearchExecutor.getSchema$lambda$0(element));
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer2) {
        Intrinsics.checkNotNullParameter((Object)queryParameters, (String)"queryParameters");
        Intrinsics.checkNotNullParameter(consumer2, (String)"consumer");
        Ref.ObjectRef element = new Ref.ObjectRef();
        PsiElement psiElement = queryParameters.getElementToSearch();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElementToSearch(...)");
        element.element = psiElement;
        if (element.element instanceof NotRenamableElement) {
            element.element = ((NotRenamableElement)element.element).getDelegate();
        }
        Pair pair = (Pair)ActionsKt.runReadAction(() -> RoomReferenceSearchExecutor.processQuery$lambda$0(element, this));
        if (pair == null) {
            return;
        }
        Pair pair2 = pair;
        Collection words = (Collection)pair2.component1();
        PsiElement referenceTarget = (PsiElement)pair2.component2();
        for (String word : words) {
            queryParameters.getOptimizer().searchWord(word, queryParameters.getEffectiveSearchScope(), false, referenceTarget);
        }
    }

    private final boolean definesSqlTable(PsiClass $this$definesSqlTable) {
        return $this$definesSqlTable.hasAnnotation(RoomAnnotations.INSTANCE.getENTITY().oldName()) || $this$definesSqlTable.hasAnnotation(RoomAnnotations.INSTANCE.getENTITY().newName()) || $this$definesSqlTable.hasAnnotation(RoomAnnotations.INSTANCE.getDATABASE_VIEW().oldName()) || $this$definesSqlTable.hasAnnotation(RoomAnnotations.INSTANCE.getDATABASE_VIEW().newName());
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<List<String>, PsiElement> chooseWordsAndElement(AndroidSqlDefinition definition) {
        void $this$mapTo$iv$iv;
        ArrayList<String> names = new ArrayList<String>();
        if (definition.getName() != null) {
            String string = definition.getName();
            Intrinsics.checkNotNull((Object)string);
            names.add(string);
        }
        if (definition instanceof AndroidSqlColumn) {
            names.addAll((Collection)((AndroidSqlColumn)definition).getAlternativeNames());
        }
        if (names.isEmpty()) {
            return null;
        }
        Iterable $this$map$iv = names;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object object;
            Collection collection2;
            block8: {
                void name2;
                block6: {
                    block7: {
                        CharSequence charSequence;
                        String string = (String)item$iv$iv;
                        collection2 = destination$iv$iv;
                        boolean bl = false;
                        if (!AndroidSqlLexer.Companion.needsQuoting((String)name2)) break block6;
                        CommonProcessors.FindFirstProcessor processor = new CommonProcessors.FindFirstProcessor();
                        new AndroidSqlFindUsagesProvider().getWordsScanner().processWords((CharSequence)AndroidSqlLexer.Companion.getValidName((String)name2), (Processor)processor);
                        object = (WordOccurrence)processor.getFoundValue();
                        if (object == null) break block7;
                        WordOccurrence it = object;
                        boolean bl2 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it.getBaseText(), (String)"getBaseText(...)");
                        int n = it.getStart();
                        int n2 = it.getEnd();
                        String string2 = ((Object)charSequence.subSequence(n, n2)).toString();
                        object = string2;
                        if (string2 != null) break block8;
                    }
                    object = name2;
                    break block8;
                }
                object = name2;
            }
            collection2.add(object);
        }
        List words = (List)destination$iv$iv;
        return new Pair((Object)words, (Object)definition.getResolveTo());
    }

    private final AndroidSqlDefinition getNameDefinition(RoomSchema schema, PsiElement element) {
        AndroidSqlDefinition androidSqlDefinition;
        PsiElement psiElement = element;
        if (psiElement instanceof PsiClass) {
            androidSqlDefinition = schema.findTable((PsiClass)element);
        } else if (psiElement instanceof PsiField) {
            AndroidSqlColumn androidSqlColumn;
            Set<AndroidSqlColumn> set2;
            PsiClass psiClass = ((PsiField)element).getContainingClass();
            if (psiClass == null) {
                return null;
            }
            RoomTable roomTable = schema.findTable(psiClass);
            if (roomTable != null && (set2 = roomTable.getColumns()) != null) {
                Object v2;
                block20: {
                    Iterable iterable = set2;
                    for (Object t : iterable) {
                        AndroidSqlColumn it = (AndroidSqlColumn)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getDefiningElement(), (Object)element)) continue;
                        v2 = t;
                        break block20;
                    }
                    v2 = null;
                }
                androidSqlColumn = v2;
            } else {
                androidSqlColumn = null;
            }
            androidSqlDefinition = androidSqlColumn;
        } else if (psiElement instanceof PsiElementForFakeColumn) {
            AndroidSqlColumn androidSqlColumn;
            Set<AndroidSqlColumn> set3;
            RoomTable roomTable = schema.findTable(((PsiElementForFakeColumn)element).getTablePsiElement());
            if (roomTable != null && (set3 = roomTable.getColumns()) != null) {
                Object v4;
                block21: {
                    Iterable iterable = set3;
                    for (Object t : iterable) {
                        AndroidSqlColumn it = (AndroidSqlColumn)t;
                        boolean bl = false;
                        if (!PsiManager.getInstance((Project)((PsiElementForFakeColumn)element).getProject()).areElementsEquivalent(it.getDefiningElement(), element)) continue;
                        v4 = t;
                        break block21;
                    }
                    v4 = null;
                }
                androidSqlColumn = v4;
            } else {
                androidSqlColumn = null;
            }
            androidSqlDefinition = androidSqlColumn;
        } else if (psiElement instanceof KtProperty) {
            AndroidSqlColumn androidSqlColumn;
            Set<AndroidSqlColumn> set4;
            Object v6;
            block22: {
                Iterable $this$firstOrNull$iv = LightClassUtilsKt.toLightElements((KtElement)((KtElement)element));
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PsiNamedElement it = (PsiNamedElement)element$iv;
                    boolean bl = false;
                    if (!(it instanceof PsiField)) continue;
                    v6 = element$iv;
                    break block22;
                }
                v6 = null;
            }
            PsiNamedElement lightField = v6;
            KtClass ktClass = KtPsiUtilKt.containingClass((KtElement)((KtElement)element));
            if (ktClass == null || (ktClass = LightClassUtilsKt.toLightClass((KtClassOrObject)((KtClassOrObject)ktClass))) == null) {
                return null;
            }
            RoomTable roomTable = schema.findTable((PsiClass)ktClass);
            if (roomTable != null && (set4 = roomTable.getColumns()) != null) {
                Object v8;
                block23: {
                    Iterable iterable = set4;
                    for (Object t : iterable) {
                        AndroidSqlColumn it = (AndroidSqlColumn)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getDefiningElement(), (Object)lightField)) continue;
                        v8 = t;
                        break block23;
                    }
                    v8 = null;
                }
                androidSqlColumn = v8;
            } else {
                androidSqlColumn = null;
            }
            androidSqlDefinition = androidSqlColumn;
        } else {
            androidSqlDefinition = null;
        }
        return androidSqlDefinition;
    }

    private static final RoomSchema getSchema$lambda$0(PsiElement $element) {
        RoomSchema roomSchema;
        if ($element.getContainingFile() != null) {
            Module module = ModuleUtil.findModuleForPsiElement((PsiElement)$element);
            if (module == null) {
                return null;
            }
            Module module2 = module;
            RoomSchemaManager roomSchemaManager = RoomSchemaManager.Companion.getInstance(module2);
            PsiFile psiFile = $element.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
            roomSchema = roomSchemaManager.getSchema(psiFile);
        } else {
            roomSchema = null;
        }
        return roomSchema;
    }

    private static final Pair processQuery$lambda$0(Ref.ObjectRef $element, RoomReferenceSearchExecutor this$0) {
        Pair pair;
        Project project = ((PsiElement)$element.element).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (!RoomDependencyChecker.Companion.getInstance(project).isRoomPresent()) {
            return null;
        }
        if (!RoomUtilsKt.getDefinesRoomSchema((PsiElement)$element.element)) {
            return null;
        }
        RoomSchema schema = this$0.getSchema((PsiElement)$element.element);
        if (schema == null) {
            if ($element.element instanceof PsiNamedElement && ((PsiNamedElement)$element.element).getName() != null) {
                String string = ((PsiNamedElement)$element.element).getName();
                Intrinsics.checkNotNull((Object)string);
                pair = new Pair((Object)SetsKt.setOf((Object)string), $element.element);
            } else {
                pair = null;
            }
        } else {
            AndroidSqlDefinition androidSqlDefinition = this$0.getNameDefinition(schema, (PsiElement)$element.element);
            if (androidSqlDefinition != null) {
                AndroidSqlDefinition p0 = androidSqlDefinition;
                boolean bl = false;
                pair = this$0.chooseWordsAndElement(p0);
            } else {
                pair = null;
            }
        }
        return pair;
    }
}

