/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lang.agsl;

import com.android.tools.idea.lang.agsl.AgslTokenType;
import com.android.tools.idea.lang.agsl.psi.AgslElementType;
import com.android.tools.idea.lang.agsl.psi.impl.AgslGlslIdentifierImpl;
import com.android.tools.idea.lang.agsl.psi.impl.AgslReservedKeywordImpl;
import com.android.tools.idea.lang.agsl.psi.impl.AgslTokenImpl;
import com.android.tools.idea.lang.agsl.psi.impl.AgslUnsupportedKeywordImpl;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;

public interface AgslTokenTypes {
    public static final IElementType GLSL_IDENTIFIER = new AgslElementType("GLSL_IDENTIFIER");
    public static final IElementType RESERVED_KEYWORD = new AgslElementType("RESERVED_KEYWORD");
    public static final IElementType TOKEN = new AgslElementType("TOKEN");
    public static final IElementType UNSUPPORTED_KEYWORD = new AgslElementType("UNSUPPORTED_KEYWORD");
    public static final IElementType ADD_ASSIGN = new AgslTokenType("+=");
    public static final IElementType AMPERSAND = new AgslTokenType("&");
    public static final IElementType AND_ASSIGN = new AgslTokenType("&=");
    public static final IElementType AND_OP = new AgslTokenType("&&");
    public static final IElementType ASM = new AgslTokenType("asm");
    public static final IElementType ATTRIBUTE = new AgslTokenType("attribute");
    public static final IElementType BANG = new AgslTokenType("!");
    public static final IElementType BLENDER = new AgslTokenType("blender");
    public static final IElementType BLOCK_COMMENT = new AgslTokenType("BLOCK_COMMENT");
    public static final IElementType BOOL = new AgslTokenType("bool");
    public static final IElementType BOOL2 = new AgslTokenType("bool2");
    public static final IElementType BOOL3 = new AgslTokenType("bool3");
    public static final IElementType BOOL4 = new AgslTokenType("bool4");
    public static final IElementType BREAK = new AgslTokenType("break");
    public static final IElementType BVEC2 = new AgslTokenType("bvec2");
    public static final IElementType BVEC3 = new AgslTokenType("bvec3");
    public static final IElementType BVEC4 = new AgslTokenType("bvec4");
    public static final IElementType CARET = new AgslTokenType("^");
    public static final IElementType CAST = new AgslTokenType("cast");
    public static final IElementType CLASS = new AgslTokenType("class");
    public static final IElementType COLON = new AgslTokenType(":");
    public static final IElementType COLORFILTER = new AgslTokenType("colorFilter");
    public static final IElementType COMMA = new AgslTokenType(",");
    public static final IElementType COMMENT = new AgslTokenType("COMMENT");
    public static final IElementType CONST = new AgslTokenType("const");
    public static final IElementType CONTINUE = new AgslTokenType("continue");
    public static final IElementType DASH = new AgslTokenType("-");
    public static final IElementType DEC_OP = new AgslTokenType("--");
    public static final IElementType DEFAULT = new AgslTokenType("default");
    public static final IElementType DISCARD = new AgslTokenType("discard");
    public static final IElementType DIV_ASSIGN = new AgslTokenType("/=");
    public static final IElementType DO = new AgslTokenType("do");
    public static final IElementType DOT = new AgslTokenType(".");
    public static final IElementType DOUBLE = new AgslTokenType("double");
    public static final IElementType DVEC2 = new AgslTokenType("dvec2");
    public static final IElementType DVEC3 = new AgslTokenType("dvec3");
    public static final IElementType DVEC4 = new AgslTokenType("dvec4");
    public static final IElementType ELSE = new AgslTokenType("else");
    public static final IElementType ENUM = new AgslTokenType("enum");
    public static final IElementType EQUAL = new AgslTokenType("=");
    public static final IElementType EQ_OP = new AgslTokenType("==");
    public static final IElementType EXTERN = new AgslTokenType("extern");
    public static final IElementType EXTERNAL = new AgslTokenType("external");
    public static final IElementType FALSE = new AgslTokenType("false");
    public static final IElementType FIXED = new AgslTokenType("fixed");
    public static final IElementType FLAT = new AgslTokenType("flat");
    public static final IElementType FLOAT = new AgslTokenType("float");
    public static final IElementType FLOAT2 = new AgslTokenType("float2");
    public static final IElementType FLOAT2X2 = new AgslTokenType("float2x2");
    public static final IElementType FLOAT3 = new AgslTokenType("float3");
    public static final IElementType FLOAT3X3 = new AgslTokenType("float3x3");
    public static final IElementType FLOAT4 = new AgslTokenType("float4");
    public static final IElementType FLOAT4X4 = new AgslTokenType("float4x4");
    public static final IElementType FLOATCONSTANT = new AgslTokenType("FLOATCONSTANT");
    public static final IElementType FOR = new AgslTokenType("for");
    public static final IElementType FVEC2 = new AgslTokenType("fvec2");
    public static final IElementType FVEC3 = new AgslTokenType("fvec3");
    public static final IElementType FVEC4 = new AgslTokenType("fvec4");
    public static final IElementType GE_OP = new AgslTokenType(">=");
    public static final IElementType GOTO = new AgslTokenType("goto");
    public static final IElementType HALF = new AgslTokenType("half");
    public static final IElementType HALF2 = new AgslTokenType("half2");
    public static final IElementType HALF2X2 = new AgslTokenType("half2x2");
    public static final IElementType HALF3 = new AgslTokenType("half3");
    public static final IElementType HALF3X3 = new AgslTokenType("half3x3");
    public static final IElementType HALF4 = new AgslTokenType("half4");
    public static final IElementType HALF4X4 = new AgslTokenType("half4x4");
    public static final IElementType HIGH_PRECISION = new AgslTokenType("highp");
    public static final IElementType HVEC2 = new AgslTokenType("hvec2");
    public static final IElementType HVEC3 = new AgslTokenType("hvec3");
    public static final IElementType HVEC4 = new AgslTokenType("hvec4");
    public static final IElementType IDENTIFIER = new AgslTokenType("IDENTIFIER");
    public static final IElementType IDENTIFIER_GL_PREFIX = new AgslTokenType("IDENTIFIER_GL_PREFIX");
    public static final IElementType IF = new AgslTokenType("if");
    public static final IElementType IN = new AgslTokenType("in");
    public static final IElementType INC_OP = new AgslTokenType("++");
    public static final IElementType INLINE = new AgslTokenType("inline");
    public static final IElementType INOUT = new AgslTokenType("inout");
    public static final IElementType INPUT = new AgslTokenType("input");
    public static final IElementType INT = new AgslTokenType("int");
    public static final IElementType INT2 = new AgslTokenType("int2");
    public static final IElementType INT3 = new AgslTokenType("int3");
    public static final IElementType INT4 = new AgslTokenType("int4");
    public static final IElementType INTCONSTANT = new AgslTokenType("INTCONSTANT");
    public static final IElementType INTERFACE = new AgslTokenType("interface");
    public static final IElementType INVARIANT = new AgslTokenType("invariant");
    public static final IElementType IVEC2 = new AgslTokenType("ivec2");
    public static final IElementType IVEC3 = new AgslTokenType("ivec3");
    public static final IElementType IVEC4 = new AgslTokenType("ivec4");
    public static final IElementType LEFT_ANGLE = new AgslTokenType("<");
    public static final IElementType LEFT_ASSIGN = new AgslTokenType("<<=");
    public static final IElementType LEFT_BRACE = new AgslTokenType("{");
    public static final IElementType LEFT_BRACKET = new AgslTokenType("[");
    public static final IElementType LEFT_OP = new AgslTokenType("<<");
    public static final IElementType LEFT_PAREN = new AgslTokenType("(");
    public static final IElementType LE_OP = new AgslTokenType("<=");
    public static final IElementType LONG = new AgslTokenType("long");
    public static final IElementType LOW_PRECISION = new AgslTokenType("lowp");
    public static final IElementType MAT2 = new AgslTokenType("mat2");
    public static final IElementType MAT3 = new AgslTokenType("mat3");
    public static final IElementType MAT4 = new AgslTokenType("mat4");
    public static final IElementType MEDIUM_PRECISION = new AgslTokenType("mediump");
    public static final IElementType MOD_ASSIGN = new AgslTokenType("%=");
    public static final IElementType MUL_ASSIGN = new AgslTokenType("*=");
    public static final IElementType NAMESPACE = new AgslTokenType("namespace");
    public static final IElementType NE_OP = new AgslTokenType("!=");
    public static final IElementType NOINLINE = new AgslTokenType("noinline");
    public static final IElementType OR_ASSIGN = new AgslTokenType("|=");
    public static final IElementType OR_OP = new AgslTokenType("||");
    public static final IElementType OUT = new AgslTokenType("out");
    public static final IElementType OUTPUT = new AgslTokenType("output");
    public static final IElementType PACKED = new AgslTokenType("packed");
    public static final IElementType PERCENT = new AgslTokenType("%");
    public static final IElementType PLUS = new AgslTokenType("+");
    public static final IElementType PRECISION = new AgslTokenType("precision");
    public static final IElementType PUBLIC = new AgslTokenType("public");
    public static final IElementType QUESTION = new AgslTokenType("?");
    public static final IElementType RETURN = new AgslTokenType("return");
    public static final IElementType RIGHT_ANGLE = new AgslTokenType(">");
    public static final IElementType RIGHT_ASSIGN = new AgslTokenType(">>=");
    public static final IElementType RIGHT_BRACE = new AgslTokenType("}");
    public static final IElementType RIGHT_BRACKET = new AgslTokenType("]");
    public static final IElementType RIGHT_OP = new AgslTokenType(">>");
    public static final IElementType RIGHT_PAREN = new AgslTokenType(")");
    public static final IElementType SAMPLER1D = new AgslTokenType("sampler1D");
    public static final IElementType SAMPLER1DSHADOW = new AgslTokenType("sampler1DShadow");
    public static final IElementType SAMPLER2D = new AgslTokenType("sampler2d");
    public static final IElementType SAMPLER2DRECT = new AgslTokenType("sampler2DRect");
    public static final IElementType SAMPLER2DRECTSHADOW = new AgslTokenType("sampler2DRectShadow");
    public static final IElementType SAMPLER2DSHADOW = new AgslTokenType("sampler2DShadow");
    public static final IElementType SAMPLER3D = new AgslTokenType("sampler3D");
    public static final IElementType SAMPLER3DRECT = new AgslTokenType("sampler3DRect");
    public static final IElementType SAMPLERCUBE = new AgslTokenType("samplerCube");
    public static final IElementType SEMICOLON = new AgslTokenType(";");
    public static final IElementType SHADER = new AgslTokenType("shader");
    public static final IElementType SHORT = new AgslTokenType("short");
    public static final IElementType SIZEOF = new AgslTokenType("sizeof");
    public static final IElementType SLASH = new AgslTokenType("/");
    public static final IElementType STAR = new AgslTokenType("*");
    public static final IElementType STATIC = new AgslTokenType("static");
    public static final IElementType STRUCT = new AgslTokenType("struct");
    public static final IElementType SUB_ASSIGN = new AgslTokenType("-=");
    public static final IElementType SUPERP = new AgslTokenType("superp");
    public static final IElementType SWITCH = new AgslTokenType("switch");
    public static final IElementType TEMPLATE = new AgslTokenType("template");
    public static final IElementType THIS = new AgslTokenType("this");
    public static final IElementType TILDE = new AgslTokenType("~");
    public static final IElementType TRUE = new AgslTokenType("true");
    public static final IElementType TYPEDEF = new AgslTokenType("typedef");
    public static final IElementType UNIFORM = new AgslTokenType("uniform");
    public static final IElementType UNION = new AgslTokenType("union");
    public static final IElementType UNSIGNED = new AgslTokenType("unsigned");
    public static final IElementType USING = new AgslTokenType("using");
    public static final IElementType VARYING = new AgslTokenType("varying");
    public static final IElementType VEC2 = new AgslTokenType("vec2");
    public static final IElementType VEC3 = new AgslTokenType("vec3");
    public static final IElementType VEC4 = new AgslTokenType("vec4");
    public static final IElementType VERTICAL_BAR = new AgslTokenType("|");
    public static final IElementType VOID = new AgslTokenType("void");
    public static final IElementType VOLATILE = new AgslTokenType("volatile");
    public static final IElementType WHILE = new AgslTokenType("while");
    public static final IElementType XOR_ASSIGN = new AgslTokenType("^=");
    public static final IElementType XOR_OP = new AgslTokenType("^^");

    public static class Factory {
        public static PsiElement createElement(ASTNode node) {
            IElementType type = node.getElementType();
            if (type == GLSL_IDENTIFIER) {
                return new AgslGlslIdentifierImpl(node);
            }
            if (type == RESERVED_KEYWORD) {
                return new AgslReservedKeywordImpl(node);
            }
            if (type == TOKEN) {
                return new AgslTokenImpl(node);
            }
            if (type == UNSUPPORTED_KEYWORD) {
                return new AgslUnsupportedKeywordImpl(node);
            }
            throw new AssertionError((Object)("Unknown element type: " + String.valueOf(type)));
        }
    }
}

