/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.insights.ui.vcs;

import com.intellij.codeInsight.hints.presentation.BasePresentation;
import com.intellij.codeInsight.hints.presentation.InlayTextMetrics;
import com.intellij.ide.ui.AntialiasingType;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.util.Map;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010#\u001a\u00020\u000fH\u0002J\u0018\u0010$\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010%\u001a\u00020\u001cH\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\u0018\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u0019\u0010\u0016\u001a\u00070\u0017\u00a2\u0006\u0002\b\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR&\u0010\u001f\u001a\u0014 !*\t\u0018\u00010\u0003\u00a2\u0006\u0002\b 0\u0003\u00a2\u0006\u0002\b 8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\r\u00a8\u00061"}, d2={"Lcom/android/tools/idea/insights/ui/vcs/InsightsTextInlayPresentation;", "Lcom/intellij/codeInsight/hints/presentation/BasePresentation;", "text", "", "textAttributesKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "isUnderline", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/editor/colors/TextAttributesKey;ZLcom/intellij/openapi/editor/Editor;)V", "getText", "()Ljava/lang/String;", "normalTextMetrics", "Lcom/intellij/codeInsight/hints/presentation/InlayTextMetrics;", "width", "", "getWidth", "()I", "height", "getHeight", "colorsScheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "Lorg/jetbrains/annotations/NotNull;", "getColorsScheme", "()Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "normalTextSize", "", "getNormalTextSize", "()F", "familyName", "Lcom/intellij/openapi/util/NlsSafe;", "kotlin.jvm.PlatformType", "getFamilyName", "getOrCreateMetrics", "createMetrics", "size", "getCurrentContext", "Ljava/awt/font/FontRenderContext;", "editorComponent", "Ljavax/swing/JComponent;", "paint", "", "g", "Ljava/awt/Graphics2D;", "attributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "toString", "intellij.android.app-quality-insights.ui"})
public final class InsightsTextInlayPresentation
extends BasePresentation {
    @NotNull
    private final String text;
    @NotNull
    private final TextAttributesKey textAttributesKey;
    private final boolean isUnderline;
    @NotNull
    private final Editor editor;
    @Nullable
    private InlayTextMetrics normalTextMetrics;

    public InsightsTextInlayPresentation(@NotNull String text2, @NotNull TextAttributesKey textAttributesKey, boolean isUnderline, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)textAttributesKey, (String)"textAttributesKey");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.text = text2;
        this.textAttributesKey = textAttributesKey;
        this.isUnderline = isUnderline;
        this.editor = editor;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public int getWidth() {
        return this.getOrCreateMetrics().getStringWidth(this.text);
    }

    public int getHeight() {
        return this.editor.getLineHeight();
    }

    private final EditorColorsScheme getColorsScheme() {
        EditorColorsScheme editorColorsScheme = this.editor.getColorsScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
        return editorColorsScheme;
    }

    private final float getNormalTextSize() {
        return this.getColorsScheme().getEditorFontSize2D();
    }

    private final String getFamilyName() {
        return this.getColorsScheme().getEditorFontName();
    }

    private final InlayTextMetrics getOrCreateMetrics() {
        block3: {
            block2: {
                if (this.normalTextMetrics == null) break block2;
                InlayTextMetrics inlayTextMetrics = this.normalTextMetrics;
                Intrinsics.checkNotNull((Object)inlayTextMetrics);
                float f = this.getNormalTextSize();
                String string = this.getFamilyName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-familyName>(...)");
                if (inlayTextMetrics.isActual(f, string)) break block3;
            }
            this.normalTextMetrics = this.createMetrics(this.editor, this.getNormalTextSize());
        }
        InlayTextMetrics inlayTextMetrics = this.normalTextMetrics;
        Intrinsics.checkNotNull((Object)inlayTextMetrics);
        return inlayTextMetrics;
    }

    private final InlayTextMetrics createMetrics(Editor editor, float size) {
        int fontType = this.getColorsScheme().getAttributes(this.textAttributesKey).getFontType();
        Font editorFont = EditorUtil.getEditorFont();
        Font font = editorFont.deriveFont(fontType, size);
        if (this.isUnderline) {
            Map<TextAttribute, ?> map2 = font.getAttributes();
            Intrinsics.checkNotNullExpressionValue(map2, (String)"getAttributes(...)");
            font = font.deriveFont(MapsKt.plus(map2, (Pair)TuplesKt.to((Object)TextAttribute.UNDERLINE, (Object)TextAttribute.UNDERLINE_ON)));
        }
        JComponent jComponent = editor.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
        FontRenderContext context = this.getCurrentContext(jComponent);
        FontMetrics fontMetrics = FontInfo.getFontMetrics((Font)font, (FontRenderContext)context);
        Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"getFontMetrics(...)");
        FontMetrics metrics = fontMetrics;
        int fontHeight = (int)Math.ceil(font.createGlyphVector(context, "H").getVisualBounds().getHeight());
        return new InlayTextMetrics(editor, fontHeight, fontHeight, metrics, fontType, UISettings.Companion.getInstance().getIdeScale());
    }

    private final FontRenderContext getCurrentContext(JComponent editorComponent) {
        FontRenderContext editorContext = FontInfo.getFontRenderContext((Component)editorComponent);
        return new FontRenderContext(editorContext.getTransform(), AntialiasingType.getKeyForCurrentScope((boolean)false), UISettings.Companion.getEditorFractionalMetricsHint());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(@NotNull Graphics2D g, @NotNull TextAttributes attributes) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Object savedHint = g.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
        try {
            InlayTextMetrics metrics = this.getOrCreateMetrics();
            Font font = metrics.getFont();
            g.setFont(font);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AntialiasingType.getKeyForCurrentScope((boolean)false));
            g.setColor(this.getColorsScheme().getAttributes(this.textAttributesKey).getForegroundColor());
            g.drawString(this.text, 0, (this.editor.getLineHeight() + metrics.getFontBaseline()) / 2);
        }
        finally {
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, savedHint);
        }
    }

    @NotNull
    public String toString() {
        return "InsightsTextInlayPresentation(text = " + this.text + ")";
    }
}

