/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.insights.ui.insight;

import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.actions.CopyAction;
import com.intellij.markdown.utils.doc.DocMarkdownToHtmlConverter;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.components.JBHtmlPane;
import com.intellij.ui.components.JBHtmlPaneConfiguration;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Color;
import java.net.URL;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0017\u0010\u000b\u001a\u00020\b2\r\u0010\f\u001a\t\u0018\u00010\r\u00a2\u0006\u0002\b\u000eH\u0016J\b\u0010\u000f\u001a\u00020\bH\u0016J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\f\u0010\u001b\u001a\u00020\b*\u00020\u001cH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/idea/insights/ui/insight/InsightTextPane;", "Lcom/intellij/ui/components/JBHtmlPane;", "Lcom/intellij/ide/CopyProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "initializePaneConfiguration", "", "builder", "Lcom/intellij/ui/components/JBHtmlPaneConfiguration$Builder;", "setText", "text", "", "Lorg/jetbrains/annotations/Nls;", "updateUI", "performCopy", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isCopyEnabled", "", "isCopyVisible", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "renderedText", "getRenderedText", "()Ljava/lang/String;", "addCodeBackgroundRule", "Ljavax/swing/text/html/StyleSheet;", "intellij.android.app-quality-insights.ui"})
@SourceDebugExtension(value={"SMAP\nInsightTextPane.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsightTextPane.kt\ncom/android/tools/idea/insights/ui/insight/InsightTextPane\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,122:1\n1#2:123\n*E\n"})
public final class InsightTextPane
extends JBHtmlPane
implements CopyProvider {
    @NotNull
    private final Project project;

    /*
     * WARNING - void declaration
     */
    public InsightTextPane(@NotNull Project project) {
        void $this$_init__u24lambda_u242;
        CopyAction copyAction;
        HTMLEditorKit hTMLEditorKit;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.setEditable(false);
        this.setOpaque(false);
        EditorKit editorKit = this.getEditorKit();
        Intrinsics.checkNotNull((Object)editorKit, (String)"null cannot be cast to non-null type javax.swing.text.html.HTMLEditorKit");
        HTMLEditorKit $this$_init__u24lambda_u240 = hTMLEditorKit = (HTMLEditorKit)editorKit;
        boolean $i$a$-apply-InsightTextPane$22 = false;
        $this$_init__u24lambda_u240.getStyleSheet().addRule("body { white-space: pre-wrap; }");
        StyleSheet styleSheet = $this$_init__u24lambda_u240.getStyleSheet();
        Intrinsics.checkNotNullExpressionValue((Object)styleSheet, (String)"getStyleSheet(...)");
        this.addCodeBackgroundRule(styleSheet);
        this.setFont(StartupUiUtil.getLabelFont());
        this.addHyperlinkListener(InsightTextPane::_init_$lambda$1);
        ActionManager actionManager = ActionManager.getInstance();
        AnAction[] $i$a$-apply-InsightTextPane$22 = new AnAction[1];
        CopyAction copyAction2 = copyAction = new CopyAction();
        int n = 0;
        AnAction[] anActionArray = $i$a$-apply-InsightTextPane$22;
        boolean bl = false;
        $this$_init__u24lambda_u242.getTemplatePresentation().setText("Copy");
        $this$_init__u24lambda_u242.getTemplatePresentation().setIcon(AllIcons.Actions.Copy);
        Unit unit = Unit.INSTANCE;
        anActionArray[n] = copyAction;
        AnAction[] anActionArray2 = $i$a$-apply-InsightTextPane$22;
        DefaultActionGroup group2 = new DefaultActionGroup(anActionArray2);
        ActionPopupMenu actionPopupMenu = actionManager.createActionPopupMenu("InsightTextPaneContextMenu", (ActionGroup)group2);
        Intrinsics.checkNotNullExpressionValue((Object)actionPopupMenu, (String)"createActionPopupMenu(...)");
        ActionPopupMenu popupMenu = actionPopupMenu;
        this.setComponentPopupMenu(popupMenu.getComponent());
        this.setBorder((Border)JBUI.Borders.empty());
    }

    protected void initializePaneConfiguration(@NotNull JBHtmlPaneConfiguration.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.setUnderlinedHoveredHyperlink(true);
    }

    public void setText(@Nullable String text2) {
        if (text2 == null || StringsKt.isBlank((CharSequence)text2)) {
            super.setText("<p></p>");
        } else {
            String htmlText = (String)ActionsKt.runReadAction(() -> InsightTextPane.setText$lambda$0(this, text2));
            super.setText(htmlText);
        }
        Caret caret = this.getCaret();
        if (caret instanceof DefaultCaret) {
            ((DefaultCaret)caret).setUpdatePolicy(1);
        }
        this.setCaretPosition(0);
    }

    public void updateUI() {
        block0: {
            super.updateUI();
            EditorKit editorKit = this.getEditorKit();
            HTMLEditorKit hTMLEditorKit = editorKit instanceof HTMLEditorKit ? (HTMLEditorKit)editorKit : null;
            if (hTMLEditorKit == null) break block0;
            EditorKit $this$updateUI_u24lambda_u240 = editorKit = hTMLEditorKit;
            boolean bl = false;
            StyleSheet styleSheet = ((HTMLEditorKit)$this$updateUI_u24lambda_u240).getStyleSheet();
            Intrinsics.checkNotNullExpressionValue((Object)styleSheet, (String)"getStyleSheet(...)");
            this.addCodeBackgroundRule(styleSheet);
        }
    }

    public void performCopy(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        String string = this.getSelectedText();
        if (string == null) {
            string = StringsKt.trimIndent((String)this.getRenderedText());
        }
        CopyPasteManager.copyTextToClipboard((String)string);
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return !StringsKt.isBlank((CharSequence)this.getRenderedText());
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return true;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private final String getRenderedText() {
        String string = this.getDocument().getText(0, this.getDocument().getLength());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return StringsKt.replace$default((String)string, (String)"\u200b", (String)"", (boolean)false, (int)4, null);
    }

    private final void addCodeBackgroundRule(StyleSheet $this$addCodeBackgroundRule) {
        String string = ColorUtil.toHex((Color)EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHex(...)");
        String color = string;
        $this$addCodeBackgroundRule.addRule("code { background-color: " + color + " }");
        $this$addCodeBackgroundRule.addRule(".code-block { background-color: " + color + " }");
    }

    private static final void _init_$lambda$1(HyperlinkEvent it) {
        if (Intrinsics.areEqual((Object)it.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
            BrowserUtil.browse((URL)it.getURL());
        }
    }

    private static final String setText$lambda$0(InsightTextPane this$0, String $text) {
        return DocMarkdownToHtmlConverter.convert$default((Project)this$0.project, (String)$text, null, (int)4, null);
    }
}

