/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.insights.ui.actions;

import com.android.tools.idea.gemini.GeminiPluginApi;
import com.android.tools.idea.insights.model.event.Device;
import com.android.tools.idea.insights.model.event.Event;
import com.android.tools.idea.insights.model.stacktrace.ExceptionStack;
import com.android.tools.idea.insights.model.stacktrace.Frame;
import com.android.tools.idea.insights.ui.AppInsightsContentPanelKt;
import com.android.tools.idea.insights.ui.actions.InsightActionKt;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.JButtonAction;
import icons.StudioIcons;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\b\u001a\u00020\t*\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\f\u0010\u001e\u001a\u00020\u0010*\u00020\u0018H\u0002R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\u0019\u001a\u00020\u0010*\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0018\u0010\u001c\u001a\u00020\u0010*\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001b\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/idea/insights/ui/actions/InsightAction;", "Lcom/intellij/util/ui/JButtonAction;", "<init>", "()V", "geminiPluginId", "Lcom/intellij/openapi/extensions/PluginId;", "getGeminiPluginId", "()Lcom/intellij/openapi/extensions/PluginId;", "setTooltipAndText", "", "Ljavax/swing/JButton;", "createCustomComponent", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "", "updateCustomComponent", "component", "actionPerformed", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "createPrompt", "event", "Lcom/android/tools/idea/insights/model/event/Event;", "deviceName", "getDeviceName", "(Lcom/android/tools/idea/insights/model/event/Event;)Ljava/lang/String;", "apiLevel", "getApiLevel", "stackTrace", "intellij.android.app-quality-insights.ui"})
@SourceDebugExtension(value={"SMAP\nInsightAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsightAction.kt\ncom/android/tools/idea/insights/ui/actions/InsightAction\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,127:1\n1310#2,2:128\n1#3:130\n1878#4,3:131\n*S KotlinDebug\n*F\n+ 1 InsightAction.kt\ncom/android/tools/idea/insights/ui/actions/InsightAction\n*L\n59#1:128,2\n116#1:131,3\n*E\n"})
public final class InsightAction
extends JButtonAction {
    @NotNull
    public static final InsightAction INSTANCE = new InsightAction();

    private InsightAction() {
        super("Enable insights", "Complete Gemini onboarding to enable insights", StudioIcons.StudioBot.GEMINI_LOGO);
    }

    private final PluginId getGeminiPluginId() {
        IdeaPluginDescriptor ideaPluginDescriptor;
        block1: {
            IdeaPluginDescriptor[] $this$firstOrNull$iv = PluginManagerCore.getPlugins();
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int i = 0; i < n; ++i) {
                IdeaPluginDescriptor element$iv;
                IdeaPluginDescriptor it = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"Gemini")) continue;
                ideaPluginDescriptor = element$iv;
                break block1;
            }
            ideaPluginDescriptor = null;
        }
        return ideaPluginDescriptor != null ? ideaPluginDescriptor.getPluginId() : null;
    }

    private final void setTooltipAndText(JButton $this$setTooltipAndText) {
        if (GeminiPluginApi.Companion.getInstance().isAvailable()) {
            $this$setTooltipAndText.setText("Show insights");
            $this$setTooltipAndText.setToolTipText("Show insights for this issue");
        } else {
            $this$setTooltipAndText.setText("Enable insights");
            $this$setTooltipAndText.setToolTipText("Complete Gemini onboarding to enable insights");
        }
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        JComponent jComponent;
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        JComponent $this$createCustomComponent_u24lambda_u240 = jComponent = super.createCustomComponent(presentation, place);
        boolean bl = false;
        $this$createCustomComponent_u24lambda_u240.putClientProperty("ActionToolbar.smallVariant", false);
        $this$createCustomComponent_u24lambda_u240.setFont(UIManager.getFont("Button.font"));
        return jComponent;
    }

    public void updateCustomComponent(@NotNull JComponent component, @NotNull Presentation presentation) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        super.updateCustomComponent(component, presentation);
        if (component instanceof JButton) {
            this.setTooltipAndText((JButton)component);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        GeminiPluginApi.RequestSource requestSource = (GeminiPluginApi.RequestSource)((Object)e.getData(AppInsightsContentPanelKt.getREQUEST_SOURCE_KEY()));
        if (requestSource == null) {
            return;
        }
        GeminiPluginApi.RequestSource source2 = requestSource;
        Event event = (Event)e.getData(AppInsightsContentPanelKt.getSELECTED_EVENT_KEY());
        if (event == null) {
            return;
        }
        Event selectedEvent = event;
        PluginId pluginId = this.getGeminiPluginId();
        if (pluginId == null) {
            return;
        }
        PluginId pluginId2 = pluginId;
        if (PluginManagerCore.isDisabled((PluginId)pluginId2)) {
            PluginManagerConfigurable.showPluginConfigurable((Project)project2, (Collection)CollectionsKt.listOf((Object)pluginId2));
        } else {
            GeminiPluginApi.Companion.getInstance().stageChatQuery(project2, this.createPrompt(selectedEvent), source2);
        }
    }

    private final String createPrompt(Event event) {
        String string = InsightActionKt.access$getCRASHLYTICS_GEMINI_PROMPT_FORMAT$p();
        Object[] objectArray = new Object[]{this.getDeviceName(event), this.getApiLevel(event), this.stackTrace(event)};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return ((Object)StringsKt.trim((CharSequence)string2)).toString();
    }

    private final String getDeviceName(Event $this$deviceName) {
        Device it = $this$deviceName.getEventData().getDevice();
        boolean bl = false;
        return it.getManufacturer() + " " + it.getModel();
    }

    private final String getApiLevel(Event $this$apiLevel) {
        return $this$apiLevel.getEventData().getOperatingSystemInfo().getDisplayVersion();
    }

    /*
     * WARNING - void declaration
     */
    private final String stackTrace(Event $this$stackTrace) {
        StringBuilder stringBuilder;
        StringBuilder $this$stackTrace_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Iterable $this$forEachIndexed$iv = $this$stackTrace.getStacktraceGroup().getExceptions();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void exception;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ExceptionStack exceptionStack = (ExceptionStack)item$iv;
            int idx = n;
            boolean bl2 = false;
            if (idx != 0 && !StringsKt.startsWith$default((String)exception.getRawExceptionMessage(), (String)"Caused by", (boolean)false, (int)2, null)) continue;
            $this$stackTrace_u24lambda_u240.append(exception.getRawExceptionMessage()).append('\n');
            $this$stackTrace_u24lambda_u240.append(CollectionsKt.joinToString$default((Iterable)exception.getStacktrace().getFrames(), (CharSequence)"", null, null, (int)0, null, InsightAction::stackTrace$lambda$0$0$0, (int)30, null));
        }
        return ((Object)StringsKt.trim((CharSequence)stringBuilder.toString())).toString();
    }

    private static final CharSequence stackTrace$lambda$0$0$0(Frame it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "\t" + it.getRawSymbol() + "\n";
    }
}

