/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.insights;

import com.android.tools.idea.insights.IssueInFrame;
import com.android.tools.idea.insights.LoadingState;
import com.android.tools.idea.insights.Selection;
import com.android.tools.idea.insights.analysis.Cause;
import com.android.tools.idea.insights.analysis.CrashFrame;
import com.android.tools.idea.insights.model.issue.AppInsightsIssue;
import com.android.tools.idea.insights.model.stacktrace.ExceptionStack;
import com.android.tools.idea.insights.model.stacktrace.Frame;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\f\u001a\u00020\bJ(\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\n0\t2\u0012\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000fH\u0002J\"\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000f2\u0006\u0010\f\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0006\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/insights/IssuesPerFileIndex;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "issueFileMapPerProviderKey", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/google/common/collect/SetMultimap;", "Lcom/android/tools/idea/insights/IssueInFrame;", "getIssuesPerFilename", "providerName", "computeIssuesPerFilename", "issues", "Lcom/android/tools/idea/insights/LoadingState;", "Lcom/android/tools/idea/insights/Selection;", "Lcom/android/tools/idea/insights/model/issue/AppInsightsIssue;", "updateIssueIndex", "", "intellij.android.app-quality-insights.api"})
public final class IssuesPerFileIndex {
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentHashMap<String, SetMultimap<String, IssueInFrame>> issueFileMapPerProviderKey;

    public IssuesPerFileIndex(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.issueFileMapPerProviderKey = new ConcurrentHashMap();
    }

    @NotNull
    public final SetMultimap<String, IssueInFrame> getIssuesPerFilename(@NotNull String providerName) {
        Intrinsics.checkNotNullParameter((Object)providerName, (String)"providerName");
        SetMultimap<String, IssueInFrame> setMultimap = this.issueFileMapPerProviderKey.getOrDefault(providerName, (SetMultimap<String, IssueInFrame>)ImmutableSetMultimap.of());
        Intrinsics.checkNotNullExpressionValue(setMultimap, (String)"getOrDefault(...)");
        return setMultimap;
    }

    /*
     * WARNING - void declaration
     */
    private final SetMultimap<String, IssueInFrame> computeIssuesPerFilename(LoadingState<Selection<AppInsightsIssue>> issues2) {
        SetMultimap setMultimap;
        if (issues2 instanceof LoadingState.Ready) {
            void var3_2;
            HashMultimap fileCache = HashMultimap.create();
            for (AppInsightsIssue issue2 : ((Selection)((LoadingState.Ready)issues2).getValue()).getItems()) {
                for (ExceptionStack exception : issue2.getSampleEvent().getStacktraceGroup().getExceptions()) {
                    Frame previousFrame = null;
                    for (Frame frame : exception.getStacktrace().getFrames()) {
                        if (((CharSequence)frame.getFile()).length() > 0) {
                            fileCache.put((Object)frame.getFile(), (Object)new IssueInFrame(new CrashFrame(frame, previousFrame == null ? (Cause)new Cause.Throwable(exception.getType()) : (Cause)new Cause.Frame(previousFrame)), issue2));
                        }
                        previousFrame = frame;
                    }
                }
            }
            void var2_10 = var3_2;
            Intrinsics.checkNotNull((Object)var2_10);
            setMultimap = (SetMultimap)var2_10;
        } else {
            ImmutableSetMultimap immutableSetMultimap = ImmutableSetMultimap.of();
            Intrinsics.checkNotNullExpressionValue((Object)immutableSetMultimap, (String)"of(...)");
            setMultimap = (SetMultimap)immutableSetMultimap;
        }
        return setMultimap;
    }

    public final void updateIssueIndex(@NotNull LoadingState<Selection<AppInsightsIssue>> issues2, @NotNull String providerName) {
        Intrinsics.checkNotNullParameter(issues2, (String)"issues");
        Intrinsics.checkNotNullParameter((Object)providerName, (String)"providerName");
        SetMultimap<String, IssueInFrame> newIndex = this.computeIssuesPerFilename(issues2);
        SetMultimap<String, IssueInFrame> oldIndex = this.issueFileMapPerProviderKey.put(providerName, newIndex);
        if (!Intrinsics.areEqual(oldIndex, newIndex)) {
            DaemonCodeAnalyzer.getInstance((Project)this.project).restart();
        }
    }
}

