/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.SdkConstants;
import com.android.ide.common.repository.AgpVersion;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.Projects;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.feature.flags.DeclarativeStudioSupport;
import com.android.tools.idea.gradle.model.IdeAndroidProject;
import com.android.tools.idea.gradle.model.IdeAndroidProjectType;
import com.android.tools.idea.gradle.model.IdeBaseArtifactCore;
import com.android.tools.idea.gradle.project.ProjectStructure;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacetConfiguration;
import com.android.tools.idea.gradle.project.model.GradleAndroidModel;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.project.model.GradleModuleModelKt;
import com.android.tools.idea.gradle.util.GradleLocalCache;
import com.android.tools.idea.gradle.util.GradleProjectSettingsFinder;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.ui.GuiTestingService;
import com.android.tools.idea.util.EmbeddedDistributionPaths;
import com.android.tools.idea.util.StudioPathManager;
import com.android.utils.BuildScriptUtil;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.tooling.internal.consumer.DefaultGradleConnector;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleProjectSystemUtil {
    public static final ProjectSystemId GRADLE_SYSTEM_ID = GradleConstants.SYSTEM_ID;
    @NonNls
    public static final String BUILD_DIR_DEFAULT_NAME = "build";
    @NonNls
    public static final String GRADLEW_PROPERTIES_PATH = FileUtil.join((String[])new String[]{SdkConstants.FD_GRADLE_WRAPPER, "gradle-wrapper.properties"});
    private static final Logger LOG = Logger.getInstance(GradleProjectSystemUtil.class);
    private static final CharMatcher ILLEGAL_GRADLE_PATH_CHARS_MATCHER = CharMatcher.anyOf((CharSequence)"\\/");

    public static boolean isAaptGeneratedSourcesFolder(@NotNull File folder, @NotNull File buildFolder) {
        File generatedFolder = new File(buildFolder, "generated");
        File generatedSourceR = FileUtils.join((File)generatedFolder, (String[])new String[]{"source", "r"});
        File rClassSources = new File(generatedFolder, "not_namespaced_r_class_sources");
        return FileUtil.isAncestor((File)generatedSourceR, (File)folder, (boolean)false) || FileUtil.isAncestor((File)rClassSources, (File)folder, (boolean)false);
    }

    public static boolean isDataBindingGeneratedBaseClassesFolder(@NotNull File folder, @NotNull File buildFolder) {
        File generatedFolder = new File(buildFolder, "generated");
        File dataBindingSources = new File(generatedFolder, "data_binding_base_class_source_out");
        return FileUtil.isAncestor((File)dataBindingSources, (File)folder, (boolean)false);
    }

    public static boolean isSafeArgGeneratedSourcesFolder(@NotNull File folder, @NotNull File buildFolder) {
        File generatedFolder = new File(buildFolder, "generated");
        File safeArgClassSources = FileUtils.join((File)generatedFolder, (String[])new String[]{"source", "navigation-args"});
        return FileUtil.isAncestor((File)safeArgClassSources, (File)folder, (boolean)false);
    }

    public static Collection<File> getGeneratedSourceFoldersToUse(@NotNull IdeBaseArtifactCore artifact, @NotNull IdeAndroidProject androidProject) {
        File buildFolder = androidProject.getBuildFolder();
        return artifact.getGeneratedSourceFolders().stream().filter(folder -> !GradleProjectSystemUtil.isAaptGeneratedSourcesFolder(folder, buildFolder)).filter(folder -> !GradleProjectSystemUtil.isDataBindingGeneratedBaseClassesFolder(folder, buildFolder)).filter(folder -> !GradleProjectSystemUtil.isSafeArgGeneratedSourcesFolder(folder, buildFolder)).collect(Collectors.toList());
    }

    @NotNull
    public static String createFullTaskName(@NotNull String gradleProjectPath, @NotNull String taskName) {
        if (gradleProjectPath.endsWith(":")) {
            return gradleProjectPath + taskName;
        }
        return gradleProjectPath + ":" + taskName;
    }

    @Nullable
    public static AgpVersion getAndroidGradleModelVersionInUse(@NotNull Project project) {
        HashSet foundInLibraries = Sets.newHashSet();
        HashSet foundInApps = Sets.newHashSet();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            GradleAndroidModel androidModel = GradleAndroidModel.get(module);
            if (androidModel == null) continue;
            IdeAndroidProject androidProject = androidModel.getAndroidProject();
            String modelVersion = androidProject.getAgpVersion();
            if (androidModel.getAndroidProject().getProjectType() == IdeAndroidProjectType.PROJECT_TYPE_APP) {
                foundInApps.add(modelVersion);
                continue;
            }
            foundInLibraries.add(modelVersion);
        }
        String found = null;
        if (foundInApps.size() == 1) {
            found = (String)Iterables.getOnlyElement((Iterable)foundInApps);
        } else if (foundInApps.isEmpty() && foundInLibraries.size() == 1) {
            found = (String)Iterables.getOnlyElement((Iterable)foundInLibraries);
        }
        return found != null ? AgpVersion.tryParse((String)found) : null;
    }

    @Nullable
    public static AgpVersion getAndroidGradleModelVersionInUse(@NotNull Module module) {
        GradleAndroidModel androidModel = GradleAndroidModel.get(module);
        if (androidModel != null) {
            IdeAndroidProject androidProject = androidModel.getAndroidProject();
            return AgpVersion.tryParse((String)androidProject.getAgpVersion());
        }
        return null;
    }

    @NotNull
    public static List<Module> getModulesToBuild(@NotNull Module module) {
        return Stream.concat(Stream.of(module), ProjectSystemUtil.getModuleSystem(module).getDynamicFeatureModules().stream()).collect(Collectors.toList());
    }

    @NotNull
    private static Logger getLogger() {
        return Logger.getInstance(GradleProjectSystemUtil.class);
    }

    @Nullable
    public static GradleAndroidModel findAndroidModelInModule(@NotNull Project project, @NotNull VirtualFile file, boolean honorExclusion) {
        Module module = ProjectFileIndex.getInstance((Project)project).getModuleForFile(file, honorExclusion);
        if (module == null) {
            return null;
        }
        if (module.isDisposed()) {
            GradleProjectSystemUtil.getLogger().warn("Attempted to get an Android Facet from a disposed module");
            return null;
        }
        return GradleAndroidModel.get(module);
    }

    @Nullable
    public static GradleAndroidModel findAndroidModelInModule(@NotNull Project project, @NotNull VirtualFile file) {
        return GradleProjectSystemUtil.findAndroidModelInModule(project, file, true);
    }

    @NotNull
    public static List<Module> getAppHolderModulesSupportingBundleTask(@NotNull Project project) {
        return ProjectStructure.getInstance(project).getAppHolderModules().stream().filter(GradleProjectSystemUtil::supportsBundleTask).collect(Collectors.toList());
    }

    public static boolean supportsBundleTask(@NotNull Module module) {
        GradleAndroidModel androidModule = GradleAndroidModel.get(module);
        if (androidModule == null) {
            return false;
        }
        return !StringUtil.isEmpty((String)androidModule.getSelectedVariant().getMainArtifact().getBuildInformation().getBundleTaskName());
    }

    public static void attemptToUseEmbeddedGradle(@NotNull Project project) {
        GradleWrapper gradleWrapper;
        if (!((Boolean)StudioFlags.USE_DEVELOPMENT_OFFLINE_REPOS.get()).booleanValue() && !StudioPathManager.isRunningFromSources()) {
            return;
        }
        if (IdeInfo.getInstance().isAndroidStudio() && (gradleWrapper = GradleWrapper.find(project)) != null) {
            GradleProjectSettings gradleSettings;
            File embeddedGradlePath;
            String gradleVersion2 = null;
            try {
                String url = gradleWrapper.getDistributionUrl();
                if (url != null) {
                    gradleVersion2 = GradleProjectSystemUtil.getGradleWrapperVersionOnlyIfComingForGradleDotOrg(url);
                }
            }
            catch (Exception e) {
                LOG.warn("Failed to read file " + gradleWrapper.getPropertiesFilePath().getPath());
            }
            if (gradleVersion2 != null && GradleProjectSystemUtil.isCompatibleWithEmbeddedGradleVersion(gradleVersion2) && !GradleLocalCache.getInstance().containsGradleWrapperVersion(gradleVersion2, project) && (embeddedGradlePath = GradleProjectSystemUtil.findEmbeddedGradleDistributionPath()) != null && (gradleSettings = GradleProjectSystemUtil.getGradleProjectSettings(project)) != null) {
                gradleSettings.setDistributionType(DistributionType.LOCAL);
                gradleSettings.setGradleHome(embeddedGradlePath.getPath());
            }
        }
    }

    @VisibleForTesting
    @Nullable
    static String getGradleWrapperVersionOnlyIfComingForGradleDotOrg(@Nullable String url) {
        if (url == null) {
            return null;
        }
        int foundIndex = url.indexOf("://");
        if (foundIndex == -1) {
            return null;
        }
        String protocol = url.substring(0, foundIndex);
        if (!protocol.equals("http") && !protocol.equals("https")) {
            return null;
        }
        String expectedPrefix = protocol + "://services.gradle.org/distributions/gradle-";
        if (!url.startsWith(expectedPrefix)) {
            return null;
        }
        foundIndex = url.indexOf(45, expectedPrefix.length());
        if (foundIndex == -1) {
            return null;
        }
        String version2 = url.substring(expectedPrefix.length(), foundIndex);
        return StringUtil.isNotEmpty((String)version2) ? version2 : null;
    }

    private static boolean isCompatibleWithEmbeddedGradleVersion(@NotNull String gradleVersion2) {
        return gradleVersion2.equals("9.1.0");
    }

    @Nullable
    public static File getGradleBuildFilePath(@NotNull Module module) {
        GradleModuleModel moduleModel = GradleProjectSystemUtil.getGradleModuleModel(module);
        if (moduleModel != null) {
            return moduleModel.getBuildFilePath();
        }
        File moduleRoot = AndroidRootUtil.findModuleRootFolderPath(module);
        return moduleRoot != null ? GradleProjectSystemUtil.getGradleBuildFilePath(moduleRoot) : null;
    }

    @Nullable
    public static File getGradleBuildFilePath(@NotNull File dirPath) {
        return BuildScriptUtil.findGradleBuildFile((File)dirPath);
    }

    public static Set<BuildFileType> projectBuildFilesTypes(@NotNull Project project) {
        EnumSet<BuildFileType> result2 = EnumSet.noneOf(BuildFileType.class);
        GradleProjectSystemUtil.addBuildFileType(result2, GradleProjectSystemUtil.getGradleBuildFilePath(Projects.getBaseDirPath((Project)project)));
        ReadAction.run(() -> {
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                GradleProjectSystemUtil.addBuildFileType(result2, GradleProjectSystemUtil.getGradleBuildFilePath(module));
            }
        });
        return result2;
    }

    private static void addBuildFileType(@NotNull Set<BuildFileType> result2, @Nullable File buildFile) {
        if (buildFile != null) {
            String buildFileName = buildFile.getName().toLowerCase(Locale.getDefault());
            if (buildFileName.endsWith(".gradle")) {
                result2.add(BuildFileType.GROOVY);
            } else if (buildFileName.endsWith(".kts")) {
                result2.add(BuildFileType.KOTLIN_SCRIPT);
            } else if (DeclarativeStudioSupport.isEnabled() && buildFileName.endsWith(".dcl")) {
                result2.add(BuildFileType.DECLARATIVE);
            }
        }
    }

    public static int isValidGradlePath(@NotNull String gradlePath) {
        return ILLEGAL_GRADLE_PATH_CHARS_MATCHER.indexIn((CharSequence)gradlePath);
    }

    @NotNull
    public static List<String> getPathSegments(@NotNull String gradlePath) {
        return Splitter.on((String)":").omitEmptyStrings().splitToList((CharSequence)gradlePath);
    }

    @NotNull
    public static String getDefaultPhysicalPathFromGradlePath(@NotNull String gradlePath) {
        List<String> segments = GradleProjectSystemUtil.getPathSegments(gradlePath);
        return FileUtil.join((String[])ArrayUtil.toStringArray(segments));
    }

    public static boolean isDirectChild(String childPath, String parentPath) {
        List<String> childSegments = GradleProjectSystemUtil.getPathSegments(childPath);
        return !childSegments.isEmpty() && childSegments.subList(0, childSegments.size() - 1).equals(GradleProjectSystemUtil.getPathSegments(parentPath));
    }

    @NotNull
    public static File getModuleDefaultPath(@NotNull VirtualFile parentDir, @NotNull String gradlePath) {
        assert (!gradlePath.isEmpty());
        String relativePath = GradleProjectSystemUtil.getDefaultPhysicalPathFromGradlePath(gradlePath);
        return new File(VfsUtilCore.virtualToIoFile((VirtualFile)parentDir), relativePath);
    }

    @NotNull
    public static Set<String> getAllParentModulesPaths(@NotNull String gradlePath) {
        ImmutableSet.Builder result2 = ImmutableSet.builder();
        String parentPath = GradleProjectSystemUtil.getParentModulePath(gradlePath);
        while (!parentPath.isEmpty()) {
            result2.add((Object)parentPath);
            parentPath = GradleProjectSystemUtil.getParentModulePath(parentPath);
        }
        return result2.build();
    }

    @NotNull
    public static String getParentModulePath(@NotNull String gradlePath) {
        int parentPathEnd = gradlePath.lastIndexOf(":");
        if (parentPathEnd <= 0) {
            return "";
        }
        return gradlePath.substring(0, parentPathEnd);
    }

    public static void stopAllGradleDaemonsAndRestart() {
        DefaultGradleConnector.close();
        Application application = ApplicationManager.getApplication();
        if (application instanceof ApplicationImpl) {
            ((ApplicationImpl)application).restart(true);
        } else {
            application.restart();
        }
    }

    public static boolean hasCause(@NotNull Throwable e, @NotNull Class<?> causeClass) {
        String causeClassName = causeClass.getName();
        for (Throwable ex = e; ex != null; ex = ex.getCause()) {
            if (!causeClassName.equals(ex.getClass().getName())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static File getUserGradlePropertiesFile(@NotNull Project project) {
        String gradleHomePath;
        GradleExecutionSettings settings = GradleProjectSystemUtil.getGradleExecutionSettings(project);
        if (settings != null && !Strings.isNullOrEmpty((String)(gradleHomePath = settings.getServiceDirectory()))) {
            return new File(gradleHomePath, "gradle.properties");
        }
        return GradleProjectSystemUtil.getUserGradlePropertiesFile();
    }

    @NotNull
    private static File getUserGradlePropertiesFile() {
        String gradleUserHome = System.getProperty("gradle.user.home");
        if (Strings.isNullOrEmpty((String)gradleUserHome)) {
            gradleUserHome = System.getenv("GRADLE_USER_HOME");
        }
        if (Strings.isNullOrEmpty((String)gradleUserHome)) {
            gradleUserHome = FileUtil.join((String[])new String[]{System.getProperty("user.home"), ".gradle"});
        }
        return new File(gradleUserHome, "gradle.properties");
    }

    @NotNull
    public static GradleExecutionSettings getOrCreateGradleExecutionSettings(@NotNull Project project) {
        GradleExecutionSettings executionSettings = GradleProjectSystemUtil.getGradleExecutionSettings(project);
        if (IdeInfo.getInstance().isAndroidStudio() && executionSettings == null) {
            File gradlePath = GradleProjectSystemUtil.findEmbeddedGradleDistributionPath();
            assert (gradlePath != null && gradlePath.isDirectory());
            executionSettings = new GradleExecutionSettings();
            executionSettings.setGradleHome(gradlePath.getPath());
            executionSettings.setDistributionType(DistributionType.LOCAL);
        }
        if (executionSettings == null) {
            executionSettings = new GradleExecutionSettings();
        }
        return executionSettings;
    }

    @Nullable
    public static GradleExecutionSettings getGradleExecutionSettings(@NotNull Project project) {
        GradleProjectSettings projectSettings = GradleProjectSystemUtil.getGradleProjectSettings(project);
        if (projectSettings == null) {
            File baseDirPath = Projects.getBaseDirPath((Project)project);
            String msg = String.format("Unable to obtain Gradle project settings for project '%1$s', located at '%2$s'", project.getName(), baseDirPath.getPath());
            LOG.info(msg);
            return null;
        }
        try {
            return (GradleExecutionSettings)ExternalSystemApiUtil.getExecutionSettings((Project)project, (String)projectSettings.getExternalProjectPath(), (ProjectSystemId)GRADLE_SYSTEM_ID);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Failed to obtain Gradle execution settings", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static GradleProjectSettings getGradleProjectSettings(@NotNull Project project) {
        return GradleProjectSettingsFinder.getInstance().findGradleProjectSettings(project);
    }

    @Nullable
    public static String getLastKnownAndroidGradlePluginVersion(@NotNull Project project) {
        for (Module module : ProjectFacetManager.getInstance((Project)project).getModulesWithFacet(GradleFacet.getFacetTypeId())) {
            GradleFacet gradleFacet = GradleFacet.getInstance(module);
            if (gradleFacet == null) continue;
            GradleFacetConfiguration configuration2 = (GradleFacetConfiguration)gradleFacet.getConfiguration();
            String version2 = configuration2.LAST_KNOWN_AGP_VERSION;
            if (version2 == null) continue;
            return version2;
        }
        return null;
    }

    @Nullable
    public static String getLastSuccessfulAndroidGradlePluginVersion(@NotNull Project project) {
        for (Module module : ProjectFacetManager.getInstance((Project)project).getModulesWithFacet(GradleFacet.getFacetTypeId())) {
            GradleFacet gradleFacet = GradleFacet.getInstance(module);
            if (gradleFacet == null) continue;
            GradleFacetConfiguration configuration2 = (GradleFacetConfiguration)gradleFacet.getConfiguration();
            String version2 = configuration2.LAST_SUCCESSFUL_SYNC_AGP_VERSION;
            if (version2 == null) continue;
            return version2;
        }
        return null;
    }

    @Nullable
    public static VirtualFile getGradleBuildFile(@NotNull Module module) {
        GradleModuleModel moduleModel = GradleProjectSystemUtil.getGradleModuleModel(module);
        if (moduleModel != null) {
            return moduleModel.buildFileAsVirtualFile();
        }
        File moduleRoot = AndroidRootUtil.findModuleRootFolderPath(module);
        return moduleRoot != null ? GradleProjectSystemUtil.getGradleBuildFile(moduleRoot) : null;
    }

    @Nullable
    public static VirtualFile findGradleBuildFile(@NotNull VirtualFile parentDir) {
        if (DeclarativeStudioSupport.isEnabled()) {
            return GradleProjectSystemUtil.findFileWithNames(parentDir, "build.gradle", "build.gradle.kts", "build.gradle.dcl");
        }
        return GradleProjectSystemUtil.findFileWithNames(parentDir, "build.gradle", "build.gradle.kts");
    }

    @Nullable
    public static VirtualFile findGradleSettingsFile(@NotNull VirtualFile parentDir) {
        if (DeclarativeStudioSupport.isEnabled()) {
            return GradleProjectSystemUtil.findFileWithNames(parentDir, "settings.gradle", "settings.gradle.kts", "settings.gradle.dcl");
        }
        return GradleProjectSystemUtil.findFileWithNames(parentDir, "settings.gradle", "settings.gradle.kts");
    }

    @Nullable
    private static VirtualFile findFileWithNames(@NotNull VirtualFile parentDir, String ... names) {
        for (String name2 : names) {
            VirtualFile file = parentDir.findChild(name2);
            if (file == null || file.isDirectory()) continue;
            return file;
        }
        return null;
    }

    @Nullable
    public static GradleModuleModel getGradleModuleModel(Module module) {
        return GradleModuleModelKt.getGradleModuleModel(module);
    }

    @Nullable
    public static VirtualFile getGradleBuildFile(@NotNull File dirPath) {
        File gradleBuildFilePath = BuildScriptUtil.findGradleBuildFile((File)dirPath);
        VirtualFile result2 = VfsUtil.findFileByIoFile((File)gradleBuildFilePath, (boolean)false);
        return result2 != null && result2.isValid() ? result2 : null;
    }

    @Nullable
    public static File findEmbeddedGradleDistributionPath() {
        Path distribution;
        if (StudioPathManager.isRunningFromSources() && Files.isDirectory(distribution = StudioPathManager.resolvePathFromSourcesRoot((String)"tools/external/gradle"), new LinkOption[0])) {
            return distribution.toFile();
        }
        return null;
    }

    @Nullable
    public static File findEmbeddedGradleDistributionFile(@NotNull String gradleVersion2) {
        File distributionPath = GradleProjectSystemUtil.findEmbeddedGradleDistributionPath();
        if (distributionPath != null) {
            File allDistributionFile = new File(distributionPath, "gradle-" + gradleVersion2 + "-all.zip");
            if (allDistributionFile.isFile() && allDistributionFile.exists()) {
                return allDistributionFile;
            }
            File binDistributionFile = new File(distributionPath, "gradle-" + gradleVersion2 + "-bin.zip");
            if (binDistributionFile.isFile() && binDistributionFile.exists()) {
                return binDistributionFile;
            }
        }
        return null;
    }

    @NotNull
    public static List<File> findAndroidStudioLocalMavenRepoPaths() {
        if (!((Boolean)StudioFlags.USE_DEVELOPMENT_OFFLINE_REPOS.get()).booleanValue() && !StudioPathManager.isRunningFromSources() && !GuiTestingService.isInTestingMode() && ((String)StudioFlags.DEVELOPMENT_OFFLINE_REPO_LOCATION.get()).isBlank()) {
            return ImmutableList.of();
        }
        return GradleProjectSystemUtil.doFindAndroidStudioLocalMavenRepoPaths();
    }

    @VisibleForTesting
    @NotNull
    public static List<File> doFindAndroidStudioLocalMavenRepoPaths() {
        ArrayList<File> repoPaths = new ArrayList<File>();
        List studioFlagOfflineRepos = Splitter.on((char)File.pathSeparatorChar).omitEmptyStrings().splitToList((CharSequence)StudioFlags.DEVELOPMENT_OFFLINE_REPO_LOCATION.get());
        for (String offlineRepo : studioFlagOfflineRepos) {
            GradleProjectSystemUtil.validateAndAdd(offlineRepo, repoPaths);
        }
        if (!(((Boolean)StudioFlags.USE_DEVELOPMENT_OFFLINE_REPOS.get()).booleanValue() || StudioPathManager.isRunningFromSources() || GuiTestingService.isInTestingMode())) {
            return repoPaths;
        }
        String studioCustomRepo = System.getenv("STUDIO_CUSTOM_REPO");
        if (studioCustomRepo != null) {
            GradleProjectSystemUtil.validateAndAdd(studioCustomRepo, repoPaths);
        }
        if (StudioPathManager.isRunningFromSources()) {
            if (studioCustomRepo == null) {
                GradleProjectSystemUtil.addIfExists("out/repo", repoPaths);
            }
            GradleProjectSystemUtil.addIfExists("out/studio/repo", repoPaths);
            GradleProjectSystemUtil.addIfExists(System.getProperty("java.io.tmpdir") + "/offline-maven-repo", repoPaths);
            GradleProjectSystemUtil.addIfExists("../maven/repository", repoPaths);
            if (!repoPaths.isEmpty()) {
                GradleProjectSystemUtil.addIfExists("prebuilts/tools/common/m2/repository", repoPaths);
            }
        }
        if (!repoPaths.isEmpty()) {
            Logger.getInstance(EmbeddedDistributionPaths.class).info("Found custom repo paths " + Joiner.on((char)File.pathSeparatorChar).join(repoPaths));
        }
        return ImmutableList.copyOf(repoPaths);
    }

    private static void validateAndAdd(String studioCustomRepo, List<File> repoPaths) {
        try {
            Path customRepoPath = Paths.get(studioCustomRepo, new String[0]).toRealPath(new LinkOption[0]);
            if (!Files.isDirectory(customRepoPath, new LinkOption[0])) {
                Logger.getInstance(EmbeddedDistributionPaths.class).error("Invalid maven repo path: " + studioCustomRepo + " is not a directory.");
                return;
            }
            repoPaths.add(customRepoPath.toFile());
        }
        catch (IOException e) {
            Logger.getInstance(EmbeddedDistributionPaths.class).error("Invalid maven repo path: " + studioCustomRepo, (Throwable)e);
        }
    }

    private static void addIfExists(String path, List<File> repoPaths) {
        Path directory = StudioPathManager.resolvePathFromSourcesRoot((String)path);
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            return;
        }
        repoPaths.add(directory.toFile());
    }

    public static enum BuildFileType {
        GROOVY,
        KOTLIN_SCRIPT,
        DECLARATIVE;

    }
}

