/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.daemon.analysis;

import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsDeclaredDependency;
import com.android.tools.idea.gradle.structure.model.PsDeclaredLibraryDependency;
import com.android.tools.idea.gradle.structure.model.PsGeneralIssue;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsIssueType;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.PsModuleType;
import com.android.tools.idea.gradle.structure.model.PsPath;
import com.android.tools.idea.gradle.structure.model.PsQuickFix;
import com.android.tools.idea.gradle.structure.navigation.PsLibraryDependencyNavigationPath;
import com.android.tools.idea.gradle.structure.quickfix.PsDependencyConfigurationQuickFixPath;
import com.android.tools.idea.gradle.structure.quickfix.PsLibraryDependencyPlusQuickFixPath;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"analyzeDeclaredDependency", "Lkotlin/sequences/Sequence;", "Lcom/android/tools/idea/gradle/structure/model/PsIssue;", "dependency", "Lcom/android/tools/idea/gradle/structure/model/PsDeclaredLibraryDependency;", "analyzeDependencyScope", "Lcom/android/tools/idea/gradle/structure/model/PsDeclaredDependency;", "intellij.android.projectSystem.gradle.psd"})
public final class PsModuleAnalyzerKt {
    @NotNull
    public static final Sequence<PsIssue> analyzeDeclaredDependency(@NotNull PsDeclaredLibraryDependency dependency) {
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        PsLibraryDependencyNavigationPath path = dependency.getPath();
        PsArtifactDependencySpec declaredSpec = dependency.getSpec();
        String declaredVersion = declaredSpec.getVersion();
        if (declaredVersion != null && StringsKt.endsWith$default((String)declaredVersion, (String)"+", (boolean)false, (int)2, null)) {
            String message = "Avoid using '+' in version numbers; can lead to unpredictable and unrepeatable builds.";
            PsPath psPath = path;
            PsIssueType psIssueType = PsIssueType.PROJECT_ANALYSIS;
            Intrinsics.checkNotNullExpressionValue((Object)psIssueType, (String)"PROJECT_ANALYSIS");
            PsGeneralIssue issue2 = new PsGeneralIssue(message, psPath, psIssueType, PsIssue.Severity.WARNING, new PsLibraryDependencyPlusQuickFixPath(dependency));
            Object[] objectArray = new PsGeneralIssue[]{issue2};
            return SequencesKt.sequenceOf((Object[])objectArray);
        }
        return SequencesKt.emptySequence();
    }

    @NotNull
    public static final Sequence<PsIssue> analyzeDependencyScope(@NotNull PsDeclaredDependency dependency) {
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        List issues2 = new ArrayList();
        String configurationName = dependency.getConfigurationName();
        if (Intrinsics.areEqual((Object)configurationName, (Object)"")) {
            PsPath path = dependency.getPath();
            if (path != null) {
                PsIssueType psIssueType = PsIssueType.PROJECT_ANALYSIS;
                Intrinsics.checkNotNullExpressionValue((Object)psIssueType, (String)"PROJECT_ANALYSIS");
                PsGeneralIssue issue2 = new PsGeneralIssue("Empty configuration", "", path, psIssueType, PsIssue.Severity.ERROR, null, null, 96, null);
                issues2.add(issue2);
            }
        } else if (Intrinsics.areEqual((Object)configurationName, (Object)"compile") || Intrinsics.areEqual((Object)configurationName, (Object)"runtime") || StringsKt.endsWith$default((String)configurationName, (String)"Compile", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)configurationName, (String)"Runtime", (boolean)false, (int)2, null)) {
            String text2 = "Obsolete dependency configuration found: <b>" + configurationName + "</b>";
            List<PsQuickFix> fixes = PsModuleAnalyzerKt.analyzeDependencyScope$fixesFor(dependency, configurationName);
            PsPath path = dependency.getPath();
            if (path != null) {
                PsIssueType psIssueType = PsIssueType.PROJECT_ANALYSIS;
                Intrinsics.checkNotNullExpressionValue((Object)psIssueType, (String)"PROJECT_ANALYSIS");
                PsGeneralIssue issue3 = new PsGeneralIssue(text2, "", path, psIssueType, PsIssue.Severity.WARNING, fixes, null, 64, null);
                issues2.add(issue3);
            }
        }
        return CollectionsKt.asSequence((Iterable)issues2);
    }

    private static final boolean analyzeDependencyScope$shouldSuggestApiScopeReplacement(PsDeclaredDependency $dependency) {
        if (StringsKt.startsWith$default((String)$dependency.getConfigurationName(), (String)"test", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)$dependency.getConfigurationName(), (String)"androidTest", (boolean)false, (int)2, null)) {
            return false;
        }
        PsModule module = $dependency.getParent();
        return switch (WhenMappings.$EnumSwitchMapping$0[module.getProjectType().ordinal()]) {
            case 1 -> true;
            case 2 -> false;
            case 3 -> true;
            case 4 -> true;
            case 5 -> false;
            case 6 -> true;
            case 7 -> true;
            case 8 -> false;
            case 9 -> true;
            case 10 -> false;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final List<PsQuickFix> analyzeDependencyScope$fixesFor(PsDeclaredDependency $dependency, String configurationName) {
        List fixes = new ArrayList();
        boolean suggestApi = PsModuleAnalyzerKt.analyzeDependencyScope$shouldSuggestApiScopeReplacement($dependency);
        if (Intrinsics.areEqual((Object)configurationName, (Object)"compile")) {
            if (suggestApi) {
                fixes.add(new PsDependencyConfigurationQuickFixPath($dependency, "api"));
            }
            fixes.add(new PsDependencyConfigurationQuickFixPath($dependency, "implementation"));
        } else if (StringsKt.endsWith$default((String)configurationName, (String)"Compile", (boolean)false, (int)2, null)) {
            String base = StringsKt.removeSuffix((String)configurationName, (CharSequence)"Compile");
            if (suggestApi) {
                fixes.add(new PsDependencyConfigurationQuickFixPath($dependency, base + "Api"));
            }
            fixes.add(new PsDependencyConfigurationQuickFixPath($dependency, base + "Implementation"));
        } else if (Intrinsics.areEqual((Object)configurationName, (Object)"runtime")) {
            fixes.add(new PsDependencyConfigurationQuickFixPath($dependency, "runtimeOnly"));
            fixes.add(new PsDependencyConfigurationQuickFixPath($dependency, "implementation"));
        } else if (StringsKt.endsWith$default((String)configurationName, (String)"Runtime", (boolean)false, (int)2, null)) {
            String base = StringsKt.removeSuffix((String)configurationName, (CharSequence)"Runtime");
            fixes.add(new PsDependencyConfigurationQuickFixPath($dependency, base + "RuntimeOnly"));
            fixes.add(new PsDependencyConfigurationQuickFixPath($dependency, base + "Implementation"));
        }
        return fixes;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PsModuleType.values().length];
            try {
                nArray[PsModuleType.UNKNOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PsModuleType.ANDROID_APP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PsModuleType.ANDROID_LIBRARY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PsModuleType.ANDROID_KMP_LIBRARY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PsModuleType.ANDROID_INSTANTAPP.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PsModuleType.ANDROID_FEATURE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PsModuleType.ANDROID_DYNAMIC_FEATURE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PsModuleType.ANDROID_TEST.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PsModuleType.JAVA.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PsModuleType.ANDROID_FUSED_LIBRARY.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

