/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.daemon;

import com.android.annotations.concurrency.AnyThread;
import com.android.annotations.concurrency.UiThread;
import com.android.ide.common.gradle.Version;
import com.android.tools.idea.gradle.structure.daemon.AvailableLibraryUpdateStorage;
import com.android.tools.idea.gradle.structure.daemon.PsAnalyzerDaemonKt;
import com.android.tools.idea.gradle.structure.daemon.PsDaemon;
import com.android.tools.idea.gradle.structure.daemon.PsLibraryUpdateCheckerDaemon;
import com.android.tools.idea.gradle.structure.daemon.PsSdkIndexCheckerDaemon;
import com.android.tools.idea.gradle.structure.daemon.analysis.PsModelAnalyzer;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsDeclaredLibraryDependency;
import com.android.tools.idea.gradle.structure.model.PsGeneralIssue;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsIssueCollection;
import com.android.tools.idea.gradle.structure.model.PsIssueType;
import com.android.tools.idea.gradle.structure.model.PsModel;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.PsPath;
import com.android.tools.idea.gradle.structure.model.PsProject;
import com.android.tools.idea.gradle.structure.model.meta.DslText;
import com.android.tools.idea.gradle.structure.model.meta.ModelPropertyCore;
import com.android.tools.idea.gradle.structure.model.meta.ParsedValue;
import com.android.tools.idea.gradle.structure.navigation.PsLibraryDependencyNavigationPath;
import com.android.tools.idea.gradle.structure.quickfix.PsLibraryDependencyVersionQuickFixPath;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0003@ABBG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u001e\u0010\n\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r0\u000b\u00a2\u0006\u0004\b\u000f\u0010\u0010J\b\u0010!\u001a\u00020\"H\u0007J\b\u0010#\u001a\u00020\"H\u0003J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'H\u0003J\u001e\u0010(\u001a\u00020\"2\u0006\u0010\u0002\u001a\u00020\u00032\u000e\b\u0001\u0010)\u001a\b\u0012\u0004\u0012\u00020\"0*J\u001e\u0010+\u001a\u00020\"2\u0006\u0010\u0002\u001a\u00020\u00032\u000e\b\u0001\u0010)\u001a\b\u0012\u0004\u0012\u00020\"0*J\u0010\u0010,\u001a\u00020\"2\u0006\u0010-\u001a\u00020\u000eH\u0007J\u0014\u0010.\u001a\b\u0012\u0004\u0012\u0002000/2\u0006\u0010-\u001a\u000201J\u0010\u00102\u001a\u00020\"2\u0006\u0010-\u001a\u000201H\u0002J$\u00103\u001a\u00020\"2\u0006\u00104\u001a\u0002052\n\b\u0002\u00106\u001a\u0004\u0018\u0001072\u0006\u00108\u001a\u000209H\u0002J\u001e\u0010:\u001a\u00020\"2\f\u0010;\u001a\b\u0012\u0004\u0012\u0002000<2\u0006\u00108\u001a\u000209H\u0007J\u0010\u0010=\u001a\u00020\"2\u0006\u00108\u001a\u000209H\u0003J\b\u0010>\u001a\u00020\"H\u0003J\b\u0010?\u001a\u00020\"H\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\n\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0012X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR!\u0010\u001b\u001a\u0015\u0012\f\u0012\n \u001e*\u0004\u0018\u00010\u001d0\u001d0\u001c\u00a2\u0006\u0002\b\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010 \u001a\u0015\u0012\f\u0012\n \u001e*\u0004\u0018\u00010\u001d0\u001d0\u001c\u00a2\u0006\u0002\b\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/android/tools/idea/gradle/structure/daemon/PsAnalyzerDaemon;", "Lcom/android/tools/idea/gradle/structure/daemon/PsDaemon;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/android/tools/idea/gradle/structure/model/PsProject;", "libraryUpdateCheckerDaemon", "Lcom/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon;", "sdkIndexCheckerDaemon", "Lcom/android/tools/idea/gradle/structure/daemon/PsSdkIndexCheckerDaemon;", "modelAnalyzers", "", "Ljava/lang/Class;", "Lcom/android/tools/idea/gradle/structure/daemon/analysis/PsModelAnalyzer;", "Lcom/android/tools/idea/gradle/structure/model/PsModule;", "<init>", "(Lcom/intellij/openapi/Disposable;Lcom/android/tools/idea/gradle/structure/model/PsProject;Lcom/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon;Lcom/android/tools/idea/gradle/structure/daemon/PsSdkIndexCheckerDaemon;Ljava/util/Map;)V", "mainQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "getMainQueue", "()Lcom/intellij/util/ui/update/MergingUpdateQueue;", "resultsUpdaterQueue", "getResultsUpdaterQueue", "issues", "Lcom/android/tools/idea/gradle/structure/model/PsIssueCollection;", "getIssues", "()Lcom/android/tools/idea/gradle/structure/model/PsIssueCollection;", "onRunningEventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/android/tools/idea/gradle/structure/daemon/PsAnalyzerDaemon$IssuesUpdatedListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "issuesUpdatedEventDispatcher", "recreateIssues", "", "recreateUpdatesAsIssues", "getAvailableUpdatesFor", "Lcom/android/tools/idea/gradle/structure/model/PsGeneralIssue;", "dependency", "Lcom/android/tools/idea/gradle/structure/model/PsDeclaredLibraryDependency;", "onIssuesChange", "listener", "Lkotlin/Function0;", "onRunningChange", "queueCheck", "model", "validate", "Lkotlin/sequences/Sequence;", "Lcom/android/tools/idea/gradle/structure/model/PsIssue;", "Lcom/android/tools/idea/gradle/structure/model/PsModel;", "doAnalyzeStructure", "removeIssues", "type", "Lcom/android/tools/idea/gradle/structure/model/PsIssueType;", "byPath", "Lcom/android/tools/idea/gradle/structure/model/PsPath;", "now", "", "addAll", "newIssues", "", "notifyUpdated", "notifyRunning", "recreateSdkIndexIssues", "AnalyzeModuleStructure", "IssuesComputed", "IssuesUpdatedListener", "intellij.android.projectSystem.gradle.psd"})
@SourceDebugExtension(value={"SMAP\nPsAnalyzerDaemon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PsAnalyzerDaemon.kt\ncom/android/tools/idea/gradle/structure/daemon/PsAnalyzerDaemon\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,497:1\n1374#2:498\n1460#2,2:499\n1617#2,9:501\n1869#2:510\n1870#2:512\n1626#2:513\n1462#2,3:514\n1869#2,2:517\n1374#2:519\n1460#2,2:520\n1563#2:522\n1634#2,3:523\n2756#2:526\n1462#2,3:528\n1#3:511\n1#3:527\n*S KotlinDebug\n*F\n+ 1 PsAnalyzerDaemon.kt\ncom/android/tools/idea/gradle/structure/daemon/PsAnalyzerDaemon\n*L\n94#1:498\n94#1:499,2\n94#1:501,9\n94#1:510\n94#1:512\n94#1:513\n94#1:514,3\n178#1:517,2\n228#1:519\n228#1:520,2\n229#1:522\n229#1:523,3\n232#1:526\n228#1:528,3\n94#1:511\n232#1:527\n*E\n"})
public final class PsAnalyzerDaemon
extends PsDaemon {
    @NotNull
    private final PsProject project;
    @NotNull
    private final PsLibraryUpdateCheckerDaemon libraryUpdateCheckerDaemon;
    @NotNull
    private final PsSdkIndexCheckerDaemon sdkIndexCheckerDaemon;
    @NotNull
    private final Map<Class<?>, PsModelAnalyzer<? extends PsModule>> modelAnalyzers;
    @NotNull
    private final MergingUpdateQueue mainQueue;
    @NotNull
    private final MergingUpdateQueue resultsUpdaterQueue;
    @NotNull
    private final PsIssueCollection issues;
    @NotNull
    private final EventDispatcher<IssuesUpdatedListener> onRunningEventDispatcher;
    @NotNull
    private final EventDispatcher<IssuesUpdatedListener> issuesUpdatedEventDispatcher;

    public PsAnalyzerDaemon(@NotNull Disposable parentDisposable, @NotNull PsProject project, @NotNull PsLibraryUpdateCheckerDaemon libraryUpdateCheckerDaemon, @NotNull PsSdkIndexCheckerDaemon sdkIndexCheckerDaemon, @NotNull Map<Class<?>, ? extends PsModelAnalyzer<? extends PsModule>> modelAnalyzers) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)libraryUpdateCheckerDaemon, (String)"libraryUpdateCheckerDaemon");
        Intrinsics.checkNotNullParameter((Object)sdkIndexCheckerDaemon, (String)"sdkIndexCheckerDaemon");
        Intrinsics.checkNotNullParameter(modelAnalyzers, (String)"modelAnalyzers");
        super(parentDisposable);
        this.project = project;
        this.libraryUpdateCheckerDaemon = libraryUpdateCheckerDaemon;
        this.sdkIndexCheckerDaemon = sdkIndexCheckerDaemon;
        this.modelAnalyzers = modelAnalyzers;
        this.mainQueue = this.createQueue("Project Structure Daemon Analyzer", null);
        this.resultsUpdaterQueue = this.createQueue("Project Structure Analysis Results Updater", MergingUpdateQueue.ANY_COMPONENT);
        this.issues = new PsIssueCollection();
        EventDispatcher eventDispatcher = EventDispatcher.create(IssuesUpdatedListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.onRunningEventDispatcher = eventDispatcher;
        EventDispatcher eventDispatcher2 = EventDispatcher.create(IssuesUpdatedListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher2, (String)"create(...)");
        this.issuesUpdatedEventDispatcher = eventDispatcher2;
        this.libraryUpdateCheckerDaemon.add((Function0<Unit>)((Function0)() -> PsAnalyzerDaemon._init_$lambda$0(this)), this);
        this.sdkIndexCheckerDaemon.add((Function0<Unit>)((Function0)() -> PsAnalyzerDaemon._init_$lambda$1(this)), this);
    }

    @Override
    @NotNull
    protected MergingUpdateQueue getMainQueue() {
        return this.mainQueue;
    }

    @Override
    @NotNull
    protected MergingUpdateQueue getResultsUpdaterQueue() {
        return this.resultsUpdaterQueue;
    }

    @NotNull
    public final PsIssueCollection getIssues() {
        return this.issues;
    }

    @UiThread
    public final void recreateIssues() {
        this.libraryUpdateCheckerDaemon.queueUpdateCheck();
        this.sdkIndexCheckerDaemon.queueCheck();
    }

    /*
     * WARNING - void declaration
     */
    @UiThread
    private final void recreateUpdatesAsIssues() {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        PsIssueType psIssueType = PsIssueType.LIBRARY_UPDATES_AVAILABLE;
        Intrinsics.checkNotNullExpressionValue((Object)psIssueType, (String)"LIBRARY_UPDATES_AVAILABLE");
        PsAnalyzerDaemon.removeIssues$default(this, psIssueType, null, true, 2, null);
        Iterable iterable = this.project.getModules();
        PsAnalyzerDaemon psAnalyzerDaemon = this;
        boolean $i$f$flatMap = false;
        void var3_4 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapNotNullTo$iv$iv;
            PsModule module = (PsModule)element$iv$iv;
            boolean bl = false;
            Iterable $this$mapNotNull$iv = module.getDependencies().getLibraries();
            boolean $i$f$mapNotNull = false;
            Iterable iterable2 = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                PsGeneralIssue it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv2 = element$iv$iv$iv = iterator2.next();
                boolean bl2 = false;
                PsDeclaredLibraryDependency it = (PsDeclaredLibraryDependency)element$iv$iv2;
                boolean bl3 = false;
                if (this.getAvailableUpdatesFor(it) == null) continue;
                boolean bl4 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        psAnalyzerDaemon.addAll((List)destination$iv$iv, false);
        this.notifyRunning();
    }

    @UiThread
    private final PsGeneralIssue getAvailableUpdatesFor(PsDeclaredLibraryDependency dependency) {
        List list2;
        AvailableLibraryUpdateStorage results2 = this.libraryUpdateCheckerDaemon.getAvailableLibraryUpdateStorage();
        PsArtifactDependencySpec spec = dependency.getSpec();
        Version version2 = results2.findUpdatedVersionFor(spec);
        if (version2 == null) {
            return null;
        }
        Version versionToUpdateTo = version2;
        String text2 = "Newer version available: <b>" + versionToUpdateTo + "<b>";
        PsLibraryDependencyNavigationPath mainPath = dependency.getPath();
        ParsedValue versionValue = ((ModelPropertyCore)dependency.getVersionProperty().bind(Unit.INSTANCE)).getParsedValue().getValue();
        boolean valueIsReference = versionValue instanceof ParsedValue.Set.Parsed && ((ParsedValue.Set.Parsed)versionValue).getDslText() instanceof DslText.Reference;
        PsPath psPath = mainPath;
        PsIssueType psIssueType = PsIssueType.LIBRARY_UPDATES_AVAILABLE;
        Intrinsics.checkNotNullExpressionValue((Object)psIssueType, (String)"LIBRARY_UPDATES_AVAILABLE");
        if (!valueIsReference) {
            list2 = CollectionsKt.listOf((Object)new PsLibraryDependencyVersionQuickFixPath(dependency, versionToUpdateTo.toString(), null, false, null, 28, null));
        } else {
            Object[] objectArray = new PsLibraryDependencyVersionQuickFixPath[]{new PsLibraryDependencyVersionQuickFixPath(dependency, versionToUpdateTo.toString(), true, false, null, 24, null), new PsLibraryDependencyVersionQuickFixPath(dependency, versionToUpdateTo.toString(), false, false, null, 24, null)};
            list2 = CollectionsKt.listOf((Object[])objectArray);
        }
        return new PsGeneralIssue(text2, "", psPath, psIssueType, PsIssue.Severity.UPDATE, list2, null, 64, null);
    }

    public final void onIssuesChange(@NotNull Disposable parentDisposable, @UiThread @NotNull Function0<Unit> listener2) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.issuesUpdatedEventDispatcher.addListener((EventListener)new IssuesUpdatedListener(listener2){
            final /* synthetic */ Function0<Unit> $listener;
            {
                this.$listener = $listener;
            }

            public void issuesUpdated() {
                this.$listener.invoke();
            }
        }, parentDisposable);
    }

    public final void onRunningChange(@NotNull Disposable parentDisposable, @UiThread @NotNull Function0<Unit> listener2) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.onRunningEventDispatcher.addListener((EventListener)new IssuesUpdatedListener(listener2){
            final /* synthetic */ Function0<Unit> $listener;
            {
                this.$listener = $listener;
            }

            public void issuesUpdated() {
                this.$listener.invoke();
            }
        }, parentDisposable);
    }

    @UiThread
    public final void queueCheck(@NotNull PsModule model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        PsIssueType psIssueType = PsIssueType.PROJECT_ANALYSIS;
        Intrinsics.checkNotNullExpressionValue((Object)psIssueType, (String)"PROJECT_ANALYSIS");
        this.removeIssues(psIssueType, model.getPath(), false);
        this.getMainQueue().queue((Update)new AnalyzeModuleStructure(model));
        this.notifyRunning();
    }

    @NotNull
    public final Sequence<PsIssue> validate(@NotNull PsModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Sequence sequence = this.modelAnalyzers.get(model.getClass());
        Sequence sequence2 = sequence instanceof PsModelAnalyzer ? sequence : null;
        if (sequence2 == null || (sequence2 = sequence2.analyze((PsModule)model)) == null) {
            sequence2 = SequencesKt.sequenceOf((Object[])new PsIssue[0]);
        }
        return sequence2;
    }

    private final void doAnalyzeStructure(PsModel model) {
        PsModelAnalyzer<? extends PsModule> analyzer;
        PsModelAnalyzer<? extends PsModule> psModelAnalyzer = this.modelAnalyzers.get(model.getClass());
        PsModelAnalyzer<? extends PsModule> psModelAnalyzer2 = analyzer = psModelAnalyzer instanceof PsModelAnalyzer ? psModelAnalyzer : null;
        if (analyzer == null) {
            PsAnalyzerDaemonKt.access$getLOG$p().info("Failed to find analyzer for model of type " + model.getClass().getName());
            return;
        }
        if (!this.isStopped()) {
            boolean bl = analyzer.getSupportedModelType().isInstance(model);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            ActionsKt.invokeAndWaitIfNeeded((ModalityState)ModalityState.any(), () -> PsAnalyzerDaemon.doAnalyzeStructure$lambda$0(this, analyzer, model));
        }
        this.getResultsUpdaterQueue().queue((Update)new IssuesComputed());
    }

    private final void removeIssues(PsIssueType type, PsPath byPath, boolean now) {
        this.issues.remove(type, byPath);
        this.notifyUpdated(now);
    }

    static /* synthetic */ void removeIssues$default(PsAnalyzerDaemon psAnalyzerDaemon, PsIssueType psIssueType, PsPath psPath, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            psPath = null;
        }
        psAnalyzerDaemon.removeIssues(psIssueType, psPath, bl);
    }

    /*
     * WARNING - void declaration
     */
    @UiThread
    public final void addAll(@NotNull List<? extends PsIssue> newIssues, boolean now) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter(newIssues, (String)"newIssues");
        Iterable iterable = newIssues;
        PsIssueCollection psIssueCollection = this.issues;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsIssue p0 = (PsIssue)element$iv;
            boolean bl = false;
            psIssueCollection.add(p0);
        }
        this.notifyUpdated(now);
    }

    @AnyThread
    private final void notifyUpdated(boolean now) {
        if (now) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            ((IssuesUpdatedListener)this.issuesUpdatedEventDispatcher.getMulticaster()).issuesUpdated();
        } else {
            this.getResultsUpdaterQueue().queue((Update)new IssuesComputed());
        }
    }

    @UiThread
    private final void notifyRunning() {
        ((IssuesUpdatedListener)this.onRunningEventDispatcher.getMulticaster()).issuesUpdated();
    }

    /*
     * WARNING - void declaration
     */
    @UiThread
    private final void recreateSdkIndexIssues() {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        PsIssueType psIssueType = PsIssueType.PLAY_SDK_INDEX_ISSUE;
        Intrinsics.checkNotNullExpressionValue((Object)psIssueType, (String)"PLAY_SDK_INDEX_ISSUE");
        PsAnalyzerDaemon.removeIssues$default(this, psIssueType, null, true, 2, null);
        int numErrors = 0;
        int numWarnings = 0;
        int numInfo = 0;
        int numUpdates = 0;
        int numOther = 0;
        Iterable iterable = this.project.getModules();
        PsAnalyzerDaemon psAnalyzerDaemon = this;
        boolean $i$f$flatMap = false;
        void var8_9 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$onEach$iv;
            void $this$mapTo$iv$iv;
            PsModule module = (PsModule)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = module.getDependencies().getLibraries();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PsDeclaredLibraryDependency psDeclaredLibraryDependency = (PsDeclaredLibraryDependency)item$iv$iv;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                collection2.add(PsAnalyzerDaemonKt.getSdkIndexIssueFor((PsDeclaredLibraryDependency)it, AvailableLibraryUpdateStorage.Companion.getInstance(this.project.getIdeProject())));
            }
            $this$map$iv = CollectionsKt.flatten((Iterable)((List)destination$iv$iv2));
            boolean $i$f$onEach = false;
            Iterable $this$onEach_u24lambda_u2418$iv = iterable2 = $this$onEach$iv;
            boolean bl3 = false;
            for (Object element$iv : $this$onEach_u24lambda_u2418$iv) {
                PsGeneralIssue issue2 = (PsGeneralIssue)element$iv;
                boolean bl4 = false;
                switch (WhenMappings.$EnumSwitchMapping$0[issue2.getSeverity().ordinal()]) {
                    case 1: {
                        int n = numErrors;
                        numErrors = n + 1;
                        break;
                    }
                    case 2: {
                        int n = numWarnings;
                        numWarnings = n + 1;
                        break;
                    }
                    case 3: {
                        int n = numInfo;
                        numInfo = n + 1;
                        break;
                    }
                    case 4: {
                        int n = numUpdates;
                        numUpdates = n + 1;
                        break;
                    }
                    default: {
                        int n = numOther;
                        numOther = n + 1;
                    }
                }
            }
            Iterable list$iv$iv = iterable2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        psAnalyzerDaemon.addAll((List)destination$iv$iv, false);
        PsAnalyzerDaemonKt.access$getLOG$p().debug("Issues recreated: " + numErrors + " errors, " + numWarnings + " warnings, " + numInfo + " information, " + numUpdates + " updates, " + numOther + " other");
        this.notifyRunning();
    }

    private static final Unit _init_$lambda$0(PsAnalyzerDaemon this$0) {
        this$0.recreateUpdatesAsIssues();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(PsAnalyzerDaemon this$0) {
        this$0.recreateSdkIndexIssues();
        return Unit.INSTANCE;
    }

    private static final Unit doAnalyzeStructure$lambda$0(PsAnalyzerDaemon this$0, PsModelAnalyzer $analyzer, PsModel $model) {
        List list2;
        if (!this$0.isStopped() && !$analyzer.getDisposed()) {
            Object t = $analyzer.getSupportedModelType().cast($model);
            Intrinsics.checkNotNullExpressionValue(t, (String)"cast(...)");
            list2 = SequencesKt.toList($analyzer.analyze((PsModel)t));
        } else {
            list2 = CollectionsKt.emptyList();
        }
        List newIssues = list2;
        this$0.addAll(newIssues, false);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/gradle/structure/daemon/PsAnalyzerDaemon$AnalyzeModuleStructure;", "Lcom/intellij/util/ui/update/Update;", "myModel", "Lcom/android/tools/idea/gradle/structure/model/PsModule;", "<init>", "(Lcom/android/tools/idea/gradle/structure/daemon/PsAnalyzerDaemon;Lcom/android/tools/idea/gradle/structure/model/PsModule;)V", "run", "", "intellij.android.projectSystem.gradle.psd"})
    private final class AnalyzeModuleStructure
    extends Update {
        @NotNull
        private final PsModule myModel;

        public AnalyzeModuleStructure(PsModule myModel) {
            Intrinsics.checkNotNullParameter((Object)myModel, (String)"myModel");
            super((Object)myModel, false, 0, 6, null);
            this.myModel = myModel;
        }

        public void run() {
            try {
                if (!this.isDisposed() && !PsAnalyzerDaemon.this.isStopped()) {
                    PsAnalyzerDaemon.this.doAnalyzeStructure(this.myModel);
                }
            }
            catch (Throwable e) {
                PsAnalyzerDaemonKt.access$getLOG$p().error("Failed to analyze " + this.myModel, e);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/gradle/structure/daemon/PsAnalyzerDaemon$IssuesComputed;", "Lcom/intellij/util/ui/update/Update;", "<init>", "(Lcom/android/tools/idea/gradle/structure/daemon/PsAnalyzerDaemon;)V", "run", "", "intellij.android.projectSystem.gradle.psd"})
    private final class IssuesComputed
    extends Update {
        public IssuesComputed() {
            super(IssuesComputed.class, false, 0, 6, null);
        }

        @UiThread
        public void run() {
            ((IssuesUpdatedListener)PsAnalyzerDaemon.this.issuesUpdatedEventDispatcher.getMulticaster()).issuesUpdated();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\bb\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/gradle/structure/daemon/PsAnalyzerDaemon$IssuesUpdatedListener;", "Ljava/util/EventListener;", "issuesUpdated", "", "intellij.android.projectSystem.gradle.psd"})
    private static interface IssuesUpdatedListener
    extends EventListener {
        public void issuesUpdated();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PsIssue.Severity.values().length];
            try {
                nArray[PsIssue.Severity.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PsIssue.Severity.WARNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PsIssue.Severity.INFO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PsIssue.Severity.UPDATE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

