/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.ui.modules;

import com.android.tools.idea.gradle.structure.configurables.ConfigurablesTreeModel;
import com.android.tools.idea.gradle.structure.configurables.ConfigurablesTreeModelKt;
import com.android.tools.idea.gradle.structure.configurables.ui.ConfigurablesMasterDetailsPanel;
import com.android.tools.idea.gradle.structure.configurables.ui.ConfigurablesMasterDetailsPanelKt;
import com.android.tools.idea.gradle.structure.configurables.ui.NameValidator;
import com.android.tools.idea.gradle.structure.configurables.ui.PsUISettings;
import com.android.tools.idea.gradle.structure.configurables.ui.modules.SigningConfigsPanel;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.model.android.PsSigningConfig;
import com.android.tools.idea.structure.dialog.TrackedConfigurableKt;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.PSDEvent;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.util.IconUtil;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001fB\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u0015H\u0016J\u000e\u0010\u0016\u001a\u0004\u0018\u00010\u0017*\u00020\bH\u0016J\u0016\u0010\u0018\u001a\u00020\u0019*\u00020\b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0017H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006 "}, d2={"Lcom/android/tools/idea/gradle/structure/configurables/ui/modules/SigningConfigsPanel;", "Lcom/android/tools/idea/gradle/structure/configurables/ui/ConfigurablesMasterDetailsPanel;", "Lcom/android/tools/idea/gradle/structure/model/android/PsSigningConfig;", "module", "Lcom/android/tools/idea/gradle/structure/model/android/PsAndroidModule;", "treeModel", "Lcom/android/tools/idea/gradle/structure/configurables/ConfigurablesTreeModel;", "psUiSettings", "Lcom/android/tools/idea/gradle/structure/configurables/ui/PsUISettings;", "<init>", "(Lcom/android/tools/idea/gradle/structure/model/android/PsAndroidModule;Lcom/android/tools/idea/gradle/structure/configurables/ConfigurablesTreeModel;Lcom/android/tools/idea/gradle/structure/configurables/ui/PsUISettings;)V", "getModule", "()Lcom/android/tools/idea/gradle/structure/model/android/PsAndroidModule;", "getTreeModel", "()Lcom/android/tools/idea/gradle/structure/configurables/ConfigurablesTreeModel;", "nameValidator", "Lcom/android/tools/idea/gradle/structure/configurables/ui/NameValidator;", "getRemoveAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "getRenameAction", "getCreateActions", "", "getLastEditedItem", "", "setLastEditedItem", "", "value", "topConfigurable", "Lcom/google/wireless/android/sdk/stats/PSDEvent$PSDTopTab;", "getTopConfigurable", "()Lcom/google/wireless/android/sdk/stats/PSDEvent$PSDTopTab;", "Companion", "intellij.android.projectSystem.gradle.psd"})
public final class SigningConfigsPanel
extends ConfigurablesMasterDetailsPanel<PsSigningConfig> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PsAndroidModule module;
    @NotNull
    private final ConfigurablesTreeModel treeModel;
    @NotNull
    private final NameValidator nameValidator;
    @NotNull
    private final PSDEvent.PSDTopTab topConfigurable;

    public SigningConfigsPanel(@NotNull PsAndroidModule module, @NotNull ConfigurablesTreeModel treeModel, @NotNull PsUISettings psUiSettings) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)treeModel, (String)"treeModel");
        Intrinsics.checkNotNullParameter((Object)psUiSettings, (String)"psUiSettings");
        super("Signing Configs", "android.psd.signing_config", treeModel, psUiSettings);
        this.module = module;
        this.treeModel = treeModel;
        this.nameValidator = new NameValidator((Function1<? super String, String>)((Function1)arg_0 -> SigningConfigsPanel.nameValidator$lambda$0(this, arg_0)));
        this.topConfigurable = PSDEvent.PSDTopTab.PROJECT_STRUCTURE_DIALOG_TOP_TAB_SIGNING_CONFIGS;
    }

    @NotNull
    public final PsAndroidModule getModule() {
        return this.module;
    }

    @NotNull
    public final ConfigurablesTreeModel getTreeModel() {
        return this.treeModel;
    }

    @Override
    @Nullable
    public AnAction getRemoveAction() {
        Icon icon = IconUtil.getRemoveIcon();
        return (AnAction)new DumbAwareAction(this, icon){
            final /* synthetic */ SigningConfigsPanel this$0;
            {
                this.this$0 = $receiver;
                super("Remove Signing Config", "Removes a Signing Config", $super_call_param$1);
            }

            public void update(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                e.getPresentation().setEnabled(SigningConfigsPanel.Companion.isNonDebugSelected(this.this$0.getSelectedConfigurable()));
            }

            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.EDT;
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                NamedConfigurable namedConfigurable = this.this$0.getSelectedConfigurable();
                if (Messages.showYesNoDialog((Project)e.getProject(), (String)("Remove signing config '" + (namedConfigurable != null ? namedConfigurable.getDisplayName() : null) + "' from the module?"), (String)"Remove Signing Config", (Icon)Messages.getQuestionIcon()) == 0) {
                    TrackedConfigurableKt.logUsagePsdAction(this.this$0.getModule().getParent().getIdeProject(), AndroidStudioEvent.EventKind.PROJECT_STRUCTURE_DIALOG_MODULES_SIGNINGCONFIGS_REMOVE);
                    DefaultMutableTreeNode defaultMutableTreeNode = this.this$0.getSelectedNode().getNextSibling();
                    if (defaultMutableTreeNode == null) {
                        defaultMutableTreeNode = this.this$0.getSelectedNode().getPreviousSibling();
                    }
                    DefaultMutableTreeNode nodeToSelectAfter = defaultMutableTreeNode;
                    PsAndroidModule psAndroidModule = this.this$0.getModule();
                    MasterDetailsComponent.MyNode myNode = this.this$0.getSelectedNode();
                    Intrinsics.checkNotNullExpressionValue((Object)myNode, (String)"getSelectedNode(...)");
                    MasterDetailsComponent.MyNode $this$getModel$iv = myNode;
                    boolean $i$f$getModel = false;
                    Object object = $this$getModel$iv.getUserObject();
                    NamedConfigurable namedConfigurable2 = object instanceof NamedConfigurable ? (NamedConfigurable)object : null;
                    Object object2 = namedConfigurable2 != null ? namedConfigurable2.getEditableObject() : null;
                    if (!(object2 instanceof PsSigningConfig)) {
                        object2 = null;
                    }
                    PsSigningConfig psSigningConfig = (PsSigningConfig)object2;
                    if (psSigningConfig == null) {
                        return;
                    }
                    psAndroidModule.removeSigningConfig(psSigningConfig);
                    SigningConfigsPanel.access$selectNode(this.this$0, nodeToSelectAfter);
                }
            }
        };
    }

    @Override
    @Nullable
    public AnAction getRenameAction() {
        Icon icon = IconUtil.getEditIcon();
        return (AnAction)new DumbAwareAction(this, icon){
            final /* synthetic */ SigningConfigsPanel this$0;
            {
                this.this$0 = $receiver;
                super("Rename Signing Config", "Renames a Signing Config", $super_call_param$1);
            }

            public void update(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                e.getPresentation().setEnabled(SigningConfigsPanel.Companion.isNonDebugSelected(this.this$0.getSelectedConfigurable()));
            }

            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.EDT;
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                NamedConfigurable namedConfigurable = this.this$0.getSelectedConfigurable();
                NamedConfigurable namedConfigurable2 = this.this$0.getSelectedConfigurable();
                ConfigurablesMasterDetailsPanelKt.renameWithDialog("Enter a new name for signing config '" + (namedConfigurable != null ? namedConfigurable.getDisplayName() : null) + "':", "Rename Signing Type", true, "Also update references", namedConfigurable2 != null ? namedConfigurable2.getDisplayName() : null, SigningConfigsPanel.access$getNameValidator$p(this.this$0), (Function2<? super String, ? super Boolean, Unit>)((Function2)(arg_0, arg_1) -> getRenameAction.1.actionPerformed$lambda$0(this.this$0, arg_0, arg_1)));
            }

            private static final Unit actionPerformed$lambda$0(SigningConfigsPanel this$0, String newName, boolean alsoRenameReferences) {
                Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
                TrackedConfigurableKt.logUsagePsdAction(this$0.getModule().getParent().getIdeProject(), AndroidStudioEvent.EventKind.PROJECT_STRUCTURE_DIALOG_MODULES_SIGNINGCONFIGS_RENAME);
                MasterDetailsComponent.MyNode myNode = this$0.getSelectedNode();
                Intrinsics.checkNotNullExpressionValue((Object)myNode, (String)"getSelectedNode(...)");
                MasterDetailsComponent.MyNode $this$getModel$iv = myNode;
                boolean $i$f$getModel = false;
                Object object = $this$getModel$iv.getUserObject();
                NamedConfigurable namedConfigurable = object instanceof NamedConfigurable ? (NamedConfigurable)object : null;
                Object object2 = namedConfigurable != null ? namedConfigurable.getEditableObject() : null;
                if (!(object2 instanceof PsSigningConfig)) {
                    object2 = null;
                }
                PsSigningConfig psSigningConfig = (PsSigningConfig)object2;
                if (psSigningConfig == null) {
                    return Unit.INSTANCE;
                }
                psSigningConfig.rename(newName, alsoRenameReferences);
                return Unit.INSTANCE;
            }
        };
    }

    @Override
    @NotNull
    public List<AnAction> getCreateActions() {
        Icon icon = IconUtil.getAddIcon();
        return CollectionsKt.listOf((Object)new DumbAwareAction(this, icon){
            final /* synthetic */ SigningConfigsPanel this$0;
            {
                this.this$0 = $receiver;
                super("Add Signing Config", "", $super_call_param$1);
            }

            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.BGT;
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                String newName = Messages.showInputDialog((Project)e.getProject(), (String)"Enter a new signing config name:", (String)"Create New Signing Config", null, (String)"", (InputValidator)SigningConfigsPanel.access$getNameValidator$p(this.this$0));
                if (newName != null) {
                    TrackedConfigurableKt.logUsagePsdAction(this.this$0.getModule().getParent().getIdeProject(), AndroidStudioEvent.EventKind.PROJECT_STRUCTURE_DIALOG_MODULES_SIGNINGCONFIGS_ADD);
                    PsSigningConfig signingConfig2 = this.this$0.getModule().addNewSigningConfig(newName);
                    MasterDetailsComponent.MyNode node = ConfigurablesTreeModelKt.findChildFor(this.this$0.getTreeModel().getRootNode(), signingConfig2);
                    SigningConfigsPanel.access$selectNode(this.this$0, (TreeNode)node);
                }
            }
        });
    }

    @Override
    @Nullable
    public String getLastEditedItem(@NotNull PsUISettings $this$getLastEditedItem) {
        Intrinsics.checkNotNullParameter((Object)$this$getLastEditedItem, (String)"<this>");
        return $this$getLastEditedItem.LAST_EDITED_SIGNING_CONFIG;
    }

    @Override
    public void setLastEditedItem(@NotNull PsUISettings $this$setLastEditedItem, @Nullable String value2) {
        Intrinsics.checkNotNullParameter((Object)$this$setLastEditedItem, (String)"<this>");
        $this$setLastEditedItem.LAST_EDITED_SIGNING_CONFIG = value2;
    }

    @Override
    @NotNull
    public PSDEvent.PSDTopTab getTopConfigurable() {
        return this.topConfigurable;
    }

    private static final String nameValidator$lambda$0(SigningConfigsPanel this$0, String it) {
        PsAndroidModule psAndroidModule = this$0.module;
        String string = it;
        if (string == null) {
            string = "";
        }
        return psAndroidModule.validateSigningConfigName(string);
    }

    public static final /* synthetic */ void access$selectNode(SigningConfigsPanel $this, TreeNode node) {
        $this.selectNode(node);
    }

    public static final /* synthetic */ NameValidator access$getNameValidator$p(SigningConfigsPanel $this) {
        return $this.nameValidator;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/gradle/structure/configurables/ui/modules/SigningConfigsPanel$Companion;", "", "<init>", "()V", "isNonDebugSelected", "", "selected", "Lcom/intellij/openapi/ui/NamedConfigurable;", "intellij.android.projectSystem.gradle.psd"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public final boolean isNonDebugSelected(@Nullable NamedConfigurable<?> selected) {
            return selected != null && !Intrinsics.areEqual((Object)selected.getDisplayName(), (Object)"debug");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

