/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.dependencies.module;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.dependencies.treeview.AbstractDependencyNode;
import com.android.tools.idea.gradle.structure.configurables.dependencies.treeview.DependencySelection;
import com.android.tools.idea.gradle.structure.configurables.dependencies.treeview.GoToModuleAction;
import com.android.tools.idea.gradle.structure.configurables.dependencies.treeview.ModuleDependencyNode;
import com.android.tools.idea.gradle.structure.configurables.dependencies.treeview.ResolvedDependenciesTreeStructure;
import com.android.tools.idea.gradle.structure.configurables.ui.SelectionChangeEventDispatcher;
import com.android.tools.idea.gradle.structure.configurables.ui.SelectionChangeListener;
import com.android.tools.idea.gradle.structure.configurables.ui.ToolWindowPanel;
import com.android.tools.idea.gradle.structure.configurables.ui.UiUtil;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractBaseCollapseAllAction;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractPsModelNode;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.NodeHyperlinkSupport;
import com.android.tools.idea.gradle.structure.model.PsBaseDependency;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.PsModuleDependency;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import icons.StudioIcons;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResolvedDependenciesPanel
extends ToolWindowPanel
implements DependencySelection {
    @NotNull
    private final Tree myTree;
    @NotNull
    private final PsContext myContext;
    @NotNull
    private final NodeHyperlinkSupport<ModuleDependencyNode> myHyperlinkSupport;
    @NotNull
    private final SelectionChangeEventDispatcher<PsBaseDependency> myEventDispatcher = new SelectionChangeEventDispatcher();
    private boolean myIgnoreTreeSelectionEvents;

    public ResolvedDependenciesPanel(@NotNull PsModule module, @NotNull PsContext context, @NotNull DependencySelection dependencySelection) {
        this("Resolved Dependencies", module, context, dependencySelection, ToolWindowAnchor.RIGHT);
    }

    private ResolvedDependenciesPanel(@NotNull String title2, @NotNull PsModule module, @NotNull PsContext context, @NotNull DependencySelection dependencySelection, @Nullable ToolWindowAnchor anchor) {
        super(title2, StudioIcons.Misc.PROJECT_SYSTEM_VARIANT, anchor);
        this.myContext = context;
        ResolvedDependenciesTreeStructure treeStructure = new ResolvedDependenciesTreeStructure(module, this.myContext.getUiSettings());
        StructureTreeModel structureTreeModel = new StructureTreeModel((AbstractTreeStructure)treeStructure, (Disposable)this);
        this.myTree = new Tree((TreeModel)new AsyncTreeModel((TreeModel)structureTreeModel, (Disposable)this)){

            protected void processMouseEvent(MouseEvent e) {
                ModuleDependencyNode node;
                int id2 = e.getID();
                if (id2 == 501 && (node = ResolvedDependenciesPanel.this.myHyperlinkSupport.getIfHyperlink(e)) != null) {
                    PsModuleDependency moduleDependency = (PsModuleDependency)node.getModels().get(0);
                    String name2 = moduleDependency.getName();
                    ResolvedDependenciesPanel.this.myContext.setSelectedModule(name2, ResolvedDependenciesPanel.this);
                    return;
                }
                super.processMouseEvent(e);
            }
        };
        this.myTree.setRowHeight(JBUI.scale((int)24));
        module.add((PsModule.DependencyChangedEvent event) -> treeStructure.reset(), this);
        this.setHeaderActions();
        this.getHeader().setPreferredFocusedComponent((JComponent)this.myTree);
        JScrollPane scrollPane2 = UiUtil.setUp((JTree)this.myTree, "resolvedDependencies");
        this.add((Component)scrollPane2, "Center");
        TreeSelectionListener treeSelectionListener = e -> {
            if (this.myIgnoreTreeSelectionEvents) {
                return;
            }
            PsBaseDependency selected = this.getSelection();
            if (selected == null) {
                AbstractPsModelNode selectedNode = this.getSelectionIfSingle();
                if (selectedNode != null && !(selectedNode instanceof AbstractDependencyNode)) {
                    this.notifySelectionChanged(null);
                }
            } else {
                this.notifySelectionChanged(selected);
            }
        };
        this.myTree.addTreeSelectionListener(treeSelectionListener);
        this.myTree.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                ResolvedDependenciesPanel.this.popupInvoked(x, y);
            }
        });
        this.myHyperlinkSupport = new NodeHyperlinkSupport<ModuleDependencyNode>(this.myTree, ModuleDependencyNode.class, this.myContext, false);
    }

    private void notifySelectionChanged(@Nullable PsBaseDependency selected) {
        this.myEventDispatcher.selectionChanged(selected);
    }

    private void setHeaderActions() {
        ArrayList<AnAction> additionalActions = new ArrayList<AnAction>();
        additionalActions.add((AnAction)new AbstractBaseCollapseAllAction(this.myTree){

            public void actionPerformed(AnActionEvent e) {
                ResolvedDependenciesPanel.this.collapseAllNodes();
            }
        });
        additionalActions.add((AnAction)Separator.getInstance());
        this.getHeader().setAdditionalActions(additionalActions);
    }

    private void collapseAllNodes() {
        this.myTree.requestFocusInWindow();
        this.myIgnoreTreeSelectionEvents = true;
        TreeUtil.collapseAll((JTree)this.myTree, (int)-1);
        this.myIgnoreTreeSelectionEvents = false;
    }

    private void popupInvoked(int x, int y) {
        ModuleDependencyNode node = this.myHyperlinkSupport.getNodeForLocation(x, y);
        if (node != null) {
            PsModuleDependency moduleDependency = (PsModuleDependency)node.getModels().get(0);
            String name2 = moduleDependency.getName();
            DefaultActionGroup group2 = new DefaultActionGroup();
            group2.add((AnAction)new GoToModuleAction(name2, this.myContext, (JComponent)this.myTree));
            ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("ResolvedDependenciesPanel", (ActionGroup)group2);
            popupMenu.getComponent().show((Component)this.myTree, x, y);
        }
    }

    @Override
    public ActionCallback setSelection(@Nullable Collection<PsBaseDependency> selection2) {
        if (selection2 == null || selection2.isEmpty()) {
            this.myTree.clearSelection();
        }
        return ActionCallback.DONE;
    }

    public void add(@NotNull SelectionChangeListener<PsBaseDependency> listener2) {
        this.myEventDispatcher.addListener(listener2, this);
    }

    @Override
    @Nullable
    public PsBaseDependency getSelection() {
        AbstractDependencyNode node;
        List models;
        AbstractPsModelNode selection2 = this.getSelectionIfSingle();
        if (selection2 instanceof AbstractDependencyNode && !(models = (node = (AbstractDependencyNode)selection2).getModels()).isEmpty()) {
            return (PsBaseDependency)models.get(0);
        }
        return null;
    }

    @Nullable
    private AbstractPsModelNode getSelectionIfSingle() {
        List selection2 = TreeUtil.collectSelectedObjectsOfType((JTree)this.myTree, AbstractPsModelNode.class);
        if (selection2.size() == 1) {
            return (AbstractPsModelNode)ContainerUtil.getFirstItem((List)selection2);
        }
        return null;
    }

    @Override
    public void dispose() {
        super.dispose();
        Disposer.dispose(this.myHyperlinkSupport);
    }
}

