/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.dependencies.details;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.dependencies.details.ConfigurationDependencyDetails;
import com.android.tools.idea.gradle.structure.model.PsBaseDependency;
import com.android.tools.idea.gradle.structure.model.PsDeclaredModuleDependency;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.PsModuleDependency;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jdesktop.swingx.JXLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleDependencyDetails
implements ConfigurationDependencyDetails {
    @NotNull
    private final PsContext myContext;
    private final boolean myShowScope;
    private JPanel myMainPanel;
    private JXLabel myNameLabel;
    private JXLabel myGradlePathLabel;
    private JBLabel myConfigurationLabel;
    private HyperlinkLabel myGoToLabel;
    private JPanel myConfigurationPanel;
    private PsModuleDependency myDependency;

    public ModuleDependencyDetails(@NotNull PsContext context, boolean showScope) {
        this.setupUI();
        this.myContext = context;
        this.myShowScope = showScope;
        this.myConfigurationLabel.setVisible(showScope);
        this.myConfigurationPanel.setVisible(showScope);
        this.myGoToLabel.setHyperlinkText("See Dependencies");
        this.myGoToLabel.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(@NotNull HyperlinkEvent e) {
                assert (ModuleDependencyDetails.this.myDependency != null);
                ModuleDependencyDetails.this.myContext.getMainConfigurable().navigateTo(ModuleDependencyDetails.this.myContext.getProject().findModuleByGradlePath(ModuleDependencyDetails.this.myDependency.getGradlePath()).getPath().getDependenciesPath().getPlaceDestination(ModuleDependencyDetails.this.myContext), true);
            }
        });
    }

    @Override
    @NotNull
    public JPanel getPanel() {
        return this.myMainPanel;
    }

    @Override
    public void display(@NotNull PsBaseDependency dependency) {
        PsModuleDependency d = (PsModuleDependency)dependency;
        this.myNameLabel.setText(d.getName());
        this.myGradlePathLabel.setText(d.getGradlePath());
        if (this.myShowScope) {
            this.displayConfiguration((PsDeclaredModuleDependency)d, PsModule.ImportantFor.MODULE);
        }
        this.myDependency = d;
    }

    @NotNull
    public Class<PsModuleDependency> getSupportedModelType() {
        return PsModuleDependency.class;
    }

    @Override
    @Nullable
    public PsModuleDependency getModel() {
        return this.myDependency;
    }

    @Override
    public PsContext getContext() {
        return this.myContext;
    }

    @Override
    public JPanel getConfigurationUI() {
        return this.myConfigurationPanel;
    }

    private void setupUI() {
        this.myMainPanel = new JPanel();
        this.myMainPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1));
        JBLabel jBLabel1 = new JBLabel();
        jBLabel1.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel1.setFontColor(UIUtil.FontColor.BRIGHTER);
        jBLabel1.setText("Name:");
        this.myMainPanel.add((Component)jBLabel1, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel2.setFontColor(UIUtil.FontColor.BRIGHTER);
        jBLabel2.setText("Gradle Path:");
        this.myMainPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myNameLabel = new JXLabel();
        Font myNameLabelFont = UIManager.getFont("Tree.font");
        if (myNameLabelFont != null) {
            this.myNameLabel.setFont(myNameLabelFont);
        }
        this.myMainPanel.add((Component)this.myNameLabel, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null, 0, false));
        this.myGradlePathLabel = new JXLabel();
        Font myGradlePathLabelFont = UIManager.getFont("Tree.font");
        if (myGradlePathLabelFont != null) {
            this.myGradlePathLabel.setFont(myGradlePathLabelFont);
        }
        this.myMainPanel.add((Component)this.myGradlePathLabel, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 3, null, null, null, 0, false));
        this.myConfigurationLabel = new JBLabel();
        this.myConfigurationLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        this.myConfigurationLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
        this.myConfigurationLabel.setText("Configuration:");
        this.myMainPanel.add((Component)this.myConfigurationLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myGoToLabel = new HyperlinkLabel();
        Font myGoToLabelFont = UIManager.getFont("Tree.font");
        if (myGoToLabelFont != null) {
            this.myGoToLabel.setFont(myGoToLabelFont);
        }
        this.myMainPanel.add((Component)this.myGoToLabel, new GridConstraints(3, 1, 1, 1, 0, 1, 3, 3, null, null, null, 0, false));
        this.myConfigurationPanel = new JPanel();
        this.myConfigurationPanel.setLayout(new BorderLayout(0, 0));
        this.myMainPanel.add((Component)this.myConfigurationPanel, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
    }
}

