/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.android.dependencies.project;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.project.DependencyGraphPanel;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.project.TargetModulesPanel;
import com.android.tools.idea.gradle.structure.configurables.dependencies.AbstractMainDependenciesPanel;
import com.android.tools.idea.gradle.structure.configurables.ui.ToolWindowHeader;
import com.android.tools.idea.gradle.structure.configurables.ui.UiUtil;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MainPanel
extends AbstractMainDependenciesPanel {
    @NotNull
    private final JBSplitter myVerticalSplitter;
    @NotNull
    private final DependencyGraphPanel myDependencyGraphPanel;
    @NotNull
    private final TargetModulesPanel myTargetModulesPanel;
    @NotNull
    private final JPanel myAltPanel;

    MainPanel(@NotNull PsModule module, @NotNull PsContext context) {
        super(context);
        this.myTargetModulesPanel = new TargetModulesPanel(context);
        this.myDependencyGraphPanel = new DependencyGraphPanel(module, context);
        this.myDependencyGraphPanel.setHistory(this.getHistory());
        this.myDependencyGraphPanel.add(this.myTargetModulesPanel::displayTargetModules);
        this.myVerticalSplitter = this.createMainVerticalSplitter();
        this.myVerticalSplitter.setFirstComponent((JComponent)this.myDependencyGraphPanel);
        this.myVerticalSplitter.setSecondComponent((JComponent)this.myTargetModulesPanel);
        this.add((Component)this.myVerticalSplitter, "Center");
        JPanel minimizedContainerPanel = this.myTargetModulesPanel.getMinimizedPanel();
        assert (minimizedContainerPanel != null);
        this.myAltPanel = new JPanel(new BorderLayout());
        this.myAltPanel.add((Component)minimizedContainerPanel, "East");
        ToolWindowHeader header = this.myTargetModulesPanel.getHeader();
        header.addMinimizeListener(this::minimizeResolvedDependenciesPanel);
        this.myTargetModulesPanel.addRestoreListener(this::restoreResolvedDependenciesPanel);
    }

    private void restoreResolvedDependenciesPanel() {
        this.remove(this.myAltPanel);
        this.myAltPanel.remove(this.myDependencyGraphPanel);
        this.myVerticalSplitter.setFirstComponent((JComponent)this.myDependencyGraphPanel);
        this.add((Component)this.myVerticalSplitter, "Center");
        UiUtil.revalidateAndRepaint(this);
        this.saveMinimizedState(false);
    }

    private void minimizeResolvedDependenciesPanel() {
        this.remove((Component)this.myVerticalSplitter);
        this.myVerticalSplitter.setFirstComponent(null);
        this.myAltPanel.add((Component)this.myDependencyGraphPanel, "Center");
        this.add((Component)this.myAltPanel, "Center");
        UiUtil.revalidateAndRepaint(this);
        this.saveMinimizedState(true);
    }

    private void saveMinimizedState(boolean minimize) {
        this.getContext().getUiSettings().TARGET_MODULES_MINIMIZE = minimize;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        boolean minimize = this.getContext().getUiSettings().TARGET_MODULES_MINIMIZE;
        if (minimize) {
            this.minimizeResolvedDependenciesPanel();
        } else {
            this.restoreResolvedDependenciesPanel();
        }
    }

    @Override
    public void setHistory(History history) {
        super.setHistory(history);
        this.myDependencyGraphPanel.setHistory(history);
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        return this.myDependencyGraphPanel.navigateTo(place, requestFocus);
    }

    public void queryPlace(@NotNull Place place) {
        this.myDependencyGraphPanel.queryPlace(place);
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myDependencyGraphPanel);
        Disposer.dispose((Disposable)this.myTargetModulesPanel);
    }
}

