/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenGradleSettingsHyperlink;
import com.android.tools.idea.gradle.structure.configurables.suggestions.SuggestionsPerspectiveConfigurable;
import com.android.tools.idea.projectsystem.AndroidProjectSettingsService;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.gradle.GradleProjectSystem;
import com.android.tools.idea.structure.dialog.ProjectStructureConfigurable;
import com.android.tools.idea.structure.dialog.ProjectStructureConfigurableKt;
import com.intellij.compiler.actions.ArtifactAwareProjectSettingsService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.IdeaProjectSettingsService;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.ui.navigation.Place;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;

public class AndroidProjectSettingsServiceImpl
extends AndroidProjectSettingsService
implements ArtifactAwareProjectSettingsService {
    private final Project myProject;
    private final IdeaProjectSettingsService myDelegate;

    public AndroidProjectSettingsServiceImpl(Project project) {
        this.myProject = project;
        this.myDelegate = new IdeaProjectSettingsService(project);
    }

    public void openProjectSettings() {
        this.myDelegate.openProjectSettings();
    }

    public void openGlobalLibraries() {
        if (!ProjectStructureConfigurableKt.canShowPsdOrWarnUser(this.myProject)) {
            return;
        }
        if (!this.isGradleProjectInAndroidStudio()) {
            this.myDelegate.openGlobalLibraries();
        }
    }

    public void openLibrary(@NotNull Library library) {
        if (!ProjectStructureConfigurableKt.canShowPsdOrWarnUser(this.myProject)) {
            return;
        }
        if (!this.isGradleProjectInAndroidStudio()) {
            this.myDelegate.openLibrary(library);
        }
    }

    public boolean canOpenModuleSettings() {
        if (!ProjectStructureConfigurableKt.canShowPsd(this.myProject)) {
            return false;
        }
        if (this.isGradleProjectInAndroidStudio()) {
            return true;
        }
        return this.myDelegate.canOpenModuleSettings();
    }

    public void openModuleLibrarySettings(Module module) {
        if (!ProjectStructureConfigurableKt.canShowPsdOrWarnUser(this.myProject)) {
            return;
        }
        if (this.isGradleProjectInAndroidStudio()) {
            this.openModuleSettings(module);
        } else {
            this.myDelegate.openModuleLibrarySettings(module);
        }
    }

    private void showNewPsd(@NotNull Place place) {
        ProjectStructureConfigurable.getInstance(this.myProject).showPlace(place);
    }

    public void openModuleSettings(Module module) {
        if (!ProjectStructureConfigurableKt.canShowPsdOrWarnUser(this.myProject)) {
            return;
        }
        if (this.isGradleProjectInAndroidStudio()) {
            this.showNewPsd(new Place().putPath("categoryName", (Object)"Modules").putPath("base_perspective.module", (Object)GradleProjectResolverUtil.getGradleIdentityPathOrNull((Module)module)));
        } else {
            this.myDelegate.openModuleSettings(module);
        }
    }

    @Override
    public void openSdkSettings() {
        this.showNewPsd(new Place().putPath("categoryName", (Object)"SDK Location"));
    }

    @Override
    public void chooseJdkLocation(@Nullable @SystemIndependent String gradleRootProjectPath) {
        if (this.myProject.isDisposed()) {
            return;
        }
        if (gradleRootProjectPath != null) {
            OpenGradleSettingsHyperlink.showGradleSettings(this.myProject, gradleRootProjectPath);
        } else {
            OpenGradleSettingsHyperlink.showGradleSettings(this.myProject);
        }
    }

    @Override
    public void openAndSelectDependency(@NotNull Module module, @NotNull String dependencyString) {
        this.showNewPsd(new Place().putPath("categoryName", (Object)"Dependencies").putPath("base_perspective.module", (Object)GradleProjectResolverUtil.getGradleIdentityPathOrNull((Module)module)).putPath("module.dependencies.place", (Object)dependencyString));
    }

    public void openAndSelectBuildTypesEditor(@NotNull Module module) {
        this.showNewPsd(new Place().putPath("categoryName", (Object)"Build Variants").putPath("base_perspective.module", (Object)GradleProjectResolverUtil.getGradleIdentityPathOrNull((Module)module)).putPath("android.psd.build_variants", (Object)"Build Types"));
    }

    public void openAndSelectFlavorsEditor(@NotNull Module module) {
        this.showNewPsd(new Place().putPath("categoryName", (Object)"Build Variants").putPath("base_perspective.module", (Object)GradleProjectResolverUtil.getGradleIdentityPathOrNull((Module)module)).putPath("android.psd.build_variants", (Object)"Flavors"));
    }

    @Override
    public void openAndSelectDependenciesEditor(@NotNull Module module) {
        this.showNewPsd(new Place().putPath("categoryName", (Object)"Dependencies").putPath("base_perspective.module", (Object)GradleProjectResolverUtil.getGradleIdentityPathOrNull((Module)module)));
    }

    @Override
    public void openSuggestions() {
        ProjectStructureConfigurable mainConfigurable = ProjectStructureConfigurable.getInstance(this.myProject);
        SuggestionsPerspectiveConfigurable suggestionsView = mainConfigurable.findConfigurable(SuggestionsPerspectiveConfigurable.class);
        String suggestionsDisplayName = suggestionsView != null ? suggestionsView.getDisplayName() : "Suggestions";
        this.showNewPsd(new Place().putPath("categoryName", (Object)suggestionsDisplayName));
    }

    public boolean canOpenModuleLibrarySettings() {
        if (!ProjectStructureConfigurableKt.canShowPsd(this.myProject)) {
            return false;
        }
        if (this.isGradleProjectInAndroidStudio()) {
            return false;
        }
        return this.myDelegate.canOpenModuleLibrarySettings();
    }

    public boolean canOpenContentEntriesSettings() {
        if (!ProjectStructureConfigurableKt.canShowPsd(this.myProject)) {
            return false;
        }
        if (this.isGradleProjectInAndroidStudio()) {
            return false;
        }
        return this.myDelegate.canOpenContentEntriesSettings();
    }

    public void openContentEntriesSettings(Module module) {
        if (!ProjectStructureConfigurableKt.canShowPsdOrWarnUser(this.myProject)) {
            return;
        }
        if (this.isGradleProjectInAndroidStudio()) {
            this.openModuleSettings(module);
        } else {
            this.myDelegate.openContentEntriesSettings(module);
        }
    }

    public boolean canOpenModuleDependenciesSettings() {
        if (!ProjectStructureConfigurableKt.canShowPsd(this.myProject)) {
            return false;
        }
        if (this.isGradleProjectInAndroidStudio()) {
            return false;
        }
        return this.myDelegate.canOpenModuleDependenciesSettings();
    }

    public void openModuleDependenciesSettings(@NotNull Module module, @Nullable OrderEntry orderEntry) {
        if (!ProjectStructureConfigurableKt.canShowPsdOrWarnUser(this.myProject)) {
            return;
        }
        if (this.isGradleProjectInAndroidStudio()) {
            this.openModuleSettings(module);
        } else {
            this.myDelegate.openModuleDependenciesSettings(module, orderEntry);
        }
    }

    public boolean canOpenLibraryOrSdkSettings(OrderEntry orderEntry) {
        if (!ProjectStructureConfigurableKt.canShowPsd(this.myProject)) {
            return false;
        }
        if (this.isGradleProjectInAndroidStudio()) {
            return false;
        }
        return this.myDelegate.canOpenLibraryOrSdkSettings(orderEntry);
    }

    public void openLibraryOrSdkSettings(@NotNull OrderEntry orderEntry) {
        if (!ProjectStructureConfigurableKt.canShowPsdOrWarnUser(this.myProject)) {
            return;
        }
        if (!this.isGradleProjectInAndroidStudio()) {
            this.myDelegate.openLibraryOrSdkSettings(orderEntry);
        }
    }

    public boolean processModulesMoved(Module[] modules, @Nullable String targetGroupName) {
        if (!ProjectStructureConfigurableKt.canShowPsd(this.myProject)) {
            return false;
        }
        if (this.isGradleProjectInAndroidStudio()) {
            return false;
        }
        return this.myDelegate.processModulesMoved(modules, targetGroupName);
    }

    public void showModuleConfigurationDialog(String moduleToSelect, String editorNameToSelect) {
        if (!ProjectStructureConfigurableKt.canShowPsdOrWarnUser(this.myProject)) {
            return;
        }
        if (this.isGradleProjectInAndroidStudio()) {
            Module module = ModuleManager.getInstance((Project)this.myProject).findModuleByName(moduleToSelect);
            assert (module != null);
            this.showNewPsd(new Place().putPath("categoryName", (Object)"Modules").putPath("base_perspective.module", (Object)GradleProjectResolverUtil.getGradleIdentityPathOrNull((Module)module)));
        } else {
            this.myDelegate.showModuleConfigurationDialog(moduleToSelect, editorNameToSelect);
        }
    }

    public Sdk chooseAndSetSdk() {
        return this.myDelegate.chooseAndSetSdk();
    }

    public void openArtifactSettings(@Nullable Artifact artifact) {
        if (!ProjectStructureConfigurableKt.canShowPsdOrWarnUser(this.myProject)) {
            return;
        }
        if (!this.isGradleProjectInAndroidStudio()) {
            this.myDelegate.openArtifactSettings(artifact);
        }
    }

    private boolean isGradleProjectInAndroidStudio() {
        return IdeInfo.getInstance().isAndroidStudio() && ProjectSystemUtil.getProjectSystem(this.myProject) instanceof GradleProjectSystem;
    }
}

