/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.roots;

import com.android.tools.idea.gradle.project.model.GradleAndroidModel;
import com.android.tools.idea.gradle.util.GradleProjectSystemUtil;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.gradle.GradleProjectSystem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public class AndroidGeneratedSourcesFilter
extends GeneratedSourcesFilter {
    public boolean isGeneratedSource(@NotNull VirtualFile file, @NotNull Project project) {
        GradleAndroidModel androidModel = GradleProjectSystemUtil.findAndroidModelInModule(project, file);
        return AndroidGeneratedSourcesFilter.isGeneratedSource(file, project, androidModel);
    }

    @VisibleForTesting
    public static boolean isGeneratedSource(@NotNull VirtualFile file, @NotNull Project project, GradleAndroidModel androidModel) {
        if (androidModel != null) {
            return VfsUtilCore.isAncestor((File)androidModel.getAndroidProject().getBuildFolder(), (File)VfsUtilCore.virtualToIoFile((VirtualFile)file), (boolean)false);
        }
        VirtualFile rootFolder = project.getBaseDir();
        if (rootFolder == null) {
            return false;
        }
        VirtualFile buildFolder = rootFolder.findChild("build");
        boolean isBuiltWithGradle = ProjectSystemUtil.getProjectSystem(project) instanceof GradleProjectSystem;
        return buildFolder != null && isBuiltWithGradle && VfsUtilCore.isAncestor((VirtualFile)buildFolder, (VirtualFile)file, (boolean)false);
    }
}

