/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.repositories.search;

import com.android.tools.idea.gradle.repositories.IdeGoogleMavenRepositoryBase;
import com.android.tools.idea.gradle.repositories.search.ArtifactRepository;
import com.android.tools.idea.gradle.repositories.search.FoundArtifact;
import com.android.tools.idea.gradle.repositories.search.GroupArtifactQuery;
import com.android.tools.idea.gradle.repositories.search.ModuleQuery;
import com.android.tools.idea.gradle.repositories.search.SearchQuery;
import com.android.tools.idea.gradle.repositories.search.SearchRequest;
import com.android.tools.idea.gradle.repositories.search.SearchResult;
import com.google.wireless.android.sdk.stats.PSDEvent;
import com.intellij.util.text.StringKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J6\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u00142\u0018\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r0\u0018H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/gradle/repositories/search/GoogleRepositoryBase;", "Lcom/android/tools/idea/gradle/repositories/search/ArtifactRepository;", "repository", "Lcom/android/tools/idea/gradle/repositories/IdeGoogleMavenRepositoryBase;", "<init>", "(Lcom/android/tools/idea/gradle/repositories/IdeGoogleMavenRepositoryBase;)V", "getRepository", "()Lcom/android/tools/idea/gradle/repositories/IdeGoogleMavenRepositoryBase;", "name", "", "getName", "()Ljava/lang/String;", "isRemote", "", "()Z", "doSearch", "Lcom/android/tools/idea/gradle/repositories/search/SearchResult;", "request", "Lcom/android/tools/idea/gradle/repositories/search/SearchRequest;", "getArtifacts", "", "Lcom/android/tools/idea/gradle/repositories/search/FoundArtifact;", "groups", "artifactFilter", "Lkotlin/Function2;", "intellij.android.projectSystem.gradle.repositorySearch"})
@SourceDebugExtension(value={"SMAP\nGoogleRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoogleRepository.kt\ncom/android/tools/idea/gradle/repositories/search/GoogleRepositoryBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,66:1\n774#2:67\n865#2,2:68\n774#2:77\n865#2,2:78\n1563#2:80\n1634#2,3:81\n37#3:70\n36#3,3:71\n126#4:74\n153#4,2:75\n155#4:84\n1#5:85\n*S KotlinDebug\n*F\n+ 1 GoogleRepository.kt\ncom/android/tools/idea/gradle/repositories/search/GoogleRepositoryBase\n*L\n36#1:67\n36#1:68,2\n58#1:77\n58#1:78,2\n58#1:80\n58#1:81,3\n54#1:70\n54#1:71,3\n57#1:74\n57#1:75,2\n57#1:84\n*E\n"})
public class GoogleRepositoryBase
extends ArtifactRepository {
    @NotNull
    private final IdeGoogleMavenRepositoryBase repository;
    @NotNull
    private final String name;
    private final boolean isRemote;

    public GoogleRepositoryBase(@NotNull IdeGoogleMavenRepositoryBase repository2) {
        Intrinsics.checkNotNullParameter((Object)((Object)repository2), (String)"repository");
        super(PSDEvent.PSDRepositoryUsage.PSDRepository.PROJECT_STRUCTURE_DIALOG_REPOSITORY_GOOGLE);
        this.repository = repository2;
        this.name = "Google";
        this.isRemote = true;
    }

    @NotNull
    public final IdeGoogleMavenRepositoryBase getRepository() {
        return this.repository;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isRemote() {
        return this.isRemote;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected SearchResult doSearch(@NotNull SearchRequest request) {
        SearchResult searchResult;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        SearchQuery searchQuery = request.getQuery();
        if (searchQuery instanceof GroupArtifactQuery) {
            void $this$filterTo$iv$iv;
            Function1<String, Boolean> groupFilter = GoogleRepositoryBase.doSearch$toFilterPredicate(((GroupArtifactQuery)request.getQuery()).getGroupId());
            Function1<String, Boolean> artifactFilter = GoogleRepositoryBase.doSearch$toFilterPredicate(((GroupArtifactQuery)request.getQuery()).getArtifactName());
            Iterable $this$filter$iv = this.repository.getGroups();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                if (!((Boolean)groupFilter.invoke(element$iv$iv)).booleanValue()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List groups = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
            searchResult = new SearchResult(this.getArtifacts(groups, (Function2<? super String, ? super String, Boolean>)((Function2)(arg_0, arg_1) -> GoogleRepositoryBase.doSearch$lambda$3(artifactFilter, arg_0, arg_1))));
        } else if (searchQuery instanceof ModuleQuery) {
            Function1<String, Boolean> moduleFilter = GoogleRepositoryBase.doSearch$toFilterPredicate(((ModuleQuery)request.getQuery()).getModule());
            List groups = CollectionsKt.sorted((Iterable)this.repository.getGroups());
            searchResult = new SearchResult(this.getArtifacts(groups, (Function2<? super String, ? super String, Boolean>)((Function2)(arg_0, arg_1) -> GoogleRepositoryBase.doSearch$lambda$4(moduleFilter, arg_0, arg_1))));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return searchResult;
    }

    /*
     * WARNING - void declaration
     */
    private final List<FoundArtifact> getArtifacts(List<String> groups, Function2<? super String, ? super String, Boolean> artifactFilter) {
        void $this$mapTo$iv$iv;
        Map<String, CompletableFuture<Set<String>>> groupsToArtifacts = this.repository.getArtifactsForAll(groups);
        Collection<CompletableFuture<Set<String>>> $this$toTypedArray$iv = groupsToArtifacts.values();
        boolean $i$f$toTypedArray = false;
        Object thisCollection$iv = $this$toTypedArray$iv;
        CompletableFuture[] futureArtifacts = thisCollection$iv.toArray(new CompletableFuture[0]);
        CompletableFuture.allOf(Arrays.copyOf(futureArtifacts, futureArtifacts.length)).get();
        Map<String, CompletableFuture<Set<String>>> $this$map$iv = groupsToArtifacts;
        boolean $i$f$map = false;
        thisCollection$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void $this$mapTo$iv$iv2;
            String it;
            Iterable $this$filterTo$iv$iv;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            String groupId = (String)entry.getKey();
            CompletableFuture futureArtifacts2 = (CompletableFuture)entry.getValue();
            Object t = futureArtifacts2.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            Iterable $this$filter$iv = (Iterable)t;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl2 = false;
                if (!((Boolean)artifactFilter.invoke((Object)groupId, (Object)it)).booleanValue()) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            Iterable $this$map$iv2 = CollectionsKt.sorted((Iterable)((List)destination$iv$iv2));
            boolean $i$f$map2 = false;
            $this$filterTo$iv$iv = $this$map$iv2;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void id2;
                it = (String)item$iv$iv2;
                Collection collection3 = destination$iv$iv2;
                boolean bl3 = false;
                Set versions2 = this.repository.getVersions(groupId, (String)id2);
                collection3.add(new FoundArtifact(this.getName(), groupId, (String)id2, versions2));
            }
            collection2.add((List)destination$iv$iv2);
        }
        return CollectionsKt.toList((Iterable)CollectionsKt.flatten((Iterable)((List)destination$iv$iv)));
    }

    private static final Function1<String, Boolean> doSearch$toFilterPredicate(String $this$doSearch_u24toFilterPredicate) {
        String string;
        block3: {
            block2: {
                string = StringKt.nullize((String)$this$doSearch_u24toFilterPredicate, (boolean)true);
                if (string == null) break block2;
                String it = string;
                boolean bl = false;
                Regex it2 = new Regex(StringsKt.replace$default((String)it, (String)"*", (String)".*", (boolean)false, (int)4, null));
                boolean bl2 = false;
                Function1 function1 = arg_0 -> GoogleRepositoryBase.doSearch$toFilterPredicate$lambda$1$0(it2, arg_0);
                string = function1;
                if (function1 != null) break block3;
            }
            string = GoogleRepositoryBase::doSearch$toFilterPredicate$lambda$2;
        }
        return string;
    }

    private static final boolean doSearch$toFilterPredicate$lambda$1$0(Regex $it, String probe) {
        Intrinsics.checkNotNullParameter((Object)probe, (String)"probe");
        return $it.matches((CharSequence)probe);
    }

    private static final boolean doSearch$toFilterPredicate$lambda$2(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean doSearch$lambda$3(Function1 $artifactFilter, String string, String id2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        return (Boolean)$artifactFilter.invoke((Object)id2);
    }

    private static final boolean doSearch$lambda$4(Function1 $moduleFilter, String groupId, String id2) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        return (Boolean)$moduleFilter.invoke((Object)(groupId + ":" + id2));
    }
}

