/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.upgrade;

import com.android.ide.common.gradle.Version;
import com.android.ide.common.repository.AgpVersion;
import com.android.tools.idea.gradle.dsl.android.model.android.AndroidModelUtilsKt;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.ext.ResolvedPropertyModel;
import com.android.tools.idea.gradle.project.upgrade.AgpUpgradeBundle;
import com.android.tools.idea.gradle.project.upgrade.AgpUpgradeComponentRefactoringProcessor;
import com.android.tools.idea.gradle.project.upgrade.AgpUpgradeRefactoringProcessor;
import com.android.tools.idea.gradle.project.upgrade.AlwaysNeeded;
import com.android.tools.idea.gradle.project.upgrade.RemoveRedundantPropertyUsageInfo;
import com.android.tools.idea.gradle.project.upgrade.WrappedPsiElement;
import com.google.wireless.android.sdk.stats.UpgradeAssistantComponentInfo;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usages.impl.rules.UsageType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 !2\u00020\u0001:\u0001!B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u0013\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0014\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016J\u001d\u0010\u001d\u001a\u00020\u001e2\u000e\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011H\u0014\u00a2\u0006\u0002\u0010 R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\""}, d2={"Lcom/android/tools/idea/gradle/project/upgrade/RedundantPropertiesRefactoringProcessor;", "Lcom/android/tools/idea/gradle/project/upgrade/AgpUpgradeComponentRefactoringProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "current", "Lcom/android/ide/common/repository/AgpVersion;", "new", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/android/ide/common/repository/AgpVersion;Lcom/android/ide/common/repository/AgpVersion;)V", "processor", "Lcom/android/tools/idea/gradle/project/upgrade/AgpUpgradeRefactoringProcessor;", "(Lcom/android/tools/idea/gradle/project/upgrade/AgpUpgradeRefactoringProcessor;)V", "necessityInfo", "Lcom/android/tools/idea/gradle/project/upgrade/AlwaysNeeded;", "getNecessityInfo", "()Lcom/android/tools/idea/gradle/project/upgrade/AlwaysNeeded;", "findComponentUsages", "", "Lcom/intellij/usageView/UsageInfo;", "()[Lcom/intellij/usageView/UsageInfo;", "minimumBuildToolsVersion", "Lcom/android/ide/common/gradle/Version;", "agpVersion", "getCommandName", "", "getShortDescription", "completeComponentInfo", "Lcom/google/wireless/android/sdk/stats/UpgradeAssistantComponentInfo$Builder;", "builder", "createUsageViewDescriptor", "Lcom/intellij/usageView/UsageViewDescriptor;", "usages", "([Lcom/intellij/usageView/UsageInfo;)Lcom/intellij/usageView/UsageViewDescriptor;", "Companion", "intellij.android.projectSystem.gradle.upgrade"})
@SourceDebugExtension(value={"SMAP\nRedundantPropertiesRefactoringProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedundantPropertiesRefactoringProcessor.kt\ncom/android/tools/idea/gradle/project/upgrade/RedundantPropertiesRefactoringProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,99:1\n1869#2:100\n1870#2:102\n1#3:101\n37#4:103\n36#4,3:104\n*S KotlinDebug\n*F\n+ 1 RedundantPropertiesRefactoringProcessor.kt\ncom/android/tools/idea/gradle/project/upgrade/RedundantPropertiesRefactoringProcessor\n*L\n38#1:100\n38#1:102\n50#1:103\n50#1:104,3\n*E\n"})
public final class RedundantPropertiesRefactoringProcessor
extends AgpUpgradeComponentRefactoringProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AlwaysNeeded necessityInfo;
    @NotNull
    private static final UsageType REDUNDANT_PROPERTY_USAGE_TYPE = new UsageType(AgpUpgradeBundle.Companion.messagePointer("redundantProperties.usageType", new Object[0]));

    public RedundantPropertiesRefactoringProcessor(@NotNull Project project, @NotNull AgpVersion current, @NotNull AgpVersion agpVersion) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        Intrinsics.checkNotNullParameter((Object)agpVersion, (String)"new");
        super(project, current, agpVersion);
        this.necessityInfo = AlwaysNeeded.INSTANCE;
    }

    public RedundantPropertiesRefactoringProcessor(@NotNull AgpUpgradeRefactoringProcessor processor) {
        Intrinsics.checkNotNullParameter((Object)((Object)processor), (String)"processor");
        super(processor);
        this.necessityInfo = AlwaysNeeded.INSTANCE;
    }

    @Override
    @NotNull
    public AlwaysNeeded getNecessityInfo() {
        return this.necessityInfo;
    }

    @Override
    @NotNull
    protected UsageInfo[] findComponentUsages() {
        ArrayList<RemoveRedundantPropertyUsageInfo> usages = new ArrayList<RemoveRedundantPropertyUsageInfo>();
        List<GradleBuildModel> list2 = this.getProjectBuildModel().getAllIncludedBuildModels();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getAllIncludedBuildModels(...)");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiElement psiElement;
            String buildToolsVersion2;
            String string;
            ResolvedPropertyModel buildToolsVersionModel;
            GradleBuildModel model = (GradleBuildModel)element$iv;
            boolean bl = false;
            if (model.getPsiElement() == null) continue;
            Intrinsics.checkNotNull((Object)model);
            Intrinsics.checkNotNullExpressionValue((Object)AndroidModelUtilsKt.android(model).buildToolsVersion(), (String)"buildToolsVersion(...)");
            String string2 = buildToolsVersionModel.valueAsString();
            if (string2 == null) continue;
            String it = string2;
            boolean bl2 = false;
            Version version2 = Version.Companion.parse(it);
            string2 = version2;
            if (version2 == null) continue;
            String it2 = string = string2;
            boolean bl3 = false;
            string2 = it2.compareTo(Version.Companion.prefixInfimum("0")) > 0 ? string : null;
            if (string2 == null || (buildToolsVersion2 = string2).compareTo(this.minimumBuildToolsVersion(this.getNew())) >= 0 || buildToolsVersionModel.getRepresentativeContainedPsiElement() == null) continue;
            WrappedPsiElement wrappedPsiElement = new WrappedPsiElement(psiElement, this, REDUNDANT_PROPERTY_USAGE_TYPE, null, 8, null);
            RemoveRedundantPropertyUsageInfo usageInfo = new RemoveRedundantPropertyUsageInfo(wrappedPsiElement, buildToolsVersionModel);
            usages.add(usageInfo);
        }
        Collection $this$toTypedArray$iv = usages;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new UsageInfo[0]);
    }

    private final Version minimumBuildToolsVersion(AgpVersion agpVersion) {
        return AgpVersion.Companion.parse("7.0.0-alpha01").compareTo(agpVersion) > 0 ? Version.Companion.parse("0.0.1") : (AgpVersion.Companion.parse("7.1.0-alpha01").compareTo(agpVersion) > 0 ? Version.Companion.parse("30.0.2") : Version.Companion.parse("30.0.3"));
    }

    @Override
    @NotNull
    public String getCommandName() {
        return AgpUpgradeBundle.Companion.message("redundantPropertiesRefactoringProcessor.commandName", new Object[0]);
    }

    @Override
    @NotNull
    public String getShortDescription() {
        return "Setting buildToolsVersion to a value that is lower than the minimum supported by the\nAndroid Gradle Plugin has no effect (other than a warning).  The setting can be\nsafely removed.";
    }

    @Override
    @NotNull
    public UpgradeAssistantComponentInfo.Builder completeComponentInfo(@NotNull UpgradeAssistantComponentInfo.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        UpgradeAssistantComponentInfo.Builder builder2 = builder.setKind(UpgradeAssistantComponentInfo.UpgradeAssistantComponentKind.REDUNDANT_PROPERTIES);
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"setKind(...)");
        return builder2;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        return (UsageViewDescriptor)new UsageViewDescriptorAdapter(){

            public PsiElement[] getElements() {
                Intrinsics.checkNotNullExpressionValue((Object)PsiElement.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                return PsiElement.EMPTY_ARRAY;
            }

            public String getProcessedElementsHeader() {
                return AgpUpgradeBundle.Companion.message("redundantPropertiesRefactoringProcessor.usageView.header", new Object[0]);
            }
        };
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/gradle/project/upgrade/RedundantPropertiesRefactoringProcessor$Companion;", "", "<init>", "()V", "REDUNDANT_PROPERTY_USAGE_TYPE", "Lcom/intellij/usages/impl/rules/UsageType;", "getREDUNDANT_PROPERTY_USAGE_TYPE", "()Lcom/intellij/usages/impl/rules/UsageType;", "intellij.android.projectSystem.gradle.upgrade"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final UsageType getREDUNDANT_PROPERTY_USAGE_TYPE() {
            return REDUNDANT_PROPERTY_USAGE_TYPE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

