/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.upgrade;

import com.android.ide.common.repository.AgpVersion;
import com.android.tools.idea.gradle.project.upgrade.AgpUpgradeBundle;
import com.android.tools.idea.gradle.project.upgrade.AgpUpgradeComponentRefactoringProcessor;
import com.android.tools.idea.gradle.project.upgrade.AgpUpgradeRefactoringProcessor;
import com.android.tools.idea.gradle.project.upgrade.AlwaysNeeded;
import com.android.tools.idea.gradle.project.upgrade.GradleSha256UsageInfo;
import com.android.tools.idea.gradle.project.upgrade.GradleVersionUsageInfo;
import com.android.tools.idea.gradle.project.upgrade.WrappedPsiElement;
import com.android.tools.idea.gradle.util.BuildFileProcessor;
import com.android.tools.idea.gradle.util.CompatibleGradleVersion;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.android.utils.FileUtils;
import com.google.wireless.android.sdk.stats.UpgradeAssistantComponentInfo;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usages.impl.rules.UsageType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 ,2\u00020\u0001:\u0001,B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0007\u0010\u000bJ<\u0010\u0014\u001a\u00020\u0015*\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00162&\u0010\u0018\u001a\"\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u001c\u0012\u0004\u0012\u00020\u00150\u0019H\u0002J\u0015\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001f0\u001eH\u0014\u00a2\u0006\u0002\u0010 J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0016J\b\u0010$\u001a\u00020\u001bH\u0016J\b\u0010%\u001a\u00020\u001bH\u0016J\b\u0010&\u001a\u00020\u001bH\u0014J\u001d\u0010'\u001a\u00020(2\u000e\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001f0\u001eH\u0014\u00a2\u0006\u0002\u0010*J\f\u0010+\u001a\u00020\u001b*\u00020\u001bH\u0002R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006-"}, d2={"Lcom/android/tools/idea/gradle/project/upgrade/GradleVersionRefactoringProcessor;", "Lcom/android/tools/idea/gradle/project/upgrade/AgpUpgradeComponentRefactoringProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "current", "Lcom/android/ide/common/repository/AgpVersion;", "new", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/android/ide/common/repository/AgpVersion;Lcom/android/ide/common/repository/AgpVersion;)V", "processor", "Lcom/android/tools/idea/gradle/project/upgrade/AgpUpgradeRefactoringProcessor;", "(Lcom/android/tools/idea/gradle/project/upgrade/AgpUpgradeRefactoringProcessor;)V", "compatibleGradleVersion", "Lcom/android/tools/idea/gradle/util/CompatibleGradleVersion;", "getCompatibleGradleVersion", "()Lcom/android/tools/idea/gradle/util/CompatibleGradleVersion;", "necessityInfo", "Lcom/android/tools/idea/gradle/project/upgrade/AlwaysNeeded;", "getNecessityInfo", "()Lcom/android/tools/idea/gradle/project/upgrade/AlwaysNeeded;", "forEachGradleVersion", "", "", "Ljava/io/File;", "body", "Lkotlin/Function4;", "Lorg/gradle/util/GradleVersion;", "", "Lcom/intellij/psi/PsiElement;", "findComponentUsages", "", "Lcom/intellij/usageView/UsageInfo;", "()[Lcom/intellij/usageView/UsageInfo;", "completeComponentInfo", "Lcom/google/wireless/android/sdk/stats/UpgradeAssistantComponentInfo$Builder;", "builder", "getCommandName", "getShortDescription", "getRefactoringId", "createUsageViewDescriptor", "Lcom/intellij/usageView/UsageViewDescriptor;", "usages", "([Lcom/intellij/usageView/UsageInfo;)Lcom/intellij/usageView/UsageViewDescriptor;", "removeEscapingBackslashes", "Companion", "intellij.android.projectSystem.gradle.upgrade"})
@SourceDebugExtension(value={"SMAP\nGradleVersionRefactoringProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleVersionRefactoringProcessor.kt\ncom/android/tools/idea/gradle/project/upgrade/GradleVersionRefactoringProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,181:1\n1869#2:182\n295#2,2:183\n295#2,2:186\n1870#2:188\n1#3:185\n37#4:189\n36#4,3:190\n434#5:193\n507#5,5:194\n*S KotlinDebug\n*F\n+ 1 GradleVersionRefactoringProcessor.kt\ncom/android/tools/idea/gradle/project/upgrade/GradleVersionRefactoringProcessor\n*L\n55#1:182\n67#1:183,2\n71#1:186,2\n55#1:188\n95#1:189\n95#1:190,3\n137#1:193\n137#1:194,5\n*E\n"})
public final class GradleVersionRefactoringProcessor
extends AgpUpgradeComponentRefactoringProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CompatibleGradleVersion compatibleGradleVersion;
    @NotNull
    private final AlwaysNeeded necessityInfo;
    @NotNull
    private static final UsageType GRADLE_URL_USAGE_TYPE = new UsageType(AgpUpgradeBundle.Companion.messagePointer("gradleVersionRefactoringProcessor.gradleUrlUsageType", new Object[0]));
    @NotNull
    private static final UsageType GRADLE_SHA_256_USAGE_TYPE = new UsageType(AgpUpgradeBundle.Companion.messagePointer("gradleVersionRefactoringProcessor.gradleShaUsageType", new Object[0]));

    public GradleVersionRefactoringProcessor(@NotNull Project project, @NotNull AgpVersion current, @NotNull AgpVersion agpVersion) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        Intrinsics.checkNotNullParameter((Object)agpVersion, (String)"new");
        super(project, current, agpVersion);
        this.necessityInfo = AlwaysNeeded.INSTANCE;
        this.compatibleGradleVersion = CompatibleGradleVersion.Companion.getCompatibleGradleVersion(agpVersion);
    }

    public GradleVersionRefactoringProcessor(@NotNull AgpUpgradeRefactoringProcessor processor) {
        Intrinsics.checkNotNullParameter((Object)((Object)processor), (String)"processor");
        super(processor);
        this.necessityInfo = AlwaysNeeded.INSTANCE;
        this.compatibleGradleVersion = CompatibleGradleVersion.Companion.getCompatibleGradleVersion(processor.getNew());
    }

    @NotNull
    public final CompatibleGradleVersion getCompatibleGradleVersion() {
        return this.compatibleGradleVersion;
    }

    @Override
    @NotNull
    public AlwaysNeeded getNecessityInfo() {
        return this.necessityInfo;
    }

    private final void forEachGradleVersion(List<? extends File> $this$forEachGradleVersion, Function4<? super GradleVersion, ? super String, ? super PsiElement, ? super PsiElement, Unit> body) {
        Iterable $this$forEach$iv = CollectionsKt.filterNotNull((Iterable)$this$forEachGradleVersion);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GradleVersion parsedCurrentGradleVersion;
            Object v4;
            String currentUrl;
            IProperty urlProperty;
            block6: {
                Object $this$forEachGradleVersion_u24lambda_u240_u241;
                Object v1;
                Object element$iv22;
                PropertiesFile propertiesFile;
                block5: {
                    PsiFile psiFile;
                    VirtualFile virtualFile;
                    File ioRoot = (File)element$iv;
                    boolean bl = false;
                    File ioFile = GradleWrapper.Companion.getDefaultPropertiesFilePath(ioRoot);
                    if (VfsUtil.findFileByIoFile((File)ioFile, (boolean)false) == null || !virtualFile.isValid() || ((psiFile = PsiManager.getInstance((Project)this.getProject()).findFile(virtualFile)) instanceof PropertiesFile ? (PropertiesFile)psiFile : null) == null) continue;
                    propertiesFile = propertiesFile;
                    List list2 = propertiesFile.getProperties();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getProperties(...)");
                    Iterable $this$firstOrNull$iv = list2;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv22 : $this$firstOrNull$iv) {
                        IProperty it = (IProperty)element$iv22;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)"distributionUrl", (Object)it.getKey())) continue;
                        v1 = element$iv22;
                        break block5;
                    }
                    v1 = null;
                }
                if ((IProperty)v1 == null) continue;
                String string = urlProperty.getValue();
                if (string == null) continue;
                if ((string = this.removeEscapingBackslashes(string)) == null || GradleWrapper.Companion.getGradleVersion(currentUrl = string) == null) continue;
                element$iv22 = $this$forEachGradleVersion;
                try {
                    String currentGradleVersion;
                    $this$forEachGradleVersion_u24lambda_u240_u241 = element$iv22;
                    boolean bl = false;
                    $this$forEachGradleVersion_u24lambda_u240_u241 = Result.constructor-impl((Object)GradleVersion.version((String)currentGradleVersion));
                }
                catch (Throwable throwable) {
                    $this$forEachGradleVersion_u24lambda_u240_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                element$iv22 = $this$forEachGradleVersion_u24lambda_u240_u241;
                if ((GradleVersion)(Result.isFailure-impl(element$iv22) ? null : element$iv22) == null) continue;
                List list3 = propertiesFile.getProperties();
                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getProperties(...)");
                Iterable $this$firstOrNull$iv = list3;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv3 : $this$firstOrNull$iv) {
                    IProperty it = (IProperty)element$iv3;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)"distributionSha256Sum")) continue;
                    v4 = element$iv3;
                    break block6;
                }
                v4 = null;
            }
            IProperty shaProperty = v4;
            PsiElement psiElement = urlProperty.getPsiElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsiElement(...)");
            IProperty iProperty = shaProperty;
            body.invoke((Object)parsedCurrentGradleVersion, (Object)currentUrl, (Object)psiElement, iProperty != null ? iProperty.getPsiElement() : null);
        }
    }

    @Override
    @NotNull
    protected UsageInfo[] findComponentUsages() {
        List usages = new ArrayList();
        String string = this.getProject().getBasePath();
        if (string != null) {
            String it = string;
            boolean bl = false;
            Collection collection2 = CollectionsKt.listOf((Object)new File(FileUtils.toSystemDependentPath((String)it)));
            List<File> list2 = BuildFileProcessor.getCompositeBuildFolderPaths(this.getProject());
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getCompositeBuildFolderPaths(...)");
            List projectRootFolders = CollectionsKt.plus((Collection)collection2, (Iterable)list2);
            this.forEachGradleVersion(projectRootFolders, (Function4<? super GradleVersion, ? super String, ? super PsiElement, ? super PsiElement, Unit>)((Function4)(arg_0, arg_1, arg_2, arg_3) -> GradleVersionRefactoringProcessor.findComponentUsages$lambda$0$0(this, usages, arg_0, arg_1, arg_2, arg_3)));
        }
        Collection $this$toTypedArray$iv = usages;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new UsageInfo[0]);
    }

    @Override
    @NotNull
    public UpgradeAssistantComponentInfo.Builder completeComponentInfo(@NotNull UpgradeAssistantComponentInfo.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        UpgradeAssistantComponentInfo.Builder builder2 = builder.setKind(UpgradeAssistantComponentInfo.UpgradeAssistantComponentKind.GRADLE_VERSION);
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"setKind(...)");
        return builder2;
    }

    @Override
    @NotNull
    public String getCommandName() {
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)this.compatibleGradleVersion.getVersion().getVersion(), (String)"getVersion(...)");
        return AgpUpgradeBundle.Companion.message("gradleVersionRefactoringProcessor.commandName", objectArray);
    }

    @Override
    @NotNull
    public String getShortDescription() {
        return StringsKt.trimIndent((String)("\n      Version " + this.compatibleGradleVersion.getVersion().getVersion() + " is the minimum version of Gradle compatible\n      with Android Gradle Plugin version " + this.getNew() + ".\n    "));
    }

    @NotNull
    protected String getRefactoringId() {
        return "com.android.tools.agp.upgrade.gradleVersion";
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        return (UsageViewDescriptor)new UsageViewDescriptorAdapter(this){
            final /* synthetic */ GradleVersionRefactoringProcessor this$0;
            {
                this.this$0 = $receiver;
            }

            public PsiElement[] getElements() {
                Intrinsics.checkNotNullExpressionValue((Object)PsiElement.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                return PsiElement.EMPTY_ARRAY;
            }

            public String getProcessedElementsHeader() {
                Object[] objectArray = new Object[1];
                Intrinsics.checkNotNullExpressionValue((Object)this.this$0.getCompatibleGradleVersion().getVersion().getVersion(), (String)"getVersion(...)");
                return AgpUpgradeBundle.Companion.message("gradleVersionRefactoringProcessor.usageView.header", objectArray);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private final String removeEscapingBackslashes(String $this$removeEscapingBackslashes) {
        void $this$filterTo$iv$iv;
        boolean escape = false;
        String $this$filter$iv = $this$removeEscapingBackslashes;
        boolean $i$f$filter = false;
        CharSequence charSequence = $this$filter$iv;
        Appendable destination$iv$iv = new StringBuilder();
        boolean $i$f$filterTo = false;
        int n = $this$filterTo$iv$iv.length();
        for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            boolean bl;
            char element$iv$iv;
            char c = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
            boolean bl2 = false;
            if (escape) {
                it = var13_13 = true;
                boolean bl3 = false;
                escape = false;
                bl = var13_13;
            } else if (c == '\\') {
                it = var13_13 = false;
                boolean bl4 = false;
                escape = true;
                bl = var13_13;
            } else {
                bl = true;
            }
            if (!bl) continue;
            destination$iv$iv.append(element$iv$iv);
        }
        return ((StringBuilder)destination$iv$iv).toString();
    }

    private static final Unit findComponentUsages$lambda$0$0(GradleVersionRefactoringProcessor this$0, List $usages, GradleVersion parsedCurrentGradleVersion, String currentUrl, PsiElement urlPsiElement, PsiElement shaPsiElementOrNull) {
        Intrinsics.checkNotNullParameter((Object)parsedCurrentGradleVersion, (String)"parsedCurrentGradleVersion");
        Intrinsics.checkNotNullParameter((Object)currentUrl, (String)"currentUrl");
        Intrinsics.checkNotNullParameter((Object)urlPsiElement, (String)"urlPsiElement");
        if (this$0.compatibleGradleVersion.getVersion().compareTo(parsedCurrentGradleVersion) > 0) {
            String updatedUrl = GradleWrapper.Companion.getUpdatedDistributionUrl(currentUrl, this$0.compatibleGradleVersion.getVersion(), true);
            WrappedPsiElement wrappedUrlPsiElement = new WrappedPsiElement(urlPsiElement, this$0, GRADLE_URL_USAGE_TYPE, null, 8, null);
            $usages.add(new GradleVersionUsageInfo(wrappedUrlPsiElement, this$0.compatibleGradleVersion.getVersion(), updatedUrl));
            if (shaPsiElementOrNull != null) {
                WrappedPsiElement wrappedShaPsiElement = new WrappedPsiElement(shaPsiElementOrNull, this$0, GRADLE_SHA_256_USAGE_TYPE, null, 8, null);
                boolean isBinaryOnlyDistribution = StringsKt.endsWith$default((String)currentUrl, (String)"-bin.zip", (boolean)false, (int)2, null);
                String updatedSha256 = GradleWrapper.Companion.getDistributionSha256(this$0.compatibleGradleVersion.getVersion(), isBinaryOnlyDistribution);
                $usages.add(new GradleSha256UsageInfo(wrappedShaPsiElement, updatedSha256));
            }
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/gradle/project/upgrade/GradleVersionRefactoringProcessor$Companion;", "", "<init>", "()V", "GRADLE_URL_USAGE_TYPE", "Lcom/intellij/usages/impl/rules/UsageType;", "getGRADLE_URL_USAGE_TYPE", "()Lcom/intellij/usages/impl/rules/UsageType;", "GRADLE_SHA_256_USAGE_TYPE", "getGRADLE_SHA_256_USAGE_TYPE", "intellij.android.projectSystem.gradle.upgrade"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final UsageType getGRADLE_URL_USAGE_TYPE() {
            return GRADLE_URL_USAGE_TYPE;
        }

        @NotNull
        public final UsageType getGRADLE_SHA_256_USAGE_TYPE() {
            return GRADLE_SHA_256_USAGE_TYPE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

