/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.upgrade;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.repository.AgpVersion;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.plugin.AgpVersions;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.project.model.GradleModuleModelKt;
import com.android.tools.idea.gradle.project.sync.idea.AndroidGradleProjectResolver;
import com.android.tools.idea.gradle.project.sync.setup.post.TimeBasedReminder;
import com.android.tools.idea.gradle.project.upgrade.AgpUpgradeBundle;
import com.android.tools.idea.gradle.project.upgrade.AgpUpgradeComponentNecessity;
import com.android.tools.idea.gradle.project.upgrade.AgpUpgradeComponentRefactoringProcessor;
import com.android.tools.idea.gradle.project.upgrade.AgpUpgradeRefactoringProcessor;
import com.android.tools.idea.gradle.project.upgrade.AgpUpgradeRefactoringProcessorKt;
import com.android.tools.idea.gradle.project.upgrade.AndroidGradlePluginCompatibility;
import com.android.tools.idea.gradle.project.upgrade.AndroidGradlePluginCompatibilityKt;
import com.android.tools.idea.gradle.project.upgrade.DeprecatedAgpUpgradeWarning;
import com.android.tools.idea.gradle.project.upgrade.GradlePluginUpgradeState;
import com.android.tools.idea.gradle.project.upgrade.ProjectUpgradeNotification;
import com.android.tools.idea.gradle.project.upgrade.Recommendation;
import com.android.tools.idea.gradle.project.upgrade.RecommendedUpgradeReminder;
import com.android.tools.idea.gradle.project.upgrade.RefactoringProcessorInstantiator;
import com.android.tools.idea.gradle.project.upgrade.UpgradeSuggestion;
import com.android.tools.idea.gradle.repositories.IdeGoogleMavenRepository;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import com.jetbrains.rd.util.CollectionExKt;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u001a0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000bH\u0007\u001a\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f\u001a&\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\t\u001a\u00020\bH\u0007\u001a\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a(\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000bH\u0007\u001a\u0016\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b\u001a\u0016\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b\u001a\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u001a0\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000bH\u0007\u001a\"\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\b2\b\b\u0002\u0010\u0019\u001a\u00020\bH\u0007\u001a8\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000b2\b\b\u0002\u0010\u001c\u001a\u00020\u000f2\b\b\u0002\u0010\u001d\u001a\u00020\u000f\u001a\u000e\u0010\u001e\u001a\u0004\u0018\u00010\u001f*\u00020\u0006H\u0007\u001a\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\bH\u0000\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "shouldRecommendPluginUpgrade", "Lcom/android/tools/idea/gradle/project/upgrade/Recommendation;", "project", "Lcom/intellij/openapi/project/Project;", "current", "Lcom/android/ide/common/repository/AgpVersion;", "latestKnown", "published", "", "recommendPluginUpgrade", "", "strongly", "", "performRecommendedPluginUpgrade", "currentVersion", "isCleanEnoughProject", "shouldRecommendUpgrade", "versionsAreIncompatible", "versionsAreUnsupported", "shouldForcePluginUpgrade", "performForcedPluginUpgrade", "currentPluginVersion", "newPluginVersion", "computeGradlePluginUpgradeState", "Lcom/android/tools/idea/gradle/project/upgrade/GradlePluginUpgradeState;", "supportFutureAgpVersions", "recommendAgpPatchReleases", "findPluginInfo", "Lcom/android/tools/idea/gradle/plugin/AndroidPluginInfo;", "releaseNotesUrl", "", "v", "intellij.android.projectSystem.gradle.upgrade"})
@JvmName(name="GradlePluginUpgrade")
@SourceDebugExtension(value={"SMAP\nGradlePluginUpgrade.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradlePluginUpgrade.kt\ncom/android/tools/idea/gradle/project/upgrade/GradlePluginUpgrade\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,407:1\n1310#2,2:408\n13472#2,2:411\n1#3:410\n1869#4,2:413\n774#4:415\n865#4,2:416\n774#4:418\n865#4,2:419\n774#4:421\n865#4,2:422\n1491#4:424\n1516#4,3:425\n1519#4,3:435\n774#4:438\n865#4,2:439\n774#4:441\n865#4,2:442\n774#4:444\n865#4,2:445\n774#4:447\n865#4,2:448\n295#4,2:478\n382#5,7:428\n382#5,7:454\n382#5,7:468\n996#6:450\n1025#6,3:451\n1028#6,3:461\n996#6:464\n1025#6,3:465\n1028#6,3:475\n*S KotlinDebug\n*F\n+ 1 GradlePluginUpgrade.kt\ncom/android/tools/idea/gradle/project/upgrade/GradlePluginUpgrade\n*L\n104#1:408,2\n170#1:411,2\n256#1:413,2\n293#1:415\n293#1:416,2\n294#1:418\n294#1:419,2\n295#1:421\n295#1:422,2\n296#1:424\n296#1:425,3\n296#1:435,3\n304#1:438\n304#1:439,2\n305#1:441\n305#1:442,2\n306#1:444\n306#1:445,2\n321#1:447\n321#1:448,2\n368#1:478,2\n296#1:428,7\n346#1:454,7\n348#1:468,7\n346#1:450\n346#1:451,3\n346#1:461,3\n348#1:464\n348#1:465,3\n348#1:475,3\n*E\n"})
public final class GradlePluginUpgrade {
    @NotNull
    private static final Logger LOG;

    @Slow
    @NotNull
    public static final Recommendation shouldRecommendPluginUpgrade(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        AndroidPluginInfo androidPluginInfo = GradlePluginUpgrade.findPluginInfo(project);
        if (androidPluginInfo == null || (androidPluginInfo = androidPluginInfo.getPluginVersion()) == null) {
            return new Recommendation(false, false);
        }
        AndroidPluginInfo current = androidPluginInfo;
        AgpVersion latestKnown = AgpVersions.getLatestKnown();
        Set published = IdeGoogleMavenRepository.INSTANCE.getAgpVersions();
        return GradlePluginUpgrade.shouldRecommendPluginUpgrade(project, (AgpVersion)current, latestKnown, published);
    }

    @JvmOverloads
    @NotNull
    public static final Recommendation shouldRecommendPluginUpgrade(@NotNull Project project, @NotNull AgpVersion current, @NotNull AgpVersion latestKnown, @NotNull Set<AgpVersion> published) {
        boolean disableAgpUpgradePrompt;
        Module module;
        Module module2;
        block6: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)current, (String)"current");
            Intrinsics.checkNotNullParameter((Object)latestKnown, (String)"latestKnown");
            Intrinsics.checkNotNullParameter(published, (String)"published");
            if (SystemProperties.getBooleanProperty((String)"studio.skip.agp.upgrade", (boolean)false)) {
                return new Recommendation(false, false);
            }
            Module[] $this$firstOrNull$iv = ModuleManager.Companion.getInstance(project).getModules();
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int i = 0; i < n; ++i) {
                Module element$iv;
                Module it = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                if (!(GradleFacet.getInstance(it) != null)) continue;
                module2 = element$iv;
                break block6;
            }
            module2 = null;
        }
        Module module3 = module = module2;
        if (module3 != null) {
            Module it = module3;
            boolean bl = false;
            v2 = ProjectSystemUtil.getProjectSystem(project).getModuleSystem(it).getDisableAgpUpgradePrompt();
        } else {
            v2 = disableAgpUpgradePrompt = false;
        }
        if (disableAgpUpgradePrompt) {
            return new Recommendation(false, false);
        }
        if (!TimeBasedReminder.shouldAsk$default(new RecommendedUpgradeReminder(project), 0L, 1, null)) {
            return new Recommendation(false, false);
        }
        return GradlePluginUpgrade.shouldRecommendUpgrade(current, latestKnown, published);
    }

    public static /* synthetic */ Recommendation shouldRecommendPluginUpgrade$default(Project project, AgpVersion agpVersion, AgpVersion agpVersion2, Set set2, int n, Object object) {
        if ((n & 8) != 0) {
            set2 = SetsKt.emptySet();
        }
        return GradlePluginUpgrade.shouldRecommendPluginUpgrade(project, agpVersion, agpVersion2, set2);
    }

    public static final void recommendPluginUpgrade(@NotNull Project project, @NotNull AgpVersion current, boolean strongly) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        Notification[] notificationArray = NotificationsManager.getNotificationsManager().getNotificationsOfType(ProjectUpgradeNotification.class, project);
        Intrinsics.checkNotNullExpressionValue((Object)notificationArray, (String)"getNotificationsOfType(...)");
        ProjectUpgradeNotification[] existing = (ProjectUpgradeNotification[])notificationArray;
        if (existing.length == 0) {
            ProjectUpgradeNotification projectUpgradeNotification;
            boolean bl = strongly;
            if (!bl) {
                var6_5 = new Object[]{current};
                projectUpgradeNotification = new UpgradeSuggestion(AgpUpgradeBundle.Companion.message("notification.title", new Object[0]), AgpUpgradeBundle.Companion.message("notification.body", var6_5), project, current);
            } else if (bl) {
                var6_5 = new Object[]{current, "7.0.0"};
                projectUpgradeNotification = new DeprecatedAgpUpgradeWarning(AgpUpgradeBundle.Companion.message("deprecated.notification.title", new Object[0]), AgpUpgradeBundle.Companion.message("deprecated.notification.body", var6_5), project, current);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            ProjectUpgradeNotification notification = projectUpgradeNotification;
            notification.notify(project);
        }
    }

    @Slow
    @JvmOverloads
    public static final void performRecommendedPluginUpgrade(@NotNull Project project, @Nullable AgpVersion currentVersion, @NotNull AgpVersion latestKnown) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)latestKnown, (String)"latestKnown");
        if (currentVersion == null) {
            return;
        }
        LOG.info("Gradle model version: " + currentVersion + ", latest known version for IDE: " + latestKnown);
        Set published = IdeGoogleMavenRepository.INSTANCE.getAgpVersions();
        GradlePluginUpgradeState state2 = GradlePluginUpgrade.computeGradlePluginUpgradeState$default(currentVersion, latestKnown, published, false, false, 24, null);
        LOG.info("Gradle upgrade state: " + state2);
        GradlePluginUpgradeState.Importance[] importanceArray = new GradlePluginUpgradeState.Importance[]{GradlePluginUpgradeState.Importance.RECOMMEND, GradlePluginUpgradeState.Importance.STRONGLY_RECOMMEND};
        if (!SetsKt.setOf((Object[])importanceArray).contains((Object)state2.getImportance())) {
            return;
        }
        AgpUpgradeRefactoringProcessorKt.showAndInvokeAgpUpgradeRefactoringProcessor(project, currentVersion, state2.getTarget());
    }

    public static /* synthetic */ void performRecommendedPluginUpgrade$default(Project project, AgpVersion agpVersion, AgpVersion agpVersion2, int n, Object object) {
        if ((n & 2) != 0) {
            AndroidPluginInfo androidPluginInfo = GradlePluginUpgrade.findPluginInfo(project);
            Object object2 = agpVersion = androidPluginInfo != null ? androidPluginInfo.getPluginVersion() : null;
        }
        if ((n & 4) != 0) {
            agpVersion2 = AgpVersions.getLatestKnown();
        }
        GradlePluginUpgrade.performRecommendedPluginUpgrade(project, agpVersion, agpVersion2);
    }

    public static final boolean isCleanEnoughProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Module[] $this$forEach$iv = ModuleManager.Companion.getInstance(project).getModules();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Module element$iv;
            Module module = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            GradleModuleModel gradleModuleModel = GradleModuleModelKt.getGradleModuleModel(module);
            if (gradleModuleModel == null || (gradleModuleModel = gradleModuleModel.buildFileAsVirtualFile()) == null) continue;
            GradleModuleModel buildFile = gradleModuleModel;
            if (Intrinsics.areEqual((Object)FileStatusManager.getInstance((Project)project).getStatus((VirtualFile)buildFile), (Object)FileStatus.NOT_CHANGED)) continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    @JvmOverloads
    @NotNull
    public static final Recommendation shouldRecommendUpgrade(@NotNull AgpVersion current, @NotNull AgpVersion latestKnown, @NotNull Set<AgpVersion> published) {
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        Intrinsics.checkNotNullParameter((Object)latestKnown, (String)"latestKnown");
        Intrinsics.checkNotNullParameter(published, (String)"published");
        GradlePluginUpgradeState.Importance importance = GradlePluginUpgrade.computeGradlePluginUpgradeState$default(current, latestKnown, published, false, false, 24, null).getImportance();
        boolean bl = false;
        GradlePluginUpgradeState.Importance[] importanceArray = new GradlePluginUpgradeState.Importance[]{GradlePluginUpgradeState.Importance.RECOMMEND, GradlePluginUpgradeState.Importance.STRONGLY_RECOMMEND};
        return new Recommendation(SetsKt.setOf((Object[])importanceArray).contains((Object)importance), importance == GradlePluginUpgradeState.Importance.STRONGLY_RECOMMEND);
    }

    public static /* synthetic */ Recommendation shouldRecommendUpgrade$default(AgpVersion agpVersion, AgpVersion agpVersion2, Set set2, int n, Object object) {
        if ((n & 4) != 0) {
            set2 = SetsKt.emptySet();
        }
        return GradlePluginUpgrade.shouldRecommendUpgrade(agpVersion, agpVersion2, set2);
    }

    public static final boolean versionsAreIncompatible(@NotNull AgpVersion current, @NotNull AgpVersion latestKnown) {
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        Intrinsics.checkNotNullParameter((Object)latestKnown, (String)"latestKnown");
        Object[] objectArray = new AndroidGradlePluginCompatibility[]{AndroidGradlePluginCompatibility.COMPATIBLE, AndroidGradlePluginCompatibility.DEPRECATED, AndroidGradlePluginCompatibility.OBSOLETE};
        return !SetsKt.setOf((Object[])objectArray).contains(AndroidGradlePluginCompatibilityKt.computeAndroidGradlePluginCompatibility((AgpVersion)current, (AgpVersion)latestKnown));
    }

    public static final boolean versionsAreUnsupported(@NotNull AgpVersion current, @NotNull AgpVersion latestKnown) {
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        Intrinsics.checkNotNullParameter((Object)latestKnown, (String)"latestKnown");
        Object[] objectArray = new AndroidGradlePluginCompatibility[]{AndroidGradlePluginCompatibility.COMPATIBLE, AndroidGradlePluginCompatibility.DEPRECATED};
        return !SetsKt.setOf((Object[])objectArray).contains(AndroidGradlePluginCompatibilityKt.computeAndroidGradlePluginCompatibility((AgpVersion)current, (AgpVersion)latestKnown));
    }

    @Slow
    public static final boolean shouldForcePluginUpgrade(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        AndroidPluginInfo androidPluginInfo = GradlePluginUpgrade.findPluginInfo(project);
        if (androidPluginInfo == null || (androidPluginInfo = androidPluginInfo.getPluginVersion()) == null) {
            return false;
        }
        AndroidPluginInfo current = androidPluginInfo;
        AgpVersion latestKnown = AgpVersions.getLatestKnown();
        Set published = IdeGoogleMavenRepository.INSTANCE.getAgpVersions();
        return GradlePluginUpgrade.shouldForcePluginUpgrade(project, (AgpVersion)current, latestKnown, published);
    }

    @JvmOverloads
    public static final boolean shouldForcePluginUpgrade(@NotNull Project project, @NotNull AgpVersion current, @NotNull AgpVersion latestKnown, @NotNull Set<AgpVersion> published) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        Intrinsics.checkNotNullParameter((Object)latestKnown, (String)"latestKnown");
        Intrinsics.checkNotNullParameter(published, (String)"published");
        if (SystemProperties.getBooleanProperty((String)"studio.skip.agp.upgrade", (boolean)false)) {
            return false;
        }
        if (AndroidGradleProjectResolver.Companion.shouldDisableForceUpgrades()) {
            return false;
        }
        GradlePluginUpgradeState state2 = GradlePluginUpgrade.computeGradlePluginUpgradeState$default(current, latestKnown, published, false, false, 24, null);
        return state2.getImportance() == GradlePluginUpgradeState.Importance.FORCE;
    }

    public static /* synthetic */ boolean shouldForcePluginUpgrade$default(Project project, AgpVersion agpVersion, AgpVersion agpVersion2, Set set2, int n, Object object) {
        if ((n & 8) != 0) {
            set2 = SetsKt.emptySet();
        }
        return GradlePluginUpgrade.shouldForcePluginUpgrade(project, agpVersion, agpVersion2, set2);
    }

    /*
     * WARNING - void declaration
     */
    @Slow
    public static final void performForcedPluginUpgrade(@NotNull Project project, @NotNull AgpVersion currentPluginVersion, @NotNull AgpVersion newPluginVersion) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)currentPluginVersion, (String)"currentPluginVersion");
        Intrinsics.checkNotNullParameter((Object)newPluginVersion, (String)"newPluginVersion");
        RefactoringProcessorInstantiator refactoringProcessorInstantiator = (RefactoringProcessorInstantiator)project.getService(RefactoringProcessorInstantiator.class);
        AgpUpgradeRefactoringProcessor processor = refactoringProcessorInstantiator.createProcessor(project, currentPluginVersion, newPluginVersion);
        Iterable $this$forEach$iv = processor.getComponentRefactoringProcessors();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void it;
            AgpUpgradeComponentRefactoringProcessor component = (AgpUpgradeComponentRefactoringProcessor)((Object)element$iv);
            boolean bl = false;
            AgpUpgradeComponentNecessity agpUpgradeComponentNecessity = component.necessity();
            AgpUpgradeComponentRefactoringProcessor agpUpgradeComponentRefactoringProcessor = component;
            boolean bl2 = false;
            agpUpgradeComponentRefactoringProcessor.setEnabled(it == AgpUpgradeComponentNecessity.MANDATORY_CODEPENDENT || it == AgpUpgradeComponentNecessity.MANDATORY_INDEPENDENT);
        }
        boolean runProcessor = refactoringProcessorInstantiator.showAndGetAgpUpgradeDialog(processor);
        if (runProcessor) {
            DumbService.Companion.getInstance(project).smartInvokeLater(() -> GradlePluginUpgrade.performForcedPluginUpgrade$lambda$1(processor));
            return;
        }
    }

    public static /* synthetic */ void performForcedPluginUpgrade$default(Project project, AgpVersion agpVersion, AgpVersion agpVersion2, int n, Object object) {
        if ((n & 4) != 0) {
            agpVersion2 = GradlePluginUpgrade.computeGradlePluginUpgradeState$default(agpVersion, AgpVersions.getLatestKnown(), IdeGoogleMavenRepository.INSTANCE.getAgpVersions(), false, false, 24, null).getTarget();
        }
        GradlePluginUpgrade.performForcedPluginUpgrade(project, agpVersion, agpVersion2);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public static final GradlePluginUpgradeState computeGradlePluginUpgradeState(@NotNull AgpVersion current, @NotNull AgpVersion latestKnown, @NotNull Set<AgpVersion> published, boolean supportFutureAgpVersions, boolean recommendAgpPatchReleases) {
        block52: {
            block51: {
                Intrinsics.checkNotNullParameter((Object)current, (String)"current");
                Intrinsics.checkNotNullParameter((Object)latestKnown, (String)"latestKnown");
                Intrinsics.checkNotNullParameter(published, (String)"published");
                if (supportFutureAgpVersions && current.compareTo(latestKnown) > 0) {
                    return new GradlePluginUpgradeState(GradlePluginUpgradeState.Importance.NO_UPGRADE, current);
                }
                compatibility = AndroidGradlePluginCompatibilityKt.computeAndroidGradlePluginCompatibility((AgpVersion)current, (AgpVersion)latestKnown);
                switch (WhenMappings.$EnumSwitchMapping$0[compatibility.ordinal()]) {
                    case 1: 
                    case 2: {
                        minimum = AgpVersion.Companion.parse("4.2.0");
                        var11_9 = published;
                        $i$f$filter = false;
                        var13_19 = $this$filter$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (AgpVersion)element$iv$iv;
                            $i$a$-filter-GradlePluginUpgrade$computeGradlePluginUpgradeState$earliestStable$1 = false;
                            if (!(it.isPreview() == false)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filter$iv = (List)destination$iv$iv;
                        $i$f$filter = false;
                        $this$filterTo$iv$iv = $this$filter$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (AgpVersion)element$iv$iv;
                            $i$a$-filter-GradlePluginUpgrade$computeGradlePluginUpgradeState$earliestStable$2 = false;
                            if (!(it.compareTo(minimum) >= 0)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filter$iv = (List)destination$iv$iv;
                        $i$f$filter = false;
                        $this$filterTo$iv$iv = $this$filter$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (AgpVersion)element$iv$iv;
                            $i$a$-filter-GradlePluginUpgrade$computeGradlePluginUpgradeState$earliestStable$3 = false;
                            if (!(it.compareTo(latestKnown) <= 0)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filter$iv = (List)destination$iv$iv;
                        $i$f$groupBy = false;
                        $this$filterTo$iv$iv = $this$groupBy$iv;
                        destination$iv$iv = new LinkedHashMap<K, V>();
                        $i$f$groupByTo = false;
                        var16_35 = $this$groupByTo$iv$iv.iterator();
                        while (var16_35.hasNext()) {
                            element$iv$iv = var16_35.next();
                            it = (AgpVersion)element$iv$iv;
                            $i$a$-groupBy-GradlePluginUpgrade$computeGradlePluginUpgradeState$earliestStable$4 = false;
                            key$iv$iv = new AgpVersion(it.getMajor(), it.getMinor(), 0, 4, null);
                            $this$getOrPut$iv$iv$iv = destination$iv$iv;
                            $i$f$getOrPut = false;
                            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                            if (value$iv$iv$iv == null) {
                                $i$a$-getOrPut-CollectionsKt___CollectionsKt$groupByTo$list$1$iv$iv = false;
                                answer$iv$iv$iv = new ArrayList<E>();
                                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                                v0 /* !! */  = answer$iv$iv$iv;
                            } else {
                                v0 /* !! */  = value$iv$iv$iv;
                            }
                            list$iv$iv = (List)v0 /* !! */ ;
                            list$iv$iv.add(element$iv$iv);
                        }
                        $i$f$groupBy = destination$iv$iv.entrySet();
                        $this$groupByTo$iv$iv = $i$f$groupBy.iterator();
                        if (!$this$groupByTo$iv$iv.hasNext()) {
                            v1 = null;
                        } else {
                            destination$iv$iv = $this$groupByTo$iv$iv.next();
                            if (!$this$groupByTo$iv$iv.hasNext()) {
                                v1 = destination$iv$iv;
                            } else {
                                it = (Map.Entry)destination$iv$iv;
                                $i$a$-minByOrNull-GradlePluginUpgrade$computeGradlePluginUpgradeState$earliestStable$5 = false;
                                it = (Comparable)((AgpVersion)it.getKey());
                                do {
                                    $i$a$-minByOrNull-GradlePluginUpgrade$computeGradlePluginUpgradeState$earliestStable$5 = $this$groupByTo$iv$iv.next();
                                    it = (Map.Entry)$i$a$-minByOrNull-GradlePluginUpgrade$computeGradlePluginUpgradeState$earliestStable$5;
                                    $i$a$-minByOrNull-GradlePluginUpgrade$computeGradlePluginUpgradeState$earliestStable$5 = false;
                                    if (it.compareTo(it = (Comparable)((AgpVersion)it.getKey())) <= 0) continue;
                                    destination$iv$iv = $i$a$-minByOrNull-GradlePluginUpgrade$computeGradlePluginUpgradeState$earliestStable$5;
                                    it = it;
                                } while ($this$groupByTo$iv$iv.hasNext());
                                v1 = destination$iv$iv;
                            }
                        }
                        var10_62 = (Map.Entry)v1;
                        earliestStable = var10_62 != null && ($this$groupBy$iv = (List)var10_62.getValue()) != null ? (AgpVersion)CollectionsKt.maxOrNull((Iterable)$this$groupBy$iv) : null;
                        v2 = earliestStable;
                        if (v2 == null) {
                            v2 = latestKnown;
                        }
                        return new GradlePluginUpgradeState(GradlePluginUpgradeState.Importance.FORCE, v2);
                    }
                    case 3: {
                        earliestStable = published;
                        $i$f$filter = false;
                        $this$groupBy$iv = $this$filter$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (AgpVersion)element$iv$iv;
                            $i$a$-filter-GradlePluginUpgrade$computeGradlePluginUpgradeState$seriesAcceptableStable$1 = false;
                            if (!(it.isPreview() == false)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filter$iv = (List)destination$iv$iv;
                        $i$f$filter = false;
                        $this$filterTo$iv$iv = $this$filter$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (AgpVersion)element$iv$iv;
                            $i$a$-filter-GradlePluginUpgrade$computeGradlePluginUpgradeState$seriesAcceptableStable$2 = false;
                            if (!Intrinsics.areEqual((Object)new AgpVersion(it.getMajor(), it.getMinor(), 0, 4, null), (Object)new AgpVersion(current.getMajor(), current.getMinor(), 0, 4, null))) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filter$iv = (List)destination$iv$iv;
                        $i$f$filter = false;
                        $this$filterTo$iv$iv = $this$filter$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (AgpVersion)element$iv$iv;
                            $i$a$-filter-GradlePluginUpgrade$computeGradlePluginUpgradeState$seriesAcceptableStable$3 = false;
                            if (!(it.compareTo(latestKnown) <= 0)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        seriesAcceptableStable = (AgpVersion)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv));
                        v3 = seriesAcceptableStable;
                        if (v3 == null) {
                            v3 = latestKnown;
                        }
                        return new GradlePluginUpgradeState(GradlePluginUpgradeState.Importance.FORCE, v3);
                    }
                    case 4: {
                        return new GradlePluginUpgradeState(GradlePluginUpgradeState.Importance.FORCE, latestKnown);
                    }
                    case 5: 
                    case 6: {
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                if (!recommendAgpPatchReleases || latestKnown.isPreview()) break block51;
                seriesAcceptableStable = published;
                $i$f$filter = false;
                $i$f$filter = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (AgpVersion)element$iv$iv;
                    $i$a$-filter-GradlePluginUpgrade$computeGradlePluginUpgradeState$latestKnown$1 = false;
                    if (!Intrinsics.areEqual((Object)new AgpVersion(it.getMajor(), it.getMinor(), 0, 4, null), (Object)new AgpVersion(latestKnown.getMajor(), latestKnown.getMinor(), 0, 4, null))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                var7_72 = (AgpVersion)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv));
                if (var7_72 == null) ** GOTO lbl-1000
                it = $i$f$filter = var7_72;
                $i$a$-takeIf-GradlePluginUpgrade$computeGradlePluginUpgradeState$latestKnown$2 = false;
                v4 /* !! */  = $this$filter$iv = it.compareTo(latestKnown) > 0 != false ? $i$f$filter : null;
                if ($this$filter$iv != null) {
                    v5 = $this$filter$iv;
                } else lbl-1000:
                // 2 sources

                {
                    v5 = latestKnown;
                }
                break block52;
            }
            v5 = latestKnown = latestKnown;
        }
        if (current.compareTo(latestKnown) >= 0) {
            return new GradlePluginUpgradeState(GradlePluginUpgradeState.Importance.NO_UPGRADE, current);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[compatibility.ordinal()]) {
            case 6: {
                v6 = GradlePluginUpgradeState.Importance.STRONGLY_RECOMMEND;
                break;
            }
            case 5: {
                v6 = GradlePluginUpgradeState.Importance.RECOMMEND;
                break;
            }
            default: {
                throw new IllegalStateException("Unreachable: forced upgrade state previously handled");
            }
        }
        recommendationStrength = v6;
        if (!current.isPreview() || Intrinsics.areEqual((Object)current.getPreviewType(), (Object)"rc")) {
            block50: {
                $i$f$filter = SequencesKt.sorted((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)published), (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, computeGradlePluginUpgradeState$lambda$10(com.android.ide.common.repository.AgpVersion ), (Lcom/android/ide/common/repository/AgpVersion;)Ljava/lang/Boolean;)()), (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, computeGradlePluginUpgradeState$lambda$11(com.android.ide.common.repository.AgpVersion com.android.ide.common.repository.AgpVersion ), (Lcom/android/ide/common/repository/AgpVersion;)Ljava/lang/Boolean;)((AgpVersion)current)), (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, computeGradlePluginUpgradeState$lambda$12(com.android.ide.common.repository.AgpVersion com.android.ide.common.repository.AgpVersion ), (Lcom/android/ide/common/repository/AgpVersion;)Ljava/lang/Boolean;)((AgpVersion)latestKnown)));
                $i$f$groupBy = false;
                $i$a$-takeIf-GradlePluginUpgrade$computeGradlePluginUpgradeState$latestKnown$2 = $this$groupBy$iv;
                destination$iv$iv = new LinkedHashMap<K, V>();
                $i$f$groupByTo = false;
                for (E element$iv$iv : $this$groupByTo$iv$iv) {
                    it = (AgpVersion)element$iv$iv;
                    $i$a$-groupBy-GradlePluginUpgrade$computeGradlePluginUpgradeState$acceptableStables$4 = false;
                    key$iv$iv /* !! */  = new AgpVersion(it.getMajor(), it.getMinor(), 0, 4, null);
                    $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    $i$f$getOrPut = false;
                    value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv /* !! */ );
                    if (value$iv$iv$iv == null) {
                        $i$a$-getOrPut-SequencesKt___SequencesKt$groupByTo$list$1$iv$iv = false;
                        answer$iv$iv$iv = new ArrayList<E>();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv /* !! */ , answer$iv$iv$iv);
                        v7 /* !! */  = answer$iv$iv$iv;
                    } else {
                        v7 /* !! */  = value$iv$iv$iv;
                    }
                    list$iv$iv = (List)v7 /* !! */ ;
                    list$iv$iv.add(element$iv$iv);
                }
                $this$groupBy$iv = MapsKt.asSequence((Map)destination$iv$iv);
                $i$f$groupBy = false;
                $this$groupByTo$iv$iv = $this$groupBy$iv;
                destination$iv$iv = new LinkedHashMap<K, V>();
                $i$f$groupByTo = false;
                for (E element$iv$iv : $this$groupByTo$iv$iv) {
                    it = (Map.Entry)element$iv$iv;
                    $i$a$-groupBy-GradlePluginUpgrade$computeGradlePluginUpgradeState$acceptableStables$5 = false;
                    key$iv$iv /* !! */  = Integer.valueOf(((AgpVersion)it.getKey()).getMajor());
                    $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    $i$f$getOrPut = false;
                    value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv /* !! */ );
                    if (value$iv$iv$iv == null) {
                        $i$a$-getOrPut-SequencesKt___SequencesKt$groupByTo$list$1$iv$iv = false;
                        answer$iv$iv$iv = new ArrayList<E>();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv /* !! */ , answer$iv$iv$iv);
                        v8 /* !! */  = answer$iv$iv$iv;
                    } else {
                        v8 /* !! */  = value$iv$iv$iv;
                    }
                    list$iv$iv = (List)v8 /* !! */ ;
                    list$iv$iv.add(element$iv$iv);
                }
                acceptableStables = destination$iv$iv;
                if (acceptableStables.isEmpty()) {
                    return latestKnown.isPreview() == false ? new GradlePluginUpgradeState(recommendationStrength, latestKnown) : (Intrinsics.areEqual((Object)latestKnown.getPreviewType(), (Object)"rc") != false ? new GradlePluginUpgradeState(recommendationStrength, latestKnown) : new GradlePluginUpgradeState(GradlePluginUpgradeState.Importance.NO_UPGRADE, current));
                }
                if (!acceptableStables.containsKey(current.getMajor())) {
                    return new GradlePluginUpgradeState(recommendationStrength, (AgpVersion)CollectionsKt.last((List)((List)((Map.Entry)CollectionsKt.last((List)((List)CollectionExKt.first((Map)acceptableStables).getValue()))).getValue())));
                }
                v9 = acceptableStables.get(current.getMajor());
                Intrinsics.checkNotNull(v9);
                currentSeriesCandidates = (List)v9;
                $this$firstOrNull$iv = acceptableStables.keySet();
                $i$f$firstOrNull = false;
                for (E element$iv : $this$firstOrNull$iv) {
                    it = ((Number)element$iv).intValue();
                    $i$a$-firstOrNull-GradlePluginUpgrade$computeGradlePluginUpgradeState$nextSeriesCandidates$1 = false;
                    if (!(it > current.getMajor())) continue;
                    v10 = element$iv;
                    break block50;
                }
                v10 = null;
            }
            v11 = v10;
            if (v11 != null) {
                it = ((Number)v11).intValue();
                $i$a$-let-GradlePluginUpgrade$computeGradlePluginUpgradeState$nextSeriesCandidates$2 = false;
                v12 = acceptableStables.get(it);
                Intrinsics.checkNotNull(v12);
                v13 = (List)v12;
            } else {
                v13 = null;
            }
            nextSeriesCandidates = v13;
            var12_18 = ((Iterable)currentSeriesCandidates).iterator();
            if (!var12_18.hasNext()) {
                throw new NoSuchElementException();
            }
            it = (Map.Entry)var12_18.next();
            $i$a$-maxOf-GradlePluginUpgrade$computeGradlePluginUpgradeState$1 = false;
            var13_23 = (Comparable)((AgpVersion)it.getKey());
            while (var12_18.hasNext()) {
                it = (Map.Entry)var12_18.next();
                $i$a$-maxOf-GradlePluginUpgrade$computeGradlePluginUpgradeState$1 = false;
                var14_29 = (Comparable)((AgpVersion)it.getKey());
                if (var13_23.compareTo(var14_29) >= 0) continue;
                var13_23 = var14_29;
            }
            if (Intrinsics.areEqual((Object)var13_23, (Object)new AgpVersion(current.getMajor(), current.getMinor(), 0, 4, null))) {
                v14 = nextSeriesCandidates;
                if (v14 == null) {
                    v14 = currentSeriesCandidates;
                }
                return new GradlePluginUpgradeState(recommendationStrength, (AgpVersion)CollectionsKt.last((List)((List)((Map.Entry)CollectionsKt.last((List)v14)).getValue())));
            }
            return new GradlePluginUpgradeState(recommendationStrength, (AgpVersion)CollectionsKt.last((List)((List)((Map.Entry)CollectionsKt.last((List)currentSeriesCandidates)).getValue())));
        }
        if (Intrinsics.areEqual((Object)current.getPreviewType(), (Object)"alpha") || Intrinsics.areEqual((Object)current.getPreviewType(), (Object)"beta")) {
            if (latestKnown.isSnapshot()) {
                if (latestKnown.compareIgnoringQualifiers(current) == 0) {
                    return new GradlePluginUpgradeState(GradlePluginUpgradeState.Importance.NO_UPGRADE, current);
                }
                return new GradlePluginUpgradeState(recommendationStrength, latestKnown);
            }
            throw new IllegalStateException("Unreachable: forced upgrade state previously handled");
        }
        throw new IllegalStateException("Unreachable: forced upgrade state previously handled");
    }

    public static /* synthetic */ GradlePluginUpgradeState computeGradlePluginUpgradeState$default(AgpVersion agpVersion, AgpVersion agpVersion2, Set set2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 8) != 0) {
            Object t = StudioFlags.SUPPORT_FUTURE_AGP_VERSIONS.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            bl = (Boolean)t;
        }
        if ((n & 0x10) != 0) {
            Object t = StudioFlags.RECOMMEND_AGP_PATCH_RELEASES.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            bl2 = (Boolean)t;
        }
        return GradlePluginUpgrade.computeGradlePluginUpgradeState(agpVersion, agpVersion2, set2, bl, bl2);
    }

    @Slow
    @Nullable
    public static final AndroidPluginInfo findPluginInfo(@NotNull Project $this$findPluginInfo) {
        Intrinsics.checkNotNullParameter((Object)$this$findPluginInfo, (String)"<this>");
        AndroidPluginInfo pluginInfo = AndroidPluginInfo.find($this$findPluginInfo);
        if (pluginInfo == null) {
            LOG.warn("Unable to obtain application's Android Project");
            return null;
        }
        return pluginInfo;
    }

    @NotNull
    public static final String releaseNotesUrl(@NotNull AgpVersion v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return v.isPreview() ? "https://developer.android.com/studio/preview/features#android_gradle_plugin_" + v.getMajor() + v.getMinor() : "https://developer.android.com/studio/releases/gradle-plugin#" + v.getMajor() + "-" + v.getMinor() + "-0";
    }

    @JvmOverloads
    @NotNull
    public static final Recommendation shouldRecommendPluginUpgrade(@NotNull Project project, @NotNull AgpVersion current, @NotNull AgpVersion latestKnown) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        Intrinsics.checkNotNullParameter((Object)latestKnown, (String)"latestKnown");
        return GradlePluginUpgrade.shouldRecommendPluginUpgrade$default(project, current, latestKnown, null, 8, null);
    }

    @Slow
    @JvmOverloads
    public static final void performRecommendedPluginUpgrade(@NotNull Project project, @Nullable AgpVersion currentVersion) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GradlePluginUpgrade.performRecommendedPluginUpgrade$default(project, currentVersion, null, 4, null);
    }

    @Slow
    @JvmOverloads
    public static final void performRecommendedPluginUpgrade(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GradlePluginUpgrade.performRecommendedPluginUpgrade$default(project, null, null, 6, null);
    }

    @VisibleForTesting
    @JvmOverloads
    @NotNull
    public static final Recommendation shouldRecommendUpgrade(@NotNull AgpVersion current, @NotNull AgpVersion latestKnown) {
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        Intrinsics.checkNotNullParameter((Object)latestKnown, (String)"latestKnown");
        return GradlePluginUpgrade.shouldRecommendUpgrade$default(current, latestKnown, null, 4, null);
    }

    @JvmOverloads
    public static final boolean shouldForcePluginUpgrade(@NotNull Project project, @NotNull AgpVersion current, @NotNull AgpVersion latestKnown) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        Intrinsics.checkNotNullParameter((Object)latestKnown, (String)"latestKnown");
        return GradlePluginUpgrade.shouldForcePluginUpgrade$default(project, current, latestKnown, null, 8, null);
    }

    private static final void performForcedPluginUpgrade$lambda$1(AgpUpgradeRefactoringProcessor $processor) {
        $processor.run();
    }

    private static final boolean computeGradlePluginUpgradeState$lambda$10(AgpVersion it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !it.isPreview();
    }

    private static final boolean computeGradlePluginUpgradeState$lambda$11(AgpVersion $current, AgpVersion it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.compareTo($current) > 0;
    }

    private static final boolean computeGradlePluginUpgradeState$lambda$12(AgpVersion $latestKnown, AgpVersion it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.compareTo($latestKnown) <= 0;
    }

    static {
        Logger logger = Logger.getInstance((String)"Upgrade Assistant");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AndroidGradlePluginCompatibility.values().length];
            try {
                nArray[AndroidGradlePluginCompatibility.BEFORE_MINIMUM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AndroidGradlePluginCompatibility.OBSOLETE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AndroidGradlePluginCompatibility.DIFFERENT_PREVIEW.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AndroidGradlePluginCompatibility.AFTER_MAXIMUM.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AndroidGradlePluginCompatibility.COMPATIBLE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AndroidGradlePluginCompatibility.DEPRECATED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

