/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.upgrade;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.repository.AgpVersion;
import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.plugin.AgpVersions;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.project.upgrade.AgpUpgradeComponentRefactoringProcessor;
import com.android.tools.idea.gradle.project.upgrade.AgpUpgradeRefactoringProcessor;
import com.android.tools.idea.gradle.project.upgrade.AgpUpgradeRefactoringProcessorWithCompileRuntimeSpecialCaseDialog;
import com.android.tools.idea.gradle.project.upgrade.AssistantInvoker;
import com.android.tools.idea.gradle.project.upgrade.AssistantInvokerImplKt;
import com.android.tools.idea.gradle.project.upgrade.CompileRuntimeConfigurationRefactoringProcessor;
import com.android.tools.idea.gradle.project.upgrade.GradlePluginUpgrade;
import com.android.tools.idea.gradle.project.upgrade.ProjectUpgradeNotification;
import com.android.tools.idea.gradle.project.upgrade.Recommendation;
import com.android.tools.idea.gradle.project.upgrade.WrappedPsiElement;
import com.android.tools.idea.gradle.repositories.IdeGoogleMavenRepository;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.psi.PsiElement;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J,\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00100\u000fH\u0007J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0017\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/gradle/project/upgrade/AssistantInvokerImpl;", "Lcom/android/tools/idea/gradle/project/upgrade/AssistantInvoker;", "<init>", "()V", "performDeprecatedConfigurationsUpgrade", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/psi/PsiElement;", "showAndGetDeprecatedConfigurationsUpgradeDialog", "", "processor", "Lcom/android/tools/idea/gradle/project/upgrade/AgpUpgradeRefactoringProcessor;", "dialogFactory", "Lkotlin/Function1;", "Lcom/android/tools/idea/gradle/project/upgrade/AgpUpgradeRefactoringProcessorWithCompileRuntimeSpecialCaseDialog;", "maybeForceOrRecommendPluginUpgrade", "info", "Lcom/android/tools/idea/gradle/plugin/AndroidPluginInfo;", "expireProjectUpgradeNotifications", "displayForceUpdatesDisabledMessage", "performRecommendedPluginUpgrade", "shouldRecommendPluginUpgradeToLatest", "intellij.android.projectSystem.gradle.upgrade"})
@SourceDebugExtension(value={"SMAP\nAssistantInvokerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AssistantInvokerImpl.kt\ncom/android/tools/idea/gradle/project/upgrade/AssistantInvokerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,115:1\n1#2:116\n13472#3,2:117\n*S KotlinDebug\n*F\n+ 1 AssistantInvokerImpl.kt\ncom/android/tools/idea/gradle/project/upgrade/AssistantInvokerImpl\n*L\n93#1:117,2\n*E\n"})
public final class AssistantInvokerImpl
implements AssistantInvoker {
    @Override
    @Slow
    public void performDeprecatedConfigurationsUpgrade(@NotNull Project project, @NotNull PsiElement element) {
        AndroidPluginInfo current;
        AgpUpgradeRefactoringProcessor processor;
        boolean runProcessor;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        AgpVersion recommended = AgpVersions.getLatestKnown();
        AndroidPluginInfo androidPluginInfo = AndroidPluginInfo.find(project);
        if (androidPluginInfo == null || (androidPluginInfo = androidPluginInfo.getPluginVersion()) == null) {
            androidPluginInfo = recommended;
        }
        if (runProcessor = this.showAndGetDeprecatedConfigurationsUpgradeDialog(processor = new AgpUpgradeRefactoringProcessor(project, (AgpVersion)(current = androidPluginInfo), recommended), element, (Function1<? super AgpUpgradeRefactoringProcessor, ? extends AgpUpgradeRefactoringProcessorWithCompileRuntimeSpecialCaseDialog>)((Function1)AssistantInvokerImpl::performDeprecatedConfigurationsUpgrade$lambda$0))) {
            DumbService.Companion.getInstance(project).smartInvokeLater(() -> AssistantInvokerImpl.performDeprecatedConfigurationsUpgrade$lambda$1(processor));
        }
    }

    @Slow
    @VisibleForTesting
    public final boolean showAndGetDeprecatedConfigurationsUpgradeDialog(@NotNull AgpUpgradeRefactoringProcessor processor, @NotNull PsiElement element, @NotNull Function1<? super AgpUpgradeRefactoringProcessor, ? extends AgpUpgradeRefactoringProcessorWithCompileRuntimeSpecialCaseDialog> dialogFactory) {
        CompileRuntimeConfigurationRefactoringProcessor compileRuntimeProcessor;
        block2: {
            CompileRuntimeConfigurationRefactoringProcessor compileRuntimeConfigurationRefactoringProcessor;
            Intrinsics.checkNotNullParameter((Object)((Object)processor), (String)"processor");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter(dialogFactory, (String)"dialogFactory");
            for (AgpUpgradeComponentRefactoringProcessor it : (Iterable)processor.getComponentRefactoringProcessors()) {
                boolean bl = false;
                CompileRuntimeConfigurationRefactoringProcessor compileRuntimeConfigurationRefactoringProcessor2 = it instanceof CompileRuntimeConfigurationRefactoringProcessor ? (CompileRuntimeConfigurationRefactoringProcessor)it : null;
                if (compileRuntimeConfigurationRefactoringProcessor2 == null) continue;
                compileRuntimeConfigurationRefactoringProcessor = compileRuntimeConfigurationRefactoringProcessor2;
                break block2;
            }
            compileRuntimeConfigurationRefactoringProcessor = compileRuntimeProcessor = null;
        }
        if (compileRuntimeProcessor == null) {
            AssistantInvokerImplKt.access$getLOG$p().error("no CompileRuntimeConfiguration processor found in AGP Upgrade Processor");
        }
        processor.setCommandName("Replace Deprecated Configurations");
        CompileRuntimeConfigurationRefactoringProcessor compileRuntimeConfigurationRefactoringProcessor = compileRuntimeProcessor;
        Intrinsics.checkNotNull(compileRuntimeConfigurationRefactoringProcessor);
        WrappedPsiElement wrappedElement = new WrappedPsiElement(element, compileRuntimeConfigurationRefactoringProcessor, null, "Upgrading deprecated configurations");
        processor.getTargets().add(wrappedElement);
        processor.ensureParsedModels();
        boolean runProcessor = (Boolean)ActionsKt.invokeAndWaitIfNeeded((ModalityState)ModalityState.nonModal(), () -> AssistantInvokerImpl.showAndGetDeprecatedConfigurationsUpgradeDialog$lambda$1(dialogFactory, processor));
        return runProcessor;
    }

    @Override
    public void maybeForceOrRecommendPluginUpgrade(@NotNull Project project, @NotNull AndroidPluginInfo info) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            AgpVersion agpVersion = info.getPluginVersion();
            if (agpVersion == null) break block0;
            AgpVersion currentAgpVersion = agpVersion;
            boolean bl = false;
            AgpVersion latestKnown = AgpVersions.getLatestKnown();
            FutureUtils.executeOnPooledThread(() -> AssistantInvokerImpl.maybeForceOrRecommendPluginUpgrade$lambda$0$0(project, currentAgpVersion, latestKnown));
        }
    }

    @Override
    public void expireProjectUpgradeNotifications(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Notification[] notificationArray = NotificationsManager.getNotificationsManager().getNotificationsOfType(ProjectUpgradeNotification.class, project);
        Intrinsics.checkNotNullExpressionValue((Object)notificationArray, (String)"getNotificationsOfType(...)");
        Object[] $this$forEach$iv = notificationArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProjectUpgradeNotification it = (ProjectUpgradeNotification)((Object)element$iv);
            boolean bl = false;
            it.expire(false);
        }
    }

    @Override
    public void displayForceUpdatesDisabledMessage(@NotNull Project project) {
        block2: {
            Notification notification;
            Notification notification2;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            String msg = "Forced upgrades are disabled, errors seen may be due to incompatibilities between the Android Gradle Plugin and the version of Android Studio.\nTo re-enable forced updates please go to 'Tools > Internal Actions > Edit Studio Flags' and set '" + StudioFlags.DISABLE_FORCED_UPGRADES.getDisplayName() + "' to 'Off'.";
            NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Android Gradle Upgrade Notification");
            if (notificationGroup != null) {
                MessageType messageType = MessageType.WARNING;
                Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"WARNING");
                notification2 = notificationGroup.createNotification(msg, messageType);
            } else {
                notification2 = null;
            }
            Notification notification3 = notification = notification2;
            if (notification3 == null) break block2;
            notification3.notify(project);
        }
    }

    @Override
    public void performRecommendedPluginUpgrade(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        FutureUtils.executeOnPooledThread(() -> AssistantInvokerImpl.performRecommendedPluginUpgrade$lambda$0(project));
    }

    @Override
    @Slow
    public boolean shouldRecommendPluginUpgradeToLatest(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return GradlePluginUpgrade.shouldRecommendPluginUpgrade(project).getUpgrade();
    }

    private static final AgpUpgradeRefactoringProcessorWithCompileRuntimeSpecialCaseDialog performDeprecatedConfigurationsUpgrade$lambda$0(AgpUpgradeRefactoringProcessor p) {
        Intrinsics.checkNotNullParameter((Object)((Object)p), (String)"p");
        return new AgpUpgradeRefactoringProcessorWithCompileRuntimeSpecialCaseDialog(p);
    }

    private static final void performDeprecatedConfigurationsUpgrade$lambda$1(AgpUpgradeRefactoringProcessor $processor) {
        $processor.run();
    }

    private static final boolean showAndGetDeprecatedConfigurationsUpgradeDialog$lambda$1(Function1 $dialogFactory, AgpUpgradeRefactoringProcessor $processor) {
        AgpUpgradeRefactoringProcessorWithCompileRuntimeSpecialCaseDialog dialog2 = (AgpUpgradeRefactoringProcessorWithCompileRuntimeSpecialCaseDialog)((Object)$dialogFactory.invoke((Object)$processor));
        return dialog2.showAndGet();
    }

    private static final Unit maybeForceOrRecommendPluginUpgrade$lambda$0$0(Project $project, AgpVersion $currentAgpVersion, AgpVersion $latestKnown) {
        Set published = IdeGoogleMavenRepository.INSTANCE.getAgpVersions();
        if (GradlePluginUpgrade.shouldForcePluginUpgrade($project, $currentAgpVersion, $latestKnown, published)) {
            GradlePluginUpgrade.performForcedPluginUpgrade$default($project, $currentAgpVersion, null, 4, null);
        } else {
            Recommendation recommendation = GradlePluginUpgrade.shouldRecommendPluginUpgrade($project, $currentAgpVersion, $latestKnown, published);
            if (recommendation.getUpgrade()) {
                GradlePluginUpgrade.recommendPluginUpgrade($project, $currentAgpVersion, recommendation.getStrongly());
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit performRecommendedPluginUpgrade$lambda$0(Project $project) {
        GradlePluginUpgrade.performRecommendedPluginUpgrade$default($project, null, null, 6, null);
        return Unit.INSTANCE;
    }
}

