/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.quickFixes;

import com.intellij.build.FilePosition;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/gradle/project/sync/quickFixes/OpenFileAtLocationQuickFix;", "Lcom/intellij/build/issue/BuildIssueQuickFix;", "myFilePosition", "Lcom/intellij/build/FilePosition;", "<init>", "(Lcom/intellij/build/FilePosition;)V", "getMyFilePosition", "()Lcom/intellij/build/FilePosition;", "id", "", "getId", "()Ljava/lang/String;", "runQuickFix", "Ljava/util/concurrent/CompletableFuture;", "project", "Lcom/intellij/openapi/project/Project;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.android.projectSystem.gradle"})
public final class OpenFileAtLocationQuickFix
implements BuildIssueQuickFix {
    @NotNull
    private final FilePosition myFilePosition;
    @NotNull
    private final String id;

    public OpenFileAtLocationQuickFix(@NotNull FilePosition myFilePosition) {
        Intrinsics.checkNotNullParameter((Object)myFilePosition, (String)"myFilePosition");
        this.myFilePosition = myFilePosition;
        this.id = "open.file";
    }

    @NotNull
    public final FilePosition getMyFilePosition() {
        return this.myFilePosition;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public CompletableFuture<?> runQuickFix(@NotNull Project project, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        VirtualFile virtualFile = project.getProjectFile();
        if (virtualFile == null) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        VirtualFile projectFile = virtualFile;
        Object object = this.myFilePosition.getFile();
        if (object == null || (object = ((File)object).getPath()) == null) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        Object filePositionFile = object;
        CompletableFuture future2 = new CompletableFuture();
        ActionsKt.invokeLater$default(null, () -> OpenFileAtLocationQuickFix.runQuickFix$lambda$0(projectFile, (String)filePositionFile, project, this, future2), (int)1, null);
        return future2;
    }

    private static final Unit runQuickFix$lambda$0(VirtualFile $projectFile, String $filePositionFile, Project $project, OpenFileAtLocationQuickFix this$0, CompletableFuture $future) {
        OpenFileDescriptor openFile2;
        VirtualFile file = $projectFile.getParent().getFileSystem().findFileByPath($filePositionFile);
        if (file != null && (openFile2 = new OpenFileDescriptor($project, file, this$0.myFilePosition.getStartLine(), this$0.myFilePosition.getStartColumn(), false)).canNavigate()) {
            openFile2.navigate(true);
        }
        $future.complete(null);
        return Unit.INSTANCE;
    }
}

