/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.quickFixes;

import com.android.tools.idea.gradle.project.sync.idea.issues.DescribedBuildIssueQuickFix;
import com.android.tools.idea.gradle.project.sync.quickFixes.SetJavaLanguageLevelProcessor;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H&J\u001c\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0005H\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/gradle/project/sync/quickFixes/AbstractSetJavaLanguageLevelQuickFix;", "Lcom/android/tools/idea/gradle/project/sync/idea/issues/DescribedBuildIssueQuickFix;", "level", "Lcom/intellij/pom/java/LanguageLevel;", "setJvmTarget", "", "modulesDescription", "", "<init>", "(Lcom/intellij/pom/java/LanguageLevel;ZLjava/lang/String;)V", "getLevel", "()Lcom/intellij/pom/java/LanguageLevel;", "description", "getDescription", "()Ljava/lang/String;", "buildFilesToApply", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "runQuickFix", "Ljava/util/concurrent/CompletableFuture;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "setJavaLevelInBuildFiles", "", "jvmTarget", "intellij.android.projectSystem.gradle"})
public abstract class AbstractSetJavaLanguageLevelQuickFix
implements DescribedBuildIssueQuickFix {
    @NotNull
    private final LanguageLevel level;
    private final boolean setJvmTarget;
    @NotNull
    private final String modulesDescription;
    @NotNull
    private final String description;

    public AbstractSetJavaLanguageLevelQuickFix(@NotNull LanguageLevel level, boolean setJvmTarget, @NotNull String modulesDescription) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)modulesDescription, (String)"modulesDescription");
        this.level = level;
        this.setJvmTarget = setJvmTarget;
        this.modulesDescription = modulesDescription;
        this.description = "Change Java language level" + (this.setJvmTarget ? " and jvmTarget" : "") + " to " + this.level.toJavaVersion().feature + " in " + this.modulesDescription + " if using a lower level.";
    }

    @NotNull
    public final LanguageLevel getLevel() {
        return this.level;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @NotNull
    public abstract List<VirtualFile> buildFilesToApply(@NotNull Project var1);

    @NotNull
    public CompletableFuture<?> runQuickFix(@NotNull Project project, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        CompletableFuture future2 = new CompletableFuture();
        try {
            if (!project.isDisposed()) {
                this.setJavaLevelInBuildFiles(project, this.setJvmTarget);
            }
            future2.complete(null);
        }
        catch (Exception e) {
            future2.completeExceptionally(e);
        }
        return future2;
    }

    @VisibleForTesting
    public final void setJavaLevelInBuildFiles(@NotNull Project project, boolean jvmTarget) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List<VirtualFile> buildFiles = this.buildFilesToApply(project);
        if (buildFiles.isEmpty()) {
            Messages.showErrorDialog((Project)project, (String)"Could not determine build files to apply fix", (String)("Change Java language level to " + this.level.toJavaVersion().feature + "}"));
        } else {
            SetJavaLanguageLevelProcessor processor = new SetJavaLanguageLevelProcessor(project, buildFiles, this.level, jvmTarget, this.modulesDescription);
            processor.setPreviewUsages(true);
            processor.run();
        }
    }
}

