/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.listeners;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.extensions.GradleDaemonJvmHelperExtensionsKt;
import com.android.tools.idea.gradle.project.ProjectMigrationsPersistentState;
import com.android.tools.idea.gradle.project.sync.GradleSyncListenerWithRoot;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenUrlHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.SelectJdkFromFileSystemHyperlink;
import com.android.tools.idea.gradle.util.GradleConfigProperties;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.sdk.IdeSdks;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.service.execution.GradleDaemonJvmHelper;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000b\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nH\u0016J/\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000b\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u001d\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000b\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/gradle/project/sync/listeners/MigrateJdkConfigToGradleJavaHomeListener;", "Lcom/android/tools/idea/gradle/project/sync/GradleSyncListenerWithRoot;", "<init>", "()V", "syncSucceeded", "", "project", "Lcom/intellij/openapi/project/Project;", "rootProjectPath", "", "Lorg/jetbrains/annotations/SystemIndependent;", "migrateToGradleLocalJavaHome", "projectMigrations", "Lcom/android/tools/idea/gradle/project/ProjectMigrationsPersistentState;", "gradleSettings", "Lorg/jetbrains/plugins/gradle/settings/GradleProjectSettings;", "showMigratedJdkConfigNotification", "intellij.android.projectSystem.gradle"})
@SourceDebugExtension(value={"SMAP\nMigrateJdkConfigToGradleJavaHomeListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigrateJdkConfigToGradleJavaHomeListener.kt\ncom/android/tools/idea/gradle/project/sync/listeners/MigrateJdkConfigToGradleJavaHomeListener\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,113:1\n37#2:114\n36#2,3:115\n*S KotlinDebug\n*F\n+ 1 MigrateJdkConfigToGradleJavaHomeListener.kt\ncom/android/tools/idea/gradle/project/sync/listeners/MigrateJdkConfigToGradleJavaHomeListener\n*L\n110#1:114\n110#1:115,3\n*E\n"})
public final class MigrateJdkConfigToGradleJavaHomeListener
implements GradleSyncListenerWithRoot {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void syncSucceeded(@NotNull Project project, @NotNull String rootProjectPath) {
        String string;
        GradleProjectSettings gradleSettings;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)rootProjectPath, (String)"rootProjectPath");
        if (!((Boolean)StudioFlags.MIGRATE_PROJECT_TO_GRADLE_LOCAL_JAVA_HOME.get()).booleanValue()) {
            return;
        }
        ProjectMigrationsPersistentState projectMigrations = ProjectMigrationsPersistentState.Companion.getInstance(project);
        if (projectMigrations.getMigratedGradleRootsToGradleLocalJavaHome().contains(rootProjectPath)) {
            return;
        }
        if (GradleDaemonJvmHelperExtensionsKt.isProjectUsingDaemonJvmCriteria(GradleDaemonJvmHelper.INSTANCE, project, rootProjectPath)) {
            return;
        }
        GradleProjectSettings gradleProjectSettings = gradleSettings = (GradleProjectSettings)GradleSettings.getInstance((Project)project).getLinkedProjectSettings(rootProjectPath);
        String string2 = string = gradleProjectSettings != null ? gradleProjectSettings.getGradleJvm() : null;
        if (string != null) {
            switch (string.hashCode()) {
                case 684858615: {
                    if (string.equals("#JAVA_INTERNAL")) return;
                    break;
                }
                case -720906142: {
                    if (string.equals("STUDIO_GRADLE_JDK")) return;
                    break;
                }
                case -836463405: {
                    if (string.equals("#GRADLE_LOCAL_JAVA_HOME")) return;
                    break;
                }
                case -610369511: {
                    if (string.equals("#JAVA_HOME")) return;
                    break;
                }
                case -1706417913: {
                    if (!string.equals("#GRADLE_JAVA_HOME")) break;
                    return;
                }
            }
        }
        if (IdeSdks.getInstance().isUsingEnvVariableJdk()) {
            return;
        }
        this.migrateToGradleLocalJavaHome(project, rootProjectPath, projectMigrations, gradleSettings);
    }

    private final void migrateToGradleLocalJavaHome(Project project, String rootProjectPath, ProjectMigrationsPersistentState projectMigrations, GradleProjectSettings gradleSettings) {
        block1: {
            GradleConfigProperties gradleConfigProperties;
            String string = GradleInstallationManager.Companion.getInstance().getGradleJvmPath(project, rootProjectPath);
            if (string == null) break block1;
            String gradleJdkPath = string;
            boolean bl = false;
            GradleConfigProperties $this$migrateToGradleLocalJavaHome_u24lambda_u240_u240 = gradleConfigProperties = new GradleConfigProperties(new File(rootProjectPath));
            boolean bl2 = false;
            $this$migrateToGradleLocalJavaHome_u24lambda_u240_u240.setJavaHome(new File(gradleJdkPath));
            $this$migrateToGradleLocalJavaHome_u24lambda_u240_u240.save();
            GradleProjectSettings gradleProjectSettings = gradleSettings;
            if (gradleProjectSettings != null) {
                gradleProjectSettings.setGradleJvm("#GRADLE_LOCAL_JAVA_HOME");
            }
            projectMigrations.getMigratedGradleRootsToGradleLocalJavaHome().add(rootProjectPath);
            this.showMigratedJdkConfigNotification(project, rootProjectPath);
        }
    }

    private final void showMigratedJdkConfigNotification(Project project, String rootProjectPath) {
        Object[] objectArray = new NotificationHyperlink[2];
        objectArray[0] = new OpenUrlHyperlink(AndroidBundle.message("project.migrated.to.gradle.local.java.home.info.url", new Object[0]), AndroidBundle.message("project.migrated.to.gradle.local.java.home.info", new Object[0]));
        String string = AndroidBundle.message("project.migrated.to.gradle.local.java.home.button", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        objectArray[1] = SelectJdkFromFileSystemHyperlink.Companion.create(project, rootProjectPath, string);
        List hyperlinks = CollectionsKt.listOfNotNull((Object[])objectArray);
        objectArray = new Object[]{new File(rootProjectPath).getName()};
        String string2 = AndroidBundle.message("project.migrated.to.gradle.local.java.home.message", objectArray);
        Collection $this$toTypedArray$iv = hyperlinks;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        objectArray = thisCollection$iv.toArray(new NotificationHyperlink[0]);
        AndroidNotification.getInstance((Project)project).showBalloon(AndroidBundle.message("project.migrated.to.gradle.local.java.home.title", new Object[0]), string2, NotificationType.INFORMATION, (NotificationHyperlink[])Arrays.copyOf(objectArray, objectArray.length));
    }
}

