/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues.processor;

import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.GradleSettingsModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.projectsystem.ProjectSystemService;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class AddRepoProcessor
extends BaseRefactoringProcessor {
    @NotNull
    private final List<VirtualFile> myBuildFiles;
    @NotNull
    private final Repository myRepository;
    private final boolean myRequestSync;

    public AddRepoProcessor(@NotNull Project project, @NotNull List<VirtualFile> buildFiles, @NotNull Repository repository2, boolean requestSync2) {
        super(project);
        this.myBuildFiles = buildFiles;
        this.myRequestSync = requestSync2;
        this.myRepository = repository2;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        return new UsageViewDescriptor(){

            public String getCodeReferencesText(int usagesCount, int filesCount) {
                return String.format(Locale.US, "File%s to add %s repository to (%d file%s found)", filesCount == 1 ? "" : "s", AddRepoProcessor.this.myRepository.getDisplayName(), filesCount, filesCount == 1 ? "" : "s");
            }

            @NotNull
            public PsiElement[] getElements() {
                return PsiElement.EMPTY_ARRAY;
            }

            public String getProcessedElementsHeader() {
                return "Add " + AddRepoProcessor.this.myRepository.getDisplayName() + " repository";
            }
        };
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        PsiElement psiElement;
        ProjectBuildModel projectBuildModel = ProjectBuildModel.get(this.myProject);
        ArrayList<UsageInfo> usages = new ArrayList<UsageInfo>();
        GradleSettingsModel settingsModel = projectBuildModel.getProjectSettingsModel();
        if (settingsModel != null && (psiElement = settingsModel.dependencyResolutionManagement().repositories().getPsiElement()) != null) {
            usages.add(new UsageInfo(psiElement));
            return usages.toArray(UsageInfo.EMPTY_ARRAY);
        }
        for (VirtualFile file : this.myBuildFiles) {
            GradleBuildModel buildModel;
            PsiElement psiElement2;
            if (!file.isValid() || !file.isWritable() || (psiElement2 = (buildModel = projectBuildModel.getModuleBuildModel(file)).getPsiElement()) == null) continue;
            usages.add(new UsageInfo(psiElement2));
        }
        return usages.toArray(UsageInfo.EMPTY_ARRAY);
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        PsiElement psiElement;
        ProjectBuildModel projectBuildModel = ProjectBuildModel.get(this.myProject);
        List<PsiElement> elements = Arrays.stream(usages).map(UsageInfo::getElement).toList();
        GradleSettingsModel settingsModel = projectBuildModel.getProjectSettingsModel();
        if (settingsModel != null && (psiElement = settingsModel.dependencyResolutionManagement().repositories().getPsiElement()) != null && elements.contains(psiElement) && this.myRepository.equals((Object)Repository.GOOGLE)) {
            settingsModel.dependencyResolutionManagement().repositories().addGoogleMavenRepository();
            projectBuildModel.applyChanges();
            if (this.myRequestSync) {
                ProjectSystemService.getInstance(this.myProject).getProjectSystem().getSyncManager().requestSyncProject(new ProjectSystemSyncManager.SyncReason(GradleSyncStats.Trigger.TRIGGER_QF_REPOSITORY_ADDED));
            }
            return;
        }
        block3: for (VirtualFile file : this.myBuildFiles) {
            GradleBuildModel buildModel = projectBuildModel.getModuleBuildModel(file);
            PsiElement filePsiElement = buildModel.getPsiElement();
            if (filePsiElement == null || !elements.contains(filePsiElement)) continue;
            switch (this.myRepository.ordinal()) {
                case 0: {
                    buildModel.repositories().addGoogleMavenRepository();
                    PsiElement buildScriptElement = buildModel.buildscript().getPsiElement();
                    if (buildScriptElement == null) continue block3;
                    buildModel.buildscript().repositories().addGoogleMavenRepository();
                    continue block3;
                }
            }
            throw new IllegalStateException("No handle for requested repository: " + this.myRepository.name());
        }
        projectBuildModel.applyChanges();
        if (this.myRequestSync) {
            ProjectSystemService.getInstance(this.myProject).getProjectSystem().getSyncManager().requestSyncProject(new ProjectSystemSyncManager.SyncReason(GradleSyncStats.Trigger.TRIGGER_QF_REPOSITORY_ADDED));
        }
    }

    @NotNull
    protected String getCommandName() {
        return "Add " + this.myRepository.getDisplayName() + " repository";
    }

    public static enum Repository {
        GOOGLE("Google");

        @NotNull
        private final String myName;

        private Repository(String name2) {
            this.myName = name2;
        }

        @NotNull
        public String getDisplayName() {
            return this.myName;
        }
    }
}

