/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.gradle.project.sync.GradleSyncStateHolder;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssueUsageReporter;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.GradleSyncIssue;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\t\u001a\u00020\n2\u000b\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rH\u0016J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/gradle/project/sync/issues/SyncIssueUsageReporterImpl;", "Lcom/android/tools/idea/gradle/project/sync/issues/SyncIssueUsageReporter;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "collectedIssues", "", "Lcom/google/wireless/android/sdk/stats/GradleSyncIssue;", "reportToUsageTracker", "", "rootProjectPath", "", "Lorg/jetbrains/annotations/SystemIndependent;", "collect", "issue", "intellij.android.projectSystem.gradle"})
public final class SyncIssueUsageReporterImpl
implements SyncIssueUsageReporter {
    @NotNull
    private final Project project;
    @NotNull
    private final List<GradleSyncIssue> collectedIssues;

    public SyncIssueUsageReporterImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.collectedIssues = new ArrayList();
    }

    @Override
    public void reportToUsageTracker(@NotNull String rootProjectPath) {
        Intrinsics.checkNotNullParameter((Object)rootProjectPath, (String)"rootProjectPath");
        if (!((Collection)this.collectedIssues).isEmpty()) {
            AndroidStudioEvent.Builder builder = GradleSyncStateHolder.Companion.getInstance(this.project).generateSyncEvent(AndroidStudioEvent.EventKind.GRADLE_SYNC_ISSUES, rootProjectPath).addAllGradleSyncIssues((Iterable)this.collectedIssues);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"addAllGradleSyncIssues(...)");
            UsageTracker.log((AndroidStudioEvent.Builder)builder);
            this.collectedIssues.clear();
        }
    }

    @Override
    public void collect(@NotNull GradleSyncIssue issue2) {
        Intrinsics.checkNotNullParameter((Object)issue2, (String)"issue");
        this.collectedIssues.add(issue2);
    }
}

