/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea.issues;

import com.android.tools.idea.gradle.project.sync.idea.issues.BuildIssueDescriptionComposer;
import com.android.tools.idea.gradle.project.sync.idea.issues.DescribedBuildIssueQuickFix;
import com.android.tools.idea.gradle.project.sync.idea.issues.ErrorMessageAwareBuildIssue;
import com.google.wireless.android.sdk.stats.BuildErrorMessage;
import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0003J\u0006\u0010\u0014\u001a\u00020\u0000J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u000fJ&\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u000fJ\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\nJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\""}, d2={"Lcom/android/tools/idea/gradle/project/sync/idea/issues/BuildIssueComposer;", "", "baseMessage", "", "issueTitle", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getIssueTitle", "()Ljava/lang/String;", "descriptionComposer", "Lcom/android/tools/idea/gradle/project/sync/idea/issues/BuildIssueDescriptionComposer;", "getDescriptionComposer", "()Lcom/android/tools/idea/gradle/project/sync/idea/issues/BuildIssueDescriptionComposer;", "issueQuickFixes", "", "Lcom/intellij/build/issue/BuildIssueQuickFix;", "getIssueQuickFixes", "()Ljava/util/List;", "addDescriptionOnNewLine", "message", "startNewParagraph", "addQuickFix", "quickFix", "Lcom/android/tools/idea/gradle/project/sync/idea/issues/DescribedBuildIssueQuickFix;", "text", "prefix", "suffix", "additionalDescription", "composeBuildIssue", "Lcom/intellij/build/issue/BuildIssue;", "composeErrorMessageAwareBuildIssue", "Lcom/android/tools/idea/gradle/project/sync/idea/issues/ErrorMessageAwareBuildIssue;", "buildErrorMessage", "Lcom/google/wireless/android/sdk/stats/BuildErrorMessage;", "intellij.android.projectSystem.gradle"})
public final class BuildIssueComposer {
    @NotNull
    private final String issueTitle;
    @NotNull
    private final BuildIssueDescriptionComposer descriptionComposer;

    public BuildIssueComposer(@NotNull String baseMessage, @NotNull String issueTitle) {
        Intrinsics.checkNotNullParameter((Object)baseMessage, (String)"baseMessage");
        Intrinsics.checkNotNullParameter((Object)issueTitle, (String)"issueTitle");
        this.issueTitle = issueTitle;
        this.descriptionComposer = new BuildIssueDescriptionComposer(baseMessage);
    }

    public /* synthetic */ BuildIssueComposer(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = "Gradle Sync issues.";
        }
        this(string, string2);
    }

    @NotNull
    public final String getIssueTitle() {
        return this.issueTitle;
    }

    @NotNull
    public final BuildIssueDescriptionComposer getDescriptionComposer() {
        return this.descriptionComposer;
    }

    @NotNull
    public final List<BuildIssueQuickFix> getIssueQuickFixes() {
        return this.descriptionComposer.getQuickFixes();
    }

    @NotNull
    public final BuildIssueComposer addDescriptionOnNewLine(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.descriptionComposer.newLine();
        this.descriptionComposer.addDescription(message);
        return this;
    }

    @NotNull
    public final BuildIssueComposer startNewParagraph() {
        this.descriptionComposer.newLine();
        return this;
    }

    @NotNull
    public final BuildIssueComposer addQuickFix(@NotNull DescribedBuildIssueQuickFix quickFix) {
        Intrinsics.checkNotNullParameter((Object)quickFix, (String)"quickFix");
        this.descriptionComposer.newLine();
        this.descriptionComposer.addQuickFix(quickFix);
        return this;
    }

    @NotNull
    public final BuildIssueComposer addQuickFix(@NotNull String text2, @NotNull BuildIssueQuickFix quickFix) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)quickFix, (String)"quickFix");
        this.descriptionComposer.newLine();
        this.descriptionComposer.addQuickFix(text2, quickFix);
        return this;
    }

    @NotNull
    public final BuildIssueComposer addQuickFix(@NotNull String prefix, @NotNull String text2, @NotNull String suffix, @NotNull BuildIssueQuickFix quickFix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        Intrinsics.checkNotNullParameter((Object)quickFix, (String)"quickFix");
        this.descriptionComposer.newLine();
        this.descriptionComposer.addQuickFix(prefix, text2, suffix, quickFix);
        return this;
    }

    @NotNull
    public final BuildIssueComposer addDescriptionOnNewLine(@NotNull BuildIssueDescriptionComposer additionalDescription) {
        Intrinsics.checkNotNullParameter((Object)additionalDescription, (String)"additionalDescription");
        this.descriptionComposer.newLine();
        this.descriptionComposer.addDescription(additionalDescription);
        return this;
    }

    @NotNull
    public final BuildIssue composeBuildIssue() {
        return new BuildIssue(this){
            private final String title;
            private final String description;
            private final List<BuildIssueQuickFix> quickFixes;
            {
                this.title = $receiver.getIssueTitle();
                this.description = $receiver.getDescriptionComposer().getDescription();
                this.quickFixes = $receiver.getDescriptionComposer().getQuickFixes();
            }

            public String getTitle() {
                return this.title;
            }

            public String getDescription() {
                return this.description;
            }

            public List<BuildIssueQuickFix> getQuickFixes() {
                return this.quickFixes;
            }

            public Void getNavigatable(Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                return null;
            }
        };
    }

    @NotNull
    public final ErrorMessageAwareBuildIssue composeErrorMessageAwareBuildIssue(@NotNull BuildErrorMessage buildErrorMessage) {
        Intrinsics.checkNotNullParameter((Object)buildErrorMessage, (String)"buildErrorMessage");
        return new ErrorMessageAwareBuildIssue(this, buildErrorMessage){
            private final String title;
            private final String description;
            private final List<BuildIssueQuickFix> quickFixes;
            private final BuildErrorMessage buildErrorMessage;
            {
                this.title = $receiver.getIssueTitle();
                this.description = $receiver.getDescriptionComposer().getDescription();
                this.quickFixes = $receiver.getDescriptionComposer().getQuickFixes();
                this.buildErrorMessage = $buildErrorMessage;
            }

            public String getTitle() {
                return this.title;
            }

            public String getDescription() {
                return this.description;
            }

            public List<BuildIssueQuickFix> getQuickFixes() {
                return this.quickFixes;
            }

            public BuildErrorMessage getBuildErrorMessage() {
                return this.buildErrorMessage;
            }

            public Void getNavigatable(Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                return null;
            }
        };
    }
}

