/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.hyperlink;

import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class OpenFileHyperlink
extends NotificationHyperlink {
    @NotNull
    private final String myFilePath;
    private final int myLineNumber;
    private final int myColumn;

    public OpenFileHyperlink(@NotNull String filePath) {
        this(filePath, -1);
    }

    public OpenFileHyperlink(@NotNull String filePath, int lineNumber) {
        this(filePath, "Open File", lineNumber, -1);
    }

    public OpenFileHyperlink(@NotNull String filePath, @NotNull String text2, int lineNumber, int column2) {
        super("openFile:" + filePath, text2);
        this.myFilePath = FileUtil.toSystemIndependentName((String)filePath);
        this.myLineNumber = lineNumber;
        this.myColumn = column2;
    }

    protected void execute(@NotNull Project project) {
        OpenFileDescriptor openFile2;
        VirtualFile projectFile = project.getProjectFile();
        if (projectFile == null) {
            return;
        }
        VirtualFile file = projectFile.getParent().getFileSystem().findFileByPath(this.myFilePath);
        if (file != null && (openFile2 = new OpenFileDescriptor(project, file, this.myLineNumber, this.myColumn, false)).canNavigate()) {
            openFile2.navigate(true);
        }
    }

    @VisibleForTesting
    @NotNull
    public String getFilePath() {
        return this.myFilePath;
    }

    @VisibleForTesting
    public int getLineNumber() {
        return this.myLineNumber;
    }
}

