/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.gradle.util.GradleProjectSystemUtil;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import java.util.concurrent.CompletableFuture;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/gradle/project/sync/errors/StopGradleDaemonQuickFix;", "Lcom/intellij/build/issue/BuildIssueQuickFix;", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "runQuickFix", "Ljava/util/concurrent/CompletableFuture;", "project", "Lcom/intellij/openapi/project/Project;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.android.projectSystem.gradle"})
public final class StopGradleDaemonQuickFix
implements BuildIssueQuickFix {
    @NotNull
    private final String id;

    public StopGradleDaemonQuickFix() {
        this.id = "stop.gradle.daemons";
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public CompletableFuture<?> runQuickFix(@NotNull Project project, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        CompletableFuture<Object> future2 = new CompletableFuture<Object>();
        if (ApplicationManager.getApplication().isRestartCapable()) {
            String message = "Stopping all Gradle daemons will terminate any running Gradle builds (e.g. from the command line).\nThis action will also restart the IDE.\nDo you want to continue?";
            String title2 = "Stop Gradle Daemons";
            int answer2 = Messages.showYesNoDialog((Project)project, (String)message, (String)title2, (Icon)Messages.getQuestionIcon());
            if (answer2 == 0) {
                FutureUtils.executeOnPooledThread(StopGradleDaemonQuickFix::runQuickFix$lambda$0);
                future2.complete(null);
            }
        } else {
            ActionsKt.invokeLater$default(null, () -> StopGradleDaemonQuickFix.runQuickFix$lambda$1(future2), (int)1, null);
        }
        return future2;
    }

    private static final Unit runQuickFix$lambda$0() {
        GradleProjectSystemUtil.stopAllGradleDaemonsAndRestart();
        return Unit.INSTANCE;
    }

    private static final Unit runQuickFix$lambda$1(CompletableFuture $future) {
        BrowserUtil.browse((String)"http://www.gradle.org/docs/current/userguide/gradle_daemon.html");
        $future.complete(null);
        return Unit.INSTANCE;
    }
}

