/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.output;

import com.android.tools.idea.gradle.project.build.output.EncodedMessage;
import com.android.tools.idea.gradle.project.build.output.FileLocation;
import com.google.gson.Gson;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.impl.FileMessageEventImpl;
import com.intellij.build.events.impl.MessageEventImpl;
import com.intellij.build.output.BuildOutputInstantReader;
import com.intellij.build.output.BuildOutputParser;
import java.io.File;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0011\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0010\u0010\u000e\u001a\f\u0012\u0006\b\u0000\u0012\u00020\u0010\u0018\u00010\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/gradle/project/build/output/DataBindingOutputParser;", "Lcom/intellij/build/output/BuildOutputParser;", "<init>", "()V", "jsonFormatter", "Lcom/android/tools/idea/gradle/project/build/output/DataBindingOutputParser$JsonDataBindingOutputParser;", "legacyFormatter", "Lcom/android/tools/idea/gradle/project/build/output/DataBindingOutputParser$LegacyDataBindingOutputParser;", "parse", "", "line", "", "reader", "Lcom/intellij/build/output/BuildOutputInstantReader;", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "JsonDataBindingOutputParser", "LegacyDataBindingOutputParser", "intellij.android.projectSystem.gradle"})
public final class DataBindingOutputParser
implements BuildOutputParser {
    @NotNull
    private final JsonDataBindingOutputParser jsonFormatter = new JsonDataBindingOutputParser();
    @NotNull
    private final LegacyDataBindingOutputParser legacyFormatter = new LegacyDataBindingOutputParser();

    public boolean parse(@Nullable String line, @Nullable BuildOutputInstantReader reader2, @Nullable Consumer<? super BuildEvent> messageConsumer) {
        return this.jsonFormatter.parse(line, reader2, messageConsumer) || this.legacyFormatter.parse(line, reader2, messageConsumer);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0010\u0010\f\u001a\f\u0012\u0006\b\u0000\u0012\u00020\u000e\u0018\u00010\rH\u0016J(\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00110\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/gradle/project/build/output/DataBindingOutputParser$JsonDataBindingOutputParser;", "Lcom/intellij/build/output/BuildOutputParser;", "<init>", "()V", "gson", "Lcom/google/gson/Gson;", "parse", "", "line", "", "reader", "Lcom/intellij/build/output/BuildOutputInstantReader;", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "parseErrorIn", "output", "Lcom/intellij/build/events/MessageEvent;", "Companion", "intellij.android.projectSystem.gradle"})
    private static final class JsonDataBindingOutputParser
    implements BuildOutputParser {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Gson gson = new Gson();
        @NotNull
        private static final String ERROR_LOG_HEADER = "Found data binding error(s):";

        public boolean parse(@Nullable String line, @Nullable BuildOutputInstantReader reader2, @Nullable Consumer<? super BuildEvent> messageConsumer) {
            if (line == null || reader2 == null || messageConsumer == null) {
                return false;
            }
            if (StringsKt.contains$default((CharSequence)line, (CharSequence)ERROR_LOG_HEADER, (boolean)false, (int)2, null)) {
                return true;
            }
            int errorPrefix = StringsKt.indexOf$default((CharSequence)line, (String)"[databinding] ", (int)0, (boolean)false, (int)6, null);
            if (errorPrefix >= 0) {
                int errorStart = errorPrefix + 14;
                String string = line.substring(errorStart);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                return this.parseErrorIn(string, reader2, messageConsumer);
            }
            return false;
        }

        private final boolean parseErrorIn(String output, BuildOutputInstantReader reader2, Consumer<? super MessageEvent> messageConsumer) {
            try {
                EncodedMessage msg = (EncodedMessage)this.gson.fromJson(output, EncodedMessage.class);
                String summary = StringsKt.substringBefore$default((String)msg.getMessage(), (char)'\n', null, (int)2, null);
                if (msg.getLocations().isEmpty()) {
                    messageConsumer.accept((MessageEvent)new MessageEventImpl(reader2.getParentEventId(), MessageEvent.Kind.ERROR, "Data Binding compiler", summary, msg.getMessage()));
                } else {
                    File sourceFile = new File(msg.getFilePath()).getAbsoluteFile();
                    FileLocation location = (FileLocation)CollectionsKt.first(msg.getLocations());
                    FilePosition filePosition = new FilePosition(sourceFile, location.getStartLine(), location.getStartCol(), location.getEndLine(), location.getEndCol());
                    messageConsumer.accept((MessageEvent)new FileMessageEventImpl(reader2.getParentEventId(), MessageEvent.Kind.ERROR, "Data Binding compiler", summary, msg.getMessage(), filePosition));
                }
                return true;
            }
            catch (Exception ignored) {
                return false;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/gradle/project/build/output/DataBindingOutputParser$JsonDataBindingOutputParser$Companion;", "", "<init>", "()V", "ERROR_LOG_HEADER", "", "intellij.android.projectSystem.gradle"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0010\u0010\n\u001a\f\u0012\u0006\b\u0000\u0012\u00020\f\u0018\u00010\u000bH\u0016J(\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000f0\u000bH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/gradle/project/build/output/DataBindingOutputParser$LegacyDataBindingOutputParser;", "Lcom/intellij/build/output/BuildOutputParser;", "<init>", "()V", "parse", "", "line", "", "reader", "Lcom/intellij/build/output/BuildOutputInstantReader;", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "parseErrorIn", "output", "Lcom/intellij/build/events/MessageEvent;", "Companion", "intellij.android.projectSystem.gradle"})
    private static final class LegacyDataBindingOutputParser
    implements BuildOutputParser {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final String ERROR_LOG_HEADER = "Found data binding errors.";
        @NotNull
        private static final Regex ERROR_LOG_REGEX = new Regex("\\*\\*\\*\\*/ data binding error \\*\\*\\*\\*(.+)\\*\\*\\*\\*\\\\ data binding error \\*\\*\\*\\*");
        @NotNull
        private static final Regex ERROR_MESSAGE_REGEX = new Regex("msg:(.+) file:(.+) loc:(.+) ");
        @NotNull
        private static final Regex LOCATION_REGEX = new Regex("(\\d+):(\\d+) - (\\d+):(\\d+)");

        public boolean parse(@Nullable String line, @Nullable BuildOutputInstantReader reader2, @Nullable Consumer<? super BuildEvent> messageConsumer) {
            if (line == null || reader2 == null || messageConsumer == null) {
                return false;
            }
            if (StringsKt.contains$default((CharSequence)line, (CharSequence)ERROR_LOG_HEADER, (boolean)false, (int)2, null)) {
                return true;
            }
            MatchResult matchResult = ERROR_LOG_REGEX.matchEntire((CharSequence)((Object)StringsKt.trim((CharSequence)line)).toString());
            if (matchResult == null) {
                return false;
            }
            MatchResult match = matchResult;
            String message = (String)match.getGroupValues().get(1);
            return this.parseErrorIn(message, reader2, messageConsumer);
        }

        private final boolean parseErrorIn(String output, BuildOutputInstantReader reader2, Consumer<? super MessageEvent> messageConsumer) {
            try {
                MatchResult matchResult = ERROR_MESSAGE_REGEX.matchEntire((CharSequence)output);
                if (matchResult == null) {
                    return false;
                }
                MatchResult messageMatch = matchResult;
                String msg = (String)messageMatch.getGroupValues().get(1);
                String file = (String)messageMatch.getGroupValues().get(2);
                String loc = (String)messageMatch.getGroupValues().get(3);
                MatchResult matchResult2 = LOCATION_REGEX.matchEntire((CharSequence)loc);
                if (matchResult2 == null) {
                    return false;
                }
                MatchResult locMatch = matchResult2;
                int startLine = Integer.parseInt((String)locMatch.getGroupValues().get(1));
                int startCol = Integer.parseInt((String)locMatch.getGroupValues().get(2));
                int endLine = Integer.parseInt((String)locMatch.getGroupValues().get(3));
                int endCol = Integer.parseInt((String)locMatch.getGroupValues().get(4));
                File sourceFile = new File(file);
                FilePosition filePosition = new FilePosition(sourceFile, startLine, startCol, endLine, endCol);
                File file2 = filePosition.getFile();
                String string = file2 != null ? file2.getPath() : null;
                if (string == null) {
                    string = "";
                }
                StringBuilder fileLink = new StringBuilder(string);
                if (filePosition.getStartLine() > 0) {
                    fileLink.append(":").append(filePosition.getStartLine() + 1);
                    if (filePosition.getStartColumn() > 0) {
                        fileLink.append(":").append(filePosition.getStartColumn() + 1);
                    }
                }
                String detailedMessage = StringsKt.trimIndent((String)("\n          " + fileLink + "\n          " + msg + "\n          "));
                messageConsumer.accept((MessageEvent)new FileMessageEventImpl(reader2.getParentEventId(), MessageEvent.Kind.ERROR, "Data Binding compiler", msg, detailedMessage, filePosition));
                return true;
            }
            catch (Exception ignored) {
                return false;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/gradle/project/build/output/DataBindingOutputParser$LegacyDataBindingOutputParser$Companion;", "", "<init>", "()V", "ERROR_LOG_HEADER", "", "ERROR_LOG_REGEX", "Lkotlin/text/Regex;", "ERROR_MESSAGE_REGEX", "LOCATION_REGEX", "intellij.android.projectSystem.gradle"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

