/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.compiler;

import com.android.tools.idea.gradle.project.build.compiler.AndroidGradleBuildConfiguration;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.intellij.compiler.CompilerConfiguration;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleCompilerSettingsConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private final CompilerConfiguration myCompilerConfiguration;
    private final AndroidGradleBuildConfiguration myBuildConfiguration;
    private JPanel myContentPanel;
    private JCheckBox myParallelBuildCheckBox;
    private HyperlinkLabel myParallelBuildDocHyperlinkLabel;
    private RawCommandLineEditor myCommandLineOptionsEditor;
    private HyperlinkLabel myCommandLineOptionsDocHyperlinkLabel;
    private JCheckBox myContinueBuildWithErrors;
    private final String myDisplayName;

    public GradleCompilerSettingsConfigurable(@NotNull Project project, @NotNull String displayName) {
        this.myDisplayName = displayName;
        this.setupUI();
        this.myCompilerConfiguration = CompilerConfiguration.getInstance((Project)project);
        this.myBuildConfiguration = AndroidGradleBuildConfiguration.getInstance(project);
    }

    @NotNull
    public String getId() {
        return "gradle.compiler";
    }

    @Nls
    public String getDisplayName() {
        return this.myDisplayName;
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.projectsettings.compiler.gradle";
    }

    @Nullable
    public JComponent createComponent() {
        return this.myContentPanel;
    }

    public boolean isModified() {
        return this.myCompilerConfiguration.isParallelCompilationEnabled() != this.isParallelBuildsEnabled() || this.myBuildConfiguration.CONTINUE_FAILED_BUILD != this.isContinueWithFailuresEnabled() || !Objects.equal((Object)this.getCommandLineOptions(), (Object)this.myBuildConfiguration.COMMAND_LINE_OPTIONS);
    }

    public void apply() {
        if (this.myCompilerConfiguration.isParallelCompilationEnabled() != this.isParallelBuildsEnabled()) {
            this.myCompilerConfiguration.setParallelCompilationEnabled(this.isParallelBuildsEnabled());
        }
        this.myBuildConfiguration.COMMAND_LINE_OPTIONS = this.getCommandLineOptions();
        this.myBuildConfiguration.CONTINUE_FAILED_BUILD = this.isContinueWithFailuresEnabled();
    }

    private boolean isParallelBuildsEnabled() {
        return this.myParallelBuildCheckBox.isSelected();
    }

    private boolean isContinueWithFailuresEnabled() {
        return this.myContinueBuildWithErrors.isSelected();
    }

    @NotNull
    private String getCommandLineOptions() {
        return this.myCommandLineOptionsEditor.getText().trim();
    }

    public void reset() {
        this.myParallelBuildCheckBox.setSelected(this.myCompilerConfiguration.isParallelCompilationEnabled());
        String commandLineOptions = Strings.nullToEmpty((String)this.myBuildConfiguration.COMMAND_LINE_OPTIONS);
        this.myContinueBuildWithErrors.setSelected(this.myBuildConfiguration.CONTINUE_FAILED_BUILD);
        this.myCommandLineOptionsEditor.setText(commandLineOptions);
    }

    public void disposeUIResources() {
    }

    private void createUIComponents() {
        this.myParallelBuildDocHyperlinkLabel = GradleCompilerSettingsConfigurable.createHyperlinkLabel("This option is in \"incubation\" and should only be used with ", "decoupled projects", ".", "https://developer.android.com/r/tools/gradle-multi-project-decoupled-projects");
        this.myCommandLineOptionsDocHyperlinkLabel = GradleCompilerSettingsConfigurable.createHyperlinkLabel("Example: --stacktrace --debug (for more information, please read Gradle's ", "documentation", ".)", "http://www.gradle.org/docs/current/userguide/gradle_command_line.html");
        this.myCommandLineOptionsEditor = new RawCommandLineEditor();
        this.myCommandLineOptionsEditor.setDialogCaption("Command-line Options");
    }

    private void setupUI() {
        this.createUIComponents();
        this.myContentPanel = new JPanel();
        this.myContentPanel.setLayout((LayoutManager)new GridLayoutManager(11, 3, new Insets(0, 0, 0, 0), -1, -1));
        Spacer spacer1 = new Spacer();
        this.myContentPanel.add((Component)spacer1, new GridConstraints(10, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        this.myParallelBuildCheckBox = new JCheckBox();
        this.myParallelBuildCheckBox.setText("Compile independent modules in parallel (may require larger heap size)");
        this.myContentPanel.add((Component)this.myParallelBuildCheckBox, new GridConstraints(2, 0, 1, 3, 8, 0, 3, 0, null, null, null, 0, false));
        this.myContentPanel.add((Component)this.myParallelBuildDocHyperlinkLabel, new GridConstraints(3, 0, 1, 3, 0, 1, 3, 3, null, null, null, 0, false));
        JBLabel jBLabel1 = new JBLabel();
        jBLabel1.setText("<html><br></html>");
        this.myContentPanel.add((Component)jBLabel1, new GridConstraints(4, 0, 1, 3, 0, 1, 0, 0, null, null, null, 0, false));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("<html><b>Note:</b> These settings are used for <b>compiling</b> Gradle-based Android projects.</html>");
        this.myContentPanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 3, 0, 1, 0, 0, null, null, null, 0, false));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("<html><br></html>");
        this.myContentPanel.add((Component)jBLabel3, new GridConstraints(1, 0, 1, 3, 0, 1, 0, 0, null, null, null, 0, false));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("<html><br></html>");
        this.myContentPanel.add((Component)jBLabel4, new GridConstraints(7, 0, 1, 3, 0, 1, 0, 0, null, null, null, 0, false));
        JBLabel jBLabel5 = new JBLabel();
        jBLabel5.setText("Command-line Options:");
        this.myContentPanel.add((Component)jBLabel5, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myContentPanel.add((Component)this.myCommandLineOptionsEditor, new GridConstraints(5, 1, 1, 2, 0, 1, 5, 0, null, null, null, 0, false));
        this.myContentPanel.add((Component)this.myCommandLineOptionsDocHyperlinkLabel, new GridConstraints(6, 0, 1, 3, 0, 1, 3, 3, null, null, null, 0, false));
        this.myContinueBuildWithErrors = new JCheckBox();
        this.myContinueBuildWithErrors.setText("Continue the build after failures");
        this.myContentPanel.add((Component)this.myContinueBuildWithErrors, new GridConstraints(8, 0, 1, 3, 8, 0, 3, 0, null, null, null, 0, false));
        JBLabel jBLabel6 = new JBLabel();
        jBLabel6.setText("<html><br></html>");
        this.myContentPanel.add((Component)jBLabel6, new GridConstraints(9, 0, 1, 3, 0, 1, 0, 0, null, null, null, 0, false));
    }

    @NotNull
    private static HyperlinkLabel createHyperlinkLabel(@NotNull String beforeLinkText, @NotNull String linkText, @NotNull String afterLinkText, @NotNull String target2) {
        HyperlinkLabel label2 = new HyperlinkLabel();
        label2.setHyperlinkText(beforeLinkText, linkText, afterLinkText);
        label2.setHyperlinkTarget(target2);
        return label2;
    }
}

