/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.flags.ExperimentalConfigurable;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.GradleExperimentalSettings;
import com.android.tools.idea.gradle.project.SyncDueMessage;
import com.android.tools.idea.gradle.project.sync.AutoSyncBehavior;
import com.android.tools.idea.gradle.project.sync.AutoSyncSettingStore;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.AutoSyncSettingChangeEvent;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class GradleExperimentalSettingsConfigurable
implements ExperimentalConfigurable {
    private JCheckBox myUseMultiVariantExtraArtifacts;
    private JCheckBox myConfigureAllGradleTasks;
    private JCheckBox myEnableParallelSync;
    private JCheckBox myEnableDeviceApiOptimization;
    private JCheckBox myDeriveRuntimeClasspathsForLibraries;
    private JCheckBox myShowAgpVersionChooserInNewProjectWizard;
    private JPanel myPanel;
    private JComboBox<AutoSyncBehavior> autoSyncBehaviorComboBox;
    private JLabel autoSyncSnoozeNote;
    @NotNull
    private final GradleExperimentalSettings mySettings;

    public GradleExperimentalSettingsConfigurable() {
        this(GradleExperimentalSettings.getInstance());
    }

    public GradleExperimentalSettingsConfigurable(@NotNull GradleExperimentalSettings settings) {
        this.setupUI();
        this.mySettings = settings;
        this.myEnableParallelSync.setVisible((Boolean)StudioFlags.GRADLE_SYNC_PARALLEL_SYNC_ENABLED.get());
        this.myDeriveRuntimeClasspathsForLibraries.setVisible((Boolean)StudioFlags.GRADLE_SKIP_RUNTIME_CLASSPATH_FOR_LIBRARIES.get());
        this.myEnableDeviceApiOptimization.setVisible((Boolean)StudioFlags.API_OPTIMIZATION_ENABLE.get());
        this.myUseMultiVariantExtraArtifacts.setVisible((Boolean)StudioFlags.GRADLE_MULTI_VARIANT_ADDITIONAL_ARTIFACT_SUPPORT.get());
        this.myShowAgpVersionChooserInNewProjectWizard.setVisible((Boolean)StudioFlags.NPW_SHOW_AGP_VERSION_COMBO_BOX_EXPERIMENTAL_SETTING.get());
        this.autoSyncBehaviorComboBox.setModel((ComboBoxModel<AutoSyncBehavior>)new EnumComboBoxModel(AutoSyncBehavior.class));
        this.autoSyncBehaviorComboBox.setRenderer((ListCellRenderer<AutoSyncBehavior>)SimpleListCellRenderer.create((String)"", behavior -> AndroidBundle.message(behavior.getLabelBundleKey(), new Object[0])));
        boolean showAutoSyncControlInExperimentalSettings = (Boolean)StudioFlags.SHOW_GRADLE_AUTO_SYNC_SETTING_UI.get() != false && (Boolean)StudioFlags.SHOW_GRADLE_AUTO_SYNC_SETTING_IN_NON_EXPERIMENTAL_UI.get() == false;
        this.autoSyncBehaviorComboBox.getParent().setVisible(showAutoSyncControlInExperimentalSettings);
        this.autoSyncSnoozeNote.setText(SyncDueMessage.INSTANCE.getSnoozedProjectsSummaryNote());
        this.reset();
    }

    @Nullable
    public JComponent createComponent() {
        return this.myPanel;
    }

    public boolean isModified() {
        return this.mySettings.USE_MULTI_VARIANT_EXTRA_ARTIFACTS != this.isUseMultiVariantExtraArtifact() || this.mySettings.SKIP_GRADLE_TASKS_LIST == this.isConfigureAllGradleTasksEnabled() || this.mySettings.ENABLE_PARALLEL_SYNC != this.isParallelSyncEnabled() || this.mySettings.ENABLE_GRADLE_API_OPTIMIZATION != this.isGradleApiOptimizationEnabled() || this.mySettings.DERIVE_RUNTIME_CLASSPATHS_FOR_LIBRARIES != this.isDeriveRuntimeClasspathsForLibraries() || this.mySettings.SHOW_ANDROID_GRADLE_PLUGIN_VERSION_COMBO_BOX_IN_NEW_PROJECT_WIZARD != this.isShowAgpVersionChooserInNewProjectWizard() || AutoSyncSettingStore.INSTANCE.getAutoSyncBehavior() != this.getAutoSyncBehaviorComboBox();
    }

    public void apply() throws ConfigurationException {
        this.mySettings.USE_MULTI_VARIANT_EXTRA_ARTIFACTS = this.isUseMultiVariantExtraArtifact();
        this.mySettings.SKIP_GRADLE_TASKS_LIST = !this.isConfigureAllGradleTasksEnabled();
        this.mySettings.ENABLE_PARALLEL_SYNC = this.isParallelSyncEnabled();
        this.mySettings.ENABLE_GRADLE_API_OPTIMIZATION = this.isGradleApiOptimizationEnabled();
        this.mySettings.DERIVE_RUNTIME_CLASSPATHS_FOR_LIBRARIES = this.isDeriveRuntimeClasspathsForLibraries();
        this.mySettings.SHOW_ANDROID_GRADLE_PLUGIN_VERSION_COMBO_BOX_IN_NEW_PROJECT_WIZARD = this.isShowAgpVersionChooserInNewProjectWizard();
        if (AutoSyncSettingStore.INSTANCE.getAutoSyncBehavior() != this.getAutoSyncBehaviorComboBox()) {
            AutoSyncSettingStore.INSTANCE.setAutoSyncBehavior(this.getAutoSyncBehaviorComboBox());
            this.trackAutoSyncSettingChanged();
            this.clearAutoSyncVariables();
            this.autoSyncSnoozeNote.setText(SyncDueMessage.INSTANCE.getSnoozedProjectsSummaryNote());
            if (this.getAutoSyncBehaviorComboBox() == AutoSyncBehavior.Default) {
                SyncDueMessage.INSTANCE.getProjectsWhereSyncIsDue().forEach(project -> GradleSyncInvoker.getInstance().requestProjectSync((Project)project, new GradleSyncInvoker.Request(GradleSyncStats.Trigger.TRIGGER_USER_REQUEST), null));
            }
        }
    }

    public void reset() {
        this.myUseMultiVariantExtraArtifacts.setSelected(this.mySettings.USE_MULTI_VARIANT_EXTRA_ARTIFACTS);
        this.myConfigureAllGradleTasks.setSelected(!this.mySettings.SKIP_GRADLE_TASKS_LIST);
        this.myEnableParallelSync.setSelected(this.mySettings.ENABLE_PARALLEL_SYNC);
        this.myEnableDeviceApiOptimization.setSelected(this.mySettings.ENABLE_GRADLE_API_OPTIMIZATION);
        this.myDeriveRuntimeClasspathsForLibraries.setSelected(this.mySettings.DERIVE_RUNTIME_CLASSPATHS_FOR_LIBRARIES);
        this.myShowAgpVersionChooserInNewProjectWizard.setSelected(this.mySettings.SHOW_ANDROID_GRADLE_PLUGIN_VERSION_COMBO_BOX_IN_NEW_PROJECT_WIZARD);
        this.autoSyncBehaviorComboBox.setSelectedIndex(AutoSyncBehavior.getEntries().indexOf((Object)AutoSyncSettingStore.INSTANCE.getAutoSyncBehavior()));
        this.autoSyncSnoozeNote.setText(SyncDueMessage.INSTANCE.getSnoozedProjectsSummaryNote());
    }

    @VisibleForTesting
    boolean isUseMultiVariantExtraArtifact() {
        return this.myUseMultiVariantExtraArtifacts.isSelected();
    }

    @TestOnly
    void enableUseMultiVariantExtraArtifacts(boolean value2) {
        this.myUseMultiVariantExtraArtifacts.setSelected(value2);
    }

    boolean isConfigureAllGradleTasksEnabled() {
        return this.myConfigureAllGradleTasks.isSelected();
    }

    @TestOnly
    void enableConfigureAllGradleTasks(boolean value2) {
        this.myConfigureAllGradleTasks.setSelected(value2);
    }

    boolean isParallelSyncEnabled() {
        return this.myEnableParallelSync.isSelected();
    }

    @TestOnly
    void enableParallelSync(boolean value2) {
        this.myEnableParallelSync.setSelected(value2);
    }

    boolean isGradleApiOptimizationEnabled() {
        return this.myEnableDeviceApiOptimization.isSelected();
    }

    @TestOnly
    void enableGradleApiOptimization(boolean value2) {
        this.myEnableDeviceApiOptimization.setSelected(value2);
    }

    boolean isDeriveRuntimeClasspathsForLibraries() {
        return this.myDeriveRuntimeClasspathsForLibraries.isSelected();
    }

    @TestOnly
    void enableDeriveRuntimeClasspathsForLibraries(boolean value2) {
        this.myDeriveRuntimeClasspathsForLibraries.setSelected(value2);
    }

    public boolean isShowAgpVersionChooserInNewProjectWizard() {
        return this.myShowAgpVersionChooserInNewProjectWizard.isSelected();
    }

    @TestOnly
    public void enableShowAndroidGradlePluginVersionChooserInNewProjectWizard(boolean value2) {
        this.myShowAgpVersionChooserInNewProjectWizard.setSelected(value2);
    }

    AutoSyncBehavior getAutoSyncBehaviorComboBox() {
        return (AutoSyncBehavior)((Object)this.autoSyncBehaviorComboBox.getSelectedItem());
    }

    private void clearAutoSyncVariables() {
        PropertiesComponent.getInstance().unsetValue("gradle.settings.autoSync.notification.snooze.expiration.date");
        PropertiesComponent.getInstance().unsetValue("gradle.settings.autoSync.dialog.shown");
    }

    private void trackAutoSyncSettingChanged() {
        UsageTracker.log((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.AUTO_SYNC_SETTING_CHANGE).setAutoSyncSettingChangeEvent(AutoSyncSettingChangeEvent.newBuilder().setState(this.getAutoSyncBehaviorComboBox() == AutoSyncBehavior.Default).setChangeSource(AutoSyncSettingChangeEvent.ChangeSource.SETTINGS).build()));
    }

    private void setupUI() {
        this.myPanel = new JPanel();
        this.myPanel.setLayout((LayoutManager)new GridLayoutManager(8, 2, new Insets(0, 0, 0, 0), -1, -1));
        Spacer spacer1 = new Spacer();
        this.myPanel.add((Component)spacer1, new GridConstraints(7, 0, 1, 2, 0, 2, 1, 4, null, null, null, 0, false));
        this.myUseMultiVariantExtraArtifacts = new JCheckBox();
        this.myUseMultiVariantExtraArtifacts.setText("Enable support for multi-variant Javadocs and Sources");
        this.myPanel.add((Component)this.myUseMultiVariantExtraArtifacts, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null, 0, false));
        this.myConfigureAllGradleTasks = new JCheckBox();
        this.myConfigureAllGradleTasks.setText("Configure all Gradle tasks during Gradle Sync (this can make Gradle Sync slower)");
        this.myPanel.add((Component)this.myConfigureAllGradleTasks, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null, 0, false));
        this.myEnableParallelSync = new JCheckBox();
        this.myEnableParallelSync.setText("Enable parallel Gradle Sync");
        this.myPanel.add((Component)this.myEnableParallelSync, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.myEnableDeviceApiOptimization = new JCheckBox();
        this.myEnableDeviceApiOptimization.setText("Optimize build for target device API level only");
        this.myPanel.add((Component)this.myEnableDeviceApiOptimization, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.myDeriveRuntimeClasspathsForLibraries = new JCheckBox();
        this.myDeriveRuntimeClasspathsForLibraries.setText("Derive runtime classpaths for libraries from application modules");
        this.myPanel.add((Component)this.myDeriveRuntimeClasspathsForLibraries, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.myShowAgpVersionChooserInNewProjectWizard = new JCheckBox();
        this.myShowAgpVersionChooserInNewProjectWizard.setText("Show Android Gradle plugin version dropdown in the New Project Wizard");
        this.myPanel.add((Component)this.myShowAgpVersionChooserInNewProjectWizard, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myPanel.add((Component)panel1, new GridConstraints(6, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.autoSyncSnoozeNote = new JLabel();
        panel1.add((Component)this.autoSyncSnoozeNote, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null, 0, false));
        this.autoSyncBehaviorComboBox = new JComboBox();
        this.autoSyncBehaviorComboBox.setToolTipText("");
        panel1.add(this.autoSyncBehaviorComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null, 0, false));
        JLabel label1 = new JLabel();
        label1.setText("Project Sync mode");
        panel1.add((Component)label1, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.autoSyncSnoozeNote = new JLabel();
        panel1.add((Component)this.autoSyncSnoozeNote, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null, 0, false));
    }
}

