/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.sdklib.AndroidVersion;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.analytics.UsageTrackerUtils;
import com.android.tools.idea.gradle.project.AndroidSdkCompatibilityChecker;
import com.android.tools.idea.serverflags.protos.StudioVersionRecommendation;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.UpgradeAndroidStudioDialogStats;
import com.intellij.CommonBundle;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.BrowserLink;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 '2\u00020\u0001:\u0002&'B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t0\b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0015\u001a\u00020\u0016H\u0014J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\nJ\u0013\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0014\u00a2\u0006\u0002\u0010\u001eJ\b\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010!\u001a\u00020 2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020#H\u0002J\"\u0010$\u001a\u00020\n2\u0018\u0010%\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t0\bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R#\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006("}, d2={"Lcom/android/tools/idea/gradle/project/AndroidSdkCompatibilityDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "recommendedVersion", "Lcom/android/tools/idea/serverflags/protos/StudioVersionRecommendation;", "potentialFallbackVersion", "modulesViolatingSupportRules", "", "Lkotlin/Pair;", "", "Lcom/android/sdklib/AndroidVersion;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/serverflags/protos/StudioVersionRecommendation;Lcom/android/tools/idea/serverflags/protos/StudioVersionRecommendation;Ljava/util/List;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getRecommendedVersion", "()Lcom/android/tools/idea/serverflags/protos/StudioVersionRecommendation;", "getPotentialFallbackVersion", "getModulesViolatingSupportRules", "()Ljava/util/List;", "createCenterPanel", "Ljavax/swing/JComponent;", "htmlTextLabelWithFixedLines", "Ljavax/swing/JEditorPane;", "htmlBodyContent", "panelName", "createActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "doCancelAction", "", "logEvent", "action", "Lcom/google/wireless/android/sdk/stats/UpgradeAndroidStudioDialogStats$UserAction;", "getAffectedModules", "modules", "DontAskAgainAction", "Companion", "intellij.android.projectSystem.gradle"})
public final class AndroidSdkCompatibilityDialog
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final StudioVersionRecommendation recommendedVersion;
    @Nullable
    private final StudioVersionRecommendation potentialFallbackVersion;
    @NotNull
    private final List<Pair<String, AndroidVersion>> modulesViolatingSupportRules;
    @NotNull
    public static final String DO_NOT_ASK_FOR_PROJECT_BUTTON_TEXT = "Don't ask for this project";
    @NotNull
    public static final String ANDROID_STUDIO_DOC_LINK = "https://developer.android.com/studio/releases#api-level-support";

    public AndroidSdkCompatibilityDialog(@NotNull Project project, @NotNull StudioVersionRecommendation recommendedVersion, @Nullable StudioVersionRecommendation potentialFallbackVersion, @NotNull List<Pair<String, AndroidVersion>> modulesViolatingSupportRules) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)recommendedVersion, (String)"recommendedVersion");
        Intrinsics.checkNotNullParameter(modulesViolatingSupportRules, (String)"modulesViolatingSupportRules");
        super(project, true, DialogWrapper.IdeModalityType.MODELESS);
        this.project = project;
        this.recommendedVersion = recommendedVersion;
        this.potentialFallbackVersion = potentialFallbackVersion;
        this.modulesViolatingSupportRules = modulesViolatingSupportRules;
        this.setTitle(!this.recommendedVersion.getVersionReleased() && this.potentialFallbackVersion == null ? AndroidBundle.message("project.upgrade.studio.notification.no.recommendation.title", new Object[0]) : AndroidBundle.message("project.upgrade.studio.notification.title", new Object[0]));
        this.setResizable(false);
        this.setCancelButtonText(CommonBundle.getCloseButtonText());
        this.init();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final StudioVersionRecommendation getRecommendedVersion() {
        return this.recommendedVersion;
    }

    @Nullable
    public final StudioVersionRecommendation getPotentialFallbackVersion() {
        return this.potentialFallbackVersion;
    }

    @NotNull
    public final List<Pair<String, AndroidVersion>> getModulesViolatingSupportRules() {
        return this.modulesViolatingSupportRules;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        BorderLayoutPanel borderLayoutPanel;
        JPanel jPanel;
        JPanel jPanel2;
        String string;
        if (!this.recommendedVersion.getVersionReleased()) {
            if (this.potentialFallbackVersion != null) {
                var2_1 = new Object[]{ApplicationInfo.getInstance().getFullVersion(), this.potentialFallbackVersion.getBuildDisplayName()};
                string = AndroidBundle.message("project.upgrade.studio.notification.body.different.channel.recommendation", var2_1);
            } else {
                var2_1 = new Object[]{ApplicationInfo.getInstance().getFullVersion()};
                string = AndroidBundle.message("project.upgrade.studio.notification.body.no.recommendation", var2_1);
            }
        } else {
            var2_1 = new Object[]{ApplicationInfo.getInstance().getFullVersion(), this.recommendedVersion.getBuildDisplayName()};
            string = AndroidBundle.message("project.upgrade.studio.notification.body.same.channel.recommendation", var2_1);
        }
        String dialogContent = string;
        JPanel $this$createCenterPanel_u24lambda_u240 = jPanel2 = new JPanel((LayoutManager)new HorizontalLayout(0, 0, 2, null));
        boolean bl = false;
        Pair pair = new Pair((Object)"For more details, please refer to the ", (Object)"Android Studio documentation");
        String preLink = (String)pair.component1();
        String link2 = (String)pair.component2();
        BrowserLink browserLink = new BrowserLink(link2, ANDROID_STUDIO_DOC_LINK);
        $this$createCenterPanel_u24lambda_u240.add((Component)new JLabel(preLink), "LEFT");
        $this$createCenterPanel_u24lambda_u240.add((Component)browserLink, "LEFT");
        JPanel documentationLinkLine = jPanel2;
        JPanel $this$createCenterPanel_u24lambda_u241 = jPanel = new JPanel();
        boolean bl2 = false;
        $this$createCenterPanel_u24lambda_u241.setLayout(new BoxLayout($this$createCenterPanel_u24lambda_u241, 1));
        Intrinsics.checkNotNull((Object)dialogContent);
        $this$createCenterPanel_u24lambda_u241.add(this.htmlTextLabelWithFixedLines(dialogContent, "main-content"));
        $this$createCenterPanel_u24lambda_u241.add(new JLabel(" "));
        $this$createCenterPanel_u24lambda_u241.add(documentationLinkLine);
        $this$createCenterPanel_u24lambda_u241.add(new JLabel(" "));
        $this$createCenterPanel_u24lambda_u241.add(this.htmlTextLabelWithFixedLines(this.getAffectedModules(this.modulesViolatingSupportRules), "affected-modules"));
        JPanel panel2 = jPanel;
        BorderLayoutPanel $this$createCenterPanel_u24lambda_u242 = borderLayoutPanel = JBUI.Panels.simplePanel((int)10, (int)10);
        boolean bl3 = false;
        $this$createCenterPanel_u24lambda_u242.addToTop((Component)panel2);
        $this$createCenterPanel_u24lambda_u242.setPreferredSize((Dimension)new JBDimension(550, 325));
        BorderLayoutPanel borderLayoutPanel2 = borderLayoutPanel;
        Intrinsics.checkNotNullExpressionValue((Object)borderLayoutPanel2, (String)"apply(...)");
        return (JComponent)borderLayoutPanel2;
    }

    @NotNull
    public final JEditorPane htmlTextLabelWithFixedLines(@NotNull String htmlBodyContent, @NotNull String panelName) {
        JEditorPane jEditorPane;
        Intrinsics.checkNotNullParameter((Object)htmlBodyContent, (String)"htmlBodyContent");
        Intrinsics.checkNotNullParameter((Object)panelName, (String)"panelName");
        JEditorPane jEditorPane2 = SwingHelper.createHtmlViewer((boolean)false, null, (Color)JBColor.background(), null);
        Intrinsics.checkNotNullExpressionValue((Object)jEditorPane2, (String)"createHtmlViewer(...)");
        JEditorPane $this$htmlTextLabelWithFixedLines_u24lambda_u240 = jEditorPane = jEditorPane2;
        boolean bl = false;
        $this$htmlTextLabelWithFixedLines_u24lambda_u240.setName(panelName);
        $this$htmlTextLabelWithFixedLines_u24lambda_u240.setBorder((Border)JBUI.Borders.empty());
        $this$htmlTextLabelWithFixedLines_u24lambda_u240.setEditable(false);
        SwingHelper.setHtml((JEditorPane)$this$htmlTextLabelWithFixedLines_u24lambda_u240, (String)htmlBodyContent, null);
        $this$htmlTextLabelWithFixedLines_u24lambda_u240.setCaretPosition(0);
        $this$htmlTextLabelWithFixedLines_u24lambda_u240.addHyperlinkListener(AndroidSdkCompatibilityDialog::htmlTextLabelWithFixedLines$lambda$0$0);
        return jEditorPane;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[2];
        Intrinsics.checkNotNullExpressionValue((Object)this.getCancelAction(), (String)"getCancelAction(...)");
        actionArray[1] = new DontAskAgainAction();
        return actionArray;
    }

    public void doCancelAction() {
        this.logEvent(this.project, UpgradeAndroidStudioDialogStats.UserAction.CANCEL);
        super.doCancelAction();
    }

    /*
     * WARNING - void declaration
     */
    private final void logEvent(Project project, UpgradeAndroidStudioDialogStats.UserAction action2) {
        void $this$logEvent_u24lambda_u240;
        UpgradeAndroidStudioDialogStats.Builder builder;
        AndroidStudioEvent.Builder builder2 = AndroidStudioEvent.newBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"newBuilder(...)");
        UpgradeAndroidStudioDialogStats.Builder builder3 = builder = UpgradeAndroidStudioDialogStats.newBuilder();
        AndroidStudioEvent.Builder builder4 = UsageTrackerUtils.withProjectId(builder2, project).setKind(AndroidStudioEvent.EventKind.UPGRADE_ANDROID_STUDIO_DIALOG);
        boolean bl = false;
        $this$logEvent_u24lambda_u240.setUserAction(action2);
        AndroidStudioEvent.Builder builder5 = builder4.setUpgradeAndroidStudioDialog(builder);
        Intrinsics.checkNotNullExpressionValue((Object)builder5, (String)"setUpgradeAndroidStudioDialog(...)");
        UsageTracker.log((AndroidStudioEvent.Builder)builder5);
    }

    private final String getAffectedModules(List<Pair<String, AndroidVersion>> modules) {
        List modulesToShow = CollectionsKt.take((Iterable)modules, (int)5);
        List remainingModules = CollectionsKt.drop((Iterable)modules, (int)5);
        StringBuilder content2 = new StringBuilder();
        content2.append("Affected modules: " + CollectionsKt.joinToString$default((Iterable)modulesToShow, null, null, null, (int)0, null, AndroidSdkCompatibilityDialog::getAffectedModules$lambda$0, (int)31, null));
        if (!((Collection)remainingModules).isEmpty()) {
            content2.append(" (and " + remainingModules.size() + " more)");
        }
        String string = content2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final void htmlTextLabelWithFixedLines$lambda$0$0(HyperlinkEvent e) {
        if (Intrinsics.areEqual((Object)e.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED) && Desktop.isDesktopSupported()) {
            Desktop.getDesktop().browse(e.getURL().toURI());
        }
    }

    private static final CharSequence getAffectedModules$lambda$0(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "<br/>'" + it.getFirst() + "' (compileSdk=" + ((AndroidVersion)it.getSecond()).getApiStringWithoutExtension() + ")";
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/gradle/project/AndroidSdkCompatibilityDialog$Companion;", "", "<init>", "()V", "DO_NOT_ASK_FOR_PROJECT_BUTTON_TEXT", "", "ANDROID_STUDIO_DOC_LINK", "intellij.android.projectSystem.gradle"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/gradle/project/AndroidSdkCompatibilityDialog$DontAskAgainAction;", "Ljavax/swing/AbstractAction;", "<init>", "(Lcom/android/tools/idea/gradle/project/AndroidSdkCompatibilityDialog;)V", "actionPerformed", "", "e", "Ljava/awt/event/ActionEvent;", "intellij.android.projectSystem.gradle"})
    private final class DontAskAgainAction
    extends AbstractAction {
        public DontAskAgainAction() {
            super(AndroidSdkCompatibilityDialog.DO_NOT_ASK_FOR_PROJECT_BUTTON_TEXT);
        }

        @Override
        public void actionPerformed(@Nullable ActionEvent e) {
            AndroidSdkCompatibilityChecker.StudioUpgradeReminder studioUpgradeReminder;
            AndroidSdkCompatibilityDialog.this.logEvent(AndroidSdkCompatibilityDialog.this.getProject(), UpgradeAndroidStudioDialogStats.UserAction.DO_NOT_ASK_AGAIN);
            AndroidSdkCompatibilityChecker.StudioUpgradeReminder $this$actionPerformed_u24lambda_u240 = studioUpgradeReminder = new AndroidSdkCompatibilityChecker.StudioUpgradeReminder(AndroidSdkCompatibilityDialog.this.getProject());
            boolean bl = false;
            $this$actionPerformed_u24lambda_u240.setDoNotAskAgainProjectLevel(true);
            $this$actionPerformed_u24lambda_u240.setDoNotAskAgainIdeLevel(true);
            AndroidSdkCompatibilityDialog.this.close(0);
        }
    }
}

