/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.notification;

import com.android.tools.idea.FileEditorUtil;
import com.android.tools.idea.gradle.project.model.GradleAndroidModel;
import com.android.tools.idea.gradle.util.GradleProjectSystemUtil;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.GeneratedSourceFileChangeTracker;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import java.io.File;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneratedFileNotificationProvider
implements EditorNotificationProvider {
    @Nullable
    public Function<FileEditor, EditorNotificationPanel> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        GeneratedSourceFileChangeTracker generatedSourceFileChangeTracker = GeneratedSourceFileChangeTracker.getInstance((Project)project);
        GradleAndroidModel androidModel = GradleProjectSystemUtil.findAndroidModelInModule(project, file, false);
        if (androidModel == null) {
            return null;
        }
        File buildFolderPath = androidModel.getAndroidProject().getBuildFolder();
        VirtualFile buildFolder = VfsUtil.findFileByIoFile((File)buildFolderPath, (boolean)false);
        if (buildFolder == null || !buildFolder.isDirectory()) {
            return null;
        }
        if (!VfsUtilCore.isAncestor((VirtualFile)buildFolder, (VirtualFile)file, (boolean)false)) {
            return null;
        }
        if (generatedSourceFileChangeTracker.isEditedGeneratedFile(file)) {
            return null;
        }
        return fileEditor -> {
            if (((Boolean)FileEditorUtil.DISABLE_GENERATED_FILE_NOTIFICATION_KEY.get((UserDataHolder)fileEditor, (Object)false)).booleanValue()) {
                return null;
            }
            return new MyEditorNotificationPanel((FileEditor)fileEditor, "Files under the \"build\" folder are generated and should not be edited.");
        };
    }

    @VisibleForTesting
    static class MyEditorNotificationPanel
    extends EditorNotificationPanel {
        MyEditorNotificationPanel(@NotNull FileEditor fileEditor, @NotNull String text2) {
            super(fileEditor, EditorNotificationPanel.Status.Warning);
            this.setText(text2);
        }
    }
}

