/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.files;

import com.android.tools.idea.gradle.dsl.model.BuildModelContext;
import com.android.tools.idea.gradle.dsl.model.GradleBlockModelMap;
import com.android.tools.idea.gradle.dsl.parser.GradleDslNameConverter;
import com.android.tools.idea.gradle.dsl.parser.apply.ApplyDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradlePropertiesFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleScriptFile;
import com.android.tools.idea.gradle.dsl.parser.java.JavaDslElement;
import com.android.tools.idea.gradle.dsl.parser.semantics.MethodSemanticsDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelEffectDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelPropertyDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.PropertiesElementDescription;
import com.google.common.collect.Sets;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleBuildFile
extends GradleScriptFile {
    @Nullable
    private GradlePropertiesFile myPropertiesFile;
    @Nullable
    private GradleBuildFile myParentModuleBuildFile;
    @NotNull
    private final Set<GradleBuildFile> myChildModuleBuildFiles = Sets.newHashSet();

    public GradleBuildFile(@NotNull VirtualFile file, @NotNull Project project, @NotNull String moduleName, @NotNull BuildModelContext context) {
        super(file, project, moduleName, context);
    }

    @Override
    public void addParsedElement(@NotNull GradleDslElement element) {
        if ("apply".equals(element.getFullName())) {
            ApplyDslElement applyDslElement = this.getPropertyElement("apply", ApplyDslElement.class);
            if (applyDslElement == null) {
                applyDslElement = new ApplyDslElement(this, this);
                super.addParsedElement(applyDslElement);
            }
            applyDslElement.addParsedElement(element);
            return;
        }
        super.addParsedElement(element);
    }

    @Override
    public void setParsedElement(@NotNull GradleDslElement element) {
        ModelEffectDescription effect = null;
        if (element instanceof GradleDslLiteral) {
            if (element.getName().equals("sourceCompatibility")) {
                effect = new ModelEffectDescription(new ModelPropertyDescription("mSourceCompatibility"), MethodSemanticsDescription.SET);
            } else if (element.getName().equals("targetCompatibility")) {
                effect = new ModelEffectDescription(new ModelPropertyDescription("mTargetCompatibility"), MethodSemanticsDescription.SET);
            } else {
                super.setParsedElement(element);
                return;
            }
            JavaDslElement javaDslElement = this.getPropertyElement(JavaDslElement.JAVA);
            if (javaDslElement == null) {
                javaDslElement = new JavaDslElement(this, GradleNameElement.create(JavaDslElement.JAVA.name));
                this.setParsedElement(javaDslElement);
            }
            element.setModelEffect(effect);
            javaDslElement.setParsedElement(element);
            return;
        }
        super.setParsedElement(element);
    }

    @Override
    public void addAppliedProperty(GradleDslElement element) {
        if (element instanceof GradleDslLiteral) {
            ModelEffectDescription effect;
            if (element.getName().equals("sourceCompatibility")) {
                effect = new ModelEffectDescription(new ModelPropertyDescription("mSourceCompatibility"), MethodSemanticsDescription.SET);
            } else if (element.getName().equals("targetCompatibility")) {
                effect = new ModelEffectDescription(new ModelPropertyDescription("mTargetCompatibility"), MethodSemanticsDescription.SET);
            } else {
                super.addAppliedProperty(element);
                return;
            }
            JavaDslElement javaDslElement = this.getPropertyElement(JavaDslElement.JAVA);
            if (javaDslElement == null) {
                javaDslElement = new JavaDslElement(this, GradleNameElement.create(JavaDslElement.JAVA.name));
                this.addAppliedProperty(javaDslElement);
            }
            element.setModelEffect(effect);
            javaDslElement.addAppliedProperty(element);
            return;
        }
        super.addAppliedProperty(element);
    }

    @Override
    @NotNull
    public Map<String, PropertiesElementDescription<?>> getChildPropertiesElementsDescriptionMap(@NotNull GradleDslNameConverter.Kind kind) {
        return GradleBlockModelMap.getElementMap(GradleBuildFile.class, kind);
    }

    public void setPropertiesFile(@NotNull GradlePropertiesFile propertiesFile) {
        this.myPropertiesFile = propertiesFile;
    }

    @Nullable
    public GradlePropertiesFile getPropertiesFile() {
        return this.myPropertiesFile;
    }

    public void setParentModuleBuildFile(@NotNull GradleBuildFile parentModuleBuildFile) {
        this.myParentModuleBuildFile = parentModuleBuildFile;
        this.myParentModuleBuildFile.myChildModuleBuildFiles.add(this);
    }

    @Nullable
    public GradleBuildFile getParentModuleBuildFile() {
        return this.myParentModuleBuildFile;
    }

    @NotNull
    public Collection<GradleBuildFile> getChildModuleBuildFiles() {
        return this.myChildModuleBuildFiles;
    }
}

