/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.parser.GradleReferenceInjection;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.semantics.PropertiesElementDescription;
import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GradleDslExpressionMap
extends GradlePropertiesDslElement
implements GradleDslExpression {
    public static final PropertiesElementDescription<GradleDslExpressionMap> VERSIONS = new PropertiesElementDescription<GradleDslExpressionMap>("versions", GradleDslExpressionMap.class, GradleDslExpressionMap::new);
    private boolean myShouldBeDeleted;
    private boolean asNamedArgs;
    private boolean myIsLiteralMap;

    public GradleDslExpressionMap(@Nullable GradleDslElement parent, @NotNull GradleNameElement name2) {
        super(parent, null, name2);
    }

    public GradleDslExpressionMap(@Nullable GradleDslElement parent, @NotNull GradleNameElement name2, boolean isLiteralMap) {
        super(parent, null, name2);
        this.myIsLiteralMap = isLiteralMap;
    }

    public GradleDslExpressionMap(@Nullable GradleDslElement parent, @Nullable PsiElement psiElement, @NotNull GradleNameElement name2, boolean isLiteralMap) {
        super(parent, psiElement, name2);
        this.myIsLiteralMap = isLiteralMap;
    }

    public void addNewLiteral(String key, Object value2) {
        GradleDslElement propertyElement = this.getPropertyElement(key);
        if (propertyElement instanceof GradleDslLiteral) {
            ((GradleDslLiteral)propertyElement).setValue(value2);
            return;
        }
        GradleNameElement name2 = GradleNameElement.create(key);
        GradleDslLiteral gradleDslLiteral = new GradleDslLiteral(this, name2);
        this.setNewElement(gradleDslLiteral);
        gradleDslLiteral.setValue(value2);
    }

    @Override
    @Nullable
    public PsiElement create() {
        return this.getDslFile().getWriter().createDslExpressionMap(this);
    }

    @Override
    public void delete() {
        this.myShouldBeDeleted = true;
        super.delete();
    }

    @Override
    public void apply() {
        this.getDslFile().getWriter().applyDslExpressionMap(this);
        super.apply();
    }

    public boolean isLiteralMap() {
        return this.myIsLiteralMap;
    }

    public boolean getAsNamedArgs() {
        return this.asNamedArgs;
    }

    public void setAsNamedArgs(boolean value2) {
        this.asNamedArgs = value2;
    }

    @Override
    @Nullable
    public PsiElement getExpression() {
        return this.getPsiElement();
    }

    public boolean shouldBeDeleted() {
        return !this.isLiteralMap() || this.myShouldBeDeleted;
    }

    @Override
    @NotNull
    public List<GradleReferenceInjection> getResolvedVariables() {
        return this.getDependencies().stream().filter(e -> e.isResolved()).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public GradleDslExpressionMap copy() {
        GradleDslExpressionMap mapClone = new GradleDslExpressionMap(this.myParent, GradleNameElement.copy(this.myName), false);
        for (GradleDslElement element : this.getCurrentElements()) {
            GradleDslExpression sourceExpression = (GradleDslExpression)element;
            GradleDslExpression copiedExpression = sourceExpression.copy();
            mapClone.setNewElement(copiedExpression);
        }
        return mapClone;
    }
}

