/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.dependencies;

import com.android.tools.idea.gradle.dsl.api.dependencies.FileTreeDependencyModel;
import com.android.tools.idea.gradle.dsl.api.ext.ResolvedPropertyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyModelImpl;
import com.android.tools.idea.gradle.dsl.model.dependencies.ScriptDependenciesModelImpl;
import com.android.tools.idea.gradle.dsl.model.ext.GradlePropertyModelBuilder;
import com.android.tools.idea.gradle.dsl.model.ext.transforms.MapMethodTransform;
import com.android.tools.idea.gradle.dsl.model.ext.transforms.SingleArgToMapTransform;
import com.android.tools.idea.gradle.dsl.model.ext.transforms.SingleArgumentMethodTransform;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTreeDependencyModelImpl
extends DependencyModelImpl
implements FileTreeDependencyModel {
    @NonNls
    public static final String FILE_TREE = "fileTree";
    @NonNls
    public static final String DIR = "dir";
    @NonNls
    private static final String INCLUDE = "include";
    @NonNls
    private static final String EXCLUDE = "exclude";
    @NotNull
    private GradleDslMethodCall myDslElement;

    @NotNull
    static FileTreeDependencyModel createNew(@NotNull GradlePropertiesDslElement parent, @NotNull String configurationName, @NotNull String dir, @Nullable List<String> includes, @Nullable List<String> excludes) {
        GradleDslMethodCall newElement = new GradleDslMethodCall((GradleDslElement)parent, GradleNameElement.create(configurationName), FILE_TREE);
        FileTreeDependencyModel fileTreeModel = FileTreeDependencyModelImpl.create(newElement, configurationName, ScriptDependenciesModelImpl.Maintainers.SINGLE_ITEM_MAINTAINER);
        assert (fileTreeModel != null);
        fileTreeModel.dir().setValue(dir);
        ResolvedPropertyModel includesModel = fileTreeModel.includes();
        if (includes != null) {
            includesModel.convertToEmptyList();
            includes.forEach(e -> includesModel.addListValue().setValue(e));
        }
        ResolvedPropertyModel excludesModel = fileTreeModel.excludes();
        if (excludes != null) {
            excludesModel.convertToEmptyList();
            excludes.forEach(e -> excludesModel.addListValue().setValue(e));
        }
        parent.setNewElement(newElement);
        return fileTreeModel;
    }

    @Nullable
    static FileTreeDependencyModel create(@NotNull GradleDslMethodCall methodCall, @NotNull String configName, @NotNull DependencyModelImpl.Maintainer maintainer) {
        if (!methodCall.getMethodName().equals(FILE_TREE)) {
            return null;
        }
        return new FileTreeDependencyModelImpl(configName, methodCall, maintainer);
    }

    private FileTreeDependencyModelImpl(@NotNull String configurationName, @NotNull GradleDslMethodCall dslElement, @NotNull DependencyModelImpl.Maintainer maintainer) {
        super(configurationName, maintainer);
        this.myDslElement = dslElement;
    }

    @Override
    @NotNull
    protected GradleDslElement getDslElement() {
        return this.myDslElement;
    }

    @Override
    void setDslElement(@NotNull GradleDslElement dslElement) {
        this.myDslElement = (GradleDslMethodCall)dslElement;
    }

    @Override
    @NotNull
    public ResolvedPropertyModel dir() {
        return GradlePropertyModelBuilder.create(this.myDslElement).addTransform(new MapMethodTransform(FILE_TREE, DIR)).addTransform(new SingleArgumentMethodTransform(FILE_TREE)).buildResolved();
    }

    @Override
    @NotNull
    public ResolvedPropertyModel includes() {
        return GradlePropertyModelBuilder.create(this.myDslElement).addTransform(new SingleArgToMapTransform(DIR, INCLUDE)).addTransform(new MapMethodTransform(FILE_TREE, INCLUDE)).buildResolved();
    }

    @Override
    @NotNull
    public ResolvedPropertyModel excludes() {
        return GradlePropertyModelBuilder.create(this.myDslElement).addTransform(new SingleArgToMapTransform(DIR, EXCLUDE)).addTransform(new MapMethodTransform(FILE_TREE, EXCLUDE)).buildResolved();
    }
}

