/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.android;

import com.android.tools.idea.gradle.dsl.api.android.UseLibraryModel;
import com.android.tools.idea.gradle.dsl.model.ext.PropertyUtil;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.intellij.psi.PsiElement;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UseLibraryModelImpl
implements UseLibraryModel {
    @NotNull
    private final GradleDslElement myDslElement;

    UseLibraryModelImpl(@NotNull GradleDslElement element) {
        this.myDslElement = element;
    }

    @Override
    @NotNull
    public String name() {
        GradleDslElement gradleDslElement = this.myDslElement;
        if (gradleDslElement instanceof GradleDslMethodCall) {
            GradleDslMethodCall methodCall = (GradleDslMethodCall)gradleDslElement;
            return methodCall.getArguments().stream().findFirst().map(arg -> ((GradleDslLiteral)arg).getValue(String.class)).orElseThrow();
        }
        gradleDslElement = this.myDslElement;
        if (gradleDslElement instanceof GradleDslLiteral) {
            GradleDslLiteral literal = (GradleDslLiteral)gradleDslElement;
            return Objects.requireNonNull(literal.getValue(String.class));
        }
        throw new NoSuchElementException("unexpected GradleDslElement in UseLibraryModel" + String.valueOf(this.myDslElement));
    }

    @Override
    public boolean required() {
        GradleDslElement gradleDslElement = this.myDslElement;
        if (gradleDslElement instanceof GradleDslMethodCall) {
            GradleDslMethodCall methodCall = (GradleDslMethodCall)gradleDslElement;
            return methodCall.getArguments().stream().skip(1L).findFirst().map(arg -> ((GradleDslLiteral)arg).getValue(Boolean.class)).orElse(true);
        }
        if (this.myDslElement instanceof GradleDslLiteral) {
            return true;
        }
        throw new NoSuchElementException("unexpected GradleDslElement in UseLibraryModel" + String.valueOf(this.myDslElement));
    }

    @Override
    public void delete() {
        PropertyUtil.removeElement(this.myDslElement);
    }

    @Override
    @Nullable
    public PsiElement getPsiElement() {
        return this.myDslElement.getPsiElement();
    }

    static UseLibraryModel createNew(@NotNull GradlePropertiesDslElement parent, @NotNull String libraryName) {
        return UseLibraryModelImpl.createNew(parent, libraryName, null);
    }

    static UseLibraryModel createNew(@NotNull GradlePropertiesDslElement parent, @NotNull String libraryName, @Nullable Boolean required) {
        GradleDslMethodCall methodCall = new GradleDslMethodCall((GradleDslElement)parent, GradleNameElement.empty(), "useLibrary");
        GradleDslLiteral nameArgument = new GradleDslLiteral(methodCall, GradleNameElement.empty());
        nameArgument.setValue(libraryName);
        methodCall.addNewArgument(nameArgument);
        if (required != null) {
            GradleDslLiteral requiredArgument = new GradleDslLiteral(methodCall, GradleNameElement.empty());
            requiredArgument.setValue(required);
            methodCall.addNewArgument(requiredArgument);
        }
        parent.setNewElement(methodCall);
        return new UseLibraryModelImpl(methodCall);
    }
}

