/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.catalog;

import com.android.tools.idea.gradle.catalog.VersionsTomlAnnotator$checkTableDuplication$;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.toml.lang.psi.TomlArray;
import org.toml.lang.psi.TomlFile;
import org.toml.lang.psi.TomlInlineTable;
import org.toml.lang.psi.TomlKey;
import org.toml.lang.psi.TomlKeySegment;
import org.toml.lang.psi.TomlKeyValue;
import org.toml.lang.psi.TomlLiteral;
import org.toml.lang.psi.TomlTable;
import org.toml.lang.psi.TomlTableHeader;
import org.toml.lang.psi.TomlValue;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 +2\u00020\u0001:\u0001+B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0015\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\u0018H\u0002J \u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u001d\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u0006H\u0002J\f\u0010!\u001a\u00020\"*\u00020\"H\u0002J\u0018\u0010#\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000eH\u0002J\f\u0010$\u001a\u00020\u001a*\u00020\fH\u0002J\u0018\u0010%\u001a\u00020\n2\u0006\u0010&\u001a\u00020'2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010(\u001a\u000e\u0018\u00010\u0006\u00a2\u0006\u0002\b)\u00a2\u0006\u0002\b**\u00020\u0016H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/android/tools/idea/gradle/catalog/VersionsTomlAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "<init>", "()V", "dependencyTables", "", "", "tables", "reservedNames", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "checkBundleDuplications", "Lorg/toml/lang/psi/TomlLiteral;", "array", "Lorg/toml/lang/psi/TomlArray;", "checkModuleLiteral", "checkDependencyLiteral", "checkDependencyAliases", "Lorg/toml/lang/psi/TomlKey;", "table", "Lorg/toml/lang/psi/TomlTable;", "isInLibrariesTable", "", "checkTableAliases", "key", "checkAliasDuplication", "sameAliases", "alias1", "alias2", "normalize", "", "checkTableDuplication", "isFirstElement", "initFileStatusFlag", "psiFile", "Lcom/intellij/psi/PsiFile;", "firstSegmentNormalizedText", "Lorg/jetbrains/annotations/Nullable;", "Lcom/intellij/openapi/util/NlsSafe;", "Companion", "intellij.android.projectSystem.gradle"})
@SourceDebugExtension(value={"SMAP\nVersionsTomlAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VersionsTomlAnnotator.kt\ncom/android/tools/idea/gradle/catalog/VersionsTomlAnnotator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 4 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 7 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,253:1\n1869#2,2:254\n1563#2:284\n1634#2,3:285\n1563#2:289\n1634#2,3:290\n774#2:293\n865#2,2:294\n1617#2,9:296\n1869#2:305\n1870#2:307\n1626#2:308\n774#2:309\n865#2,2:310\n58#3,2:256\n28#3,12:258\n58#3,2:270\n28#3,12:272\n196#4:288\n1#5:306\n477#6:312\n1255#6,2:313\n4135#7,11:315\n*S KotlinDebug\n*F\n+ 1 VersionsTomlAnnotator.kt\ncom/android/tools/idea/gradle/catalog/VersionsTomlAnnotator\n*L\n107#1:254,2\n182#1:284\n182#1:285,3\n196#1:289\n196#1:290,3\n197#1:293\n197#1:294,2\n198#1:296,9\n198#1:305\n198#1:307\n198#1:308\n199#1:309\n199#1:310,2\n117#1:256,2\n117#1:258,12\n125#1:270,2\n125#1:272,12\n193#1:288\n198#1:306\n226#1:312\n228#1:313,2\n246#1:315,11\n*E\n"})
public final class VersionsTomlAnnotator
implements Annotator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> dependencyTables;
    @NotNull
    private final List<String> tables;
    @NotNull
    private final List<String> reservedNames;
    @NotNull
    private static final Key<Boolean> FILE_IS_GOOD_FOR_LONG_CHECKS;

    public VersionsTomlAnnotator() {
        Object[] objectArray = new String[]{"plugins", "libraries", "bundles"};
        this.dependencyTables = CollectionsKt.listOf((Object[])objectArray);
        this.tables = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)this.dependencyTables, (Object)"versions"), (Object)"metadata");
        objectArray = new String[]{"extensions", "convention"};
        this.reservedNames = CollectionsKt.listOf((Object[])objectArray);
    }

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        String string = element.getContainingFile().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!StringsKt.endsWith$default((String)string, (String)".versions.toml", (boolean)false, (int)2, null)) {
            return;
        }
        if (this.isFirstElement(element)) {
            PsiFile psiFile = element.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
            this.initFileStatusFlag(psiFile, holder);
        }
        if ((psiElement = element.getParent()) == null || (psiElement = psiElement.getParent()) == null) {
            return;
        }
        PsiElement grandParent = psiElement;
        PsiElement psiElement2 = grandParent.getParent();
        if (psiElement2 == null) {
            return;
        }
        PsiElement greatGrandParent = psiElement2;
        if (element instanceof TomlKey && ((TomlKey)element).getParent() instanceof TomlKeyValue && grandParent instanceof TomlTable && greatGrandParent instanceof TomlFile) {
            this.checkDependencyAliases((TomlKey)element, (TomlTable)grandParent, holder);
        }
        if (element instanceof TomlKey && ((TomlKey)element).getParent() instanceof TomlTableHeader && grandParent instanceof TomlTable && greatGrandParent instanceof TomlFile) {
            this.checkTableAliases((TomlKey)element, (TomlTable)grandParent, holder);
        }
        if (element instanceof TomlLiteral && ((TomlLiteral)element).getParent() instanceof TomlKeyValue && grandParent instanceof TomlTable && greatGrandParent instanceof TomlFile) {
            PsiElement psiElement3 = ((TomlLiteral)element).getParent();
            Intrinsics.checkNotNull((Object)psiElement3, (String)"null cannot be cast to non-null type org.toml.lang.psi.TomlKeyValue");
            if (((TomlKeyValue)psiElement3).getKey().getSegments().size() > 1) {
                return;
            }
            this.checkDependencyLiteral((TomlLiteral)element, holder);
        }
        if (element instanceof TomlLiteral && ((TomlLiteral)element).getParent() instanceof TomlKeyValue) {
            PsiElement psiElement4 = ((TomlLiteral)element).getParent();
            Intrinsics.checkNotNull((Object)psiElement4, (String)"null cannot be cast to non-null type org.toml.lang.psi.TomlKeyValue");
            if (Intrinsics.areEqual((Object)((TomlKeyValue)psiElement4).getKey().getText(), (Object)"module") && grandParent instanceof TomlInlineTable) {
                this.checkModuleLiteral((TomlLiteral)element, holder);
            }
        }
        if (element instanceof TomlLiteral && ((TomlLiteral)element).getParent() instanceof TomlArray && grandParent instanceof TomlKeyValue && greatGrandParent instanceof TomlTable) {
            TomlKey tomlKey = ((TomlTable)greatGrandParent).getHeader().getKey();
            if (Intrinsics.areEqual((Object)(tomlKey != null ? tomlKey.getText() : null), (Object)"bundles")) {
                TomlLiteral tomlLiteral = (TomlLiteral)element;
                PsiElement psiElement5 = ((TomlLiteral)element).getParent();
                Intrinsics.checkNotNull((Object)psiElement5, (String)"null cannot be cast to non-null type org.toml.lang.psi.TomlArray");
                this.checkBundleDuplications(tomlLiteral, (TomlArray)psiElement5, holder);
            }
        }
    }

    private final void checkBundleDuplications(TomlLiteral element, TomlArray array, AnnotationHolder holder) {
        Iterable $this$forEach$iv = array.getElements();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TomlValue ref = (TomlValue)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)ref, (Object)element)) {
                return;
            }
            String string = ref.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String string2 = element.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            if (!this.sameAliases(string, string2)) continue;
            holder.newAnnotation(HighlightSeverity.WARNING, "Duplicate reference to dependency").create();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkModuleLiteral(TomlLiteral element, AnnotationHolder holder) {
        PsiElement psiElement;
        PsiElement psiElement2;
        block9: {
            void $this$findParentInFile$iv$iv;
            PsiElement $this$findParentOfType_u24default$iv = (PsiElement)element;
            boolean strict$iv = true;
            boolean $i$f$findParentOfType = false;
            PsiElement psiElement3 = $this$findParentOfType_u24default$iv;
            boolean withSelf$iv$iv = false;
            boolean $i$f$findParentInFile = false;
            if ($this$findParentInFile$iv$iv instanceof PsiFile) {
                psiElement2 = null;
            } else {
                for (PsiElement current$iv$iv = $this$findParentInFile$iv$iv.getParent(); current$iv$iv != null; current$iv$iv = current$iv$iv.getParent()) {
                    PsiElement it$iv = current$iv$iv;
                    boolean bl = false;
                    if (it$iv instanceof TomlTable) {
                        psiElement2 = current$iv$iv;
                        break block9;
                    }
                    if (current$iv$iv instanceof PsiFile) break;
                }
                psiElement2 = psiElement = null;
            }
        }
        if (!(psiElement2 instanceof TomlTable)) {
            psiElement = null;
        }
        TomlTable tomlTable = (TomlTable)((PsiElement)((TomlTable)psiElement));
        if (tomlTable == null) {
            return;
        }
        TomlTable table2 = tomlTable;
        Object object = table2.getHeader().getKey();
        if (object == null || (object = object.getSegments()) == null || (object = (TomlKeySegment)CollectionsKt.firstOrNull((List)object)) == null || (object = object.getName()) == null) {
            return;
        }
        Object name2 = object;
        if (Intrinsics.areEqual((Object)name2, (Object)"libraries")) {
            String string = element.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String[] stringArray = new String[]{":"};
            if (StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null).size() != 2) {
                holder.newAnnotation(HighlightSeverity.ERROR, "Make sure that the module coordinates consist of 2 parts separated by colons, eg: my.group:artifact").create();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkDependencyLiteral(TomlLiteral element, AnnotationHolder holder) {
        PsiElement psiElement;
        PsiElement psiElement2;
        block13: {
            void $this$findParentInFile$iv$iv;
            PsiElement $this$findParentOfType_u24default$iv = (PsiElement)element;
            boolean strict$iv = true;
            boolean $i$f$findParentOfType = false;
            PsiElement psiElement3 = $this$findParentOfType_u24default$iv;
            boolean withSelf$iv$iv = false;
            boolean $i$f$findParentInFile = false;
            if ($this$findParentInFile$iv$iv instanceof PsiFile) {
                psiElement2 = null;
            } else {
                for (PsiElement current$iv$iv = $this$findParentInFile$iv$iv.getParent(); current$iv$iv != null; current$iv$iv = current$iv$iv.getParent()) {
                    PsiElement it$iv = current$iv$iv;
                    boolean bl = false;
                    if (it$iv instanceof TomlTable) {
                        psiElement2 = current$iv$iv;
                        break block13;
                    }
                    if (current$iv$iv instanceof PsiFile) break;
                }
                psiElement2 = psiElement = null;
            }
        }
        if (!(psiElement2 instanceof TomlTable)) {
            psiElement = null;
        }
        TomlTable tomlTable = (TomlTable)((PsiElement)((TomlTable)psiElement));
        if (tomlTable == null) {
            return;
        }
        TomlTable table2 = tomlTable;
        Object object = table2.getHeader().getKey();
        if (object == null || (object = object.getSegments()) == null || (object = (TomlKeySegment)CollectionsKt.firstOrNull((List)object)) == null || (object = object.getName()) == null) {
            return;
        }
        Object name2 = object;
        Object object2 = name2;
        if (Intrinsics.areEqual((Object)object2, (Object)"plugins")) {
            String string = element.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String[] stringArray = new String[]{":"};
            if (StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null).size() != 2) {
                holder.newAnnotation(HighlightSeverity.ERROR, "Make sure that the coordinates consist of 2 parts separated by colons, eg: my_plugin:1.2").create();
            }
        } else if (Intrinsics.areEqual((Object)object2, (Object)"libraries")) {
            String string = element.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String[] stringArray = new String[]{":"};
            if (StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null).size() < 2) {
                holder.newAnnotation(HighlightSeverity.ERROR, "Make sure that the coordinates consist of 2 parts with BOM and 3 without BOM that are separated by colons.").create();
            }
        } else {
            return;
        }
    }

    private final void checkDependencyAliases(TomlKey element, TomlTable table2, AnnotationHolder holder) {
        String string = this.firstSegmentNormalizedText(element);
        if (string == null) {
            return;
        }
        String text2 = string;
        if (!new Regex("[a-z]([a-zA-Z0-9_\\-])+").matches((CharSequence)text2)) {
            holder.newAnnotation(HighlightSeverity.ERROR, "Invalid alias `" + text2 + "`. It must start with a lower-case letter, contain at least 2 characters and be made up of letters, digits and the symbols '-' or '_' only").create();
        } else if (Regex.find$default((Regex)new Regex(".+[_\\-][0-9]"), (CharSequence)text2, (int)0, (int)2, null) != null) {
            TomlKey tomlKey = table2.getHeader().getKey();
            holder.newAnnotation(CollectionsKt.contains((Iterable)this.dependencyTables, (Object)(tomlKey != null ? tomlKey.getText() : null)) ? HighlightSeverity.ERROR : HighlightSeverity.WARNING, "Invalid alias `" + text2 + "`. There must be letter after '-' or '_ delimiter.").create();
        } else if (StringsKt.endsWith$default((String)text2, (String)"_", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)text2, (String)"-", (boolean)false, (int)2, null)) {
            holder.newAnnotation(HighlightSeverity.ERROR, "Invalid alias `" + text2 + "`. It cannot end with '-' or '_'").create();
        } else if (Regex.find$default((Regex)new Regex("[_\\-]{2,}"), (CharSequence)text2, (int)0, (int)2, null) != null) {
            holder.newAnnotation(HighlightSeverity.ERROR, "Invalid alias `" + text2 + "`. Cannot have more than one consecutive '-' or '_'").create();
        } else if (this.isInLibrariesTable(table2) && Regex.find$default((Regex)new Regex("^((plugins)|(bundles)|(versions))[_\\-]?"), (CharSequence)text2, (int)0, (int)2, null) != null) {
            holder.newAnnotation(HighlightSeverity.ERROR, "Invalid alias `" + text2 + "`. It cannot start with 'plugins', 'bundles' or 'versions' as will interfere with gradle naming").create();
        } else if (this.reservedNames.contains(text2)) {
            holder.newAnnotation(HighlightSeverity.ERROR, "Invalid alias `" + text2 + "`. Aliases '" + CollectionsKt.joinToString$default((Iterable)this.reservedNames, (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + "' are reserved names in Gradle which prevents generation of accessors.").create();
        } else {
            char[] cArray = new char[]{'_'};
            if (StringsKt.split$default((CharSequence)text2, (char[])cArray, (boolean)false, (int)0, (int)6, null).contains("class")) {
                holder.newAnnotation(HighlightSeverity.ERROR, "Invalid alias `" + text2 + "`. Alias 'class' is a reserved name in Gradle which prevents generation of accessors.").create();
            } else {
                this.checkAliasDuplication(element, holder);
            }
        }
    }

    private final boolean isInLibrariesTable(TomlTable element) {
        Object object = element.getHeader().getKey();
        return Intrinsics.areEqual(object != null && (object = object.getSegments()) != null && (object = (TomlKeySegment)CollectionsKt.firstOrNull((List)object)) != null ? object.getName() : null, (Object)"libraries");
    }

    /*
     * WARNING - void declaration
     */
    private final void checkTableAliases(TomlKey key, TomlTable table2, AnnotationHolder holder) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = key.getSegments();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TomlKeySegment tomlKeySegment = (TomlKeySegment)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getName());
        }
        String text2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
        if (!this.tables.contains(text2)) {
            holder.newAnnotation(HighlightSeverity.ERROR, "Invalid table name `" + text2 + "`. It must be one of: " + CollectionsKt.joinToString$default((Iterable)this.tables, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)).create();
        } else if (Intrinsics.areEqual((Object)holder.getCurrentAnnotationSession().getUserData(FILE_IS_GOOD_FOR_LONG_CHECKS), (Object)true)) {
            this.checkTableDuplication(table2, holder);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkAliasDuplication(TomlKey element, AnnotationHolder holder) {
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Object it;
        void $this$mapTo$iv$iv;
        void $this$getParentOfType$iv;
        PsiElement psiElement = (PsiElement)element;
        boolean strict$iv = true;
        boolean $i$f$getParentOfType = false;
        TomlTable tomlTable = (TomlTable)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, TomlTable.class, (boolean)strict$iv);
        if (tomlTable == null) {
            return;
        }
        TomlTable parent = tomlTable;
        if (element.getSegments().size() > 1) {
            return;
        }
        String string = this.firstSegmentNormalizedText(element);
        if (string == null) {
            return;
        }
        String elementName = string;
        Iterable $this$map$iv = parent.getEntries();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            TomlKeyValue tomlKeyValue = (TomlKeyValue)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getKey());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (TomlKey)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)element) && it.getSegments().size() == 1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl = false;
            TomlKey it2 = (TomlKey)element$iv$iv;
            boolean bl2 = false;
            if (this.firstSegmentNormalizedText(it2) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!this.sameAliases(elementName, (String)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List same = (List)destination$iv$iv;
        if (!((Collection)same).isEmpty()) {
            String suffix = same.size() > 2 ? " etc." : ".";
            holder.newAnnotation(HighlightSeverity.ERROR, "Duplicated alias name. Effectively same as " + CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)same, (int)2), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + suffix).create();
        }
    }

    private final boolean sameAliases(String alias1, String alias2) {
        if (alias1.length() != alias2.length()) {
            return false;
        }
        int n = ((CharSequence)alias1).length();
        for (int i = 0; i < n; ++i) {
            char char1 = this.normalize(alias1.charAt(i));
            char char2 = this.normalize(alias2.charAt(i));
            if (!(i > 0 && this.normalize(alias1.charAt(i - 1)) == '_' && this.normalize(alias2.charAt(i - 1)) == '_' ? !CharsKt.equals((char)char1, (char)char2, (boolean)true) : char1 != char2)) continue;
            return false;
        }
        return true;
    }

    private final char normalize(char $this$normalize) {
        return switch ($this$normalize) {
            case '-', '.' -> '_';
            default -> $this$normalize;
        };
    }

    /*
     * WARNING - void declaration
     */
    private final void checkTableDuplication(TomlTable element, AnnotationHolder holder) {
        boolean hasDuplicates;
        block3: {
            boolean bl;
            void $this$any$iv;
            Sequence $this$filterIsInstance$iv;
            Object object = element.getHeader().getKey();
            if (object == null || (object = this.firstSegmentNormalizedText((TomlKey)object)) == null) {
                return;
            }
            Object name2 = object;
            PsiElement[] psiElementArray = element.getParent().getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
            Sequence sequence = ArraysKt.asSequence((Object[])psiElementArray);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)checkTableDuplication$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            $this$filterIsInstance$iv = SequencesKt.filter((Sequence)sequence2, arg_0 -> VersionsTomlAnnotator.checkTableDuplication$lambda$0(element, arg_0));
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                TomlTable it = (TomlTable)element$iv;
                boolean bl2 = false;
                TomlKey tomlKey = it.getHeader().getKey();
                if (!Intrinsics.areEqual((Object)(tomlKey != null ? this.firstSegmentNormalizedText(tomlKey) : null), (Object)name2)) continue;
                bl = true;
                break block3;
            }
            bl = hasDuplicates = false;
        }
        if (hasDuplicates) {
            holder.newAnnotation(HighlightSeverity.ERROR, "Duplicated table name.").create();
        }
    }

    private final boolean isFirstElement(PsiElement $this$isFirstElement) {
        PsiFile psiFile = $this$isFirstElement.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        PsiElement currentElement = (PsiElement)psiFile;
        while (currentElement.getFirstChild() != null) {
            Intrinsics.checkNotNullExpressionValue((Object)currentElement.getFirstChild(), (String)"getFirstChild(...)");
        }
        return Intrinsics.areEqual((Object)$this$isFirstElement, (Object)currentElement);
    }

    /*
     * WARNING - void declaration
     */
    private final void initFileStatusFlag(PsiFile psiFile, AnnotationHolder holder) {
        void $this$filterIsInstanceTo$iv$iv;
        PsiElement[] psiElementArray = psiFile.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
        Object[] $this$filterIsInstance$iv = psiElementArray;
        boolean $i$f$filterIsInstance = false;
        Object[] objectArray = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof TomlTable)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        int tables = ((Collection)((List)destination$iv$iv)).size();
        holder.getCurrentAnnotationSession().putUserData(FILE_IS_GOOD_FOR_LONG_CHECKS, (Object)(tables < 1000 ? 1 : 0));
    }

    private final String firstSegmentNormalizedText(TomlKey $this$firstSegmentNormalizedText) {
        TomlKeySegment tomlKeySegment = (TomlKeySegment)CollectionsKt.firstOrNull((List)$this$firstSegmentNormalizedText.getSegments());
        return tomlKeySegment != null ? tomlKeySegment.getName() : null;
    }

    private static final boolean checkTableDuplication$lambda$0(TomlTable $element, TomlTable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !Intrinsics.areEqual((Object)it, (Object)$element);
    }

    static {
        Key key = Key.create((String)"FILE_IS_GOOD_FOR_LONG_CHECKS");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        FILE_IS_GOOD_FOR_LONG_CHECKS = key;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/gradle/catalog/VersionsTomlAnnotator$Companion;", "", "<init>", "()V", "FILE_IS_GOOD_FOR_LONG_CHECKS", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "intellij.android.projectSystem.gradle"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

