/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.adtimport.actions;

import com.android.tools.adtui.validation.Validator;
import com.android.tools.idea.actions.OpenProjectFileChooserDescriptorWithAsyncIcon;
import com.android.tools.idea.gradle.project.ProjectImportUtil;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.android.tools.idea.ui.validation.validators.ProjectImportPathValidator;
import com.intellij.ide.actions.ImportModuleAction;
import com.intellij.ide.actions.ImportProjectAction;
import com.intellij.ide.impl.NewProjectUtil;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.newProjectWizard.AbstractProjectWizard;
import com.intellij.ide.util.newProjectWizard.AddModuleWizard;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectImportProvider;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidImportProjectAction
extends AnAction {
    @NonNls
    private static final String LAST_IMPORTED_LOCATION = "last.imported.location";
    private static final Logger LOG = Logger.getInstance(AndroidImportProjectAction.class);
    private static final String WIZARD_TITLE = "Select Gradle Project to Import";
    private static final String WIZARD_DESCRIPTION = "Select build.gradle or settings.gradle file";

    public AndroidImportProjectAction(@Nullable @NlsActions.ActionText String text2, @Nullable @NlsActions.ActionDescription String description2, @Nullable Icon icon) {
        super(text2, description2, icon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        Disposable wizardDisposable = Disposer.newDisposable();
        try {
            AddModuleWizard wizard2 = this.selectFileAndCreateWizard(wizardDisposable, e.getProject());
            if (wizard2 != null && wizard2.getStepCount() > 0) {
                if (!wizard2.showAndGet()) {
                    return;
                }
                NewProjectUtil.createFromWizard((AbstractProjectWizard)wizard2, null);
            }
        }
        catch (ConfigurationException | IOException exception) {
            AndroidImportProjectAction.handleImportException(e.getProject(), (Exception)exception);
        }
        finally {
            Disposer.dispose((Disposable)wizardDisposable);
        }
    }

    private static void handleImportException(@Nullable Project project, @NotNull Exception e) {
        String message = String.format("Project import failed: %s", e.getMessage());
        Messages.showErrorDialog((Project)project, (String)message, (String)"Import Project");
        LOG.error((Throwable)e);
    }

    @NotNull
    protected FileChooserDescriptor createFileChooserDescriptor(Disposable wizardDisposable) {
        final OpenProjectFileChooserDescriptorWithAsyncIcon delegate2 = new OpenProjectFileChooserDescriptorWithAsyncIcon();
        Disposer.register((Disposable)wizardDisposable, (Disposable)delegate2);
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(this, true, true, true, true, false, false){

            public Icon getIcon(VirtualFile file) {
                Icon icon = delegate2.getIcon(file);
                return icon == null ? super.getIcon(file) : icon;
            }
        };
        descriptor2.setHideIgnored(false);
        descriptor2.setTitle(WIZARD_TITLE);
        descriptor2.setDescription(WIZARD_DESCRIPTION);
        return descriptor2;
    }

    @Nullable
    private AddModuleWizard selectFileAndCreateWizard(Disposable disposable, @Nullable Project project) throws IOException, ConfigurationException {
        return this.selectFileAndCreateWizard(project, this.createFileChooserDescriptor(disposable));
    }

    @Nullable
    private AddModuleWizard selectFileAndCreateWizard(@Nullable Project project, @NotNull FileChooserDescriptor descriptor2) throws IOException, ConfigurationException {
        VirtualFile[] files2;
        FileChooserDialog chooser = FileChooserFactory.getInstance().createFileChooser(descriptor2, null, null);
        VirtualFile toSelect = null;
        String lastLocation = PropertiesComponent.getInstance().getValue(LAST_IMPORTED_LOCATION);
        if (lastLocation != null) {
            toSelect = LocalFileSystem.getInstance().refreshAndFindFileByPath(lastLocation);
        }
        if ((files2 = chooser.choose(project, new VirtualFile[]{toSelect})).length == 0) {
            return null;
        }
        VirtualFile file = files2[0];
        if (!AndroidImportProjectAction.isSelectedFileValid(project, file)) {
            return null;
        }
        PropertiesComponent.getInstance().setValue(LAST_IMPORTED_LOCATION, file.getPath());
        return this.createImportWizard(file);
    }

    private static boolean isSelectedFileValid(@Nullable Project project, @NotNull VirtualFile file) {
        ProjectImportPathValidator validator = new ProjectImportPathValidator("project file");
        Validator.Result result2 = validator.validate(file.toNioPath());
        if (result2.getSeverity() != Validator.Severity.OK) {
            boolean isError = result2.getSeverity() == Validator.Severity.ERROR;
            Messages.showInfoMessage((Project)project, (String)result2.getMessage(), (String)(isError ? "Cannot Import Project" : "Project Import Warning"));
            if (isError) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    protected AddModuleWizard createImportWizard(@NotNull VirtualFile file) {
        VirtualFile targetDir;
        VirtualFile target2 = AndroidImportProjectAction.findImportTarget(file);
        VirtualFile virtualFile = targetDir = target2.isDirectory() ? target2 : target2.getParent();
        if (GradleProjects.canImportAsGradleProject(target2)) {
            if (ProjectUtil.findAndFocusExistingProjectForPath((Path)targetDir.toNioPath()) == null) {
                ProjectUtil.openOrImport((String)target2.getPath(), null, (boolean)true);
            }
        } else {
            List providers = ImportModuleAction.getProviders(null);
            return ImportProjectAction.createImportWizard(null, null, (VirtualFile)file, (ProjectImportProvider[])providers.toArray(new ProjectImportProvider[0]));
        }
        return null;
    }

    @NotNull
    public static VirtualFile findImportTarget(@NotNull VirtualFile file) {
        VirtualFile gradleTarget = ProjectImportUtil.findGradleTarget(file);
        if (gradleTarget != null) {
            return gradleTarget;
        }
        return file;
    }
}

